/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateElementInCUOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CreateImportOperation
extends CreateElementInCUOperation {
    protected String importName;
    protected int flags;

    public CreateImportOperation(String string, ICompilationUnit iCompilationUnit, int n) {
        super(iCompilationUnit);
        this.importName = string;
        this.flags = n;
    }

    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode aSTNode) {
        return CompilationUnit.IMPORTS_PROPERTY;
    }

    protected ASTNode generateElementAST(ASTRewrite aSTRewrite, IDocument iDocument, ICompilationUnit iCompilationUnit) throws JavaModelException {
        Object object;
        Iterator iterator = this.cuAST.imports().iterator();
        boolean bl = this.importName.endsWith(".*");
        String string = this.importName;
        if (bl) {
            string = this.importName.substring(0, this.importName.length() - 2);
        }
        while (iterator.hasNext()) {
            object = (ImportDeclaration)iterator.next();
            if (!string.equals(((ImportDeclaration)object).getName().getFullyQualifiedName()) || bl != ((ImportDeclaration)object).isOnDemand() || Flags.isStatic(this.flags) != ((ImportDeclaration)object).isStatic()) continue;
            this.creationOccurred = false;
            return null;
        }
        object = this.cuAST.getAST();
        ImportDeclaration importDeclaration = ((AST)object).newImportDeclaration();
        importDeclaration.setStatic(Flags.isStatic(this.flags));
        char[][] cArray = CharOperation.splitOn('.', string.toCharArray(), 0, string.length());
        int n = cArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = String.valueOf(cArray[n2]);
            ++n2;
        }
        Name name = ((AST)object).newName(stringArray);
        importDeclaration.setName(name);
        if (bl) {
            importDeclaration.setOnDemand(true);
        }
        return importDeclaration;
    }

    protected IJavaElement generateResultHandle() {
        return this.getCompilationUnit().getImport(this.importName);
    }

    public String getMainTaskName() {
        return Messages.operation_createImportsProgress;
    }

    protected void initializeDefaultPosition() {
        try {
            ICompilationUnit iCompilationUnit = this.getCompilationUnit();
            IImportDeclaration[] iImportDeclarationArray = iCompilationUnit.getImports();
            if (iImportDeclarationArray.length > 0) {
                this.createAfter(iImportDeclarationArray[iImportDeclarationArray.length - 1]);
                return;
            }
            IType[] iTypeArray = iCompilationUnit.getTypes();
            if (iTypeArray.length > 0) {
                this.createBefore(iTypeArray[0]);
                return;
            }
            IJavaElement[] iJavaElementArray = iCompilationUnit.getChildren();
            int n = 0;
            while (n < iJavaElementArray.length) {
                if (iJavaElementArray[n].getElementType() == 11) {
                    this.createAfter(iJavaElementArray[n]);
                    return;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus iJavaModelStatus = super.verify();
        if (!iJavaModelStatus.isOK()) {
            return iJavaModelStatus;
        }
        IJavaProject iJavaProject = this.getParentElement().getJavaProject();
        if (JavaConventions.validateImportDeclaration(this.importName, iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.importName);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

