/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateTypeMemberOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CreateMethodOperation
extends CreateTypeMemberOperation {
    protected String[] parameterTypes;

    public CreateMethodOperation(IJavaElement iJavaElement, String string, boolean bl) {
        super(iJavaElement, string, bl);
    }

    protected String[] convertASTMethodTypesToSignatures() {
        if (this.parameterTypes == null && this.createdNode != null) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)this.createdNode;
            List list = methodDeclaration.parameters();
            int n = list.size();
            this.parameterTypes = new String[n];
            Iterator iterator = list.iterator();
            int n2 = 0;
            while (n2 < n) {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
                String string = Util.getSignature(singleVariableDeclaration.getType());
                int n3 = singleVariableDeclaration.getExtraDimensions();
                if (methodDeclaration.isVarargs() && n2 == n - 1) {
                    ++n3;
                }
                this.parameterTypes[n2] = Signature.createArraySignature(string, n3);
                ++n2;
            }
        }
        return this.parameterTypes;
    }

    protected ASTNode generateElementAST(ASTRewrite aSTRewrite, IDocument iDocument, ICompilationUnit iCompilationUnit) throws JavaModelException {
        ASTNode aSTNode = super.generateElementAST(aSTRewrite, iDocument, iCompilationUnit);
        if (aSTNode.getNodeType() != 31) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return aSTNode;
    }

    protected IJavaElement generateResultHandle() {
        String[] stringArray = this.convertASTMethodTypesToSignatures();
        String string = this.getASTNodeName();
        if (this.getType() != null) {
            return this.getType().getMethod(string, stringArray);
        }
        return this.getCompilationUnit().getMethod(string, stringArray);
    }

    private String getASTNodeName() {
        return ((MethodDeclaration)this.createdNode).getName().getIdentifier();
    }

    public String getMainTaskName() {
        return Messages.operation_createMethodProgress;
    }

    protected SimpleName rename(ASTNode aSTNode, SimpleName simpleName) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
        SimpleName simpleName2 = methodDeclaration.getName();
        methodDeclaration.setName(simpleName);
        return simpleName2;
    }

    protected IJavaModelStatus verifyNameCollision() {
        if (this.createdNode != null) {
            IType iType = this.getType();
            String string = ((MethodDeclaration)this.createdNode).isConstructor() ? iType.getElementName() : this.getASTNodeName();
            String[] stringArray = this.convertASTMethodTypesToSignatures();
            if (iType != null ? iType.getMethod(string, stringArray).exists() : this.getCompilationUnit().getMethod(string, stringArray).exists()) {
                return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, string));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

