/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.IVirtualParent;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRootInfo;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragment;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragmentInfo;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;

public class LibraryFragmentRoot
extends PackageFragmentRoot
implements IVirtualParent {
    protected final IPath libraryPath;
    protected boolean[] fLangeRuntime = new boolean[2];

    protected LibraryFragmentRoot(IPath iPath, JavaProject javaProject) {
        super(null, javaProject);
        this.libraryPath = iPath;
    }

    protected LibraryFragmentRoot(IResource iResource, JavaProject javaProject) {
        super(iResource, javaProject);
        this.libraryPath = iResource.getFullPath();
    }

    public PackageFragment getPackageFragment(String[] stringArray) {
        return new LibraryPackageFragment(this, stringArray);
    }

    public IPath getPath() {
        if (this.isExternal()) {
            return this.libraryPath;
        }
        return super.getPath();
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    public IResource getResource() {
        if (this.resource == null) {
            this.resource = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.libraryPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    protected boolean computeChildren(OpenableElementInfo openableElementInfo, Map map) throws JavaModelException {
        String[] stringArray = new String[]{""};
        LibraryPackageFragment libraryPackageFragment = new LibraryPackageFragment(this, stringArray);
        LibraryPackageFragmentInfo libraryPackageFragmentInfo = new LibraryPackageFragmentInfo();
        libraryPackageFragment.computeChildren(libraryPackageFragmentInfo);
        map.put(libraryPackageFragment, libraryPackageFragmentInfo);
        IJavaElement[] iJavaElementArray = new IJavaElement[]{libraryPackageFragment};
        openableElementInfo.setChildren(iJavaElementArray);
        return true;
    }

    protected Object createElementInfo() {
        return new LibraryFragmentRootInfo();
    }

    protected int determineKind(IResource iResource) {
        return 2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LibraryFragmentRoot) {
            LibraryFragmentRoot libraryFragmentRoot = (LibraryFragmentRoot)object;
            return this.libraryPath.equals((Object)libraryFragmentRoot.libraryPath);
        }
        return false;
    }

    public String getElementName() {
        return this.libraryPath.lastSegment();
    }

    public int hashCode() {
        return this.libraryPath.hashCode();
    }

    public boolean isExternal() {
        return this.getResource() == null;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected boolean resourceExists() {
        if (this.isExternal()) {
            return JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.getPath(), true) != null;
        }
        return super.resourceExists();
    }

    private ClassFile getLibraryClassFile() {
        try {
            IPackageFragment iPackageFragment;
            IClassFile[] iClassFileArray;
            ArrayList arrayList = this.getChildrenOfType(4);
            if (!arrayList.isEmpty() && (iClassFileArray = (iPackageFragment = (IPackageFragment)arrayList.get(0)).getClassFiles()) != null && iClassFileArray.length > 0) {
                return (ClassFile)iClassFileArray[0];
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return null;
    }

    protected void toStringAncestors(StringBuffer stringBuffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(stringBuffer);
    }

    public boolean isResourceContainer() {
        return false;
    }

    public String getDisplayName() {
        ClasspathContainerInitializer classpathContainerInitializer = this.getContainerInitializer();
        if (classpathContainerInitializer != null) {
            return classpathContainerInitializer.getDescription(this.getPath(), this.getJavaProject());
        }
        return super.getDisplayName();
    }

    public ClasspathContainerInitializer getContainerInitializer() {
        IClasspathEntry iClasspathEntry = null;
        try {
            iClasspathEntry = this.getRawClasspathEntry();
        }
        catch (JavaModelException javaModelException) {}
        if (iClasspathEntry == null) {
            return null;
        }
        return JavaCore.getClasspathContainerInitializer(iClasspathEntry.getPath().segment(0));
    }

    public boolean isVirtual() {
        return true;
    }

    public boolean isLanguageRuntime() {
        if (this.fLangeRuntime[0]) {
            return this.fLangeRuntime[1];
        }
        ClasspathContainerInitializer classpathContainerInitializer = this.getContainerInitializer();
        if (classpathContainerInitializer == null) {
            this.fLangeRuntime[0] = true;
            this.fLangeRuntime[1] = false;
            return this.fLangeRuntime[1];
        }
        this.fLangeRuntime[1] = classpathContainerInitializer.getKind() == 2 || classpathContainerInitializer.getKind() == 3;
        this.fLangeRuntime[0] = true;
        return this.fLangeRuntime[1];
    }

    public boolean isLibrary() {
        return true;
    }
}

