/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class SortElementsOperation
extends JavaModelOperation {
    public static final String CONTAINS_MALFORMED_NODES = "malformed";
    Comparator comparator;
    int[] positions;
    int apiLevel;

    public SortElementsOperation(int n, IJavaElement[] iJavaElementArray, int[] nArray, Comparator comparator) {
        super(iJavaElementArray);
        this.comparator = comparator;
        this.positions = nArray;
        this.apiLevel = n;
    }

    protected int getMainAmountOfWork() {
        return this.elementsToProcess.length;
    }

    boolean checkMalformedNodes(ASTNode aSTNode) {
        Object object = aSTNode.getProperty(CONTAINS_MALFORMED_NODES);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    protected boolean isMalformed(ASTNode aSTNode) {
        return (aSTNode.getFlags() & 1) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block6: {
            block5: {
                try {
                    this.beginTask(Messages.operation_sortelements, this.getMainAmountOfWork());
                    CompilationUnit compilationUnit = (CompilationUnit)this.elementsToProcess[0];
                    ICompilationUnit iCompilationUnit = compilationUnit.getPrimary();
                    IBuffer iBuffer = compilationUnit.getBuffer();
                    if (iBuffer == null) {
                        Object var6_4 = null;
                        break block5;
                    }
                    char[] cArray = iBuffer.getCharacters();
                    String string = this.processElement(iCompilationUnit, cArray);
                    if (!CharOperation.equals(string.toCharArray(), cArray)) {
                        compilationUnit.getBuffer().setContents(string);
                    }
                    this.worked(1);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.done();
                    throw throwable;
                }
            }
            this.done();
            return;
        }
        Object var6_6 = null;
        this.done();
    }

    public TextEdit calculateEdit(org.eclipse.wst.jsdt.core.dom.CompilationUnit compilationUnit, TextEditGroup textEditGroup) throws JavaModelException {
        ASTRewrite aSTRewrite;
        String string;
        block5: {
            if (this.elementsToProcess.length != 1) {
                throw new JavaModelException(new JavaModelStatus(968));
            }
            if (!(this.elementsToProcess[0] instanceof ICompilationUnit)) {
                throw new JavaModelException(new JavaModelStatus(967, this.elementsToProcess[0]));
            }
            try {
                this.beginTask(Messages.operation_sortelements, this.getMainAmountOfWork());
                ICompilationUnit iCompilationUnit = (ICompilationUnit)this.elementsToProcess[0];
                string = iCompilationUnit.getBuffer().getContents();
                aSTRewrite = this.sortCompilationUnit(compilationUnit, textEditGroup);
                if (aSTRewrite != null) break block5;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.done();
                throw throwable;
            }
            this.done();
            return null;
        }
        Document document = new Document(string);
        TextEdit textEdit = aSTRewrite.rewriteAST((IDocument)document, null);
        Object var7_7 = null;
        this.done();
        return textEdit;
    }

    private String processElement(ICompilationUnit iCompilationUnit, char[] cArray) {
        int n;
        int n2;
        Document document = new Document(new String(cArray));
        CompilerOptions compilerOptions = new CompilerOptions(iCompilationUnit.getJavaProject().getOptions(true));
        ASTParser aSTParser = ASTParser.newParser(this.apiLevel);
        aSTParser.setCompilerOptions(compilerOptions.getMap());
        aSTParser.setSource(cArray);
        aSTParser.setKind(8);
        aSTParser.setResolveBindings(false);
        org.eclipse.wst.jsdt.core.dom.CompilationUnit compilationUnit = (org.eclipse.wst.jsdt.core.dom.CompilationUnit)aSTParser.createAST(null);
        ASTRewrite aSTRewrite = this.sortCompilationUnit(compilationUnit, null);
        if (aSTRewrite == null) {
            return document.get();
        }
        TextEdit textEdit = aSTRewrite.rewriteAST((IDocument)document, null);
        RangeMarker[] rangeMarkerArray = null;
        if (this.positions != null) {
            rangeMarkerArray = new RangeMarker[this.positions.length];
            n2 = 0;
            n = this.positions.length;
            while (n2 < n) {
                rangeMarkerArray[n2] = new RangeMarker(this.positions[n2], 0);
                SortElementsOperation.insert(textEdit, (TextEdit)rangeMarkerArray[n2]);
                ++n2;
            }
        }
        try {
            textEdit.apply((IDocument)document, 2);
            if (this.positions != null) {
                n2 = 0;
                n = rangeMarkerArray.length;
                while (n2 < n) {
                    this.positions[n2] = rangeMarkerArray[n2].getOffset();
                    ++n2;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return document.get();
    }

    private ASTRewrite sortCompilationUnit(org.eclipse.wst.jsdt.core.dom.CompilationUnit compilationUnit, final TextEditGroup textEditGroup) {
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(org.eclipse.wst.jsdt.core.dom.CompilationUnit compilationUnit) {
                List list = compilationUnit.types();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)iterator.next();
                    abstractTypeDeclaration.setProperty("relativeOrder", new Integer(abstractTypeDeclaration.getStartPosition()));
                    compilationUnit.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed(abstractTypeDeclaration));
                }
                return true;
            }

            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                List list = annotationTypeDeclaration.bodyDeclarations();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
                    bodyDeclaration.setProperty("relativeOrder", new Integer(bodyDeclaration.getStartPosition()));
                    annotationTypeDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed(bodyDeclaration));
                }
                return true;
            }

            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                List list = anonymousClassDeclaration.bodyDeclarations();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
                    bodyDeclaration.setProperty("relativeOrder", new Integer(bodyDeclaration.getStartPosition()));
                    anonymousClassDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed(bodyDeclaration));
                }
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration) {
                List list = typeDeclaration.bodyDeclarations();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
                    bodyDeclaration.setProperty("relativeOrder", new Integer(bodyDeclaration.getStartPosition()));
                    typeDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed(bodyDeclaration));
                }
                return true;
            }

            public boolean visit(EnumDeclaration enumDeclaration) {
                Object object;
                List list = enumDeclaration.bodyDeclarations();
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (BodyDeclaration)object2.next();
                    ((ASTNode)object).setProperty("relativeOrder", new Integer(((ASTNode)object).getStartPosition()));
                    enumDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed((ASTNode)object));
                }
                object2 = enumDeclaration.enumConstants();
                object = object2.iterator();
                while (object.hasNext()) {
                    EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)object.next();
                    enumConstantDeclaration.setProperty("relativeOrder", new Integer(enumConstantDeclaration.getStartPosition()));
                    enumDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed(enumConstantDeclaration));
                }
                return true;
            }
        });
        final ASTRewrite aSTRewrite = ASTRewrite.create(compilationUnit.getAST());
        final boolean[] blArray = new boolean[1];
        compilationUnit.accept(new ASTVisitor(){

            private void sortElements(List list, ListRewrite listRewrite) {
                if (list.size() == 0) {
                    return;
                }
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(list);
                Collections.sort(arrayList, SortElementsOperation.this.comparator);
                int n = 0;
                while (n < list.size()) {
                    ASTNode aSTNode;
                    ASTNode aSTNode2 = (ASTNode)list.get(n);
                    if (aSTNode2 != (aSTNode = (ASTNode)arrayList.get(n))) {
                        listRewrite.replace(aSTNode2, aSTRewrite.createMoveTarget(aSTNode), textEditGroup);
                        blArray[0] = true;
                    }
                    ++n;
                }
            }

            public boolean visit(org.eclipse.wst.jsdt.core.dom.CompilationUnit compilationUnit) {
                if (SortElementsOperation.this.checkMalformedNodes(compilationUnit)) {
                    return true;
                }
                this.sortElements(compilationUnit.types(), aSTRewrite.getListRewrite(compilationUnit, org.eclipse.wst.jsdt.core.dom.CompilationUnit.TYPES_PROPERTY));
                return true;
            }

            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(annotationTypeDeclaration)) {
                    return true;
                }
                this.sortElements(annotationTypeDeclaration.bodyDeclarations(), aSTRewrite.getListRewrite(annotationTypeDeclaration, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(anonymousClassDeclaration)) {
                    return true;
                }
                this.sortElements(anonymousClassDeclaration.bodyDeclarations(), aSTRewrite.getListRewrite(anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(typeDeclaration)) {
                    return true;
                }
                this.sortElements(typeDeclaration.bodyDeclarations(), aSTRewrite.getListRewrite(typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            public boolean visit(EnumDeclaration enumDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(enumDeclaration)) {
                    return true;
                }
                this.sortElements(enumDeclaration.bodyDeclarations(), aSTRewrite.getListRewrite(enumDeclaration, EnumDeclaration.BODY_DECLARATIONS_PROPERTY));
                this.sortElements(enumDeclaration.enumConstants(), aSTRewrite.getListRewrite(enumDeclaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY));
                return true;
            }
        });
        if (!blArray[0]) {
            return null;
        }
        return aSTRewrite;
    }

    public IJavaModelStatus verify() {
        if (this.elementsToProcess.length != 1) {
            return new JavaModelStatus(968);
        }
        if (this.elementsToProcess[0] == null) {
            return new JavaModelStatus(968);
        }
        if (!(this.elementsToProcess[0] instanceof ICompilationUnit) || !((ICompilationUnit)this.elementsToProcess[0]).isWorkingCopy()) {
            return new JavaModelStatus(967, this.elementsToProcess[0]);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static void insert(TextEdit textEdit, TextEdit textEdit2) {
        TextEdit textEdit3;
        if (!textEdit.hasChildren()) {
            textEdit.addChild(textEdit2);
            return;
        }
        TextEdit[] textEditArray = textEdit.getChildren();
        int n = 0;
        while (n < textEditArray.length) {
            textEdit3 = textEditArray[n];
            if (SortElementsOperation.covers(textEdit3, textEdit2)) {
                SortElementsOperation.insert(textEdit3, textEdit2);
                return;
            }
            ++n;
        }
        n = textEditArray.length - 1;
        while (n >= 0) {
            textEdit3 = textEditArray[n];
            if (SortElementsOperation.covers(textEdit2, textEdit3)) {
                textEdit.removeChild(n);
                textEdit2.addChild(textEdit3);
            }
            --n;
        }
        textEdit.addChild(textEdit2);
    }

    private static boolean covers(TextEdit textEdit, TextEdit textEdit2) {
        if (textEdit.getLength() == 0) {
            return false;
        }
        int n = textEdit.getOffset();
        int n2 = textEdit.getExclusiveEnd();
        if (textEdit2.getLength() == 0) {
            int n3 = textEdit2.getOffset();
            return n <= n3 && n3 < n2;
        }
        int n4 = textEdit2.getOffset();
        int n5 = textEdit2.getExclusiveEnd();
        return n <= n4 && n5 <= n2;
    }
}

