/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;

public final class NameSet {
    public char[][] names;
    public int elementSize = 0;
    public int threshold;

    public NameSet(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.5f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.names = new char[n2][];
    }

    public char[] add(char[] cArray) {
        char[] cArray2;
        int n = this.names.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        while ((cArray2 = this.names[n2]) != null) {
            if (CharOperation.equals(cArray2, cArray)) {
                return cArray2;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.names[n2] = cArray;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return cArray;
    }

    private void rehash() {
        NameSet nameSet = new NameSet(this.elementSize * 2);
        int n = this.names.length;
        while (--n >= 0) {
            char[] cArray = this.names[n];
            if (cArray == null) continue;
            nameSet.add(cArray);
        }
        this.names = nameSet.names;
        this.elementSize = nameSet.elementSize;
        this.threshold = nameSet.threshold;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.names.length;
        while (n < n2) {
            char[] cArray = this.names[n];
            if (cArray != null) {
                string = String.valueOf(string) + new String(cArray) + "\n";
            }
            ++n;
        }
        return string;
    }
}

