/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.CopySourceEdit;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ISourceModifier;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.MethodRefParameter;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.SynchronizedStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ASTRewriteFormatter;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.LineCommentEndOffsets;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.LineInformation;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeInfoStore;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEventStore;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.SourceModifier;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.TokenScanner;

public final class ASTRewriteAnalyzer
extends ASTVisitor {
    static final int JLS2_INTERNAL = 2;
    TextEdit currentEdit;
    final RewriteEventStore eventStore;
    private TokenScanner tokenScanner;
    private final Map sourceCopyInfoToEdit;
    private final Stack sourceCopyEndNodes;
    private final char[] content;
    private final LineInformation lineInfo;
    private final ASTRewriteFormatter formatter;
    private final NodeInfoStore nodeInfos;
    private final TargetSourceRangeComputer extendedSourceRangeComputer;
    private final LineCommentEndOffsets lineCommentEndOffsets;

    public ASTRewriteAnalyzer(char[] cArray, LineInformation lineInformation, String string, TextEdit textEdit, RewriteEventStore rewriteEventStore, NodeInfoStore nodeInfoStore, List list, Map map, TargetSourceRangeComputer targetSourceRangeComputer) {
        this.eventStore = rewriteEventStore;
        this.content = cArray;
        this.lineInfo = lineInformation;
        this.nodeInfos = nodeInfoStore;
        this.tokenScanner = null;
        this.currentEdit = textEdit;
        this.sourceCopyInfoToEdit = new IdentityHashMap();
        this.sourceCopyEndNodes = new Stack();
        this.formatter = new ASTRewriteFormatter(nodeInfoStore, rewriteEventStore, map, string);
        this.extendedSourceRangeComputer = targetSourceRangeComputer;
        this.lineCommentEndOffsets = new LineCommentEndOffsets(list);
    }

    final TokenScanner getScanner() {
        if (this.tokenScanner == null) {
            IScanner iScanner = ToolFactory.createScanner(true, false, false, false);
            iScanner.setSource(this.content);
            this.tokenScanner = new TokenScanner(iScanner);
        }
        return this.tokenScanner;
    }

    final char[] getContent() {
        return this.content;
    }

    final LineInformation getLineInformation() {
        return this.lineInfo;
    }

    final TargetSourceRangeComputer.SourceRange getExtendedRange(ASTNode aSTNode) {
        if (this.eventStore.isRangeCopyPlaceholder(aSTNode)) {
            return new TargetSourceRangeComputer.SourceRange(aSTNode.getStartPosition(), aSTNode.getLength());
        }
        return this.extendedSourceRangeComputer.computeSourceRange(aSTNode);
    }

    final int getExtendedOffset(ASTNode aSTNode) {
        return this.getExtendedRange(aSTNode).getStartPosition();
    }

    final int getExtendedEnd(ASTNode aSTNode) {
        TargetSourceRangeComputer.SourceRange sourceRange = this.getExtendedRange(aSTNode);
        return sourceRange.getStartPosition() + sourceRange.getLength();
    }

    final TextEdit getCopySourceEdit(RewriteEventStore.CopySourceInfo copySourceInfo) {
        TextEdit textEdit = (TextEdit)this.sourceCopyInfoToEdit.get(copySourceInfo);
        if (textEdit == null) {
            TargetSourceRangeComputer.SourceRange sourceRange = this.getExtendedRange(copySourceInfo.getNode());
            int n = sourceRange.getStartPosition();
            int n2 = n + sourceRange.getLength();
            if (copySourceInfo.isMove) {
                MoveSourceEdit moveSourceEdit = new MoveSourceEdit(n, n2 - n);
                moveSourceEdit.setTargetEdit(new MoveTargetEdit(0));
                textEdit = moveSourceEdit;
            } else {
                CopySourceEdit copySourceEdit = new CopySourceEdit(n, n2 - n);
                copySourceEdit.setTargetEdit(new CopyTargetEdit(0));
                textEdit = copySourceEdit;
            }
            this.sourceCopyInfoToEdit.put(copySourceInfo, textEdit);
        }
        return textEdit;
    }

    private final int getChangeKind(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null) {
            return rewriteEvent.getChangeKind();
        }
        return 0;
    }

    private final boolean hasChildrenChanges(ASTNode aSTNode) {
        return this.eventStore.hasChangedProperties(aSTNode);
    }

    private final boolean isChanged(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null) {
            return rewriteEvent.getChangeKind() != 0;
        }
        return false;
    }

    private final boolean isCollapsed(ASTNode aSTNode) {
        return this.nodeInfos.isCollapsed(aSTNode);
    }

    final boolean isInsertBoundToPrevious(ASTNode aSTNode) {
        return this.eventStore.isInsertBoundToPrevious(aSTNode);
    }

    private final TextEditGroup getEditGroup(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null) {
            return this.getEditGroup(rewriteEvent);
        }
        return null;
    }

    final RewriteEvent getEvent(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return this.eventStore.getEvent(aSTNode, structuralPropertyDescriptor);
    }

    final TextEditGroup getEditGroup(RewriteEvent rewriteEvent) {
        return this.eventStore.getEventEditGroup(rewriteEvent);
    }

    private final Object getOriginalValue(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return this.eventStore.getOriginalValue(aSTNode, structuralPropertyDescriptor);
    }

    private final Object getNewValue(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return this.eventStore.getNewValue(aSTNode, structuralPropertyDescriptor);
    }

    final void addEdit(TextEdit textEdit) {
        this.currentEdit.addChild(textEdit);
    }

    final String getLineDelimiter() {
        return this.formatter.getLineDelimiter();
    }

    final String createIndentString(int n) {
        return this.formatter.createIndentString(n);
    }

    private final String getIndentOfLine(int n) {
        int n2 = this.getLineInformation().getLineOfOffset(n);
        if (n2 >= 0) {
            int n3;
            char[] cArray = this.getContent();
            int n4 = n3 = this.getLineInformation().getLineOffset(n2);
            while (n4 < cArray.length && IndentManipulation.isIndentChar(this.content[n4])) {
                ++n4;
            }
            return new String(cArray, n3, n4 - n3);
        }
        return new String();
    }

    final String getIndentAtOffset(int n) {
        return this.formatter.getIndentString(this.getIndentOfLine(n));
    }

    final void doTextInsert(int n, String string, TextEditGroup textEditGroup) {
        if (string.length() > 0) {
            InsertEdit insertEdit;
            if (this.lineCommentEndOffsets.isEndOfLineComment(n, this.content)) {
                if (!string.startsWith(this.getLineDelimiter())) {
                    insertEdit = new InsertEdit(n, this.getLineDelimiter());
                    this.addEdit((TextEdit)insertEdit);
                    if (textEditGroup != null) {
                        this.addEditGroup(textEditGroup, (TextEdit)insertEdit);
                    }
                }
                this.lineCommentEndOffsets.remove(n);
            }
            insertEdit = new InsertEdit(n, string);
            this.addEdit((TextEdit)insertEdit);
            if (textEditGroup != null) {
                this.addEditGroup(textEditGroup, (TextEdit)insertEdit);
            }
        }
    }

    final void addEditGroup(TextEditGroup textEditGroup, TextEdit textEdit) {
        textEditGroup.addTextEdit(textEdit);
    }

    final TextEdit doTextRemove(int n, int n2, TextEditGroup textEditGroup) {
        if (n2 == 0) {
            return null;
        }
        DeleteEdit deleteEdit = new DeleteEdit(n, n2);
        this.addEdit((TextEdit)deleteEdit);
        if (textEditGroup != null) {
            this.addEditGroup(textEditGroup, (TextEdit)deleteEdit);
        }
        return deleteEdit;
    }

    final void doTextRemoveAndVisit(int n, int n2, ASTNode aSTNode, TextEditGroup textEditGroup) {
        TextEdit textEdit = this.doTextRemove(n, n2, textEditGroup);
        if (textEdit != null) {
            this.currentEdit = textEdit;
            this.voidVisit(aSTNode);
            this.currentEdit = textEdit.getParent();
        } else {
            this.voidVisit(aSTNode);
        }
    }

    final int doVisit(ASTNode aSTNode) {
        aSTNode.accept(this);
        return this.getExtendedEnd(aSTNode);
    }

    private final int doVisit(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n) {
        Object object = this.getOriginalValue(aSTNode, structuralPropertyDescriptor);
        if (structuralPropertyDescriptor.isChildProperty() && object != null) {
            return this.doVisit((ASTNode)object);
        }
        if (structuralPropertyDescriptor.isChildListProperty()) {
            return this.doVisitList((List)object, n);
        }
        return n;
    }

    private int doVisitList(List list, int n) {
        int n2 = n;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            n2 = this.doVisit(aSTNode);
        }
        return n2;
    }

    final void voidVisit(ASTNode aSTNode) {
        aSTNode.accept(this);
    }

    private final void voidVisit(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        Object object = this.getOriginalValue(aSTNode, structuralPropertyDescriptor);
        if (structuralPropertyDescriptor.isChildProperty() && object != null) {
            this.voidVisit((ASTNode)object);
        } else if (structuralPropertyDescriptor.isChildListProperty()) {
            this.voidVisitList((List)object);
        }
    }

    private void voidVisitList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.doVisit((ASTNode)iterator.next());
        }
    }

    private final boolean doVisitUnchangedChildren(ASTNode aSTNode) {
        List list = aSTNode.structuralPropertiesForType();
        int n = 0;
        while (n < list.size()) {
            this.voidVisit(aSTNode, (StructuralPropertyDescriptor)list.get(n));
            ++n;
        }
        return false;
    }

    private final void doTextReplace(int n, int n2, String string, TextEditGroup textEditGroup) {
        if (n2 > 0 || string.length() > 0) {
            ReplaceEdit replaceEdit = new ReplaceEdit(n, n2, string);
            this.addEdit((TextEdit)replaceEdit);
            if (textEditGroup != null) {
                this.addEditGroup(textEditGroup, (TextEdit)replaceEdit);
            }
        }
    }

    private final TextEdit doTextCopy(TextEdit textEdit, int n, int n2, String string, TextEditGroup textEditGroup) {
        MoveTargetEdit moveTargetEdit;
        SourceModifier sourceModifier = new SourceModifier(n2, string, this.formatter.getTabWidth(), this.formatter.getIndentWidth());
        if (textEdit instanceof MoveSourceEdit) {
            MoveSourceEdit moveSourceEdit = (MoveSourceEdit)textEdit;
            moveSourceEdit.setSourceModifier((ISourceModifier)sourceModifier);
            moveTargetEdit = new MoveTargetEdit(n, moveSourceEdit);
            this.addEdit((TextEdit)moveTargetEdit);
        } else {
            CopySourceEdit copySourceEdit = (CopySourceEdit)textEdit;
            copySourceEdit.setSourceModifier((ISourceModifier)sourceModifier);
            moveTargetEdit = new CopyTargetEdit(n, copySourceEdit);
            this.addEdit((TextEdit)moveTargetEdit);
        }
        if (textEditGroup != null) {
            this.addEditGroup(textEditGroup, textEdit);
            this.addEditGroup(textEditGroup, (TextEdit)moveTargetEdit);
        }
        return moveTargetEdit;
    }

    private void changeNotSupported(ASTNode aSTNode) {
        Assert.isTrue((boolean)false, (String)("Change not supported in " + aSTNode.getClass().getName()));
    }

    private int rewriteRequiredNode(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null && rewriteEvent.getChangeKind() == 4) {
            ASTNode aSTNode2 = (ASTNode)rewriteEvent.getOriginalValue();
            TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
            TargetSourceRangeComputer.SourceRange sourceRange = this.getExtendedRange(aSTNode2);
            int n = sourceRange.getStartPosition();
            int n2 = sourceRange.getLength();
            this.doTextRemoveAndVisit(n, n2, aSTNode2, textEditGroup);
            this.doTextInsert(n, (ASTNode)rewriteEvent.getNewValue(), this.getIndent(n), true, textEditGroup);
            return n + n2;
        }
        return this.doVisit(aSTNode, structuralPropertyDescriptor, 0);
    }

    private int rewriteNode(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n, ASTRewriteFormatter.Prefix prefix) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null) {
            switch (rewriteEvent.getChangeKind()) {
                case 1: {
                    ASTNode aSTNode2 = (ASTNode)rewriteEvent.getNewValue();
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    int n2 = this.getIndent(n);
                    this.doTextInsert(n, prefix.getPrefix(n2), textEditGroup);
                    this.doTextInsert(n, aSTNode2, n2, true, textEditGroup);
                    return n;
                }
                case 2: {
                    ASTNode aSTNode3 = (ASTNode)rewriteEvent.getOriginalValue();
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    int n3 = this.getExtendedEnd(aSTNode3);
                    int n4 = n3 - n;
                    this.doTextRemoveAndVisit(n, n4, aSTNode3, textEditGroup);
                    return n3;
                }
                case 4: {
                    ASTNode aSTNode4 = (ASTNode)rewriteEvent.getOriginalValue();
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    TargetSourceRangeComputer.SourceRange sourceRange = this.getExtendedRange(aSTNode4);
                    int n5 = sourceRange.getStartPosition();
                    int n6 = sourceRange.getLength();
                    this.doTextRemoveAndVisit(n5, n6, aSTNode4, textEditGroup);
                    this.doTextInsert(n5, (ASTNode)rewriteEvent.getNewValue(), this.getIndent(n), true, textEditGroup);
                    return n5 + n6;
                }
            }
        }
        return this.doVisit(aSTNode, structuralPropertyDescriptor, n);
    }

    private int rewriteJavadoc(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        int n = this.rewriteNode(aSTNode, structuralPropertyDescriptor, aSTNode.getStartPosition(), ASTRewriteFormatter.NONE);
        int n2 = this.getChangeKind(aSTNode, structuralPropertyDescriptor);
        if (n2 == 1) {
            String string = String.valueOf(this.getLineDelimiter()) + this.getIndentAtOffset(n);
            this.doTextInsert(n, string, this.getEditGroup(aSTNode, structuralPropertyDescriptor));
        } else if (n2 == 2) {
            try {
                this.getScanner().readNext(n, false);
                this.doTextRemove(n, this.getScanner().getCurrentStartOffset() - n, this.getEditGroup(aSTNode, structuralPropertyDescriptor));
                n = this.getScanner().getCurrentStartOffset();
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
        return n;
    }

    private int rewriteBodyNode(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n, int n2, int n3, ASTRewriteFormatter.BlockContext blockContext) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null) {
            switch (rewriteEvent.getChangeKind()) {
                case 1: {
                    ASTNode aSTNode2 = (ASTNode)rewriteEvent.getNewValue();
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    String[] stringArray = blockContext.getPrefixAndSuffix(n3, aSTNode2, this.eventStore);
                    this.doTextInsert(n, stringArray[0], textEditGroup);
                    this.doTextInsert(n, aSTNode2, n3, true, textEditGroup);
                    this.doTextInsert(n, stringArray[1], textEditGroup);
                    return n;
                }
                case 2: {
                    ASTNode aSTNode3 = (ASTNode)rewriteEvent.getOriginalValue();
                    if (n2 == -1) {
                        n2 = this.getExtendedEnd(aSTNode3);
                    }
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    int n4 = n2 - n;
                    this.doTextRemoveAndVisit(n, n4, aSTNode3, textEditGroup);
                    return n2;
                }
                case 4: {
                    ASTNode aSTNode4 = (ASTNode)rewriteEvent.getOriginalValue();
                    if (n2 == -1) {
                        n2 = this.getExtendedEnd(aSTNode4);
                    }
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    int n5 = n2 - n;
                    ASTNode aSTNode5 = (ASTNode)rewriteEvent.getNewValue();
                    String[] stringArray = blockContext.getPrefixAndSuffix(n3, aSTNode5, this.eventStore);
                    this.doTextRemoveAndVisit(n, n5, aSTNode4, textEditGroup);
                    String string = stringArray[0];
                    this.doTextInsert(n, string, textEditGroup);
                    String string2 = this.getCurrentLine(string, string.length());
                    if (string.length() != string2.length()) {
                        n3 = this.formatter.computeIndentUnits(string2);
                    }
                    this.doTextInsert(n, aSTNode5, n3, true, textEditGroup);
                    this.doTextInsert(n, stringArray[1], textEditGroup);
                    return n2;
                }
            }
        }
        int n6 = this.doVisit(aSTNode, structuralPropertyDescriptor, n);
        if (n2 != -1) {
            return n2;
        }
        return n6;
    }

    private int rewriteOptionalQualifier(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n) {
        Object object;
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null) {
            switch (rewriteEvent.getChangeKind()) {
                case 1: {
                    ASTNode aSTNode2 = (ASTNode)rewriteEvent.getNewValue();
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    this.doTextInsert(n, aSTNode2, this.getIndent(n), true, textEditGroup);
                    this.doTextInsert(n, ".", textEditGroup);
                    return n;
                }
                case 2: {
                    try {
                        ASTNode aSTNode3 = (ASTNode)rewriteEvent.getOriginalValue();
                        TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                        int n2 = this.getScanner().getTokenEndOffset(6, aSTNode3.getStartPosition() + aSTNode3.getLength());
                        this.doTextRemoveAndVisit(n, n2 - n, aSTNode3, textEditGroup);
                        return n2;
                    }
                    catch (CoreException coreException) {
                        this.handleException(coreException);
                        break;
                    }
                }
                case 4: {
                    object = (ASTNode)rewriteEvent.getOriginalValue();
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    TargetSourceRangeComputer.SourceRange sourceRange = this.getExtendedRange((ASTNode)object);
                    int n3 = sourceRange.getStartPosition();
                    int n4 = sourceRange.getLength();
                    this.doTextRemoveAndVisit(n3, n4, (ASTNode)object, textEditGroup);
                    this.doTextInsert(n3, (ASTNode)rewriteEvent.getNewValue(), this.getIndent(n), true, textEditGroup);
                    try {
                        return this.getScanner().getTokenEndOffset(6, n3 + n4);
                    }
                    catch (CoreException coreException) {
                        this.handleException(coreException);
                    }
                }
            }
        }
        if ((object = this.getOriginalValue(aSTNode, structuralPropertyDescriptor)) == null) {
            return n;
        }
        int n5 = this.doVisit((ASTNode)object);
        try {
            return this.getScanner().getTokenEndOffset(6, n5);
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
            return n5;
        }
    }

    private int rewriteParagraphList(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n, int n2, int n3, int n4) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent == null || rewriteEvent.getChangeKind() == 0) {
            return this.doVisit(aSTNode, structuralPropertyDescriptor, n);
        }
        RewriteEvent[] rewriteEventArray = rewriteEvent.getChildren();
        ParagraphListRewriter paragraphListRewriter = new ParagraphListRewriter(n2, n3);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isAllOfKind(rewriteEventArray, 1)) {
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append(this.getLineDelimiter());
                ++n5;
            }
            stringBuffer.append(this.createIndentString(n2));
        }
        return paragraphListRewriter.rewriteList(aSTNode, structuralPropertyDescriptor, n, stringBuffer.toString());
    }

    private int rewriteOptionalTypeParameters(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n, String string, boolean bl, boolean bl2) {
        int n2 = n;
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null && rewriteEvent.getChangeKind() != 0) {
            RewriteEvent[] rewriteEventArray = rewriteEvent.getChildren();
            try {
                int n3;
                boolean bl3;
                boolean bl4 = this.isAllOfKind(rewriteEventArray, 1);
                if (bl4 && bl) {
                    n2 = this.getScanner().getNextStartOffset(n2, false);
                }
                boolean bl5 = bl3 = !bl4 && this.isAllOfKind(rewriteEventArray, 2);
                if (bl3) {
                    n3 = this.getScanner().getTokenStartOffset(69, n2);
                    if (n3 != n2) {
                        bl2 = false;
                    }
                    n2 = n3;
                }
                n2 = new ListRewriter().rewriteList(aSTNode, structuralPropertyDescriptor, n2, String.valueOf('<'), ", ");
                if (bl3) {
                    n3 = this.getScanner().getTokenEndOffset(68, n2);
                    n3 = this.getScanner().getNextStartOffset(n3, false);
                    String string2 = bl2 ? String.valueOf(' ') : new String();
                    this.doTextReplace(n2, n3 - n2, string2, this.getEditGroup(rewriteEventArray[rewriteEventArray.length - 1]));
                    return n3;
                }
                if (bl4) {
                    this.doTextInsert(n2, String.valueOf(String.valueOf('>') + string), this.getEditGroup(rewriteEventArray[rewriteEventArray.length - 1]));
                    return n2;
                }
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            n2 = this.doVisit(aSTNode, structuralPropertyDescriptor, n2);
        }
        if (n2 != n) {
            try {
                return this.getScanner().getTokenEndOffset(68, n2);
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
        return n2;
    }

    private boolean isAllOfKind(RewriteEvent[] rewriteEventArray, int n) {
        int n2 = 0;
        while (n2 < rewriteEventArray.length) {
            if (rewriteEventArray[n2].getChangeKind() != n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private int rewriteNodeList(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n, String string, String string2) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null && rewriteEvent.getChangeKind() != 0) {
            return new ListRewriter().rewriteList(aSTNode, structuralPropertyDescriptor, n, string, string2);
        }
        return this.doVisit(aSTNode, structuralPropertyDescriptor, n);
    }

    private void rewriteMethodBody(MethodDeclaration methodDeclaration, int n) {
        RewriteEvent rewriteEvent = this.getEvent(methodDeclaration, MethodDeclaration.BODY_PROPERTY);
        if (rewriteEvent != null) {
            switch (rewriteEvent.getChangeKind()) {
                case 1: {
                    int n2 = methodDeclaration.getStartPosition() + methodDeclaration.getLength();
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    ASTNode aSTNode = (ASTNode)rewriteEvent.getNewValue();
                    this.doTextRemove(n, n2 - n, textEditGroup);
                    int n3 = this.getIndent(methodDeclaration.getStartPosition());
                    String string = this.formatter.METHOD_BODY.getPrefix(n3);
                    this.doTextInsert(n, string, textEditGroup);
                    this.doTextInsert(n, aSTNode, n3, true, textEditGroup);
                    return;
                }
                case 2: {
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    ASTNode aSTNode = (ASTNode)rewriteEvent.getOriginalValue();
                    int n4 = methodDeclaration.getStartPosition() + methodDeclaration.getLength();
                    this.doTextRemoveAndVisit(n, n4 - n, aSTNode, textEditGroup);
                    this.doTextInsert(n, ";", textEditGroup);
                    return;
                }
                case 4: {
                    TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                    ASTNode aSTNode = (ASTNode)rewriteEvent.getOriginalValue();
                    this.doTextRemoveAndVisit(aSTNode.getStartPosition(), aSTNode.getLength(), aSTNode, textEditGroup);
                    this.doTextInsert(aSTNode.getStartPosition(), (ASTNode)rewriteEvent.getNewValue(), this.getIndent(aSTNode.getStartPosition()), true, textEditGroup);
                    return;
                }
            }
        }
        this.voidVisit(methodDeclaration, MethodDeclaration.BODY_PROPERTY);
    }

    private int rewriteExtraDimensions(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n) {
        int n2;
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent == null || rewriteEvent.getChangeKind() == 0) {
            return (Integer)this.getOriginalValue(aSTNode, structuralPropertyDescriptor);
        }
        int n3 = (Integer)rewriteEvent.getOriginalValue();
        if (n3 != (n2 = ((Integer)rewriteEvent.getNewValue()).intValue())) {
            TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
            this.rewriteExtraDimensions(n3, n2, n, textEditGroup);
        }
        return n3;
    }

    private void rewriteExtraDimensions(int n, int n2, int n3, TextEditGroup textEditGroup) {
        block5: {
            block4: {
                if (n >= n2) break block4;
                int n4 = n;
                while (n4 < n2) {
                    this.doTextInsert(n3, "[]", textEditGroup);
                    ++n4;
                }
                break block5;
            }
            if (n2 >= n) break block5;
            try {
                this.getScanner().setOffset(n3);
                int n5 = n2;
                while (n5 < n) {
                    this.getScanner().readToToken(166);
                    ++n5;
                }
                this.doTextRemove(n3, this.getScanner().getCurrentEndOffset() - n3, textEditGroup);
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
    }

    private int getPosAfterLeftBrace(int n) {
        try {
            int n2 = this.getScanner().readNext(n, true);
            if (n2 == 110) {
                return this.getScanner().getCurrentEndOffset();
            }
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return n;
    }

    final int getIndent(int n) {
        return this.formatter.computeIndentUnits(this.getIndentOfLine(n));
    }

    final void doTextInsert(int n, ASTNode aSTNode, int n2, boolean bl, TextEditGroup textEditGroup) {
        ArrayList<ASTRewriteFormatter.NodeMarker> arrayList = new ArrayList<ASTRewriteFormatter.NodeMarker>();
        String string = this.formatter.getFormattedResult(aSTNode, n2, arrayList);
        int n3 = 0;
        if (bl) {
            while (n3 < string.length() && ScannerHelper.isWhitespace(string.charAt(n3))) {
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < arrayList.size()) {
            Object object;
            Object object2;
            ASTRewriteFormatter.NodeMarker nodeMarker = (ASTRewriteFormatter.NodeMarker)((Object)arrayList.get(n4));
            int n5 = nodeMarker.offset;
            if (n5 != n3) {
                object2 = string.substring(n3, n5);
                this.doTextInsert(n, (String)object2, textEditGroup);
            }
            if ((object2 = nodeMarker.data) instanceof TextEditGroup) {
                object = new RangeMarker(n, 0);
                this.addEditGroup((TextEditGroup)object2, (TextEdit)object);
                this.addEdit((TextEdit)object);
                if (nodeMarker.length != 0) {
                    int n6 = n5 + nodeMarker.length;
                    int n7 = n4 + 1;
                    while (n7 < arrayList.size() && ((ASTRewriteFormatter.NodeMarker)((Object)arrayList.get((int)n7))).offset < n6) {
                        ++n7;
                    }
                    nodeMarker.offset = n6;
                    nodeMarker.length = 0;
                    arrayList.add(n7, nodeMarker);
                }
                n3 = n5;
            } else {
                object = this.formatter.getIndentString(this.getCurrentLine(string, n5));
                if (object2 instanceof NodeInfoStore.CopyPlaceholderData) {
                    RewriteEventStore.CopySourceInfo copySourceInfo = ((NodeInfoStore.CopyPlaceholderData)object2).copySource;
                    int n8 = this.getIndent(copySourceInfo.getNode().getStartPosition());
                    TextEdit textEdit = this.getCopySourceEdit(copySourceInfo);
                    this.doTextCopy(textEdit, n, n8, (String)object, textEditGroup);
                    n3 = n5 + nodeMarker.length;
                    if (this.needsNewLineForLineComment(copySourceInfo.getNode(), string, n3)) {
                        this.doTextInsert(n, this.getLineDelimiter(), textEditGroup);
                    }
                } else if (object2 instanceof NodeInfoStore.StringPlaceholderData) {
                    String string2 = ((NodeInfoStore.StringPlaceholderData)object2).code;
                    String string3 = this.formatter.changeIndent(string2, 0, (String)object);
                    this.doTextInsert(n, string3, textEditGroup);
                    n3 = n5 + nodeMarker.length;
                }
            }
            ++n4;
        }
        if (n3 < string.length()) {
            String string4 = string.substring(n3);
            this.doTextInsert(n, string4, textEditGroup);
        }
    }

    private boolean needsNewLineForLineComment(ASTNode aSTNode, String string, int n) {
        if (!this.lineCommentEndOffsets.isEndOfLineComment(this.getExtendedEnd(aSTNode), this.content)) {
            return false;
        }
        return n < string.length() && !IndentManipulation.isLineDelimiterChar(string.charAt(n));
    }

    private String getCurrentLine(String string, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (IndentManipulation.isLineDelimiterChar(c)) {
                return string.substring(n2 + 1, n);
            }
            --n2;
        }
        return string.substring(0, n);
    }

    private void rewriteModifiers(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n) {
    }

    private int rewriteModifiers2(ASTNode aSTNode, ChildListPropertyDescriptor childListPropertyDescriptor, int n) {
        return this.doVisit(aSTNode, childListPropertyDescriptor, n);
    }

    private void replaceOperation(int n, String string, TextEditGroup textEditGroup) {
        try {
            this.getScanner().readNext(n, true);
            this.doTextReplace(this.getScanner().getCurrentStartOffset(), this.getScanner().getCurrentLength(), string, textEditGroup);
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
    }

    private void rewriteOperation(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null && rewriteEvent.getChangeKind() != 0) {
            try {
                String string = rewriteEvent.getNewValue().toString();
                TextEditGroup textEditGroup = this.getEditGroup(rewriteEvent);
                this.getScanner().readNext(n, true);
                this.doTextReplace(this.getScanner().getCurrentStartOffset(), this.getScanner().getCurrentLength(), string, textEditGroup);
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
    }

    public void postVisit(ASTNode aSTNode) {
        TextEditGroup textEditGroup = this.eventStore.getTrackedNodeData(aSTNode);
        if (textEditGroup != null) {
            this.currentEdit = this.currentEdit.getParent();
        }
        this.doCopySourcePostVisit(aSTNode, this.sourceCopyEndNodes);
    }

    public void preVisit(ASTNode aSTNode) {
        RewriteEventStore.CopySourceInfo[] copySourceInfoArray = this.eventStore.getNodeCopySources(aSTNode);
        this.doCopySourcePreVisit(copySourceInfoArray, this.sourceCopyEndNodes);
        TextEditGroup textEditGroup = this.eventStore.getTrackedNodeData(aSTNode);
        if (textEditGroup != null) {
            TargetSourceRangeComputer.SourceRange sourceRange = this.getExtendedRange(aSTNode);
            int n = sourceRange.getStartPosition();
            int n2 = sourceRange.getLength();
            RangeMarker rangeMarker = new RangeMarker(n, n2);
            this.addEditGroup(textEditGroup, (TextEdit)rangeMarker);
            this.addEdit((TextEdit)rangeMarker);
            this.currentEdit = rangeMarker;
        }
    }

    final void doCopySourcePreVisit(RewriteEventStore.CopySourceInfo[] copySourceInfoArray, Stack stack) {
        if (copySourceInfoArray != null) {
            int n = 0;
            while (n < copySourceInfoArray.length) {
                RewriteEventStore.CopySourceInfo copySourceInfo = copySourceInfoArray[n];
                TextEdit textEdit = this.getCopySourceEdit(copySourceInfo);
                this.addEdit(textEdit);
                this.currentEdit = textEdit;
                stack.push(copySourceInfo.getNode());
                ++n;
            }
        }
    }

    final void doCopySourcePostVisit(ASTNode aSTNode, Stack stack) {
        while (!stack.isEmpty() && stack.peek() == aSTNode) {
            stack.pop();
            this.currentEdit = this.currentEdit.getParent();
        }
    }

    public boolean visit(CompilationUnit compilationUnit) {
        if (!this.hasChildrenChanges(compilationUnit)) {
            return this.doVisitUnchangedChildren(compilationUnit);
        }
        int n = this.rewriteNode(compilationUnit, CompilationUnit.PACKAGE_PROPERTY, 0, ASTRewriteFormatter.NONE);
        if (this.getChangeKind(compilationUnit, CompilationUnit.PACKAGE_PROPERTY) == 1) {
            this.doTextInsert(0, this.getLineDelimiter(), this.getEditGroup(compilationUnit, CompilationUnit.PACKAGE_PROPERTY));
        }
        n = this.rewriteParagraphList(compilationUnit, CompilationUnit.IMPORTS_PROPERTY, n, 0, 0, 2);
        this.rewriteParagraphList(compilationUnit, CompilationUnit.STATEMENTS_PROPERTY, n, 0, -1, 1);
        return false;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        ChildListPropertyDescriptor childListPropertyDescriptor;
        int n;
        int n2;
        int n3;
        Object object;
        if (!this.hasChildrenChanges(typeDeclaration)) {
            return this.doVisitUnchangedChildren(typeDeclaration);
        }
        int n4 = typeDeclaration.getAST().apiLevel();
        int n5 = this.rewriteJavadoc(typeDeclaration, TypeDeclaration.JAVADOC_PROPERTY);
        if (n4 == 2) {
            this.rewriteModifiers(typeDeclaration, TypeDeclaration.MODIFIERS_PROPERTY, n5);
        } else {
            this.rewriteModifiers2(typeDeclaration, TypeDeclaration.MODIFIERS2_PROPERTY, n5);
        }
        boolean bl = (Boolean)this.getOriginalValue(typeDeclaration, TypeDeclaration.INTERFACE_PROPERTY);
        boolean bl2 = this.isChanged(typeDeclaration, TypeDeclaration.INTERFACE_PROPERTY);
        if (bl2) {
            try {
                int n6 = bl ? 180 : 165;
                this.getScanner().readToToken(n6, typeDeclaration.getStartPosition());
                object = bl ? "class" : "interface";
                n3 = this.getScanner().getCurrentStartOffset();
                n2 = this.getScanner().getCurrentEndOffset();
                this.doTextReplace(n3, n2 - n3, (String)object, this.getEditGroup(typeDeclaration, TypeDeclaration.INTERFACE_PROPERTY));
            }
            catch (CoreException coreException) {}
        }
        n5 = this.rewriteRequiredNode(typeDeclaration, TypeDeclaration.NAME_PROPERTY);
        if (n4 >= 3) {
            n5 = this.rewriteOptionalTypeParameters(typeDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY, n5, "", false, true);
        }
        if (!bl || bl2) {
            ChildPropertyDescriptor childPropertyDescriptor = n4 == 2 ? TypeDeclaration.SUPERCLASS_PROPERTY : TypeDeclaration.SUPERCLASS_TYPE_PROPERTY;
            object = this.getEvent(typeDeclaration, childPropertyDescriptor);
            n3 = object != null ? ((RewriteEvent)object).getChangeKind() : 0;
            switch (n3) {
                case 1: {
                    this.doTextInsert(n5, " extends ", this.getEditGroup((RewriteEvent)object));
                    this.doTextInsert(n5, (ASTNode)((RewriteEvent)object).getNewValue(), 0, false, this.getEditGroup((RewriteEvent)object));
                    break;
                }
                case 2: {
                    ASTNode aSTNode = (ASTNode)((RewriteEvent)object).getOriginalValue();
                    int n7 = this.getExtendedEnd(aSTNode);
                    this.doTextRemoveAndVisit(n5, n7 - n5, aSTNode, this.getEditGroup((RewriteEvent)object));
                    n5 = n7;
                    break;
                }
                case 4: {
                    ASTNode aSTNode = (ASTNode)((RewriteEvent)object).getOriginalValue();
                    TargetSourceRangeComputer.SourceRange sourceRange = this.getExtendedRange(aSTNode);
                    n = sourceRange.getStartPosition();
                    int n8 = sourceRange.getLength();
                    this.doTextRemoveAndVisit(n, n8, aSTNode, this.getEditGroup((RewriteEvent)object));
                    this.doTextInsert(n, (ASTNode)((RewriteEvent)object).getNewValue(), 0, false, this.getEditGroup((RewriteEvent)object));
                    n5 = n + n8;
                    break;
                }
                case 0: {
                    n5 = this.doVisit(typeDeclaration, childPropertyDescriptor, n5);
                }
            }
        }
        if ((object = this.getEvent(typeDeclaration, childListPropertyDescriptor = n4 == 2 ? TypeDeclaration.SUPER_INTERFACES_PROPERTY : TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY)) == null || ((RewriteEvent)object).getChangeKind() == 0) {
            List list;
            if (bl2 && !(list = (List)this.getOriginalValue(typeDeclaration, childListPropertyDescriptor)).isEmpty()) {
                String string = bl ? " implements " : " extends ";
                ASTNode aSTNode = (ASTNode)list.get(0);
                this.doTextReplace(n5, aSTNode.getStartPosition() - n5, string, this.getEditGroup(typeDeclaration, TypeDeclaration.INTERFACE_PROPERTY));
            }
            n5 = this.doVisit(typeDeclaration, childListPropertyDescriptor, n5);
        } else {
            List list;
            String string;
            String string2 = string = bl == bl2 ? " implements " : " extends ";
            if (bl2 && !(list = (List)((RewriteEvent)object).getNewValue()).isEmpty()) {
                List list2 = (List)((RewriteEvent)object).getOriginalValue();
                n = n5;
                if (!list2.isEmpty()) {
                    n = ((ASTNode)list2.get(0)).getStartPosition();
                }
                this.doTextReplace(n5, n - n5, string, this.getEditGroup(typeDeclaration, TypeDeclaration.INTERFACE_PROPERTY));
                string = "";
                n5 = n;
            }
            n5 = this.rewriteNodeList(typeDeclaration, childListPropertyDescriptor, n5, string, ", ");
        }
        int n9 = this.getIndent(typeDeclaration.getStartPosition()) + 1;
        n2 = this.getPosAfterLeftBrace(n5);
        this.rewriteParagraphList(typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY, n2, n9, -1, 2);
        return false;
    }

    private void rewriteReturnType(MethodDeclaration methodDeclaration, boolean bl, boolean bl2) {
        boolean bl3;
        ChildPropertyDescriptor childPropertyDescriptor = methodDeclaration.getAST().apiLevel() == 2 ? MethodDeclaration.RETURN_TYPE_PROPERTY : MethodDeclaration.RETURN_TYPE2_PROPERTY;
        ASTNode aSTNode = (ASTNode)this.getOriginalValue(methodDeclaration, childPropertyDescriptor);
        boolean bl4 = bl3 = aSTNode != null && aSTNode.getStartPosition() != -1;
        if (!bl2 && bl3) {
            this.rewriteRequiredNode(methodDeclaration, childPropertyDescriptor);
            return;
        }
        ASTNode aSTNode2 = (ASTNode)this.getNewValue(methodDeclaration, childPropertyDescriptor);
        if (bl2 || !bl3 && aSTNode2 != aSTNode) {
            ASTNode aSTNode3 = (ASTNode)this.getOriginalValue(methodDeclaration, MethodDeclaration.NAME_PROPERTY);
            int n = aSTNode3.getStartPosition();
            TextEditGroup textEditGroup = this.getEditGroup(methodDeclaration, childPropertyDescriptor);
            if (bl || !bl3) {
                this.doTextInsert(n, aSTNode2, this.getIndent(n), true, textEditGroup);
                this.doTextInsert(n, " ", textEditGroup);
            } else {
                int n2 = this.getExtendedOffset(aSTNode);
                this.doTextRemoveAndVisit(n2, n - n2, aSTNode, textEditGroup);
            }
        }
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        if (!this.hasChildrenChanges(methodDeclaration)) {
            return this.doVisitUnchangedChildren(methodDeclaration);
        }
        int n = this.rewriteJavadoc(methodDeclaration, MethodDeclaration.JAVADOC_PROPERTY);
        boolean bl = this.isChanged(methodDeclaration, MethodDeclaration.CONSTRUCTOR_PROPERTY);
        boolean bl2 = (Boolean)this.getOriginalValue(methodDeclaration, MethodDeclaration.CONSTRUCTOR_PROPERTY);
        if (!bl2 || bl) {
            this.rewriteReturnType(methodDeclaration, bl2, bl);
        }
        try {
            n = this.getScanner().getTokenEndOffset(455, n);
            n = this.rewriteNode(methodDeclaration, MethodDeclaration.NAME_PROPERTY, n, ASTRewriteFormatter.NONE);
            if (this.isChanged(methodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY)) {
                n = this.getScanner().getTokenEndOffset(7, n);
                n = this.rewriteNodeList(methodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY, n, "", ", ");
            } else {
                n = this.doVisit(methodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY, n);
            }
            n = this.getScanner().getTokenEndOffset(86, n);
            int n2 = this.rewriteExtraDimensions(methodDeclaration, MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY, n);
            boolean bl3 = this.isChanged(methodDeclaration, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
            int n3 = this.getChangeKind(methodDeclaration, MethodDeclaration.BODY_PROPERTY);
            if (n2 > 0 && (bl3 || n3 == 1 || n3 == 2)) {
                int n4 = (Integer)this.getOriginalValue(methodDeclaration, MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY);
                while (n4 > 0) {
                    n = this.getScanner().getTokenEndOffset(166, n);
                    --n4;
                }
            }
            n = this.rewriteNodeList(methodDeclaration, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY, n, " throws ", ", ");
            this.rewriteMethodBody(methodDeclaration, n);
        }
        catch (CoreException coreException) {}
        return false;
    }

    public boolean visit(FunctionExpression functionExpression) {
        if (!this.hasChildrenChanges(functionExpression)) {
            return this.doVisitUnchangedChildren(functionExpression);
        }
        this.rewriteRequiredNode(functionExpression, FunctionExpression.METHOD_PROPERTY);
        return false;
    }

    public boolean visit(ObjectLiteralField objectLiteralField) {
        if (!this.hasChildrenChanges(objectLiteralField)) {
            return this.doVisitUnchangedChildren(objectLiteralField);
        }
        this.rewriteRequiredNode(objectLiteralField, ObjectLiteralField.FIELD_NAME_PROPERTY);
        this.rewriteRequiredNode(objectLiteralField, ObjectLiteralField.INITIALIZER_PROPERTY);
        return false;
    }

    public boolean visit(RegularExpressionLiteral regularExpressionLiteral) {
        if (!this.hasChildrenChanges(regularExpressionLiteral)) {
            return this.doVisitUnchangedChildren(regularExpressionLiteral);
        }
        String string = (String)this.getNewValue(regularExpressionLiteral, RegularExpressionLiteral.REGULAR_EXPRESSION_PROPERTY);
        TextEditGroup textEditGroup = this.getEditGroup(regularExpressionLiteral, RegularExpressionLiteral.REGULAR_EXPRESSION_PROPERTY);
        this.doTextReplace(regularExpressionLiteral.getStartPosition(), regularExpressionLiteral.getLength(), string, textEditGroup);
        return false;
    }

    public boolean visit(ObjectLiteral objectLiteral) {
        if (!this.hasChildrenChanges(objectLiteral)) {
            return this.doVisitUnchangedChildren(objectLiteral);
        }
        int n = objectLiteral.getStartPosition();
        try {
            if (this.isChanged(objectLiteral, ObjectLiteral.FIELDS_PROPERTY)) {
                n = this.getScanner().getTokenEndOffset(110, n);
                n = this.rewriteNodeList(objectLiteral, ObjectLiteral.FIELDS_PROPERTY, n, "", ", ");
            } else {
                n = this.doVisit(objectLiteral, ObjectLiteral.FIELDS_PROPERTY, n);
            }
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(Block block) {
        if (!this.hasChildrenChanges(block)) {
            return this.doVisitUnchangedChildren(block);
        }
        int n = this.isCollapsed(block) ? block.getStartPosition() : this.getPosAfterLeftBrace(block.getStartPosition());
        int n2 = this.getIndent(block.getStartPosition()) + 1;
        this.rewriteParagraphList(block, Block.STATEMENTS_PROPERTY, n, n2, 0, 1);
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        if (!this.hasChildrenChanges(returnStatement)) {
            return this.doVisitUnchangedChildren(returnStatement);
        }
        try {
            int n = this.getScanner().getTokenEndOffset(124, returnStatement.getStartPosition());
            this.ensureSpaceBeforeReplace(returnStatement, ReturnStatement.EXPRESSION_PROPERTY, n, 0);
            this.rewriteNode(returnStatement, ReturnStatement.EXPRESSION_PROPERTY, n, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        if (!this.hasChildrenChanges(anonymousClassDeclaration)) {
            return this.doVisitUnchangedChildren(anonymousClassDeclaration);
        }
        int n = this.getPosAfterLeftBrace(anonymousClassDeclaration.getStartPosition());
        int n2 = this.getIndent(anonymousClassDeclaration.getStartPosition()) + 1;
        this.rewriteParagraphList(anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY, n, n2, -1, 2);
        return false;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        if (!this.hasChildrenChanges(arrayAccess)) {
            return this.doVisitUnchangedChildren(arrayAccess);
        }
        this.rewriteRequiredNode(arrayAccess, ArrayAccess.ARRAY_PROPERTY);
        this.rewriteRequiredNode(arrayAccess, ArrayAccess.INDEX_PROPERTY);
        return false;
    }

    public boolean visit(ArrayCreation arrayCreation) {
        int n;
        Object object;
        Object object2;
        int n2;
        if (!this.hasChildrenChanges(arrayCreation)) {
            return this.doVisitUnchangedChildren(arrayCreation);
        }
        ArrayType arrayType = (ArrayType)this.getOriginalValue(arrayCreation, ArrayCreation.TYPE_PROPERTY);
        int n3 = n2 = this.getDimensions(arrayType);
        TextEditGroup textEditGroup = null;
        RewriteEvent rewriteEvent = this.getEvent(arrayCreation, ArrayCreation.TYPE_PROPERTY);
        if (rewriteEvent != null && rewriteEvent.getChangeKind() == 4) {
            Type type;
            ArrayType arrayType2 = (ArrayType)rewriteEvent.getNewValue();
            textEditGroup = this.getEditGroup(rewriteEvent);
            object2 = arrayType2.getElementType();
            if (!((ASTNode)object2).equals(type = this.getElementType(arrayType))) {
                object = this.getExtendedRange(type);
                n = ((TargetSourceRangeComputer.SourceRange)object).getStartPosition();
                int n4 = ((TargetSourceRangeComputer.SourceRange)object).getLength();
                this.doTextRemove(n, n4, textEditGroup);
                this.doTextInsert(n, (ASTNode)object2, 0, false, textEditGroup);
            }
            n3 = arrayType2.getDimensions();
        }
        this.voidVisit(arrayType);
        try {
            int n5;
            boolean bl;
            int n6 = this.getScanner().getTokenStartOffset(15, arrayType.getStartPosition());
            object2 = this.getEvent(arrayCreation, ArrayCreation.DIMENSIONS_PROPERTY);
            boolean bl2 = bl = object2 != null && ((RewriteEvent)object2).getChangeKind() != 0;
            if (bl) {
                object = ((RewriteEvent)object2).getChildren();
                n = 0;
                while (n < ((Object)object).length) {
                    Object object3 = object[n];
                    int n7 = ((RewriteEvent)object3).getChangeKind();
                    if (n7 == 1) {
                        textEditGroup = this.getEditGroup((RewriteEvent)object3);
                        this.doTextInsert(n6, "[", textEditGroup);
                        this.doTextInsert(n6, (ASTNode)((RewriteEvent)object3).getNewValue(), 0, false, textEditGroup);
                        this.doTextInsert(n6, "]", textEditGroup);
                        --n3;
                    } else {
                        ASTNode aSTNode = (ASTNode)((RewriteEvent)object3).getOriginalValue();
                        int n8 = aSTNode.getStartPosition() + aSTNode.getLength();
                        int n9 = this.getScanner().getTokenEndOffset(166, n8);
                        if (n7 == 2) {
                            textEditGroup = this.getEditGroup((RewriteEvent)object3);
                            this.doTextRemoveAndVisit(n6, n9 - n6, aSTNode, textEditGroup);
                        } else if (n7 == 4) {
                            textEditGroup = this.getEditGroup((RewriteEvent)object3);
                            TargetSourceRangeComputer.SourceRange sourceRange = this.getExtendedRange(aSTNode);
                            int n10 = sourceRange.getStartPosition();
                            int n11 = sourceRange.getLength();
                            this.doTextRemoveAndVisit(n10, n11, aSTNode, textEditGroup);
                            this.doTextInsert(n10, (ASTNode)((RewriteEvent)object3).getNewValue(), 0, false, textEditGroup);
                            --n3;
                        } else {
                            this.voidVisit(aSTNode);
                            --n3;
                        }
                        n6 = n9;
                        --n2;
                    }
                    ++n;
                }
            } else {
                n6 = this.doVisit(arrayCreation, ArrayCreation.DIMENSIONS_PROPERTY, n6);
            }
            if (n2 != n3) {
                if (!bl) {
                    n6 = this.getScanner().getTokenEndOffset(166, n6);
                }
                this.rewriteExtraDimensions(n2, n3, n6, textEditGroup);
            }
            n6 = (n5 = this.getChangeKind(arrayCreation, ArrayCreation.INITIALIZER_PROPERTY)) == 2 ? this.getScanner().getPreviousTokenEndOffset(110, n6) : arrayCreation.getStartPosition() + arrayCreation.getLength();
            this.rewriteNode(arrayCreation, ArrayCreation.INITIALIZER_PROPERTY, n6, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    private Type getElementType(ArrayType arrayType) {
        Type type = (Type)this.getOriginalValue(arrayType, ArrayType.COMPONENT_TYPE_PROPERTY);
        while (type.isArrayType()) {
            type = (Type)this.getOriginalValue(type, ArrayType.COMPONENT_TYPE_PROPERTY);
        }
        return type;
    }

    private int getDimensions(ArrayType arrayType) {
        Type type = (Type)this.getOriginalValue(arrayType, ArrayType.COMPONENT_TYPE_PROPERTY);
        int n = 1;
        while (type.isArrayType()) {
            ++n;
            type = (Type)this.getOriginalValue(type, ArrayType.COMPONENT_TYPE_PROPERTY);
        }
        return n;
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        if (!this.hasChildrenChanges(arrayInitializer)) {
            return this.doVisitUnchangedChildren(arrayInitializer);
        }
        int n = this.getPosAfterLeftBrace(arrayInitializer.getStartPosition());
        this.rewriteNodeList(arrayInitializer, ArrayInitializer.EXPRESSIONS_PROPERTY, n, "", ", ");
        return false;
    }

    public boolean visit(ArrayType arrayType) {
        if (!this.hasChildrenChanges(arrayType)) {
            return this.doVisitUnchangedChildren(arrayType);
        }
        this.rewriteRequiredNode(arrayType, ArrayType.COMPONENT_TYPE_PROPERTY);
        return false;
    }

    public boolean visit(AssertStatement assertStatement) {
        if (!this.hasChildrenChanges(assertStatement)) {
            return this.doVisitUnchangedChildren(assertStatement);
        }
        this.ensureSpaceBeforeReplace(assertStatement, AssertStatement.EXPRESSION_PROPERTY, assertStatement.getStartPosition(), 1);
        int n = this.rewriteRequiredNode(assertStatement, AssertStatement.EXPRESSION_PROPERTY);
        this.rewriteNode(assertStatement, AssertStatement.MESSAGE_PROPERTY, n, ASTRewriteFormatter.ASSERT_COMMENT);
        return false;
    }

    public boolean visit(Assignment assignment) {
        if (!this.hasChildrenChanges(assignment)) {
            return this.doVisitUnchangedChildren(assignment);
        }
        int n = this.rewriteRequiredNode(assignment, Assignment.LEFT_HAND_SIDE_PROPERTY);
        this.rewriteOperation(assignment, Assignment.OPERATOR_PROPERTY, n);
        this.rewriteRequiredNode(assignment, Assignment.RIGHT_HAND_SIDE_PROPERTY);
        return false;
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        if (!this.hasChildrenChanges(booleanLiteral)) {
            return this.doVisitUnchangedChildren(booleanLiteral);
        }
        Boolean bl = (Boolean)this.getNewValue(booleanLiteral, BooleanLiteral.BOOLEAN_VALUE_PROPERTY);
        TextEditGroup textEditGroup = this.getEditGroup(booleanLiteral, BooleanLiteral.BOOLEAN_VALUE_PROPERTY);
        this.doTextReplace(booleanLiteral.getStartPosition(), booleanLiteral.getLength(), bl.toString(), textEditGroup);
        return false;
    }

    public boolean visit(BreakStatement breakStatement) {
        if (!this.hasChildrenChanges(breakStatement)) {
            return this.doVisitUnchangedChildren(breakStatement);
        }
        try {
            int n = this.getScanner().getTokenEndOffset(119, breakStatement.getStartPosition());
            this.rewriteNode(breakStatement, BreakStatement.LABEL_PROPERTY, n, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        if (!this.hasChildrenChanges(castExpression)) {
            return this.doVisitUnchangedChildren(castExpression);
        }
        this.rewriteRequiredNode(castExpression, CastExpression.TYPE_PROPERTY);
        this.rewriteRequiredNode(castExpression, CastExpression.EXPRESSION_PROPERTY);
        return false;
    }

    public boolean visit(CatchClause catchClause) {
        if (!this.hasChildrenChanges(catchClause)) {
            return this.doVisitUnchangedChildren(catchClause);
        }
        this.rewriteRequiredNode(catchClause, CatchClause.EXCEPTION_PROPERTY);
        this.rewriteRequiredNode(catchClause, CatchClause.BODY_PROPERTY);
        return false;
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        if (!this.hasChildrenChanges(characterLiteral)) {
            return this.doVisitUnchangedChildren(characterLiteral);
        }
        String string = (String)this.getNewValue(characterLiteral, CharacterLiteral.ESCAPED_VALUE_PROPERTY);
        TextEditGroup textEditGroup = this.getEditGroup(characterLiteral, CharacterLiteral.ESCAPED_VALUE_PROPERTY);
        this.doTextReplace(characterLiteral.getStartPosition(), characterLiteral.getLength(), string, textEditGroup);
        return false;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        int n;
        if (!this.hasChildrenChanges(classInstanceCreation)) {
            return this.doVisitUnchangedChildren(classInstanceCreation);
        }
        int n2 = this.rewriteOptionalQualifier(classInstanceCreation, ClassInstanceCreation.EXPRESSION_PROPERTY, classInstanceCreation.getStartPosition());
        n2 = this.rewriteRequiredNode(classInstanceCreation, ClassInstanceCreation.MEMBER_PROPERTY);
        if (this.isChanged(classInstanceCreation, ClassInstanceCreation.ARGUMENTS_PROPERTY)) {
            try {
                n = this.getScanner().getTokenEndOffset(7, n2);
                this.rewriteNodeList(classInstanceCreation, ClassInstanceCreation.ARGUMENTS_PROPERTY, n, "", ", ");
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(classInstanceCreation, ClassInstanceCreation.ARGUMENTS_PROPERTY);
        }
        n = this.getChangeKind(classInstanceCreation, ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY);
        if (n == 2) {
            try {
                n2 = this.getScanner().getPreviousTokenEndOffset(110, n2);
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            n2 = classInstanceCreation.getStartPosition() + classInstanceCreation.getLength();
        }
        this.rewriteNode(classInstanceCreation, ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY, n2, ASTRewriteFormatter.SPACE);
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        if (!this.hasChildrenChanges(conditionalExpression)) {
            return this.doVisitUnchangedChildren(conditionalExpression);
        }
        this.rewriteRequiredNode(conditionalExpression, ConditionalExpression.EXPRESSION_PROPERTY);
        this.rewriteRequiredNode(conditionalExpression, ConditionalExpression.THEN_EXPRESSION_PROPERTY);
        this.rewriteRequiredNode(conditionalExpression, ConditionalExpression.ELSE_EXPRESSION_PROPERTY);
        return false;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        if (!this.hasChildrenChanges(constructorInvocation)) {
            return this.doVisitUnchangedChildren(constructorInvocation);
        }
        int n = constructorInvocation.getStartPosition();
        if (constructorInvocation.getAST().apiLevel() >= 3) {
            n = this.rewriteOptionalTypeParameters(constructorInvocation, ConstructorInvocation.TYPE_ARGUMENTS_PROPERTY, n, "", false, false);
        }
        try {
            n = this.getScanner().getTokenEndOffset(7, n);
            this.rewriteNodeList(constructorInvocation, ConstructorInvocation.ARGUMENTS_PROPERTY, n, "", ", ");
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(ContinueStatement continueStatement) {
        if (!this.hasChildrenChanges(continueStatement)) {
            return this.doVisitUnchangedChildren(continueStatement);
        }
        try {
            int n = this.getScanner().getTokenEndOffset(120, continueStatement.getStartPosition());
            this.rewriteNode(continueStatement, ContinueStatement.LABEL_PROPERTY, n, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        if (!this.hasChildrenChanges(doStatement)) {
            return this.doVisitUnchangedChildren(doStatement);
        }
        int n = doStatement.getStartPosition();
        try {
            RewriteEvent rewriteEvent = this.getEvent(doStatement, DoStatement.BODY_PROPERTY);
            if (rewriteEvent != null && rewriteEvent.getChangeKind() == 4) {
                int n2 = this.getScanner().getTokenEndOffset(121, n);
                ASTNode aSTNode = (ASTNode)rewriteEvent.getOriginalValue();
                int n3 = aSTNode.getStartPosition() + aSTNode.getLength();
                int n4 = this.getScanner().getTokenStartOffset(117, n3);
                this.rewriteBodyNode(doStatement, DoStatement.BODY_PROPERTY, n2, n4, this.getIndent(doStatement.getStartPosition()), this.formatter.DO_BLOCK);
            } else {
                this.voidVisit(doStatement, DoStatement.BODY_PROPERTY);
            }
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        this.rewriteRequiredNode(doStatement, DoStatement.EXPRESSION_PROPERTY);
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        if (!this.hasChildrenChanges(emptyStatement)) {
            return this.doVisitUnchangedChildren(emptyStatement);
        }
        this.changeNotSupported(emptyStatement);
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        if (!this.hasChildrenChanges(expressionStatement)) {
            return this.doVisitUnchangedChildren(expressionStatement);
        }
        this.rewriteRequiredNode(expressionStatement, ExpressionStatement.EXPRESSION_PROPERTY);
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        if (!this.hasChildrenChanges(fieldAccess)) {
            return this.doVisitUnchangedChildren(fieldAccess);
        }
        this.rewriteRequiredNode(fieldAccess, FieldAccess.EXPRESSION_PROPERTY);
        this.rewriteRequiredNode(fieldAccess, FieldAccess.NAME_PROPERTY);
        return false;
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        if (!this.hasChildrenChanges(fieldDeclaration)) {
            return this.doVisitUnchangedChildren(fieldDeclaration);
        }
        int n = this.rewriteJavadoc(fieldDeclaration, FieldDeclaration.JAVADOC_PROPERTY);
        if (fieldDeclaration.getAST().apiLevel() == 2) {
            this.rewriteModifiers(fieldDeclaration, FieldDeclaration.MODIFIERS_PROPERTY, n);
        } else {
            this.rewriteModifiers2(fieldDeclaration, FieldDeclaration.MODIFIERS2_PROPERTY, n);
        }
        n = this.rewriteRequiredNode(fieldDeclaration, FieldDeclaration.TYPE_PROPERTY);
        this.rewriteNodeList(fieldDeclaration, FieldDeclaration.FRAGMENTS_PROPERTY, n, "", ", ");
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        if (!this.hasChildrenChanges(forStatement)) {
            return this.doVisitUnchangedChildren(forStatement);
        }
        try {
            int n;
            int n2 = forStatement.getStartPosition();
            if (this.isChanged(forStatement, ForStatement.INITIALIZERS_PROPERTY)) {
                n = this.getScanner().getTokenEndOffset(7, n2);
                n2 = this.rewriteNodeList(forStatement, ForStatement.INITIALIZERS_PROPERTY, n, "", ", ");
            } else {
                n2 = this.doVisit(forStatement, ForStatement.INITIALIZERS_PROPERTY, n2);
            }
            n2 = this.getScanner().getTokenEndOffset(64, n2);
            n2 = this.rewriteNode(forStatement, ForStatement.EXPRESSION_PROPERTY, n2, ASTRewriteFormatter.NONE);
            if (this.isChanged(forStatement, ForStatement.UPDATERS_PROPERTY)) {
                n = this.getScanner().getTokenEndOffset(64, n2);
                n2 = this.rewriteNodeList(forStatement, ForStatement.UPDATERS_PROPERTY, n, "", ", ");
            } else {
                n2 = this.doVisit(forStatement, ForStatement.UPDATERS_PROPERTY, n2);
            }
            RewriteEvent rewriteEvent = this.getEvent(forStatement, ForStatement.BODY_PROPERTY);
            if (rewriteEvent != null && rewriteEvent.getChangeKind() == 4) {
                int n3 = this.getScanner().getTokenEndOffset(86, n2);
                this.rewriteBodyNode(forStatement, ForStatement.BODY_PROPERTY, n3, -1, this.getIndent(forStatement.getStartPosition()), this.formatter.FOR_BLOCK);
            } else {
                this.voidVisit(forStatement, ForStatement.BODY_PROPERTY);
            }
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(ForInStatement forInStatement) {
        if (!this.hasChildrenChanges(forInStatement)) {
            return this.doVisitUnchangedChildren(forInStatement);
        }
        try {
            int n = forInStatement.getStartPosition();
            n = this.rewriteNode(forInStatement, ForInStatement.ITERATION_VARIABLE_PROPERTY, n, ASTRewriteFormatter.NONE);
            n = this.getScanner().getTokenEndOffset(456, n);
            n = this.rewriteNode(forInStatement, ForInStatement.COLLECTION_PROPERTY, n, ASTRewriteFormatter.NONE);
            RewriteEvent rewriteEvent = this.getEvent(forInStatement, ForInStatement.BODY_PROPERTY);
            if (rewriteEvent != null && rewriteEvent.getChangeKind() == 4) {
                int n2 = this.getScanner().getTokenEndOffset(86, n);
                this.rewriteBodyNode(forInStatement, ForInStatement.BODY_PROPERTY, n2, -1, this.getIndent(forInStatement.getStartPosition()), this.formatter.FOR_BLOCK);
            } else {
                this.voidVisit(forInStatement, ForInStatement.BODY_PROPERTY);
            }
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        int n;
        int n2;
        int n3;
        block11: {
            if (!this.hasChildrenChanges(ifStatement)) {
                return this.doVisitUnchangedChildren(ifStatement);
            }
            n3 = this.rewriteRequiredNode(ifStatement, IfStatement.EXPRESSION_PROPERTY);
            RewriteEvent rewriteEvent = this.getEvent(ifStatement, IfStatement.THEN_STATEMENT_PROPERTY);
            n2 = this.getChangeKind(ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY);
            if (rewriteEvent != null && rewriteEvent.getChangeKind() != 0) {
                try {
                    n3 = this.getScanner().getTokenEndOffset(86, n3);
                    n = this.getIndent(ifStatement.getStartPosition());
                    int n4 = -1;
                    Object object = this.getOriginalValue(ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY);
                    if (object != null) {
                        ASTNode aSTNode = (ASTNode)rewriteEvent.getOriginalValue();
                        n4 = this.getScanner().getTokenStartOffset(213, aSTNode.getStartPosition() + aSTNode.getLength());
                    }
                    if (object == null || n2 != 0) {
                        n3 = this.rewriteBodyNode(ifStatement, IfStatement.THEN_STATEMENT_PROPERTY, n3, n4, n, this.formatter.IF_BLOCK_NO_ELSE);
                        break block11;
                    }
                    n3 = this.rewriteBodyNode(ifStatement, IfStatement.THEN_STATEMENT_PROPERTY, n3, n4, n, this.formatter.IF_BLOCK_WITH_ELSE);
                }
                catch (CoreException coreException) {
                    this.handleException(coreException);
                }
            } else {
                n3 = this.doVisit(ifStatement, IfStatement.THEN_STATEMENT_PROPERTY, n3);
            }
        }
        if (n2 != 0) {
            n = this.getIndent(ifStatement.getStartPosition());
            Object object = this.getNewValue(ifStatement, IfStatement.THEN_STATEMENT_PROPERTY);
            if (object instanceof Block) {
                this.rewriteBodyNode(ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY, n3, -1, n, this.formatter.ELSE_AFTER_BLOCK);
            } else {
                this.rewriteBodyNode(ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY, n3, -1, n, this.formatter.ELSE_AFTER_STATEMENT);
            }
        } else {
            n3 = this.doVisit(ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY, n3);
        }
        return false;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        int n;
        boolean bl;
        RewriteEvent rewriteEvent;
        if (!this.hasChildrenChanges(importDeclaration)) {
            return this.doVisitUnchangedChildren(importDeclaration);
        }
        if (importDeclaration.getAST().apiLevel() >= 3 && (rewriteEvent = this.getEvent(importDeclaration, ImportDeclaration.STATIC_PROPERTY)) != null && rewriteEvent.getChangeKind() != 0) {
            try {
                int n2 = this.getScanner().getTokenEndOffset(191, importDeclaration.getStartPosition());
                bl = (Boolean)rewriteEvent.getOriginalValue();
                if (bl) {
                    n = this.getScanner().getTokenEndOffset(94, n2);
                    this.doTextRemove(n2, n - n2, this.getEditGroup(rewriteEvent));
                } else {
                    this.doTextInsert(n2, " static", this.getEditGroup(rewriteEvent));
                }
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
        int n3 = this.rewriteRequiredNode(importDeclaration, ImportDeclaration.NAME_PROPERTY);
        RewriteEvent rewriteEvent2 = this.getEvent(importDeclaration, ImportDeclaration.ON_DEMAND_PROPERTY);
        if (rewriteEvent2 != null && rewriteEvent2.getChangeKind() != 0) {
            bl = (Boolean)rewriteEvent2.getOriginalValue();
            if (!bl) {
                this.doTextInsert(n3, ".*", this.getEditGroup(rewriteEvent2));
            } else {
                try {
                    n = this.getScanner().getTokenStartOffset(64, n3);
                    this.doTextRemove(n3, n - n3, this.getEditGroup(rewriteEvent2));
                }
                catch (CoreException coreException) {
                    this.handleException(coreException);
                }
            }
        }
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        if (!this.hasChildrenChanges(infixExpression)) {
            return this.doVisitUnchangedChildren(infixExpression);
        }
        int n = this.rewriteRequiredNode(infixExpression, InfixExpression.LEFT_OPERAND_PROPERTY);
        boolean bl = this.isChanged(infixExpression, InfixExpression.OPERATOR_PROPERTY);
        String string = this.getNewValue(infixExpression, InfixExpression.OPERATOR_PROPERTY).toString();
        if (bl) {
            this.replaceOperation(n, string, this.getEditGroup(infixExpression, InfixExpression.OPERATOR_PROPERTY));
        }
        n = this.rewriteRequiredNode(infixExpression, InfixExpression.RIGHT_OPERAND_PROPERTY);
        RewriteEvent rewriteEvent = this.getEvent(infixExpression, InfixExpression.EXTENDED_OPERANDS_PROPERTY);
        String string2 = String.valueOf(' ') + string + ' ';
        if (bl) {
            int n2 = n;
            TextEditGroup textEditGroup = this.getEditGroup(infixExpression, InfixExpression.OPERATOR_PROPERTY);
            if (rewriteEvent != null && rewriteEvent.getChangeKind() != 0) {
                RewriteEvent[] rewriteEventArray = rewriteEvent.getChildren();
                int n3 = 0;
                while (n3 < rewriteEventArray.length) {
                    RewriteEvent rewriteEvent2 = rewriteEventArray[n3];
                    ASTNode aSTNode = (ASTNode)rewriteEvent2.getOriginalValue();
                    if (aSTNode != null) {
                        if (rewriteEvent2.getChangeKind() != 4) {
                            this.replaceOperation(n2, string, textEditGroup);
                        }
                        n2 = aSTNode.getStartPosition() + aSTNode.getLength();
                    }
                    ++n3;
                }
            } else {
                List list = (List)this.getOriginalValue(infixExpression, InfixExpression.EXTENDED_OPERANDS_PROPERTY);
                int n4 = 0;
                while (n4 < list.size()) {
                    ASTNode aSTNode = (ASTNode)list.get(n4);
                    this.replaceOperation(n2, string, textEditGroup);
                    n2 = aSTNode.getStartPosition() + aSTNode.getLength();
                    ++n4;
                }
            }
        }
        this.rewriteNodeList(infixExpression, InfixExpression.EXTENDED_OPERANDS_PROPERTY, n, string2, string2);
        return false;
    }

    public boolean visit(Initializer initializer) {
        if (!this.hasChildrenChanges(initializer)) {
            return this.doVisitUnchangedChildren(initializer);
        }
        int n = this.rewriteJavadoc(initializer, Initializer.JAVADOC_PROPERTY);
        if (initializer.getAST().apiLevel() == 2) {
            this.rewriteModifiers(initializer, Initializer.MODIFIERS_PROPERTY, n);
        } else {
            this.rewriteModifiers2(initializer, Initializer.MODIFIERS2_PROPERTY, n);
        }
        this.rewriteRequiredNode(initializer, Initializer.BODY_PROPERTY);
        return false;
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        if (!this.hasChildrenChanges(instanceofExpression)) {
            return this.doVisitUnchangedChildren(instanceofExpression);
        }
        this.rewriteRequiredNode(instanceofExpression, InstanceofExpression.LEFT_OPERAND_PROPERTY);
        this.ensureSpaceAfterReplace(instanceofExpression, InstanceofExpression.LEFT_OPERAND_PROPERTY);
        this.rewriteRequiredNode(instanceofExpression, InstanceofExpression.RIGHT_OPERAND_PROPERTY);
        return false;
    }

    public void ensureSpaceAfterReplace(ASTNode aSTNode, ChildPropertyDescriptor childPropertyDescriptor) {
        if (this.getChangeKind(aSTNode, childPropertyDescriptor) == 4) {
            int n = this.getExtendedEnd((ASTNode)this.getOriginalValue(aSTNode, childPropertyDescriptor));
            try {
                int n2 = this.getScanner().getNextStartOffset(n, true);
                if (n2 == n) {
                    this.doTextInsert(n2, String.valueOf(' '), this.getEditGroup(aSTNode, childPropertyDescriptor));
                }
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
    }

    public void ensureSpaceBeforeReplace(ASTNode aSTNode, ChildPropertyDescriptor childPropertyDescriptor, int n, int n2) {
        if (this.getChangeKind(aSTNode, childPropertyDescriptor) == 4) {
            try {
                while (n2 > 0) {
                    n = this.getScanner().getNextEndOffset(n, true);
                    --n2;
                }
                if (n == this.getExtendedOffset((ASTNode)this.getOriginalValue(aSTNode, childPropertyDescriptor))) {
                    this.doTextInsert(n, String.valueOf(' '), this.getEditGroup(aSTNode, childPropertyDescriptor));
                }
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
    }

    public boolean visit(Javadoc javadoc) {
        if (!this.hasChildrenChanges(javadoc)) {
            return this.doVisitUnchangedChildren(javadoc);
        }
        int n = javadoc.getStartPosition() + 3;
        String string = String.valueOf(this.getLineDelimiter()) + this.getIndentAtOffset(javadoc.getStartPosition()) + " * ";
        this.rewriteNodeList(javadoc, Javadoc.TAGS_PROPERTY, n, string, string);
        return false;
    }

    public boolean visit(LabeledStatement labeledStatement) {
        if (!this.hasChildrenChanges(labeledStatement)) {
            return this.doVisitUnchangedChildren(labeledStatement);
        }
        this.rewriteRequiredNode(labeledStatement, LabeledStatement.LABEL_PROPERTY);
        this.rewriteRequiredNode(labeledStatement, LabeledStatement.BODY_PROPERTY);
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        if (!this.hasChildrenChanges(methodInvocation)) {
            return this.doVisitUnchangedChildren(methodInvocation);
        }
        int n = this.rewriteOptionalQualifier(methodInvocation, MethodInvocation.EXPRESSION_PROPERTY, methodInvocation.getStartPosition());
        if (methodInvocation.getAST().apiLevel() >= 3) {
            n = this.rewriteOptionalTypeParameters(methodInvocation, MethodInvocation.TYPE_ARGUMENTS_PROPERTY, n, "", false, false);
        }
        n = this.rewriteOptionalQualifier(methodInvocation, MethodInvocation.NAME_PROPERTY, n);
        if (this.isChanged(methodInvocation, MethodInvocation.ARGUMENTS_PROPERTY)) {
            try {
                int n2 = this.getScanner().getTokenEndOffset(7, n);
                this.rewriteNodeList(methodInvocation, MethodInvocation.ARGUMENTS_PROPERTY, n2, "", ", ");
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(methodInvocation, MethodInvocation.ARGUMENTS_PROPERTY);
        }
        return false;
    }

    public boolean visit(NullLiteral nullLiteral) {
        if (!this.hasChildrenChanges(nullLiteral)) {
            return this.doVisitUnchangedChildren(nullLiteral);
        }
        this.changeNotSupported(nullLiteral);
        return false;
    }

    public boolean visit(NumberLiteral numberLiteral) {
        if (!this.hasChildrenChanges(numberLiteral)) {
            return this.doVisitUnchangedChildren(numberLiteral);
        }
        String string = (String)this.getNewValue(numberLiteral, NumberLiteral.TOKEN_PROPERTY);
        TextEditGroup textEditGroup = this.getEditGroup(numberLiteral, NumberLiteral.TOKEN_PROPERTY);
        this.doTextReplace(numberLiteral.getStartPosition(), numberLiteral.getLength(), string, textEditGroup);
        return false;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        if (!this.hasChildrenChanges(packageDeclaration)) {
            return this.doVisitUnchangedChildren(packageDeclaration);
        }
        if (packageDeclaration.getAST().apiLevel() >= 3) {
            int n = this.rewriteJavadoc(packageDeclaration, PackageDeclaration.JAVADOC_PROPERTY);
            this.rewriteNodeList(packageDeclaration, PackageDeclaration.ANNOTATIONS_PROPERTY, n, "", " ");
        }
        this.rewriteRequiredNode(packageDeclaration, PackageDeclaration.NAME_PROPERTY);
        return false;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        if (!this.hasChildrenChanges(parenthesizedExpression)) {
            return this.doVisitUnchangedChildren(parenthesizedExpression);
        }
        this.rewriteRequiredNode(parenthesizedExpression, ParenthesizedExpression.EXPRESSION_PROPERTY);
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        if (!this.hasChildrenChanges(postfixExpression)) {
            return this.doVisitUnchangedChildren(postfixExpression);
        }
        int n = this.rewriteRequiredNode(postfixExpression, PostfixExpression.OPERAND_PROPERTY);
        this.rewriteOperation(postfixExpression, PostfixExpression.OPERATOR_PROPERTY, n);
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        if (!this.hasChildrenChanges(prefixExpression)) {
            return this.doVisitUnchangedChildren(prefixExpression);
        }
        this.rewriteOperation(prefixExpression, PrefixExpression.OPERATOR_PROPERTY, prefixExpression.getStartPosition());
        this.rewriteRequiredNode(prefixExpression, PrefixExpression.OPERAND_PROPERTY);
        return false;
    }

    public boolean visit(PrimitiveType primitiveType) {
        if (!this.hasChildrenChanges(primitiveType)) {
            return this.doVisitUnchangedChildren(primitiveType);
        }
        PrimitiveType.Code code = (PrimitiveType.Code)this.getNewValue(primitiveType, PrimitiveType.PRIMITIVE_TYPE_CODE_PROPERTY);
        TextEditGroup textEditGroup = this.getEditGroup(primitiveType, PrimitiveType.PRIMITIVE_TYPE_CODE_PROPERTY);
        this.doTextReplace(primitiveType.getStartPosition(), primitiveType.getLength(), code.toString(), textEditGroup);
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        if (!this.hasChildrenChanges(qualifiedName)) {
            return this.doVisitUnchangedChildren(qualifiedName);
        }
        this.rewriteRequiredNode(qualifiedName, QualifiedName.QUALIFIER_PROPERTY);
        this.rewriteRequiredNode(qualifiedName, QualifiedName.NAME_PROPERTY);
        return false;
    }

    public boolean visit(SimpleName simpleName) {
        if (!this.hasChildrenChanges(simpleName)) {
            return this.doVisitUnchangedChildren(simpleName);
        }
        String string = (String)this.getNewValue(simpleName, SimpleName.IDENTIFIER_PROPERTY);
        TextEditGroup textEditGroup = this.getEditGroup(simpleName, SimpleName.IDENTIFIER_PROPERTY);
        this.doTextReplace(simpleName.getStartPosition(), simpleName.getLength(), string, textEditGroup);
        return false;
    }

    public boolean visit(SimpleType simpleType) {
        if (!this.hasChildrenChanges(simpleType)) {
            return this.doVisitUnchangedChildren(simpleType);
        }
        this.rewriteRequiredNode(simpleType, SimpleType.NAME_PROPERTY);
        return false;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        int n;
        if (!this.hasChildrenChanges(singleVariableDeclaration)) {
            return this.doVisitUnchangedChildren(singleVariableDeclaration);
        }
        int n2 = singleVariableDeclaration.getStartPosition();
        if (singleVariableDeclaration.getAST().apiLevel() == 2) {
            this.rewriteModifiers(singleVariableDeclaration, SingleVariableDeclaration.MODIFIERS_PROPERTY, n2);
        } else {
            this.rewriteModifiers2(singleVariableDeclaration, SingleVariableDeclaration.MODIFIERS2_PROPERTY, n2);
        }
        n2 = this.rewriteRequiredNode(singleVariableDeclaration, SingleVariableDeclaration.TYPE_PROPERTY);
        if (singleVariableDeclaration.getAST().apiLevel() >= 3 && this.isChanged(singleVariableDeclaration, SingleVariableDeclaration.VARARGS_PROPERTY)) {
            if (this.getNewValue(singleVariableDeclaration, SingleVariableDeclaration.VARARGS_PROPERTY).equals(Boolean.TRUE)) {
                this.doTextInsert(n2, "...", this.getEditGroup(singleVariableDeclaration, SingleVariableDeclaration.VARARGS_PROPERTY));
            } else {
                try {
                    n = this.getScanner().getNextEndOffset(n2, true);
                    this.doTextRemove(n2, n - n2, this.getEditGroup(singleVariableDeclaration, SingleVariableDeclaration.VARARGS_PROPERTY));
                }
                catch (CoreException coreException) {
                    this.handleException(coreException);
                }
            }
        }
        if ((n = this.rewriteExtraDimensions(singleVariableDeclaration, SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, n2 = this.rewriteRequiredNode(singleVariableDeclaration, SingleVariableDeclaration.NAME_PROPERTY))) > 0) {
            int n3 = this.getChangeKind(singleVariableDeclaration, SingleVariableDeclaration.INITIALIZER_PROPERTY);
            if (n3 == 2) {
                try {
                    n2 = this.getScanner().getPreviousTokenEndOffset(167, n2);
                }
                catch (CoreException coreException) {
                    this.handleException(coreException);
                }
            } else {
                n2 = singleVariableDeclaration.getStartPosition() + singleVariableDeclaration.getLength();
            }
        }
        this.rewriteNode(singleVariableDeclaration, SingleVariableDeclaration.INITIALIZER_PROPERTY, n2, this.formatter.VAR_INITIALIZER);
        return false;
    }

    public boolean visit(StringLiteral stringLiteral) {
        if (!this.hasChildrenChanges(stringLiteral)) {
            return this.doVisitUnchangedChildren(stringLiteral);
        }
        String string = (String)this.getNewValue(stringLiteral, StringLiteral.ESCAPED_VALUE_PROPERTY);
        TextEditGroup textEditGroup = this.getEditGroup(stringLiteral, StringLiteral.ESCAPED_VALUE_PROPERTY);
        this.doTextReplace(stringLiteral.getStartPosition(), stringLiteral.getLength(), string, textEditGroup);
        return false;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        if (!this.hasChildrenChanges(superConstructorInvocation)) {
            return this.doVisitUnchangedChildren(superConstructorInvocation);
        }
        int n = this.rewriteOptionalQualifier(superConstructorInvocation, SuperConstructorInvocation.EXPRESSION_PROPERTY, superConstructorInvocation.getStartPosition());
        if (superConstructorInvocation.getAST().apiLevel() >= 3) {
            n = this.rewriteOptionalTypeParameters(superConstructorInvocation, SuperConstructorInvocation.TYPE_ARGUMENTS_PROPERTY, n, "", false, false);
        }
        if (this.isChanged(superConstructorInvocation, SuperConstructorInvocation.ARGUMENTS_PROPERTY)) {
            try {
                n = this.getScanner().getTokenEndOffset(7, n);
                this.rewriteNodeList(superConstructorInvocation, SuperConstructorInvocation.ARGUMENTS_PROPERTY, n, "", ", ");
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(superConstructorInvocation, SuperConstructorInvocation.ARGUMENTS_PROPERTY);
        }
        return false;
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        if (!this.hasChildrenChanges(superFieldAccess)) {
            return this.doVisitUnchangedChildren(superFieldAccess);
        }
        this.rewriteOptionalQualifier(superFieldAccess, SuperFieldAccess.QUALIFIER_PROPERTY, superFieldAccess.getStartPosition());
        this.rewriteRequiredNode(superFieldAccess, SuperFieldAccess.NAME_PROPERTY);
        return false;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        if (!this.hasChildrenChanges(superMethodInvocation)) {
            return this.doVisitUnchangedChildren(superMethodInvocation);
        }
        int n = this.rewriteOptionalQualifier(superMethodInvocation, SuperMethodInvocation.QUALIFIER_PROPERTY, superMethodInvocation.getStartPosition());
        if (superMethodInvocation.getAST().apiLevel() >= 3 && this.isChanged(superMethodInvocation, SuperMethodInvocation.TYPE_ARGUMENTS_PROPERTY)) {
            try {
                n = this.getScanner().getTokenEndOffset(6, n);
                this.rewriteOptionalTypeParameters(superMethodInvocation, SuperMethodInvocation.TYPE_ARGUMENTS_PROPERTY, n, "", false, false);
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
        n = this.rewriteRequiredNode(superMethodInvocation, SuperMethodInvocation.NAME_PROPERTY);
        if (this.isChanged(superMethodInvocation, SuperMethodInvocation.ARGUMENTS_PROPERTY)) {
            try {
                n = this.getScanner().getTokenEndOffset(7, n);
                this.rewriteNodeList(superMethodInvocation, SuperMethodInvocation.ARGUMENTS_PROPERTY, n, "", ", ");
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(superMethodInvocation, SuperMethodInvocation.ARGUMENTS_PROPERTY);
        }
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        if (!this.hasChildrenChanges(switchCase)) {
            return this.doVisitUnchangedChildren(switchCase);
        }
        this.rewriteRequiredNode(switchCase, SwitchCase.EXPRESSION_PROPERTY);
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        if (!this.hasChildrenChanges(switchStatement)) {
            return this.doVisitUnchangedChildren(switchStatement);
        }
        int n = this.rewriteRequiredNode(switchStatement, SwitchStatement.EXPRESSION_PROPERTY);
        ChildListPropertyDescriptor childListPropertyDescriptor = SwitchStatement.STATEMENTS_PROPERTY;
        if (this.getChangeKind(switchStatement, childListPropertyDescriptor) != 0) {
            try {
                n = this.getScanner().getTokenEndOffset(110, n);
                int n2 = this.getIndent(switchStatement.getStartPosition()) + 1;
                SwitchListRewriter switchListRewriter = new SwitchListRewriter(n2);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getLineDelimiter());
                stringBuffer.append(this.createIndentString(n2));
                switchListRewriter.rewriteList(switchStatement, childListPropertyDescriptor, n, stringBuffer.toString());
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(switchStatement, SwitchStatement.STATEMENTS_PROPERTY);
        }
        return false;
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        if (!this.hasChildrenChanges(synchronizedStatement)) {
            return this.doVisitUnchangedChildren(synchronizedStatement);
        }
        this.rewriteRequiredNode(synchronizedStatement, SynchronizedStatement.EXPRESSION_PROPERTY);
        this.rewriteRequiredNode(synchronizedStatement, SynchronizedStatement.BODY_PROPERTY);
        return false;
    }

    public boolean visit(ThisExpression thisExpression) {
        if (!this.hasChildrenChanges(thisExpression)) {
            return this.doVisitUnchangedChildren(thisExpression);
        }
        this.rewriteOptionalQualifier(thisExpression, ThisExpression.QUALIFIER_PROPERTY, thisExpression.getStartPosition());
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        if (!this.hasChildrenChanges(throwStatement)) {
            return this.doVisitUnchangedChildren(throwStatement);
        }
        this.rewriteRequiredNode(throwStatement, ThrowStatement.EXPRESSION_PROPERTY);
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        if (!this.hasChildrenChanges(tryStatement)) {
            return this.doVisitUnchangedChildren(tryStatement);
        }
        int n = this.rewriteRequiredNode(tryStatement, TryStatement.BODY_PROPERTY);
        if (this.isChanged(tryStatement, TryStatement.CATCH_CLAUSES_PROPERTY)) {
            int n2 = this.getIndent(tryStatement.getStartPosition());
            String string = this.formatter.CATCH_BLOCK.getPrefix(n2);
            n = this.rewriteNodeList(tryStatement, TryStatement.CATCH_CLAUSES_PROPERTY, n, string, string);
        } else {
            n = this.doVisit(tryStatement, TryStatement.CATCH_CLAUSES_PROPERTY, n);
        }
        this.rewriteNode(tryStatement, TryStatement.FINALLY_PROPERTY, n, this.formatter.FINALLY_BLOCK);
        return false;
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        if (!this.hasChildrenChanges(typeDeclarationStatement)) {
            return this.doVisitUnchangedChildren(typeDeclarationStatement);
        }
        if (typeDeclarationStatement.getAST().apiLevel() == 2) {
            this.rewriteRequiredNode(typeDeclarationStatement, TypeDeclarationStatement.TYPE_DECLARATION_PROPERTY);
        } else {
            this.rewriteRequiredNode(typeDeclarationStatement, TypeDeclarationStatement.DECLARATION_PROPERTY);
        }
        return false;
    }

    public boolean visit(TypeLiteral typeLiteral) {
        if (!this.hasChildrenChanges(typeLiteral)) {
            return this.doVisitUnchangedChildren(typeLiteral);
        }
        this.rewriteRequiredNode(typeLiteral, TypeLiteral.TYPE_PROPERTY);
        return false;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        if (!this.hasChildrenChanges(variableDeclarationExpression)) {
            return this.doVisitUnchangedChildren(variableDeclarationExpression);
        }
        int n = variableDeclarationExpression.getStartPosition();
        if (variableDeclarationExpression.getAST().apiLevel() == 2) {
            this.rewriteModifiers(variableDeclarationExpression, VariableDeclarationExpression.MODIFIERS_PROPERTY, n);
        } else {
            this.rewriteModifiers2(variableDeclarationExpression, VariableDeclarationExpression.MODIFIERS2_PROPERTY, n);
        }
        n = this.rewriteRequiredNode(variableDeclarationExpression, VariableDeclarationExpression.TYPE_PROPERTY);
        this.rewriteNodeList(variableDeclarationExpression, VariableDeclarationExpression.FRAGMENTS_PROPERTY, n, "", ", ");
        return false;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        if (!this.hasChildrenChanges(variableDeclarationFragment)) {
            return this.doVisitUnchangedChildren(variableDeclarationFragment);
        }
        int n = this.rewriteRequiredNode(variableDeclarationFragment, VariableDeclarationFragment.NAME_PROPERTY);
        int n2 = this.rewriteExtraDimensions(variableDeclarationFragment, VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, n);
        if (n2 > 0) {
            int n3 = this.getChangeKind(variableDeclarationFragment, VariableDeclarationFragment.INITIALIZER_PROPERTY);
            if (n3 == 2) {
                try {
                    n = this.getScanner().getPreviousTokenEndOffset(167, n);
                }
                catch (CoreException coreException) {
                    this.handleException(coreException);
                }
            } else {
                n = variableDeclarationFragment.getStartPosition() + variableDeclarationFragment.getLength();
            }
        }
        this.rewriteNode(variableDeclarationFragment, VariableDeclarationFragment.INITIALIZER_PROPERTY, n, this.formatter.VAR_INITIALIZER);
        return false;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        if (!this.hasChildrenChanges(variableDeclarationStatement)) {
            return this.doVisitUnchangedChildren(variableDeclarationStatement);
        }
        int n = variableDeclarationStatement.getStartPosition();
        if (variableDeclarationStatement.getAST().apiLevel() == 2) {
            this.rewriteModifiers(variableDeclarationStatement, VariableDeclarationStatement.MODIFIERS_PROPERTY, n);
        } else {
            this.rewriteModifiers2(variableDeclarationStatement, VariableDeclarationStatement.MODIFIERS2_PROPERTY, n);
        }
        n = this.rewriteRequiredNode(variableDeclarationStatement, VariableDeclarationStatement.TYPE_PROPERTY);
        this.rewriteNodeList(variableDeclarationStatement, VariableDeclarationStatement.FRAGMENTS_PROPERTY, n, "", ", ");
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        if (!this.hasChildrenChanges(whileStatement)) {
            return this.doVisitUnchangedChildren(whileStatement);
        }
        int n = this.rewriteRequiredNode(whileStatement, WhileStatement.EXPRESSION_PROPERTY);
        try {
            if (this.isChanged(whileStatement, WhileStatement.BODY_PROPERTY)) {
                int n2 = this.getScanner().getTokenEndOffset(86, n);
                this.rewriteBodyNode(whileStatement, WhileStatement.BODY_PROPERTY, n2, -1, this.getIndent(whileStatement.getStartPosition()), this.formatter.WHILE_BLOCK);
            } else {
                this.voidVisit(whileStatement, WhileStatement.BODY_PROPERTY);
            }
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(WithStatement withStatement) {
        if (!this.hasChildrenChanges(withStatement)) {
            return this.doVisitUnchangedChildren(withStatement);
        }
        int n = this.rewriteRequiredNode(withStatement, WithStatement.EXPRESSION_PROPERTY);
        try {
            if (this.isChanged(withStatement, WithStatement.BODY_PROPERTY)) {
                int n2 = this.getScanner().getTokenEndOffset(86, n);
                this.rewriteBodyNode(withStatement, WithStatement.BODY_PROPERTY, n2, -1, this.getIndent(withStatement.getStartPosition()), this.formatter.WHILE_BLOCK);
            } else {
                this.voidVisit(withStatement, WithStatement.BODY_PROPERTY);
            }
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(MemberRef memberRef) {
        if (!this.hasChildrenChanges(memberRef)) {
            return this.doVisitUnchangedChildren(memberRef);
        }
        this.rewriteNode(memberRef, MemberRef.QUALIFIER_PROPERTY, memberRef.getStartPosition(), ASTRewriteFormatter.NONE);
        this.rewriteRequiredNode(memberRef, MemberRef.NAME_PROPERTY);
        return false;
    }

    public boolean visit(MethodRef methodRef) {
        if (!this.hasChildrenChanges(methodRef)) {
            return this.doVisitUnchangedChildren(methodRef);
        }
        this.rewriteNode(methodRef, MethodRef.QUALIFIER_PROPERTY, methodRef.getStartPosition(), ASTRewriteFormatter.NONE);
        int n = this.rewriteRequiredNode(methodRef, MethodRef.NAME_PROPERTY);
        if (this.isChanged(methodRef, MethodRef.PARAMETERS_PROPERTY)) {
            try {
                int n2 = this.getScanner().getTokenEndOffset(7, n);
                this.rewriteNodeList(methodRef, MethodRef.PARAMETERS_PROPERTY, n2, "", ", ");
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(methodRef, MethodRef.PARAMETERS_PROPERTY);
        }
        return false;
    }

    public boolean visit(MethodRefParameter methodRefParameter) {
        if (!this.hasChildrenChanges(methodRefParameter)) {
            return this.doVisitUnchangedChildren(methodRefParameter);
        }
        int n = this.rewriteRequiredNode(methodRefParameter, MethodRefParameter.TYPE_PROPERTY);
        if (methodRefParameter.getAST().apiLevel() >= 3 && this.isChanged(methodRefParameter, MethodRefParameter.VARARGS_PROPERTY)) {
            if (this.getNewValue(methodRefParameter, MethodRefParameter.VARARGS_PROPERTY).equals(Boolean.TRUE)) {
                this.doTextInsert(n, "...", this.getEditGroup(methodRefParameter, MethodRefParameter.VARARGS_PROPERTY));
            } else {
                try {
                    int n2 = this.getScanner().getNextEndOffset(n, true);
                    this.doTextRemove(n, n2 - n, this.getEditGroup(methodRefParameter, MethodRefParameter.VARARGS_PROPERTY));
                }
                catch (CoreException coreException) {
                    this.handleException(coreException);
                }
            }
        }
        this.rewriteNode(methodRefParameter, MethodRefParameter.NAME_PROPERTY, n, ASTRewriteFormatter.SPACE);
        return false;
    }

    public boolean visit(TagElement tagElement) {
        if (!this.hasChildrenChanges(tagElement)) {
            return this.doVisitUnchangedChildren(tagElement);
        }
        int n = this.getChangeKind(tagElement, TagElement.TAG_NAME_PROPERTY);
        switch (n) {
            case 1: {
                String string = (String)this.getNewValue(tagElement, TagElement.TAG_NAME_PROPERTY);
                this.doTextInsert(tagElement.getStartPosition(), string, this.getEditGroup(tagElement, TagElement.TAG_NAME_PROPERTY));
                break;
            }
            case 2: {
                this.doTextRemove(tagElement.getStartPosition(), this.findTagNameEnd(tagElement) - tagElement.getStartPosition(), this.getEditGroup(tagElement, TagElement.TAG_NAME_PROPERTY));
                break;
            }
            case 4: {
                String string = (String)this.getNewValue(tagElement, TagElement.TAG_NAME_PROPERTY);
                this.doTextReplace(tagElement.getStartPosition(), this.findTagNameEnd(tagElement) - tagElement.getStartPosition(), string, this.getEditGroup(tagElement, TagElement.TAG_NAME_PROPERTY));
            }
        }
        if (this.isChanged(tagElement, TagElement.FRAGMENTS_PROPERTY)) {
            int n2 = this.findTagNameEnd(tagElement);
            this.rewriteNodeList(tagElement, TagElement.FRAGMENTS_PROPERTY, n2, " ", " ");
        } else {
            this.voidVisit(tagElement, TagElement.FRAGMENTS_PROPERTY);
        }
        return false;
    }

    private int findTagNameEnd(TagElement tagElement) {
        if (tagElement.getTagName() != null) {
            char[] cArray = this.getContent();
            int n = cArray.length;
            int n2 = tagElement.getStartPosition();
            while (n2 < n && !IndentManipulation.isIndentChar(cArray[n2])) {
                ++n2;
            }
            return n2;
        }
        return tagElement.getStartPosition();
    }

    public boolean visit(TextElement textElement) {
        if (!this.hasChildrenChanges(textElement)) {
            return this.doVisitUnchangedChildren(textElement);
        }
        String string = (String)this.getNewValue(textElement, TextElement.TEXT_PROPERTY);
        TextEditGroup textEditGroup = this.getEditGroup(textElement, TextElement.TEXT_PROPERTY);
        this.doTextReplace(textElement.getStartPosition(), textElement.getLength(), string, textEditGroup);
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        if (!this.hasChildrenChanges(annotationTypeDeclaration)) {
            return this.doVisitUnchangedChildren(annotationTypeDeclaration);
        }
        int n = this.rewriteJavadoc(annotationTypeDeclaration, AnnotationTypeDeclaration.JAVADOC_PROPERTY);
        this.rewriteModifiers2(annotationTypeDeclaration, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY, n);
        n = this.rewriteRequiredNode(annotationTypeDeclaration, AnnotationTypeDeclaration.NAME_PROPERTY);
        int n2 = this.getIndent(annotationTypeDeclaration.getStartPosition()) + 1;
        int n3 = this.getPosAfterLeftBrace(n);
        this.rewriteParagraphList(annotationTypeDeclaration, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY, n3, n2, -1, 2);
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        if (!this.hasChildrenChanges(annotationTypeMemberDeclaration)) {
            return this.doVisitUnchangedChildren(annotationTypeMemberDeclaration);
        }
        int n = this.rewriteJavadoc(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.JAVADOC_PROPERTY);
        this.rewriteModifiers2(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY, n);
        this.rewriteRequiredNode(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.TYPE_PROPERTY);
        n = this.rewriteRequiredNode(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.NAME_PROPERTY);
        try {
            int n2 = this.getChangeKind(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.DEFAULT_PROPERTY);
            if (n2 == 1 || n2 == 2) {
                n = this.getScanner().getTokenEndOffset(86, n);
            }
            this.rewriteNode(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.DEFAULT_PROPERTY, n, this.formatter.ANNOT_MEMBER_DEFAULT);
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        if (!this.hasChildrenChanges(enhancedForStatement)) {
            return this.doVisitUnchangedChildren(enhancedForStatement);
        }
        this.rewriteRequiredNode(enhancedForStatement, EnhancedForStatement.PARAMETER_PROPERTY);
        int n = this.rewriteRequiredNode(enhancedForStatement, EnhancedForStatement.EXPRESSION_PROPERTY);
        RewriteEvent rewriteEvent = this.getEvent(enhancedForStatement, EnhancedForStatement.BODY_PROPERTY);
        if (rewriteEvent != null && rewriteEvent.getChangeKind() == 4) {
            try {
                int n2 = this.getScanner().getTokenEndOffset(86, n);
                this.rewriteBodyNode(enhancedForStatement, EnhancedForStatement.BODY_PROPERTY, n2, -1, this.getIndent(enhancedForStatement.getStartPosition()), this.formatter.FOR_BLOCK);
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(enhancedForStatement, EnhancedForStatement.BODY_PROPERTY);
        }
        return false;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        if (!this.hasChildrenChanges(enumConstantDeclaration)) {
            return this.doVisitUnchangedChildren(enumConstantDeclaration);
        }
        int n = this.rewriteJavadoc(enumConstantDeclaration, EnumConstantDeclaration.JAVADOC_PROPERTY);
        this.rewriteModifiers2(enumConstantDeclaration, EnumConstantDeclaration.MODIFIERS2_PROPERTY, n);
        n = this.rewriteRequiredNode(enumConstantDeclaration, EnumConstantDeclaration.NAME_PROPERTY);
        RewriteEvent rewriteEvent = this.getEvent(enumConstantDeclaration, EnumConstantDeclaration.ARGUMENTS_PROPERTY);
        if (rewriteEvent != null && rewriteEvent.getChangeKind() != 0) {
            RewriteEvent[] rewriteEventArray = rewriteEvent.getChildren();
            try {
                int n2 = this.getScanner().readNext(n, true);
                boolean bl = n2 == 7;
                boolean bl2 = bl && this.isAllOfKind(rewriteEventArray, 2);
                String string = "";
                if (!bl) {
                    string = "(";
                } else if (!bl2) {
                    n = this.getScanner().getCurrentEndOffset();
                }
                n = this.rewriteNodeList(enumConstantDeclaration, EnumConstantDeclaration.ARGUMENTS_PROPERTY, n, string, ", ");
                if (!bl) {
                    this.doTextInsert(n, ")", this.getEditGroup(rewriteEventArray[rewriteEventArray.length - 1]));
                } else if (bl2) {
                    int n3 = this.getScanner().getNextEndOffset(n, true);
                    this.doTextRemove(n, n3 - n, this.getEditGroup(rewriteEventArray[rewriteEventArray.length - 1]));
                    n = n3;
                }
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            n = this.doVisit(enumConstantDeclaration, EnumConstantDeclaration.ARGUMENTS_PROPERTY, n);
        }
        if (this.isChanged(enumConstantDeclaration, EnumConstantDeclaration.ANONYMOUS_CLASS_DECLARATION_PROPERTY)) {
            int n4 = this.getChangeKind(enumConstantDeclaration, EnumConstantDeclaration.ANONYMOUS_CLASS_DECLARATION_PROPERTY);
            if (n4 == 2) {
                try {
                    n = this.getScanner().getPreviousTokenEndOffset(110, n);
                }
                catch (CoreException coreException) {
                    this.handleException(coreException);
                }
            } else {
                n = enumConstantDeclaration.getStartPosition() + enumConstantDeclaration.getLength();
            }
            this.rewriteNode(enumConstantDeclaration, EnumConstantDeclaration.ANONYMOUS_CLASS_DECLARATION_PROPERTY, n, ASTRewriteFormatter.SPACE);
        }
        return false;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        Object object;
        if (!this.hasChildrenChanges(enumDeclaration)) {
            return this.doVisitUnchangedChildren(enumDeclaration);
        }
        int n = this.rewriteJavadoc(enumDeclaration, EnumDeclaration.JAVADOC_PROPERTY);
        this.rewriteModifiers2(enumDeclaration, EnumDeclaration.MODIFIERS2_PROPERTY, n);
        n = this.rewriteRequiredNode(enumDeclaration, EnumDeclaration.NAME_PROPERTY);
        n = this.rewriteNodeList(enumDeclaration, EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, n, " implements ", ", ");
        n = this.getPosAfterLeftBrace(n);
        String string = "";
        RewriteEvent rewriteEvent = this.getEvent(enumDeclaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
        if (rewriteEvent != null && rewriteEvent.getChangeKind() != 0 && this.isAllOfKind((RewriteEvent[])(object = rewriteEvent.getChildren()), 1)) {
            string = this.formatter.FIRST_ENUM_CONST.getPrefix(this.getIndent(enumDeclaration.getStartPosition()));
        }
        n = this.rewriteNodeList(enumDeclaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY, n, string, ", ");
        object = this.getEvent(enumDeclaration, EnumDeclaration.BODY_DECLARATIONS_PROPERTY);
        int n2 = 0;
        if (object != null && ((RewriteEvent)object).getChangeKind() != 0) {
            boolean bl = !((List)this.getNewValue(enumDeclaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY)).isEmpty();
            RewriteEvent[] rewriteEventArray = ((RewriteEvent)object).getChildren();
            try {
                boolean bl2;
                n2 = bl ? this.getIndent(n) : this.getIndent(enumDeclaration.getStartPosition()) + 1;
                int n3 = this.getScanner().readNext(n, true);
                boolean bl3 = bl2 = n3 == 64;
                if (!bl2 && this.isAllOfKind(rewriteEventArray, 1)) {
                    if (!bl) {
                        String string2 = this.formatter.FIRST_ENUM_CONST.getPrefix(n2 - 1);
                        this.doTextInsert(n, string2, this.getEditGroup(rewriteEventArray[0]));
                    }
                    this.doTextInsert(n, ";", this.getEditGroup(rewriteEventArray[0]));
                } else if (bl2) {
                    int n4 = this.getScanner().getCurrentEndOffset();
                    if (this.isAllOfKind(rewriteEventArray, 2)) {
                        this.doTextRemove(n, n4 - n, this.getEditGroup(rewriteEventArray[0]));
                    }
                    n = n4;
                }
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
        this.rewriteParagraphList(enumDeclaration, EnumDeclaration.BODY_DECLARATIONS_PROPERTY, n, n2, -1, 2);
        return false;
    }

    public boolean visit(ListExpression listExpression) {
        if (!this.hasChildrenChanges(listExpression)) {
            return this.doVisitUnchangedChildren(listExpression);
        }
        int n = listExpression.getStartPosition();
        this.rewriteNodeList(listExpression, ListExpression.EXPRESSIONS_PROPERTY, n, "", ", ");
        return false;
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        if (!this.hasChildrenChanges(markerAnnotation)) {
            return this.doVisitUnchangedChildren(markerAnnotation);
        }
        this.rewriteRequiredNode(markerAnnotation, MarkerAnnotation.TYPE_NAME_PROPERTY);
        return false;
    }

    public boolean visit(MemberValuePair memberValuePair) {
        if (!this.hasChildrenChanges(memberValuePair)) {
            return this.doVisitUnchangedChildren(memberValuePair);
        }
        this.rewriteRequiredNode(memberValuePair, MemberValuePair.NAME_PROPERTY);
        this.rewriteRequiredNode(memberValuePair, MemberValuePair.VALUE_PROPERTY);
        return false;
    }

    public boolean visit(Modifier modifier) {
        if (!this.hasChildrenChanges(modifier)) {
            return this.doVisitUnchangedChildren(modifier);
        }
        String string = this.getNewValue(modifier, Modifier.KEYWORD_PROPERTY).toString();
        TextEditGroup textEditGroup = this.getEditGroup(modifier, Modifier.KEYWORD_PROPERTY);
        this.doTextReplace(modifier.getStartPosition(), modifier.getLength(), string, textEditGroup);
        return false;
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        if (!this.hasChildrenChanges(normalAnnotation)) {
            return this.doVisitUnchangedChildren(normalAnnotation);
        }
        int n = this.rewriteRequiredNode(normalAnnotation, NormalAnnotation.TYPE_NAME_PROPERTY);
        if (this.isChanged(normalAnnotation, NormalAnnotation.VALUES_PROPERTY)) {
            try {
                int n2 = this.getScanner().getTokenEndOffset(7, n);
                this.rewriteNodeList(normalAnnotation, NormalAnnotation.VALUES_PROPERTY, n2, "", ", ");
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(normalAnnotation, NormalAnnotation.VALUES_PROPERTY);
        }
        return false;
    }

    public boolean visit(ParameterizedType parameterizedType) {
        if (!this.hasChildrenChanges(parameterizedType)) {
            return this.doVisitUnchangedChildren(parameterizedType);
        }
        int n = this.rewriteRequiredNode(parameterizedType, ParameterizedType.TYPE_PROPERTY);
        if (this.isChanged(parameterizedType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY)) {
            try {
                int n2 = this.getScanner().getTokenEndOffset(69, n);
                this.rewriteNodeList(parameterizedType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY, n2, "", ", ");
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        } else {
            this.voidVisit(parameterizedType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
        }
        return false;
    }

    public boolean visit(QualifiedType qualifiedType) {
        if (!this.hasChildrenChanges(qualifiedType)) {
            return this.doVisitUnchangedChildren(qualifiedType);
        }
        this.rewriteRequiredNode(qualifiedType, QualifiedType.QUALIFIER_PROPERTY);
        this.rewriteRequiredNode(qualifiedType, QualifiedType.NAME_PROPERTY);
        return false;
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        if (!this.hasChildrenChanges(singleMemberAnnotation)) {
            return this.doVisitUnchangedChildren(singleMemberAnnotation);
        }
        this.rewriteRequiredNode(singleMemberAnnotation, SingleMemberAnnotation.TYPE_NAME_PROPERTY);
        this.rewriteRequiredNode(singleMemberAnnotation, SingleMemberAnnotation.VALUE_PROPERTY);
        return false;
    }

    public boolean visit(UndefinedLiteral undefinedLiteral) {
        if (!this.hasChildrenChanges(undefinedLiteral)) {
            return this.doVisitUnchangedChildren(undefinedLiteral);
        }
        this.changeNotSupported(undefinedLiteral);
        return false;
    }

    public boolean visit(TypeParameter typeParameter) {
        if (!this.hasChildrenChanges(typeParameter)) {
            return this.doVisitUnchangedChildren(typeParameter);
        }
        int n = this.rewriteRequiredNode(typeParameter, TypeParameter.NAME_PROPERTY);
        if (this.isChanged(typeParameter, TypeParameter.TYPE_BOUNDS_PROPERTY)) {
            this.rewriteNodeList(typeParameter, TypeParameter.TYPE_BOUNDS_PROPERTY, n, " extends ", " & ");
        } else {
            this.voidVisit(typeParameter, TypeParameter.TYPE_BOUNDS_PROPERTY);
        }
        return false;
    }

    public boolean visit(WildcardType wildcardType) {
        if (!this.hasChildrenChanges(wildcardType)) {
            return this.doVisitUnchangedChildren(wildcardType);
        }
        try {
            int n;
            int n2 = this.getScanner().getNextEndOffset(wildcardType.getStartPosition(), true);
            ASTRewriteFormatter.Prefix prefix = Boolean.TRUE.equals(this.getNewValue(wildcardType, WildcardType.UPPER_BOUND_PROPERTY)) ? this.formatter.WILDCARD_EXTENDS : this.formatter.WILDCARD_SUPER;
            int n3 = this.getChangeKind(wildcardType, WildcardType.UPPER_BOUND_PROPERTY);
            if (n3 != 0 && (n = this.getChangeKind(wildcardType, WildcardType.BOUND_PROPERTY)) != 1 && n != 2) {
                ASTNode aSTNode = (ASTNode)this.getOriginalValue(wildcardType, WildcardType.BOUND_PROPERTY);
                String string = prefix.getPrefix(0);
                this.doTextReplace(n2, aSTNode.getStartPosition() - n2, string, this.getEditGroup(wildcardType, WildcardType.BOUND_PROPERTY));
            }
            this.rewriteNode(wildcardType, WildcardType.BOUND_PROPERTY, n2, prefix);
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
        return false;
    }

    final void handleException(Throwable throwable) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Document does not match the AST");
        illegalArgumentException.initCause(throwable);
        throw illegalArgumentException;
    }

    class ListRewriter {
        protected String contantSeparator;
        protected int startPos;
        protected RewriteEvent[] list;

        ListRewriter() {
        }

        protected final ASTNode getOriginalNode(int n) {
            return (ASTNode)this.list[n].getOriginalValue();
        }

        protected final ASTNode getNewNode(int n) {
            return (ASTNode)this.list[n].getNewValue();
        }

        protected String getSeparatorString(int n) {
            return this.contantSeparator;
        }

        protected int getInitialIndent() {
            return ASTRewriteAnalyzer.this.getIndent(this.startPos);
        }

        protected int getNodeIndent(int n) {
            ASTNode aSTNode = this.getOriginalNode(n);
            if (aSTNode == null) {
                int n2 = n - 1;
                while (n2 >= 0) {
                    ASTNode aSTNode2 = this.getOriginalNode(n2);
                    if (aSTNode2 != null) {
                        return ASTRewriteAnalyzer.this.getIndent(aSTNode2.getStartPosition());
                    }
                    --n2;
                }
                return this.getInitialIndent();
            }
            return ASTRewriteAnalyzer.this.getIndent(aSTNode.getStartPosition());
        }

        protected int getStartOfNextNode(int n, int n2) {
            int n3 = n;
            while (n3 < this.list.length) {
                RewriteEvent rewriteEvent = this.list[n3];
                if (rewriteEvent.getChangeKind() != 1) {
                    ASTNode aSTNode = (ASTNode)rewriteEvent.getOriginalValue();
                    return ASTRewriteAnalyzer.this.getExtendedOffset(aSTNode);
                }
                ++n3;
            }
            return n2;
        }

        protected int getEndOfNode(ASTNode aSTNode) {
            return ASTRewriteAnalyzer.this.getExtendedEnd(aSTNode);
        }

        public final int rewriteList(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n, String string, String string2) {
            this.contantSeparator = string2;
            return this.rewriteList(aSTNode, structuralPropertyDescriptor, n, string);
        }

        private boolean insertAfterSeparator(ASTNode aSTNode) {
            return !ASTRewriteAnalyzer.this.isInsertBoundToPrevious(aSTNode);
        }

        public final int rewriteList(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, int n, String string) {
            int n2;
            this.startPos = n;
            this.list = ASTRewriteAnalyzer.this.getEvent(aSTNode, structuralPropertyDescriptor).getChildren();
            int n3 = this.list.length;
            if (n3 == 0) {
                return this.startPos;
            }
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            while (n7 < n3) {
                n2 = this.list[n7].getChangeKind();
                if (n2 != 1) {
                    n5 = n7;
                    if (n4 == -1) {
                        ASTNode aSTNode2 = (ASTNode)this.list[n7].getOriginalValue();
                        n4 = ASTRewriteAnalyzer.this.getExtendedOffset(aSTNode2);
                    }
                }
                if (n2 != 2) {
                    n6 = n7;
                }
                ++n7;
            }
            if (n4 == -1) {
                if (string.length() > 0) {
                    TextEditGroup textEditGroup = ASTRewriteAnalyzer.this.getEditGroup(this.list[0]);
                    ASTRewriteAnalyzer.this.doTextInsert(n, string, textEditGroup);
                }
                n4 = n;
            }
            if (n6 == -1) {
                n4 = n;
            }
            int n8 = n4;
            n2 = 1;
            int n9 = 0;
            while (n9 < n3) {
                Object object;
                RewriteEvent rewriteEvent = this.list[n9];
                int n10 = rewriteEvent.getChangeKind();
                int n11 = n9 + 1;
                if (n10 == 1) {
                    object = ASTRewriteAnalyzer.this.getEditGroup(rewriteEvent);
                    ASTNode aSTNode3 = (ASTNode)rewriteEvent.getNewValue();
                    if (n2 == 0) {
                        ASTRewriteAnalyzer.this.doTextInsert(n4, this.getSeparatorString(n9 - 1), (TextEditGroup)object);
                        n2 = 1;
                    }
                    if (n2 == 1 || this.insertAfterSeparator(aSTNode3)) {
                        ASTRewriteAnalyzer.this.doTextInsert(n4, aSTNode3, this.getNodeIndent(n9), true, (TextEditGroup)object);
                        n2 = 1;
                        if (n9 != n6) {
                            if (this.list[n11].getChangeKind() != 1) {
                                ASTRewriteAnalyzer.this.doTextInsert(n4, this.getSeparatorString(n9), (TextEditGroup)object);
                            } else {
                                n2 = 0;
                            }
                        }
                    } else {
                        ASTRewriteAnalyzer.this.doTextInsert(n8, this.getSeparatorString(n9 - 1), (TextEditGroup)object);
                        ASTRewriteAnalyzer.this.doTextInsert(n8, aSTNode3, this.getNodeIndent(n9), true, (TextEditGroup)object);
                    }
                } else if (n10 == 2) {
                    object = (ASTNode)rewriteEvent.getOriginalValue();
                    TextEditGroup textEditGroup = ASTRewriteAnalyzer.this.getEditGroup(rewriteEvent);
                    int n12 = this.getEndOfNode((ASTNode)object);
                    if (n9 > n6 && n2 == 2) {
                        ASTRewriteAnalyzer.this.doTextRemove(n8, n4 - n8, textEditGroup);
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(n4, n12 - n4, (ASTNode)object, textEditGroup);
                        n4 = n12;
                        n8 = n12;
                    } else {
                        int n13 = this.getStartOfNextNode(n11, n12);
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(n4, n12 - n4, (ASTNode)object, ASTRewriteAnalyzer.this.getEditGroup(rewriteEvent));
                        ASTRewriteAnalyzer.this.doTextRemove(n12, n13 - n12, textEditGroup);
                        n4 = n13;
                        n8 = n12;
                        n2 = 1;
                    }
                } else {
                    if (n10 == 4) {
                        object = (ASTNode)rewriteEvent.getOriginalValue();
                        int n14 = this.getEndOfNode((ASTNode)object);
                        TextEditGroup textEditGroup = ASTRewriteAnalyzer.this.getEditGroup(rewriteEvent);
                        ASTNode aSTNode4 = (ASTNode)rewriteEvent.getNewValue();
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(n4, n14 - n4, (ASTNode)object, textEditGroup);
                        ASTRewriteAnalyzer.this.doTextInsert(n4, aSTNode4, this.getNodeIndent(n9), true, textEditGroup);
                        n8 = n14;
                    } else {
                        object = (ASTNode)rewriteEvent.getOriginalValue();
                        ASTRewriteAnalyzer.this.voidVisit((ASTNode)object);
                    }
                    if (n9 == n5) {
                        n2 = 0;
                        if (n10 == 0) {
                            object = (ASTNode)rewriteEvent.getOriginalValue();
                            n8 = this.getEndOfNode((ASTNode)object);
                        }
                        n4 = n8;
                    } else if (this.list[n11].getChangeKind() != 0) {
                        if (n10 == 0) {
                            object = (ASTNode)rewriteEvent.getOriginalValue();
                            n8 = this.getEndOfNode((ASTNode)object);
                        }
                        n4 = this.getStartOfNextNode(n11, n8);
                        n2 = 2;
                    }
                }
                ++n9;
            }
            return n4;
        }
    }

    class ModifierRewriter
    extends ListRewriter {
        private final ASTRewriteFormatter.Prefix annotationSeparation;

        public ModifierRewriter(ASTRewriteFormatter.Prefix prefix) {
            this.annotationSeparation = prefix;
        }

        protected String getSeparatorString(int n) {
            ASTNode aSTNode = this.getNewNode(n);
            if (aSTNode instanceof Annotation) {
                return this.annotationSeparation.getPrefix(this.getNodeIndent(n + 1));
            }
            return super.getSeparatorString(n);
        }
    }

    class ParagraphListRewriter
    extends ListRewriter {
        public static final int DEFAULT_SPACING = 1;
        private int initialIndent;
        private int separatorLines;

        public ParagraphListRewriter(int n, int n2) {
            this.initialIndent = n;
            this.separatorLines = n2;
        }

        protected int getInitialIndent() {
            return this.initialIndent;
        }

        protected String getSeparatorString(int n) {
            int n2 = this.separatorLines == -1 ? this.getNewLines(n) : this.separatorLines;
            String string = ASTRewriteAnalyzer.this.getLineDelimiter();
            StringBuffer stringBuffer = new StringBuffer(string);
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(string);
                ++n3;
            }
            stringBuffer.append(ASTRewriteAnalyzer.this.createIndentString(this.getNodeIndent(n + 1)));
            return stringBuffer.toString();
        }

        private ASTNode getNode(int n) {
            ASTNode aSTNode = (ASTNode)this.list[n].getOriginalValue();
            if (aSTNode == null) {
                aSTNode = (ASTNode)this.list[n].getNewValue();
            }
            return aSTNode;
        }

        private int getNewLines(int n) {
            ASTNode aSTNode = this.getNode(n);
            ASTNode aSTNode2 = this.getNode(n + 1);
            int n2 = aSTNode.getNodeType();
            int n3 = aSTNode2.getNodeType();
            ASTNode aSTNode3 = null;
            ASTNode aSTNode4 = null;
            int n4 = 0;
            while (n4 < this.list.length) {
                ASTNode aSTNode5 = (ASTNode)this.list[n4].getOriginalValue();
                if (aSTNode5 != null) {
                    if (aSTNode3 != null) {
                        if (aSTNode5.getNodeType() == n3 && aSTNode3.getNodeType() == n2) {
                            return this.countEmptyLines(aSTNode3);
                        }
                        aSTNode4 = aSTNode3;
                    }
                    aSTNode3 = aSTNode5;
                }
                ++n4;
            }
            if (n2 == 23 && n3 == 23) {
                return 0;
            }
            if (aSTNode4 != null) {
                return this.countEmptyLines(aSTNode4);
            }
            return 1;
        }

        private int countEmptyLines(ASTNode aSTNode) {
            LineInformation lineInformation = ASTRewriteAnalyzer.this.getLineInformation();
            int n = lineInformation.getLineOfOffset(ASTRewriteAnalyzer.this.getExtendedEnd(aSTNode));
            if (n >= 0) {
                int n2 = n + 1;
                int n3 = lineInformation.getLineOffset(n2);
                if (n3 < 0) {
                    return 0;
                }
                char[] cArray = ASTRewriteAnalyzer.this.getContent();
                int n4 = n3;
                while (n4 < cArray.length && ScannerHelper.isWhitespace(cArray[n4])) {
                    ++n4;
                }
                if (n4 > n3 && (n = lineInformation.getLineOfOffset(n4)) > n2) {
                    return n - n2;
                }
            }
            return 0;
        }
    }

    class SwitchListRewriter
    extends ParagraphListRewriter {
        public SwitchListRewriter(int n) {
            super(n, 0);
        }

        protected int getNodeIndent(int n) {
            int n2 = this.getInitialIndent();
            ASTNode aSTNode = (ASTNode)this.list[n].getOriginalValue();
            if (aSTNode == null) {
                aSTNode = (ASTNode)this.list[n].getNewValue();
            }
            if (aSTNode.getNodeType() != 49) {
                ++n2;
            }
            return n2;
        }
    }
}

