/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.MethodRefParameter;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.SynchronizedStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEventStore;

public class ASTRewriteFlattener
extends ASTVisitor {
    static final int JLS2_INTERNAL = 2;
    protected StringBuffer result;
    private RewriteEventStore store;

    public static String asString(ASTNode aSTNode, RewriteEventStore rewriteEventStore) {
        ASTRewriteFlattener aSTRewriteFlattener = new ASTRewriteFlattener(rewriteEventStore);
        aSTNode.accept(aSTRewriteFlattener);
        return aSTRewriteFlattener.getResult();
    }

    public ASTRewriteFlattener(RewriteEventStore rewriteEventStore) {
        this.store = rewriteEventStore;
        this.result = new StringBuffer();
    }

    public String getResult() {
        return new String(this.result.toString());
    }

    public void reset() {
        this.result.setLength(0);
    }

    public static void printModifiers(int n, StringBuffer stringBuffer) {
    }

    protected List getChildList(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return (List)this.getAttribute(aSTNode, structuralPropertyDescriptor);
    }

    protected ASTNode getChildNode(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return (ASTNode)this.getAttribute(aSTNode, structuralPropertyDescriptor);
    }

    protected int getIntAttribute(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return (Integer)this.getAttribute(aSTNode, structuralPropertyDescriptor);
    }

    protected boolean getBooleanAttribute(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return (Boolean)this.getAttribute(aSTNode, structuralPropertyDescriptor);
    }

    protected Object getAttribute(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return this.store.getNewValue(aSTNode, structuralPropertyDescriptor);
    }

    protected void visitList(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, String string) {
        List list = this.getChildList(aSTNode, structuralPropertyDescriptor);
        int n = 0;
        while (n < list.size()) {
            if (string != null && n > 0) {
                this.result.append(string);
            }
            ((ASTNode)list.get(n)).accept(this);
            ++n;
        }
    }

    protected void visitList(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, String string, String string2, String string3) {
        List list = this.getChildList(aSTNode, structuralPropertyDescriptor);
        if (!list.isEmpty()) {
            this.result.append(string2);
            int n = 0;
            while (n < list.size()) {
                if (string != null && n > 0) {
                    this.result.append(string);
                }
                ((ASTNode)list.get(n)).accept(this);
                ++n;
            }
            this.result.append(string3);
        }
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.result.append('{');
        this.visitList(anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        this.getChildNode(arrayAccess, ArrayAccess.ARRAY_PROPERTY).accept(this);
        this.result.append('[');
        this.getChildNode(arrayAccess, ArrayAccess.INDEX_PROPERTY).accept(this);
        this.result.append(']');
        return false;
    }

    public boolean visit(ArrayCreation arrayCreation) {
        this.result.append("new ");
        ArrayType arrayType = (ArrayType)this.getChildNode(arrayCreation, ArrayCreation.TYPE_PROPERTY);
        Type type = (Type)this.getChildNode(arrayType, ArrayType.COMPONENT_TYPE_PROPERTY);
        int n = 1;
        while (type.isArrayType()) {
            ++n;
            type = (Type)this.getChildNode(type, ArrayType.COMPONENT_TYPE_PROPERTY);
        }
        type.accept(this);
        List list = this.getChildList(arrayCreation, ArrayCreation.DIMENSIONS_PROPERTY);
        int n2 = 0;
        while (n2 < list.size()) {
            this.result.append('[');
            ((ASTNode)list.get(n2)).accept(this);
            this.result.append(']');
            --n;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.result.append("[]");
            ++n2;
        }
        ASTNode aSTNode = this.getChildNode(arrayCreation, ArrayCreation.INITIALIZER_PROPERTY);
        if (aSTNode != null) {
            this.getChildNode(arrayCreation, ArrayCreation.INITIALIZER_PROPERTY).accept(this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        this.result.append('[');
        this.visitList(arrayInitializer, ArrayInitializer.EXPRESSIONS_PROPERTY, String.valueOf(','));
        this.result.append(']');
        return false;
    }

    public boolean visit(ArrayType arrayType) {
        this.getChildNode(arrayType, ArrayType.COMPONENT_TYPE_PROPERTY).accept(this);
        this.result.append("[]");
        return false;
    }

    public boolean visit(AssertStatement assertStatement) {
        this.result.append("assert ");
        this.getChildNode(assertStatement, AssertStatement.EXPRESSION_PROPERTY).accept(this);
        ASTNode aSTNode = this.getChildNode(assertStatement, AssertStatement.MESSAGE_PROPERTY);
        if (aSTNode != null) {
            this.result.append(':');
            aSTNode.accept(this);
        }
        this.result.append(';');
        return false;
    }

    public boolean visit(Assignment assignment) {
        this.getChildNode(assignment, Assignment.LEFT_HAND_SIDE_PROPERTY).accept(this);
        this.result.append(this.getAttribute(assignment, Assignment.OPERATOR_PROPERTY).toString());
        this.getChildNode(assignment, Assignment.RIGHT_HAND_SIDE_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(Block block) {
        this.result.append('{');
        this.visitList(block, Block.STATEMENTS_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        if (booleanLiteral.booleanValue()) {
            this.result.append("true");
        } else {
            this.result.append("false");
        }
        return false;
    }

    public boolean visit(BreakStatement breakStatement) {
        this.result.append("break");
        ASTNode aSTNode = this.getChildNode(breakStatement, BreakStatement.LABEL_PROPERTY);
        if (aSTNode != null) {
            this.result.append(' ');
            aSTNode.accept(this);
        }
        this.result.append(';');
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        this.result.append('(');
        this.getChildNode(castExpression, CastExpression.TYPE_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(castExpression, CastExpression.EXPRESSION_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(FunctionExpression functionExpression) {
        this.getChildNode(functionExpression, FunctionExpression.METHOD_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(ObjectLiteralField objectLiteralField) {
        this.getChildNode(objectLiteralField, ObjectLiteralField.FIELD_NAME_PROPERTY).accept(this);
        this.result.append(" : ");
        this.getChildNode(objectLiteralField, ObjectLiteralField.INITIALIZER_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(ObjectLiteral objectLiteral) {
        this.result.append('{');
        this.visitList(objectLiteral, ObjectLiteral.FIELDS_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    public boolean visit(CatchClause catchClause) {
        this.result.append("catch (");
        this.getChildNode(catchClause, CatchClause.EXCEPTION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(catchClause, CatchClause.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        this.result.append(this.getAttribute(characterLiteral, CharacterLiteral.ESCAPED_VALUE_PROPERTY));
        return false;
    }

    public boolean visit(RegularExpressionLiteral regularExpressionLiteral) {
        this.result.append(this.getAttribute(regularExpressionLiteral, RegularExpressionLiteral.REGULAR_EXPRESSION_PROPERTY));
        return false;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        ASTNode aSTNode = this.getChildNode(classInstanceCreation, ClassInstanceCreation.EXPRESSION_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
            this.result.append('.');
        }
        this.result.append("new ");
        this.getChildNode(classInstanceCreation, ClassInstanceCreation.MEMBER_PROPERTY).accept(this);
        this.result.append('(');
        this.visitList(classInstanceCreation, ClassInstanceCreation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        ASTNode aSTNode2 = this.getChildNode(classInstanceCreation, ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY);
        if (aSTNode2 != null) {
            aSTNode2.accept(this);
        }
        return false;
    }

    public boolean visit(CompilationUnit compilationUnit) {
        ASTNode aSTNode = this.getChildNode(compilationUnit, CompilationUnit.PACKAGE_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.visitList(compilationUnit, CompilationUnit.IMPORTS_PROPERTY, null);
        this.visitList(compilationUnit, CompilationUnit.STATEMENTS_PROPERTY, null);
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        this.getChildNode(conditionalExpression, ConditionalExpression.EXPRESSION_PROPERTY).accept(this);
        this.result.append('?');
        this.getChildNode(conditionalExpression, ConditionalExpression.THEN_EXPRESSION_PROPERTY).accept(this);
        this.result.append(':');
        this.getChildNode(conditionalExpression, ConditionalExpression.ELSE_EXPRESSION_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        if (constructorInvocation.getAST().apiLevel() >= 3) {
            this.visitList(constructorInvocation, ConstructorInvocation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.result.append("this(");
        this.visitList(constructorInvocation, ConstructorInvocation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(");");
        return false;
    }

    public boolean visit(ContinueStatement continueStatement) {
        this.result.append("continue");
        ASTNode aSTNode = this.getChildNode(continueStatement, ContinueStatement.LABEL_PROPERTY);
        if (aSTNode != null) {
            this.result.append(' ');
            aSTNode.accept(this);
        }
        this.result.append(';');
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        this.result.append("do ");
        this.getChildNode(doStatement, DoStatement.BODY_PROPERTY).accept(this);
        this.result.append(" while (");
        this.getChildNode(doStatement, DoStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(");");
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.result.append(';');
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        this.getChildNode(expressionStatement, ExpressionStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(';');
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        this.getChildNode(fieldAccess, FieldAccess.EXPRESSION_PROPERTY).accept(this);
        this.result.append('.');
        this.getChildNode(fieldAccess, FieldAccess.NAME_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        ASTNode aSTNode = this.getChildNode(fieldDeclaration, FieldDeclaration.JAVADOC_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        if (fieldDeclaration.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(fieldDeclaration, FieldDeclaration.MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(fieldDeclaration, FieldDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.result.append("var ");
        this.visitList(fieldDeclaration, FieldDeclaration.FRAGMENTS_PROPERTY, String.valueOf(','));
        this.result.append(';');
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        this.result.append("for (");
        this.visitList(forStatement, ForStatement.INITIALIZERS_PROPERTY, String.valueOf(','));
        this.result.append(';');
        ASTNode aSTNode = this.getChildNode(forStatement, ForStatement.EXPRESSION_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.result.append(';');
        this.visitList(forStatement, ForStatement.UPDATERS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        this.getChildNode(forStatement, ForStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(ForInStatement forInStatement) {
        this.result.append("for (");
        ASTNode aSTNode = this.getChildNode(forInStatement, ForInStatement.ITERATION_VARIABLE_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.result.append(" in ");
        aSTNode = this.getChildNode(forInStatement, ForInStatement.COLLECTION_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.result.append(')');
        this.getChildNode(forInStatement, ForInStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        this.result.append("if (");
        this.getChildNode(ifStatement, IfStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(ifStatement, IfStatement.THEN_STATEMENT_PROPERTY).accept(this);
        ASTNode aSTNode = this.getChildNode(ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY);
        if (aSTNode != null) {
            this.result.append(" else ");
            aSTNode.accept(this);
        }
        return false;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        this.result.append("import ");
        if (importDeclaration.getAST().apiLevel() >= 3 && this.getBooleanAttribute(importDeclaration, ImportDeclaration.STATIC_PROPERTY)) {
            this.result.append("static ");
        }
        this.getChildNode(importDeclaration, ImportDeclaration.NAME_PROPERTY).accept(this);
        if (this.getBooleanAttribute(importDeclaration, ImportDeclaration.ON_DEMAND_PROPERTY)) {
            this.result.append(".*");
        }
        this.result.append(';');
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        this.getChildNode(infixExpression, InfixExpression.LEFT_OPERAND_PROPERTY).accept(this);
        this.result.append(' ');
        String string = this.getAttribute(infixExpression, InfixExpression.OPERATOR_PROPERTY).toString();
        this.result.append(string);
        this.result.append(' ');
        this.getChildNode(infixExpression, InfixExpression.RIGHT_OPERAND_PROPERTY).accept(this);
        List list = this.getChildList(infixExpression, InfixExpression.EXTENDED_OPERANDS_PROPERTY);
        int n = 0;
        while (n < list.size()) {
            this.result.append(string);
            ((ASTNode)list.get(n)).accept(this);
            ++n;
        }
        return false;
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        this.getChildNode(instanceofExpression, InstanceofExpression.LEFT_OPERAND_PROPERTY).accept(this);
        this.result.append(" instanceof ");
        this.getChildNode(instanceofExpression, InstanceofExpression.RIGHT_OPERAND_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(Initializer initializer) {
        ASTNode aSTNode = this.getChildNode(initializer, Initializer.JAVADOC_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        if (initializer.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(initializer, Initializer.MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(initializer, Initializer.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(initializer, Initializer.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(Javadoc javadoc) {
        this.result.append("/**");
        List list = this.getChildList(javadoc, Javadoc.TAGS_PROPERTY);
        int n = 0;
        while (n < list.size()) {
            this.result.append("\n * ");
            ((ASTNode)list.get(n)).accept(this);
            ++n;
        }
        this.result.append("\n */");
        return false;
    }

    public boolean visit(LabeledStatement labeledStatement) {
        this.getChildNode(labeledStatement, LabeledStatement.LABEL_PROPERTY).accept(this);
        this.result.append(": ");
        this.getChildNode(labeledStatement, LabeledStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        ASTNode aSTNode = this.getChildNode(methodDeclaration, MethodDeclaration.JAVADOC_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        if (methodDeclaration.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(methodDeclaration, MethodDeclaration.MODIFIERS_PROPERTY), this.result);
        }
        this.result.append("function ");
        ASTNode aSTNode2 = this.getChildNode(methodDeclaration, MethodDeclaration.NAME_PROPERTY);
        if (aSTNode2 != null) {
            aSTNode2.accept(this);
        }
        this.result.append('(');
        this.visitList(methodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        int n = this.getIntAttribute(methodDeclaration, MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY);
        int n2 = 0;
        while (n2 < n) {
            this.result.append("[]");
            ++n2;
        }
        this.visitList(methodDeclaration, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY, String.valueOf(','), " throws ", Util.EMPTY_STRING);
        ASTNode aSTNode3 = this.getChildNode(methodDeclaration, MethodDeclaration.BODY_PROPERTY);
        if (aSTNode3 == null) {
            this.result.append("{}");
        } else {
            aSTNode3.accept(this);
        }
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        ASTNode aSTNode = this.getChildNode(methodInvocation, MethodInvocation.EXPRESSION_PROPERTY);
        ASTNode aSTNode2 = this.getChildNode(methodInvocation, MethodInvocation.NAME_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
            if (aSTNode2 != null) {
                this.result.append('.');
            }
        }
        if (methodInvocation.getAST().apiLevel() >= 3) {
            this.visitList(methodInvocation, MethodInvocation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        if (aSTNode2 != null) {
            aSTNode2.accept(this);
        }
        this.result.append('(');
        this.visitList(methodInvocation, MethodInvocation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        return false;
    }

    public boolean visit(NullLiteral nullLiteral) {
        this.result.append("null");
        return false;
    }

    public boolean visit(UndefinedLiteral undefinedLiteral) {
        this.result.append("undefined");
        return false;
    }

    public boolean visit(NumberLiteral numberLiteral) {
        this.result.append(this.getAttribute(numberLiteral, NumberLiteral.TOKEN_PROPERTY).toString());
        return false;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        if (packageDeclaration.getAST().apiLevel() >= 3) {
            ASTNode aSTNode = this.getChildNode(packageDeclaration, PackageDeclaration.JAVADOC_PROPERTY);
            if (aSTNode != null) {
                aSTNode.accept(this);
            }
            this.visitList(packageDeclaration, PackageDeclaration.ANNOTATIONS_PROPERTY, String.valueOf(' '));
        }
        this.result.append("package ");
        this.getChildNode(packageDeclaration, PackageDeclaration.NAME_PROPERTY).accept(this);
        this.result.append(';');
        return false;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        this.result.append('(');
        this.getChildNode(parenthesizedExpression, ParenthesizedExpression.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        this.getChildNode(postfixExpression, PostfixExpression.OPERAND_PROPERTY).accept(this);
        this.result.append(this.getAttribute(postfixExpression, PostfixExpression.OPERATOR_PROPERTY).toString());
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        this.result.append(this.getAttribute(prefixExpression, PrefixExpression.OPERATOR_PROPERTY).toString());
        this.getChildNode(prefixExpression, PrefixExpression.OPERAND_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(PrimitiveType primitiveType) {
        this.result.append(this.getAttribute(primitiveType, PrimitiveType.PRIMITIVE_TYPE_CODE_PROPERTY).toString());
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        this.getChildNode(qualifiedName, QualifiedName.QUALIFIER_PROPERTY).accept(this);
        this.result.append('.');
        this.getChildNode(qualifiedName, QualifiedName.NAME_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.result.append("return");
        ASTNode aSTNode = this.getChildNode(returnStatement, ReturnStatement.EXPRESSION_PROPERTY);
        if (aSTNode != null) {
            this.result.append(' ');
            aSTNode.accept(this);
        }
        this.result.append(';');
        return false;
    }

    public boolean visit(SimpleName simpleName) {
        this.result.append(this.getAttribute(simpleName, SimpleName.IDENTIFIER_PROPERTY));
        return false;
    }

    public boolean visit(SimpleType simpleType) {
        return true;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        if (singleVariableDeclaration.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(singleVariableDeclaration, SingleVariableDeclaration.MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(singleVariableDeclaration, SingleVariableDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        if (singleVariableDeclaration.getParent() != null && singleVariableDeclaration.getParent().getNodeType() != 31) {
            this.result.append("var ");
        }
        this.getChildNode(singleVariableDeclaration, SingleVariableDeclaration.NAME_PROPERTY).accept(this);
        int n = this.getIntAttribute(singleVariableDeclaration, SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY);
        int n2 = 0;
        while (n2 < n) {
            this.result.append("[]");
            ++n2;
        }
        ASTNode aSTNode = this.getChildNode(singleVariableDeclaration, SingleVariableDeclaration.INITIALIZER_PROPERTY);
        if (aSTNode != null) {
            this.result.append('=');
            aSTNode.accept(this);
        }
        return false;
    }

    public boolean visit(StringLiteral stringLiteral) {
        this.result.append(this.getAttribute(stringLiteral, StringLiteral.ESCAPED_VALUE_PROPERTY));
        return false;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        ASTNode aSTNode = this.getChildNode(superConstructorInvocation, SuperConstructorInvocation.EXPRESSION_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
            this.result.append('.');
        }
        if (superConstructorInvocation.getAST().apiLevel() >= 3) {
            this.visitList(superConstructorInvocation, SuperConstructorInvocation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.result.append("super(");
        this.visitList(superConstructorInvocation, SuperConstructorInvocation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(");");
        return false;
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        ASTNode aSTNode = this.getChildNode(superFieldAccess, SuperFieldAccess.QUALIFIER_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
            this.result.append('.');
        }
        this.result.append("super.");
        this.getChildNode(superFieldAccess, SuperFieldAccess.NAME_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        ASTNode aSTNode = this.getChildNode(superMethodInvocation, SuperMethodInvocation.QUALIFIER_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
            this.result.append('.');
        }
        this.result.append("super.");
        if (superMethodInvocation.getAST().apiLevel() >= 3) {
            this.visitList(superMethodInvocation, SuperMethodInvocation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.getChildNode(superMethodInvocation, SuperMethodInvocation.NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.visitList(superMethodInvocation, SuperMethodInvocation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        ASTNode aSTNode = this.getChildNode(switchCase, SwitchCase.EXPRESSION_PROPERTY);
        if (aSTNode == null) {
            this.result.append("default");
        } else {
            this.result.append("case ");
            aSTNode.accept(this);
        }
        this.result.append(':');
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        this.result.append("switch (");
        this.getChildNode(switchStatement, SwitchStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.result.append('{');
        this.visitList(switchStatement, SwitchStatement.STATEMENTS_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        this.result.append("synchronized (");
        this.getChildNode(synchronizedStatement, SynchronizedStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(synchronizedStatement, SynchronizedStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(ThisExpression thisExpression) {
        ASTNode aSTNode = this.getChildNode(thisExpression, ThisExpression.QUALIFIER_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
            this.result.append('.');
        }
        this.result.append("this");
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.result.append("throw ");
        this.getChildNode(throwStatement, ThrowStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(';');
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        this.result.append("try ");
        this.getChildNode(tryStatement, TryStatement.BODY_PROPERTY).accept(this);
        this.result.append(' ');
        this.visitList(tryStatement, TryStatement.CATCH_CLAUSES_PROPERTY, null);
        ASTNode aSTNode = this.getChildNode(tryStatement, TryStatement.FINALLY_PROPERTY);
        if (aSTNode != null) {
            this.result.append(" finally ");
            aSTNode.accept(this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        int n = typeDeclaration.getAST().apiLevel();
        ASTNode aSTNode = this.getChildNode(typeDeclaration, TypeDeclaration.JAVADOC_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        if (n == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(typeDeclaration, TypeDeclaration.MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(typeDeclaration, TypeDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        boolean bl = this.getBooleanAttribute(typeDeclaration, TypeDeclaration.INTERFACE_PROPERTY);
        this.result.append(bl ? "interface " : "class ");
        this.getChildNode(typeDeclaration, TypeDeclaration.NAME_PROPERTY).accept(this);
        if (n >= 3) {
            this.visitList(typeDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.result.append(' ');
        ChildPropertyDescriptor childPropertyDescriptor = n == 2 ? TypeDeclaration.SUPERCLASS_PROPERTY : TypeDeclaration.SUPERCLASS_TYPE_PROPERTY;
        ASTNode aSTNode2 = this.getChildNode(typeDeclaration, childPropertyDescriptor);
        if (aSTNode2 != null) {
            this.result.append("extends ");
            aSTNode2.accept(this);
            this.result.append(' ');
        }
        ChildListPropertyDescriptor childListPropertyDescriptor = n == 2 ? TypeDeclaration.SUPER_INTERFACES_PROPERTY : TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY;
        String string = bl ? "extends " : "implements ";
        this.visitList(typeDeclaration, childListPropertyDescriptor, String.valueOf(','), string, Util.EMPTY_STRING);
        this.result.append('{');
        this.visitList(typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        if (typeDeclarationStatement.getAST().apiLevel() == 2) {
            this.getChildNode(typeDeclarationStatement, TypeDeclarationStatement.TYPE_DECLARATION_PROPERTY).accept(this);
        } else {
            this.getChildNode(typeDeclarationStatement, TypeDeclarationStatement.DECLARATION_PROPERTY).accept(this);
        }
        return false;
    }

    public boolean visit(TypeLiteral typeLiteral) {
        this.getChildNode(typeLiteral, TypeLiteral.TYPE_PROPERTY).accept(this);
        this.result.append(".class");
        return false;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        if (variableDeclarationExpression.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(variableDeclarationExpression, VariableDeclarationExpression.MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(variableDeclarationExpression, VariableDeclarationExpression.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.result.append("var ");
        this.visitList(variableDeclarationExpression, VariableDeclarationExpression.FRAGMENTS_PROPERTY, String.valueOf(','));
        return false;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        this.getChildNode(variableDeclarationFragment, VariableDeclarationFragment.NAME_PROPERTY).accept(this);
        int n = this.getIntAttribute(variableDeclarationFragment, VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY);
        int n2 = 0;
        while (n2 < n) {
            this.result.append("[]");
            ++n2;
        }
        ASTNode aSTNode = this.getChildNode(variableDeclarationFragment, VariableDeclarationFragment.INITIALIZER_PROPERTY);
        if (aSTNode != null) {
            this.result.append('=');
            aSTNode.accept(this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        if (variableDeclarationStatement.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(variableDeclarationStatement, VariableDeclarationStatement.MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(variableDeclarationStatement, VariableDeclarationStatement.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.result.append("var ");
        this.visitList(variableDeclarationStatement, VariableDeclarationStatement.FRAGMENTS_PROPERTY, String.valueOf(','));
        this.result.append(';');
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        this.result.append("while (");
        this.getChildNode(whileStatement, WhileStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(whileStatement, WhileStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(WithStatement withStatement) {
        this.result.append("with (");
        this.getChildNode(withStatement, WithStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(withStatement, WithStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(BlockComment blockComment) {
        return false;
    }

    public boolean visit(LineComment lineComment) {
        return false;
    }

    public boolean visit(ListExpression listExpression) {
        this.visitList(listExpression, ArrayInitializer.EXPRESSIONS_PROPERTY, String.valueOf(','));
        return false;
    }

    public boolean visit(MemberRef memberRef) {
        ASTNode aSTNode = this.getChildNode(memberRef, MemberRef.QUALIFIER_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.result.append('#');
        this.getChildNode(memberRef, MemberRef.NAME_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(MethodRef methodRef) {
        ASTNode aSTNode = this.getChildNode(methodRef, MethodRef.QUALIFIER_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.result.append('#');
        this.getChildNode(methodRef, MethodRef.NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.visitList(methodRef, MethodRef.PARAMETERS_PROPERTY, ",");
        this.result.append(')');
        return false;
    }

    public boolean visit(MethodRefParameter methodRefParameter) {
        ASTNode aSTNode;
        this.getChildNode(methodRefParameter, MethodRefParameter.TYPE_PROPERTY).accept(this);
        if (methodRefParameter.getAST().apiLevel() >= 3 && this.getBooleanAttribute(methodRefParameter, MethodRefParameter.VARARGS_PROPERTY)) {
            this.result.append("...");
        }
        if ((aSTNode = this.getChildNode(methodRefParameter, MethodRefParameter.NAME_PROPERTY)) != null) {
            this.result.append(' ');
            aSTNode.accept(this);
        }
        return false;
    }

    public boolean visit(TagElement tagElement) {
        Object object = this.getAttribute(tagElement, TagElement.TAG_NAME_PROPERTY);
        if (object != null) {
            this.result.append((String)object);
        }
        List list = this.getChildList(tagElement, TagElement.FRAGMENTS_PROPERTY);
        int n = 0;
        while (n < list.size()) {
            ASTNode aSTNode;
            if (n > 0 || object != null) {
                this.result.append(' ');
            }
            if ((aSTNode = (ASTNode)list.get(n)) instanceof TagElement) {
                this.result.append('{');
                aSTNode.accept(this);
                this.result.append('}');
            } else {
                aSTNode.accept(this);
            }
            ++n;
        }
        return false;
    }

    public boolean visit(TextElement textElement) {
        this.result.append(this.getAttribute(textElement, TextElement.TEXT_PROPERTY));
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        ASTNode aSTNode = this.getChildNode(annotationTypeDeclaration, AnnotationTypeDeclaration.JAVADOC_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.visitList(annotationTypeDeclaration, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.result.append("@interface ");
        this.getChildNode(annotationTypeDeclaration, AnnotationTypeDeclaration.NAME_PROPERTY).accept(this);
        this.result.append('{');
        this.visitList(annotationTypeDeclaration, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY, Util.EMPTY_STRING);
        this.result.append('}');
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        ASTNode aSTNode = this.getChildNode(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.JAVADOC_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.visitList(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.getChildNode(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.TYPE_PROPERTY).accept(this);
        this.result.append(' ');
        this.getChildNode(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.NAME_PROPERTY).accept(this);
        this.result.append("()");
        ASTNode aSTNode2 = this.getChildNode(annotationTypeMemberDeclaration, AnnotationTypeMemberDeclaration.DEFAULT_PROPERTY);
        if (aSTNode2 != null) {
            this.result.append(" default ");
            aSTNode2.accept(this);
        }
        this.result.append(';');
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        this.result.append("for (");
        this.getChildNode(enhancedForStatement, EnhancedForStatement.PARAMETER_PROPERTY).accept(this);
        this.result.append(':');
        this.getChildNode(enhancedForStatement, EnhancedForStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(enhancedForStatement, EnhancedForStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        ASTNode aSTNode = this.getChildNode(enumConstantDeclaration, EnumConstantDeclaration.JAVADOC_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.visitList(enumConstantDeclaration, EnumConstantDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.getChildNode(enumConstantDeclaration, EnumConstantDeclaration.NAME_PROPERTY).accept(this);
        this.visitList(enumConstantDeclaration, EnumConstantDeclaration.ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('('), String.valueOf(')'));
        ASTNode aSTNode2 = this.getChildNode(enumConstantDeclaration, EnumConstantDeclaration.ANONYMOUS_CLASS_DECLARATION_PROPERTY);
        if (aSTNode2 != null) {
            aSTNode2.accept(this);
        }
        return false;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        ASTNode aSTNode = this.getChildNode(enumDeclaration, EnumDeclaration.JAVADOC_PROPERTY);
        if (aSTNode != null) {
            aSTNode.accept(this);
        }
        this.visitList(enumDeclaration, EnumDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.result.append("enum ");
        this.getChildNode(enumDeclaration, EnumDeclaration.NAME_PROPERTY).accept(this);
        this.result.append(' ');
        this.visitList(enumDeclaration, EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, String.valueOf(','), "implements ", Util.EMPTY_STRING);
        this.result.append('{');
        this.visitList(enumDeclaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY, String.valueOf(','), Util.EMPTY_STRING, Util.EMPTY_STRING);
        this.visitList(enumDeclaration, EnumDeclaration.BODY_DECLARATIONS_PROPERTY, Util.EMPTY_STRING, String.valueOf(';'), Util.EMPTY_STRING);
        this.result.append('}');
        return false;
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        this.result.append('@');
        this.getChildNode(markerAnnotation, MarkerAnnotation.TYPE_NAME_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(MemberValuePair memberValuePair) {
        this.getChildNode(memberValuePair, MemberValuePair.NAME_PROPERTY).accept(this);
        this.result.append('=');
        this.getChildNode(memberValuePair, MemberValuePair.VALUE_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(Modifier modifier) {
        this.result.append(this.getAttribute(modifier, Modifier.KEYWORD_PROPERTY).toString());
        return false;
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        this.result.append('@');
        this.getChildNode(normalAnnotation, NormalAnnotation.TYPE_NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.visitList(normalAnnotation, NormalAnnotation.VALUES_PROPERTY, ", ");
        this.result.append(')');
        return false;
    }

    public boolean visit(ParameterizedType parameterizedType) {
        this.getChildNode(parameterizedType, ParameterizedType.TYPE_PROPERTY).accept(this);
        this.result.append('<');
        this.visitList(parameterizedType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY, ", ");
        this.result.append('>');
        return false;
    }

    public boolean visit(QualifiedType qualifiedType) {
        this.getChildNode(qualifiedType, QualifiedType.QUALIFIER_PROPERTY).accept(this);
        this.result.append('.');
        this.getChildNode(qualifiedType, QualifiedType.NAME_PROPERTY).accept(this);
        return false;
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        this.result.append('@');
        this.getChildNode(singleMemberAnnotation, SingleMemberAnnotation.TYPE_NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.getChildNode(singleMemberAnnotation, SingleMemberAnnotation.VALUE_PROPERTY).accept(this);
        this.result.append(')');
        return false;
    }

    public boolean visit(TypeParameter typeParameter) {
        this.getChildNode(typeParameter, TypeParameter.NAME_PROPERTY).accept(this);
        this.visitList(typeParameter, TypeParameter.TYPE_BOUNDS_PROPERTY, " & ", " extends ", Util.EMPTY_STRING);
        return false;
    }

    public boolean visit(WildcardType wildcardType) {
        this.result.append('?');
        ASTNode aSTNode = this.getChildNode(wildcardType, WildcardType.BOUND_PROPERTY);
        if (aSTNode != null) {
            if (this.getBooleanAttribute(wildcardType, WildcardType.UPPER_BOUND_PROPERTY)) {
                this.result.append(" extends ");
            } else {
                this.result.append(" super ");
            }
            aSTNode.accept(this);
        }
        return false;
    }
}

