/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.IGenericType;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.Member;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.util.ASTNodeFinder;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class HierarchyResolver
implements ITypeRequestor {
    private ReferenceBinding focusType;
    private boolean superTypesOnly;
    private boolean hasMissingSuperClass;
    LookupEnvironment lookupEnvironment;
    private CompilerOptions options;
    HierarchyBuilder builder;
    private ReferenceBinding[] typeBindings;
    private int typeIndex;
    private IGenericType[] typeModels;

    public HierarchyResolver(INameEnvironment iNameEnvironment, Map map, HierarchyBuilder hierarchyBuilder, IProblemFactory iProblemFactory) {
        this.options = new CompilerOptions(map);
        IErrorHandlingPolicy iErrorHandlingPolicy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemReporter problemReporter = new ProblemReporter(iErrorHandlingPolicy, this.options, iProblemFactory);
        this.setEnvironment(new LookupEnvironment(this, this.options, problemReporter, iNameEnvironment), hierarchyBuilder);
    }

    public HierarchyResolver(LookupEnvironment lookupEnvironment, HierarchyBuilder hierarchyBuilder) {
        this.setEnvironment(lookupEnvironment, hierarchyBuilder);
    }

    public void accept(IBinaryType iBinaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
    }

    public void accept(org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
        CompilationResult compilationResult = new CompilationResult(iCompilationUnit, 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse(iCompilationUnit, compilationResult);
        if (compilationUnitDeclaration != null) {
            parser.inferTypes(compilationUnitDeclaration, this.options);
            try {
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, accessRestriction);
                this.rememberAllTypes(compilationUnitDeclaration, iCompilationUnit, false);
                this.lookupEnvironment.completeTypeBindings(compilationUnitDeclaration, true);
            }
            catch (AbortCompilation abortCompilation) {}
        }
    }

    public void accept(ISourceType[] iSourceTypeArray, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        IProgressMonitor iProgressMonitor = this.builder.hierarchy.progressMonitor;
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ISourceType iSourceType = iSourceTypeArray[0];
        while (iSourceType.getEnclosingType() != null) {
            iSourceType = iSourceType.getEnclosingType();
        }
        CompilationResult compilationResult = new CompilationResult(iSourceType.getFileName(), iSourceType.getPackageName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{iSourceType}, 8, this.lookupEnvironment.problemReporter, compilationResult);
        if (compilationUnitDeclaration != null) {
            try {
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, accessRestriction);
                ICompilationUnit iCompilationUnit = ((SourceTypeElementInfo)iSourceType).getHandle().getCompilationUnit();
                this.rememberAllTypes(compilationUnitDeclaration, iCompilationUnit, false);
                this.lookupEnvironment.completeTypeBindings(compilationUnitDeclaration, true);
            }
            catch (AbortCompilation abortCompilation) {}
        }
    }

    private IType findSuperClass(IGenericType iGenericType, ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2 = referenceBinding.superclass();
        if (referenceBinding2 != null) {
            referenceBinding2 = (ReferenceBinding)referenceBinding2.erasure();
            if (referenceBinding.isHierarchyInconsistent()) {
                if (referenceBinding2.problemId() == 1) {
                    this.hasMissingSuperClass = true;
                    this.builder.hierarchy.missingTypes.add(new String(referenceBinding2.sourceName));
                    return null;
                }
                if (referenceBinding2.id == 1) {
                    int n;
                    char[] cArray;
                    if (iGenericType instanceof IBinaryType) {
                        cArray = ((IBinaryType)iGenericType).getSuperclassName();
                        n = 47;
                    } else if (iGenericType instanceof ISourceType) {
                        cArray = ((ISourceType)iGenericType).getSuperclassName();
                        n = 46;
                    } else if (iGenericType instanceof HierarchyType) {
                        cArray = ((HierarchyType)iGenericType).superclassName;
                        n = 46;
                    } else {
                        return null;
                    }
                    if (cArray != null) {
                        char[] cArray2;
                        int n2 = CharOperation.lastIndexOf((char)n, cArray);
                        char[] cArray3 = cArray2 = n2 == -1 ? cArray : CharOperation.subarray(cArray, n2 + 1, cArray.length);
                        if (!CharOperation.equals(cArray2, TypeConstants.OBJECT)) {
                            this.hasMissingSuperClass = true;
                            this.builder.hierarchy.missingTypes.add(new String(cArray2));
                            return null;
                        }
                    }
                }
            }
            int n = this.typeIndex;
            while (n >= 0) {
                if (this.typeBindings[n] == referenceBinding2) {
                    return this.builder.getHandle(this.typeModels[n], referenceBinding2);
                }
                --n;
            }
        }
        return null;
    }

    private IType[] findSuperInterfaces(IGenericType iGenericType, ReferenceBinding referenceBinding) {
        Object object;
        char c;
        Object object2;
        if (iGenericType instanceof IBinaryType) {
            object2 = ((IBinaryType)iGenericType).getInterfaceNames();
            c = '/';
        } else if (iGenericType instanceof ISourceType) {
            object = (ISourceType)iGenericType;
            object2 = object.getName().length == 0 ? (referenceBinding.superInterfaces() != null && referenceBinding.superInterfaces().length > 0 ? (Object)new char[][]{object.getSuperclassName()} : object.getInterfaceNames()) : (TypeDeclaration.kind(object.getModifiers()) == 4 ? (Object)new char[][]{TypeConstants.CharArray_JAVA_LANG_ANNOTATION_ANNOTATION} : object.getInterfaceNames());
            c = '.';
        } else if (iGenericType instanceof HierarchyType) {
            object = (HierarchyType)iGenericType;
            object2 = object.name.length == 0 ? (referenceBinding.superInterfaces() != null && referenceBinding.superInterfaces().length > 0 ? (Object)new char[][]{object.superclassName} : object.superInterfaceNames) : object.superInterfaceNames;
            c = '.';
        } else {
            return null;
        }
        object = referenceBinding.superInterfaces();
        int n = 0;
        int n2 = object == null ? 0 : ((ReferenceBinding[])object).length;
        int n3 = object2 == null ? 0 : ((char[][])object2).length;
        IType[] iTypeArray = new IType[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            block14: {
                int n6;
                int n7;
                int n8;
                char[] cArray = object2[n5];
                int n9 = cArray.length;
                int n10 = CharOperation.indexOf('<', cArray);
                if (n10 != -1) {
                    n9 = n10;
                }
                if ((n8 = CharOperation.lastIndexOf('$', cArray, n7 = (n6 = CharOperation.lastIndexOf(c, cArray, 0, n9)) + 1)) != -1) {
                    n7 = n8 + 1;
                }
                char[] cArray2 = CharOperation.subarray(cArray, n7, n9);
                if (n < n2) {
                    ReferenceBinding referenceBinding2 = (ReferenceBinding)object[n].erasure();
                    if (CharOperation.equals(cArray2, referenceBinding2.sourceName)) {
                        ++n;
                        int n11 = this.typeIndex;
                        while (n11 >= 0) {
                            if (this.typeBindings[n11] == referenceBinding2) {
                                iTypeArray[n4++] = this.builder.getHandle(this.typeModels[n11], referenceBinding2);
                                break block14;
                            }
                            --n11;
                        }
                    }
                }
                this.builder.hierarchy.missingTypes.add(new String(cArray2));
            }
            ++n5;
        }
        if (n4 != n3) {
            IType[] iTypeArray2 = iTypeArray;
            iTypeArray = new IType[n4];
            System.arraycopy(iTypeArray2, 0, iTypeArray, 0, n4);
        }
        return iTypeArray;
    }

    private void fixSupertypeBindings() {
        int n = this.typeIndex;
        while (n >= 0) {
            ReferenceBinding referenceBinding = this.typeBindings[n];
            if (referenceBinding instanceof SourceTypeBinding) {
                ClassScope classScope = (ClassScope)((SourceTypeBinding)referenceBinding).scope;
                if (classScope != null) {
                    int n2;
                    TypeBinding typeBinding;
                    TypeDeclaration typeDeclaration = classScope.referenceContext;
                    TypeReference typeReference = typeDeclaration == null ? null : typeDeclaration.superclass;
                    TypeBinding typeBinding2 = typeBinding = typeReference == null ? null : typeReference.resolvedType;
                    if (typeBinding instanceof ProblemReferenceBinding) {
                        typeBinding = ((ProblemReferenceBinding)typeBinding).closestMatch();
                    }
                    if (typeBinding != null) {
                        ((SourceTypeBinding)referenceBinding).superclass = (ReferenceBinding)typeBinding;
                    }
                    TypeReference[] typeReferenceArray = typeDeclaration == null ? null : typeDeclaration.superInterfaces;
                    ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
                    if (typeReferenceArray != null && (n2 = typeReferenceArray.length) > (referenceBindingArray == null ? 0 : referenceBindingArray.length)) {
                        referenceBindingArray = new ReferenceBinding[n2];
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < n2) {
                            ReferenceBinding referenceBinding2 = (ReferenceBinding)typeReferenceArray[n4].resolvedType;
                            if (referenceBinding2 instanceof ProblemReferenceBinding) {
                                referenceBinding2 = referenceBinding2.closestMatch();
                            }
                            if (referenceBinding2 != null) {
                                referenceBindingArray[n3++] = referenceBinding2;
                            }
                            ++n4;
                        }
                        if (n3 < n2) {
                            ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                            referenceBindingArray = new ReferenceBinding[n3];
                            System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n3);
                        }
                        ((SourceTypeBinding)referenceBinding).superInterfaces = referenceBindingArray;
                    }
                }
            } else if (referenceBinding instanceof BinaryTypeBinding) {
                try {
                    referenceBinding.superclass();
                }
                catch (AbortCompilation abortCompilation) {
                    ((BinaryTypeBinding)referenceBinding).tagBits &= 0xFFFFFFFFFDFFFFFFL;
                    this.builder.hierarchy.missingTypes.add(new String(referenceBinding.superclass().sourceName()));
                    this.hasMissingSuperClass = true;
                }
                try {
                    referenceBinding.superInterfaces();
                }
                catch (AbortCompilation abortCompilation) {
                    ((BinaryTypeBinding)referenceBinding).tagBits &= 0xFFFFFFFFFBFFFFFFL;
                }
            }
            --n;
        }
    }

    private void remember(IGenericType iGenericType, ReferenceBinding referenceBinding) {
        if (referenceBinding == null) {
            return;
        }
        if (++this.typeIndex == this.typeModels.length) {
            this.typeModels = new IGenericType[this.typeIndex * 2];
            System.arraycopy(this.typeModels, 0, this.typeModels, 0, this.typeIndex);
            this.typeBindings = new ReferenceBinding[this.typeIndex * 2];
            System.arraycopy(this.typeBindings, 0, this.typeBindings, 0, this.typeIndex);
        }
        this.typeModels[this.typeIndex] = iGenericType;
        this.typeBindings[this.typeIndex] = referenceBinding;
    }

    private void remember(IType iType, ReferenceBinding referenceBinding) {
        if (((CompilationUnit)iType.getCompilationUnit()).isOpen()) {
            try {
                IGenericType iGenericType = (IGenericType)((JavaElement)((Object)iType)).getElementInfo();
                this.remember(iGenericType, referenceBinding);
            }
            catch (JavaModelException javaModelException) {
                return;
            }
        } else {
            Object object;
            if (referenceBinding == null) {
                return;
            }
            TypeDeclaration typeDeclaration = ((ClassScope)((SourceTypeBinding)referenceBinding).scope).referenceType();
            char[] cArray = null;
            TypeReference typeReference = (typeDeclaration.bits & 0x200) != 0 ? typeDeclaration.allocation.type : typeDeclaration.superclass;
            if (typeReference != null) {
                object = typeReference.getTypeName();
                cArray = object == null ? null : object[((char[][])object).length - 1];
            }
            object = null;
            TypeReference[] typeReferenceArray = typeDeclaration.superInterfaces;
            if (typeReferenceArray != null) {
                int n = typeReferenceArray.length;
                object = new char[n][];
                int n2 = 0;
                while (n2 < n) {
                    TypeReference typeReference2 = typeReferenceArray[n2];
                    char[][] cArray2 = typeReference2.getTypeName();
                    object[n2] = cArray2[cArray2.length - 1];
                    ++n2;
                }
            }
            HierarchyType hierarchyType = new HierarchyType(iType, typeDeclaration.name, typeDeclaration.binding.modifiers, cArray, (char[][])object);
            this.remember(hierarchyType, (ReferenceBinding)typeDeclaration.binding);
        }
    }

    private void rememberInferredType(InferredType inferredType, IType iType, ReferenceBinding referenceBinding) {
        if (iType.getCompilationUnit() != null && ((CompilationUnit)iType.getCompilationUnit()).isOpen()) {
            try {
                IGenericType iGenericType = (IGenericType)((JavaElement)((Object)iType)).getElementInfo();
                this.remember(iGenericType, referenceBinding);
            }
            catch (JavaModelException javaModelException) {
                return;
            }
        } else {
            if (referenceBinding == null) {
                return;
            }
            char[] cArray = inferredType.getSuperClassName();
            char[][] cArray2 = null;
            HierarchyType hierarchyType = new HierarchyType(iType, inferredType.getName(), 0, cArray, cArray2);
            this.remember(hierarchyType, (ReferenceBinding)inferredType.binding);
        }
    }

    private void rememberAllTypes(CompilationUnitDeclaration compilationUnitDeclaration, Object object, boolean bl) {
        Object object2;
        int n;
        ICompilationUnit iCompilationUnit = object instanceof ICompilationUnit ? (ICompilationUnit)object : null;
        IClassFile iClassFile = object instanceof IClassFile ? (IClassFile)object : null;
        TypeDeclaration[] typeDeclarationArray = compilationUnitDeclaration.types;
        if (typeDeclarationArray != null) {
            n = 0;
            int n2 = typeDeclarationArray.length;
            while (n < n2) {
                object2 = typeDeclarationArray[n];
                IType iType = iCompilationUnit != null ? iCompilationUnit.getType(new String(((TypeDeclaration)object2).name)) : iClassFile.getType(new String(((TypeDeclaration)object2).name));
                this.rememberWithMemberTypes((TypeDeclaration)object2, iType);
                ++n;
            }
        }
        n = 0;
        while (n < compilationUnitDeclaration.numberInferredTypes) {
            InferredType inferredType = compilationUnitDeclaration.inferredTypes[n];
            object2 = iCompilationUnit != null ? iCompilationUnit.getType(new String(inferredType.getName())) : iClassFile.getType(new String(inferredType.getName()));
            this.rememberInferredType(inferredType, (IType)object2, inferredType.binding);
            ++n;
        }
    }

    private void rememberWithMemberTypes(TypeDeclaration typeDeclaration, IType iType) {
        this.remember(iType, (ReferenceBinding)typeDeclaration.binding);
        TypeDeclaration[] typeDeclarationArray = typeDeclaration.memberTypes;
        if (typeDeclarationArray != null) {
            int n = 0;
            int n2 = typeDeclarationArray.length;
            while (n < n2) {
                TypeDeclaration typeDeclaration2 = typeDeclarationArray[n];
                this.rememberWithMemberTypes(typeDeclaration2, iType.getType(new String(typeDeclaration2.name)));
                ++n;
            }
        }
    }

    private void reportHierarchy(IType iType, CompilationUnitDeclaration compilationUnitDeclaration, ReferenceBinding referenceBinding) {
        Object object;
        Object object2;
        if (iType != null) {
            if (referenceBinding != null) {
                this.focusType = referenceBinding;
            } else {
                Object object3;
                Member member = ((Member)((Object)iType)).getOuterMostLocalContext();
                if (member == null) {
                    object3 = iType.getFullyQualifiedName().toCharArray();
                    this.setFocusType(CharOperation.splitOn('.', (char[])object3));
                } else if (compilationUnitDeclaration != null) {
                    object3 = new ASTNodeFinder(compilationUnitDeclaration);
                    object2 = ((ASTNodeFinder)object3).findInferredType(iType);
                    if (object2 != null) {
                        this.focusType = ((InferredType)object2).binding;
                    } else {
                        object = ((ASTNodeFinder)object3).findType(iType);
                        if (object != null) {
                            this.focusType = ((TypeDeclaration)object).binding;
                        }
                    }
                }
            }
        }
        this.fixSupertypeBindings();
        int n = -1;
        int n2 = this.typeIndex;
        while (n2 >= 0) {
            object2 = this.typeBindings[n2];
            if (((ReferenceBinding)object2).id == 1) {
                n = n2;
            } else {
                object = this.typeModels[n2];
                if (this.subOrSuperOfFocus((ReferenceBinding)object2)) {
                    IType iType2 = ((ReferenceBinding)object2).isInterface() ? null : this.findSuperClass((IGenericType)object, (ReferenceBinding)object2);
                    IType[] iTypeArray = new IType[]{};
                    this.builder.connect((IGenericType)object, this.builder.getHandle((IGenericType)object, (ReferenceBinding)object2), iType2, iTypeArray);
                }
            }
            --n2;
        }
        if (!this.hasMissingSuperClass && n > -1) {
            IGenericType iGenericType = this.typeModels[n];
            this.builder.connect(iGenericType, this.builder.getHandle(iGenericType, this.typeBindings[n]), null, null);
        }
    }

    private void reset() {
        this.lookupEnvironment.reset();
        this.focusType = null;
        this.superTypesOnly = false;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(IGenericType var1_1) {
        try {
            try {
                block9: {
                    if (!var1_1.isBinaryType()) break block9;
                    var2_2 = this.lookupEnvironment.cacheBinaryType((ISourceType)var1_1, false, null);
                    this.remember(var1_1, (ReferenceBinding)var2_2);
                    var4_6 = var3_4 = this.typeIndex;
                    if (true) ** GOTO lbl29
                }
                var2_3 = ((SourceTypeElementInfo)var1_1).getHandle().getCompilationUnit();
                var3_5 = new HashSet<String>();
                var3_5.add(var2_3.getPath().toString());
                this.superTypesOnly = true;
                this.resolve(new Openable[]{(Openable)var2_3}, var3_5, null);
            }
            catch (AbortCompilation v0) {}
            ** GOTO lbl-1000
            do {
                if ((var5_7 = this.typeModels[var4_6]) != null && var5_7.isBinaryType()) {
                    try {
                        var6_8 = this.typeBindings[var4_6];
                        var6_8.superclass();
                        var6_8.superInterfaces();
                    }
                    catch (AbortCompilation v1) {}
                }
                ++var4_6;
lbl29:
                // 2 sources

            } while (var4_6 <= this.typeIndex);
            this.superTypesOnly = true;
            this.reportHierarchy(this.builder.getType(), null, var2_2);
        }
        catch (Throwable var8_9) {
            var7_10 = null;
            this.reset();
            throw var8_9;
        }
lbl-1000:
        // 3 sources

        {
            var7_11 = null;
            this.reset();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(Openable[] openableArray, HashSet hashSet, IProgressMonitor iProgressMonitor) {
        try {
            block39: {
                try {
                    Object object;
                    Object object2;
                    int n = openableArray.length;
                    CompilationUnitDeclaration[] compilationUnitDeclarationArray = new CompilationUnitDeclaration[n];
                    boolean[] blArray = new boolean[n];
                    ICompilationUnit[] iCompilationUnitArray = new ICompilationUnit[n];
                    int n2 = 0;
                    Object object3 = null;
                    ReferenceBinding referenceBinding = null;
                    IType iType = this.builder.getType();
                    Openable openable = null;
                    if (iType != null) {
                        openable = iType.isBinary() ? (Openable)((Object)iType.getClassFile()) : (Openable)((Object)iType.getCompilationUnit());
                    }
                    Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
                    int n3 = 0;
                    while (n3 < n) {
                        block38: {
                            Object object4;
                            Object object5;
                            block40: {
                                IType[] iTypeArray;
                                ISourceType[] iSourceTypeArray;
                                object2 = openableArray[n3];
                                if (!(object2 instanceof ICompilationUnit)) break block40;
                                object = (ICompilationUnit)object2;
                                boolean bl = false;
                                if (hashSet == null) {
                                    bl = true;
                                } else {
                                    object5 = object.getPath();
                                    bl = hashSet.contains(object5.toString());
                                }
                                object5 = null;
                                if (object.isOpen()) {
                                    object4 = new CompilationResult(((org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit)object).getFileName(), ((org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit)object).getPackageName(), n3, n, this.options.maxProblemsPerUnit);
                                    iSourceTypeArray = null;
                                    try {
                                        iTypeArray = object.getTypes();
                                        int n4 = iTypeArray.length;
                                        if (n4 == 0) break block38;
                                        iSourceTypeArray = new SourceTypeElementInfo[n4];
                                        int n5 = 0;
                                        while (n5 < n4) {
                                            IType iType2 = iTypeArray[n5];
                                            iSourceTypeArray[n5] = (SourceTypeElementInfo)((JavaElement)((Object)iType2)).getElementInfo();
                                            ++n5;
                                        }
                                    }
                                    catch (JavaModelException javaModelException) {}
                                    int n6 = !bl ? 8 : 47;
                                    object5 = SourceTypeConverter.buildCompilationUnit(iSourceTypeArray, n6, this.lookupEnvironment.problemReporter, (CompilationResult)object4);
                                    if (bl) {
                                        object5.bits |= 0x10;
                                    }
                                } else {
                                    object4 = (IFile)object.getResource();
                                    iSourceTypeArray = this.builder.createCompilationUnitFromPath((Openable)object2, (IFile)object4);
                                    iTypeArray = new CompilationResult((org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit)iSourceTypeArray, n3, n, this.options.maxProblemsPerUnit);
                                    object5 = parser.dietParse((org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit)iSourceTypeArray, (CompilationResult)iTypeArray);
                                }
                                if (object5 != null) {
                                    parser.inferTypes((CompilationUnitDeclaration)object5, this.options);
                                    blArray[n2] = bl;
                                    iCompilationUnitArray[n2] = object;
                                    compilationUnitDeclarationArray[n2++] = object5;
                                    try {
                                        this.lookupEnvironment.buildTypeBindings((CompilationUnitDeclaration)object5, null);
                                        if (((JavaElement)object2).equals(openable)) {
                                            object3 = object5;
                                        }
                                        break block38;
                                    }
                                    catch (AbortCompilation abortCompilation) {}
                                }
                                break block38;
                            }
                            object = (ClassFile)object2;
                            org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit compilationUnit = new org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit(null, ((ClassFile)object).getPath().toOSString(), this.options.defaultEncoding);
                            compilationUnit.packageName = Util.toCharArrays(new String[]{((JavaElement)object).getParent().getElementName()});
                            object5 = new CompilationResult(compilationUnit, n3, n, this.options.maxProblemsPerUnit);
                            object4 = parser.dietParse(compilationUnit, (CompilationResult)object5);
                            if (object4 != null) {
                                parser.inferTypes((CompilationUnitDeclaration)object4, this.options);
                                blArray[n2] = true;
                                iCompilationUnitArray[n2] = null;
                                compilationUnitDeclarationArray[n2++] = object4;
                                try {
                                    this.lookupEnvironment.buildTypeBindings((CompilationUnitDeclaration)object4, null);
                                    if (((JavaElement)object2).equals(openable)) {
                                        object3 = object4;
                                    }
                                }
                                catch (AbortCompilation abortCompilation) {}
                            }
                        }
                        ++n3;
                    }
                    n3 = 0;
                    while (n3 <= this.typeIndex) {
                        object2 = this.typeModels[n3];
                        if (object2 != null && object2.isBinaryType()) {
                            try {
                                object = this.typeBindings[n3];
                                ((ReferenceBinding)object).superclass();
                                ((ReferenceBinding)object).superInterfaces();
                            }
                            catch (AbortCompilation abortCompilation) {}
                        }
                        ++n3;
                    }
                    n3 = 0;
                    while (n3 < n2) {
                        object2 = compilationUnitDeclarationArray[n3];
                        if (object2 != null) {
                            try {
                                boolean bl = blArray[n3];
                                if (bl) {
                                    parser.getMethodBodies((CompilationUnitDeclaration)object2);
                                }
                                this.lookupEnvironment.completeTypeBindings((CompilationUnitDeclaration)object2, bl);
                            }
                            catch (AbortCompilation abortCompilation) {
                                blArray[n3] = false;
                            }
                        }
                        this.worked(iProgressMonitor, 1);
                        ++n3;
                    }
                    n3 = 0;
                    while (n3 < n2) {
                        object2 = compilationUnitDeclarationArray[n3];
                        if (object2 != null) {
                            boolean bl = blArray[n3];
                            if (bl) {
                                ((CompilationUnitDeclaration)object2).scope.faultInTypes();
                                ((CompilationUnitDeclaration)object2).resolve();
                            }
                            this.rememberAllTypes((CompilationUnitDeclaration)object2, openableArray[n3], bl);
                        }
                        ++n3;
                    }
                    if (referenceBinding == null && iType != null && iType.isBinary()) {
                        char[] cArray = iType.getElementName().toCharArray();
                        object2 = iType.getPackageFragment().getElementName().toCharArray();
                        char[][] cArrayArray = new char[][]{(char[])object2, cArray};
                        referenceBinding = this.lookupEnvironment.getCachedType(cArrayArray);
                        if (referenceBinding == null) {
                            Object var25_33 = null;
                            this.reset();
                            return;
                        }
                    }
                    this.reportHierarchy(iType, (CompilationUnitDeclaration)object3, referenceBinding);
                }
                catch (ClassCastException classCastException) {
                }
                catch (AbortCompilation abortCompilation) {
                    if (!TypeHierarchy.DEBUG) break block39;
                    abortCompilation.printStackTrace();
                }
            }
            Object var25_35 = null;
            this.reset();
            return;
        }
        catch (Throwable throwable) {
            Object var25_34 = null;
            this.reset();
            throw throwable;
        }
    }

    private void setEnvironment(LookupEnvironment lookupEnvironment, HierarchyBuilder hierarchyBuilder) {
        this.lookupEnvironment = lookupEnvironment;
        this.builder = hierarchyBuilder;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
    }

    public ReferenceBinding setFocusType(char[][] cArray) {
        if (cArray == null || this.lookupEnvironment == null) {
            return null;
        }
        this.focusType = this.lookupEnvironment.getCachedType(cArray);
        if (this.focusType == null) {
            this.focusType = this.lookupEnvironment.askForType(cArray);
        }
        return this.focusType;
    }

    public boolean subOrSuperOfFocus(ReferenceBinding referenceBinding) {
        block5: {
            if (this.focusType == null) {
                return true;
            }
            try {
                if (!this.subTypeOfType(this.focusType, referenceBinding)) break block5;
                return true;
            }
            catch (AbortCompilation abortCompilation) {}
        }
        if (!this.superTypesOnly && this.subTypeOfType(referenceBinding, this.focusType)) {
            return true;
        }
        return false;
    }

    private boolean subTypeOfType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        if (referenceBinding2 == null || referenceBinding == null) {
            return false;
        }
        if (referenceBinding == referenceBinding2) {
            return true;
        }
        ReferenceBinding referenceBinding3 = referenceBinding.superclass();
        if (referenceBinding3 != null) {
            referenceBinding3 = (ReferenceBinding)referenceBinding3.erasure();
        }
        if (referenceBinding3 != null && referenceBinding3.id == 1 && referenceBinding.isHierarchyInconsistent()) {
            return false;
        }
        if (this.subTypeOfType(referenceBinding3, referenceBinding2)) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        if (referenceBindingArray != null) {
            int n = 0;
            int n2 = referenceBindingArray.length;
            while (n < n2) {
                ReferenceBinding referenceBinding4 = (ReferenceBinding)referenceBindingArray[n].erasure();
                if (this.subTypeOfType(referenceBinding4, referenceBinding2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected void worked(IProgressMonitor iProgressMonitor, int n) {
        if (iProgressMonitor != null) {
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProgressMonitor.worked(n);
        }
    }

    public CompilationUnitDeclaration doParse(org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
        CompilationResult compilationResult = new CompilationResult(iCompilationUnit, 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse(iCompilationUnit, compilationResult);
        parser.inferTypes(compilationUnitDeclaration, this.options);
        return compilationUnitDeclaration;
    }
}

