/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeHierarchyChangedListener;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.Region;
import org.eclipse.wst.jsdt.internal.core.TypeVector;
import org.eclipse.wst.jsdt.internal.core.hierarchy.ChangeCollector;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.IndexBasedHierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class TypeHierarchy
implements ITypeHierarchy,
IElementChangedListener {
    public static boolean DEBUG = false;
    static final byte VERSION = 0;
    static final byte SEPARATOR1 = 10;
    static final byte SEPARATOR2 = 44;
    static final byte SEPARATOR3 = 62;
    static final byte SEPARATOR4 = 13;
    static final byte COMPUTE_SUBTYPES = 1;
    static final byte CLASS = 0;
    static final byte INTERFACE = 1;
    static final byte COMPUTED_FOR = 2;
    static final byte ROOT = 4;
    static final byte[] NO_FLAGS = new byte[0];
    static final int SIZE = 10;
    protected IJavaProject project;
    protected IType focusType;
    protected ICompilationUnit[] workingCopies;
    protected Map classToSuperclass;
    protected Map typeToSuperInterfaces;
    protected Map typeToSubtypes;
    protected Map typeFlags;
    protected TypeVector rootClasses = new TypeVector();
    protected ArrayList interfaces = new ArrayList(10);
    public ArrayList missingTypes = new ArrayList(4);
    protected static final IType[] NO_TYPE = new IType[0];
    protected IProgressMonitor progressMonitor = null;
    protected ArrayList changeListeners = null;
    public Map files = null;
    protected Region packageRegion = null;
    protected Region projectRegion = null;
    protected boolean computeSubtypes;
    IJavaSearchScope scope;
    public boolean needsRefresh = true;
    protected ChangeCollector changeCollector;

    public TypeHierarchy() {
    }

    public TypeHierarchy(IType iType, ICompilationUnit[] iCompilationUnitArray, IJavaProject iJavaProject, boolean bl) {
        this(iType, iCompilationUnitArray, SearchEngine.createJavaSearchScope(new IJavaElement[]{iJavaProject}), bl);
        this.project = iJavaProject;
    }

    public TypeHierarchy(IType iType, ICompilationUnit[] iCompilationUnitArray, IJavaSearchScope iJavaSearchScope, boolean bl) {
        this.focusType = iType == null ? null : (IType)((Object)((JavaElement)((Object)iType)).unresolved());
        this.workingCopies = iCompilationUnitArray;
        this.computeSubtypes = bl;
        this.scope = iJavaSearchScope;
    }

    protected void initializeRegions() {
        IType[] iTypeArray = this.getAllTypes();
        int n = 0;
        while (n < iTypeArray.length) {
            ArrayList arrayList;
            IType iType = iTypeArray[n];
            Openable openable = (Openable)((JavaElement)((Object)iType)).getOpenableParent();
            if (openable != null) {
                arrayList = (ArrayList)this.files.get(openable);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.files.put(openable, arrayList);
                }
                arrayList.add(iType);
            }
            arrayList = iType.getPackageFragment();
            this.packageRegion.add((IJavaElement)((Object)arrayList));
            IJavaProject iJavaProject = iType.getJavaProject();
            if (iJavaProject != null) {
                this.projectRegion.add(iJavaProject);
            }
            this.checkCanceled();
            ++n;
        }
    }

    private void addAllCheckingDuplicates(ArrayList arrayList, IType[] iTypeArray) {
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType = iTypeArray[n];
            if (!arrayList.contains(iType)) {
                arrayList.add(iType);
            }
            ++n;
        }
    }

    protected void addInterface(IType iType) {
        this.interfaces.add(iType);
    }

    protected void addRootClass(IType iType) {
        if (this.rootClasses.contains(iType)) {
            return;
        }
        this.rootClasses.add(iType);
    }

    protected void addSubtype(IType iType, IType iType2) {
        TypeVector typeVector = (TypeVector)this.typeToSubtypes.get(iType);
        if (typeVector == null) {
            typeVector = new TypeVector();
            this.typeToSubtypes.put(iType, typeVector);
        }
        if (!typeVector.contains(iType2)) {
            typeVector.add(iType2);
        }
    }

    public synchronized void addTypeHierarchyChangedListener(ITypeHierarchyChangedListener iTypeHierarchyChangedListener) {
        ArrayList<ITypeHierarchyChangedListener> arrayList = this.changeListeners;
        if (arrayList == null) {
            this.changeListeners = arrayList = new ArrayList<ITypeHierarchyChangedListener>();
        }
        if (arrayList.size() == 0) {
            JavaCore.addElementChangedListener(this);
        }
        if (arrayList.indexOf(iTypeHierarchyChangedListener) == -1) {
            arrayList.add(iTypeHierarchyChangedListener);
        }
    }

    private static Integer bytesToFlags(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            return new Integer(new String(byArray));
        }
        return null;
    }

    public void cacheFlags(IType iType, int n) {
        this.typeFlags.put(iType, new Integer(n));
    }

    protected void cacheSuperclass(IType iType, IType iType2) {
        if (iType2 != null) {
            this.classToSuperclass.put(iType, iType2);
            this.addSubtype(iType2, iType);
        }
    }

    protected void cacheSuperInterfaces(IType iType, IType[] iTypeArray) {
        this.typeToSuperInterfaces.put(iType, iTypeArray);
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType2 = iTypeArray[n];
            if (iType2 != null) {
                this.addSubtype(iType2, iType);
            }
            ++n;
        }
    }

    protected void checkCanceled() {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void compute() throws JavaModelException, CoreException {
        if (this.focusType != null) {
            IndexBasedHierarchyBuilder indexBasedHierarchyBuilder = new IndexBasedHierarchyBuilder(this, this.scope);
            ((HierarchyBuilder)indexBasedHierarchyBuilder).build(this.computeSubtypes);
        }
    }

    private String typehash(IJavaElement iJavaElement) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iJavaElement != null && iJavaElement.getElementType() != 1) {
            stringBuffer.append(iJavaElement.getElementName());
            stringBuffer.append(" - ");
            iJavaElement = iJavaElement.getParent();
        }
        return stringBuffer.toString();
    }

    public boolean contains(IType iType) {
        if (this.classToSuperclass.get(iType) != null) {
            return true;
        }
        if (this.rootClasses.contains(iType)) {
            return true;
        }
        return this.interfaces.contains(iType);
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        if (this.needsRefresh) {
            return;
        }
        if (this.isAffected(elementChangedEvent.getDelta())) {
            this.needsRefresh = true;
            this.fireChange();
        }
    }

    public boolean exists() {
        if (!this.needsRefresh) {
            return true;
        }
        return (this.focusType == null || this.focusType.exists()) && this.javaProject().exists();
    }

    public void fireChange() {
        ArrayList arrayList = this.changeListeners;
        if (arrayList == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("FIRING hierarchy change [" + Thread.currentThread() + "]");
            if (this.focusType != null) {
                System.out.println("    for hierarchy focused on " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors());
            }
        }
        arrayList = (ArrayList)arrayList.clone();
        int n = 0;
        while (n < arrayList.size()) {
            final ITypeHierarchyChangedListener iTypeHierarchyChangedListener = (ITypeHierarchyChangedListener)arrayList.get(n);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    Util.log(throwable, "Exception occurred in listener of Type hierarchy change notification");
                }

                public void run() throws Exception {
                    iTypeHierarchyChangedListener.typeHierarchyChanged(TypeHierarchy.this);
                }
            });
            ++n;
        }
    }

    private static byte[] flagsToBytes(Integer n) {
        if (n != null) {
            return n.toString().getBytes();
        }
        return NO_FLAGS;
    }

    public IType[] getAllClasses() {
        TypeVector typeVector = this.rootClasses.copy();
        Iterator iterator = this.classToSuperclass.keySet().iterator();
        while (iterator.hasNext()) {
            typeVector.add((IType)iterator.next());
        }
        return typeVector.elements();
    }

    public IType[] getAllInterfaces() {
        IType[] iTypeArray = new IType[this.interfaces.size()];
        this.interfaces.toArray(iTypeArray);
        return iTypeArray;
    }

    public IType[] getAllSubtypes(IType iType) {
        return this.getAllSubtypesForType(iType);
    }

    private IType[] getAllSubtypesForType(IType iType) {
        ArrayList arrayList = new ArrayList();
        this.getAllSubtypesForType0(iType, arrayList);
        IType[] iTypeArray = new IType[arrayList.size()];
        arrayList.toArray(iTypeArray);
        return iTypeArray;
    }

    private void getAllSubtypesForType0(IType iType, ArrayList arrayList) {
        IType[] iTypeArray = this.getSubtypesForType(iType);
        if (iTypeArray.length != 0) {
            int n = 0;
            while (n < iTypeArray.length) {
                IType iType2 = iTypeArray[n];
                arrayList.add(iType2);
                this.getAllSubtypesForType0(iType2, arrayList);
                ++n;
            }
        }
    }

    public IType[] getAllSuperclasses(IType iType) {
        IType iType2 = this.getSuperclass(iType);
        TypeVector typeVector = new TypeVector();
        while (iType2 != null) {
            typeVector.add(iType2);
            iType2 = this.getSuperclass(iType2);
        }
        return typeVector.elements();
    }

    public IType[] getAllSuperInterfaces(IType iType) {
        ArrayList arrayList = new ArrayList();
        if (this.typeToSuperInterfaces.get(iType) == null) {
            return NO_TYPE;
        }
        this.getAllSuperInterfaces0(iType, arrayList);
        IType[] iTypeArray = new IType[arrayList.size()];
        arrayList.toArray(iTypeArray);
        return iTypeArray;
    }

    private void getAllSuperInterfaces0(IType iType, ArrayList arrayList) {
        IType iType2;
        IType[] iTypeArray = (IType[])this.typeToSuperInterfaces.get(iType);
        if (iTypeArray != null && iTypeArray.length != 0) {
            this.addAllCheckingDuplicates(arrayList, iTypeArray);
            int n = 0;
            while (n < iTypeArray.length) {
                this.getAllSuperInterfaces0(iTypeArray[n], arrayList);
                ++n;
            }
        }
        if ((iType2 = (IType)this.classToSuperclass.get(iType)) != null) {
            this.getAllSuperInterfaces0(iType2, arrayList);
        }
    }

    public IType[] getAllSupertypes(IType iType) {
        ArrayList arrayList = new ArrayList();
        if (this.typeToSuperInterfaces.get(iType) == null) {
            return NO_TYPE;
        }
        this.getAllSupertypes0(iType, arrayList);
        IType[] iTypeArray = new IType[arrayList.size()];
        arrayList.toArray(iTypeArray);
        return iTypeArray;
    }

    private void getAllSupertypes0(IType iType, ArrayList arrayList) {
        IType iType2;
        IType[] iTypeArray = (IType[])this.typeToSuperInterfaces.get(iType);
        if (iTypeArray != null && iTypeArray.length != 0) {
            this.addAllCheckingDuplicates(arrayList, iTypeArray);
            int n = 0;
            while (n < iTypeArray.length) {
                this.getAllSuperInterfaces0(iTypeArray[n], arrayList);
                ++n;
            }
        }
        if ((iType2 = (IType)this.classToSuperclass.get(iType)) != null) {
            arrayList.add(iType2);
            this.getAllSupertypes0(iType2, arrayList);
        }
    }

    public IType[] getAllTypes() {
        IType[] iTypeArray = this.getAllClasses();
        int n = iTypeArray.length;
        IType[] iTypeArray2 = this.getAllInterfaces();
        int n2 = iTypeArray2.length;
        IType[] iTypeArray3 = new IType[n + n2];
        System.arraycopy(iTypeArray, 0, iTypeArray3, 0, n);
        System.arraycopy(iTypeArray2, 0, iTypeArray3, n, n2);
        return iTypeArray3;
    }

    public int getCachedFlags(IType iType) {
        Integer n = (Integer)this.typeFlags.get(iType);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public IType[] getExtendingInterfaces(IType iType) {
        if (!this.isInterface(iType)) {
            return NO_TYPE;
        }
        return this.getExtendingInterfaces0(iType);
    }

    private IType[] getExtendingInterfaces0(IType iType) {
        Object object;
        Iterator iterator = this.typeToSuperInterfaces.entrySet().iterator();
        ArrayList<IType> arrayList = new ArrayList<IType>();
        while (iterator.hasNext()) {
            IType[] iTypeArray;
            object = iterator.next();
            IType iType2 = (IType)object.getKey();
            if (!this.isInterface(iType2) || (iTypeArray = (IType[])object.getValue()) == null) continue;
            int n = 0;
            while (n < iTypeArray.length) {
                IType iType3 = iTypeArray[n];
                if (iType3.equals(iType)) {
                    arrayList.add(iType2);
                }
                ++n;
            }
        }
        object = new IType[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public IType[] getImplementingClasses(IType iType) {
        if (!this.isInterface(iType)) {
            return NO_TYPE;
        }
        return this.getImplementingClasses0(iType);
    }

    private IType[] getImplementingClasses0(IType iType) {
        Object object;
        Iterator iterator = this.typeToSuperInterfaces.entrySet().iterator();
        ArrayList<IType> arrayList = new ArrayList<IType>();
        while (iterator.hasNext()) {
            object = iterator.next();
            IType iType2 = (IType)object.getKey();
            if (this.isInterface(iType2)) continue;
            IType[] iTypeArray = (IType[])object.getValue();
            int n = 0;
            while (n < iTypeArray.length) {
                IType iType3 = iTypeArray[n];
                if (iType3.equals(iType)) {
                    arrayList.add(iType2);
                }
                ++n;
            }
        }
        object = new IType[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public IType[] getRootClasses() {
        return this.rootClasses.elements();
    }

    public IType[] getRootInterfaces() {
        IType[] iTypeArray = this.getAllInterfaces();
        IType[] iTypeArray2 = new IType[iTypeArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < iTypeArray.length) {
            IType[] iTypeArray3 = this.getSuperInterfaces(iTypeArray[n2]);
            if (iTypeArray3 == null || iTypeArray3.length == 0) {
                iTypeArray2[n++] = iTypeArray[n2];
            }
            ++n2;
        }
        IType[] iTypeArray4 = new IType[n];
        if (iTypeArray4.length > 0) {
            System.arraycopy(iTypeArray2, 0, iTypeArray4, 0, n);
        }
        return iTypeArray4;
    }

    public IType[] getSubclasses(IType iType) {
        if (this.isInterface(iType)) {
            return NO_TYPE;
        }
        TypeVector typeVector = (TypeVector)this.typeToSubtypes.get(iType);
        if (typeVector == null) {
            return NO_TYPE;
        }
        return typeVector.elements();
    }

    public IType[] getSubtypes(IType iType) {
        return this.getSubtypesForType(iType);
    }

    private IType[] getSubtypesForType(IType iType) {
        TypeVector typeVector = (TypeVector)this.typeToSubtypes.get(iType);
        if (typeVector == null) {
            return NO_TYPE;
        }
        return typeVector.elements();
    }

    public IType getSuperclass(IType iType) {
        if (this.isInterface(iType)) {
            return null;
        }
        return (IType)this.classToSuperclass.get(iType);
    }

    public IType[] getSuperInterfaces(IType iType) {
        IType[] iTypeArray = (IType[])this.typeToSuperInterfaces.get(iType);
        if (iTypeArray == null) {
            return NO_TYPE;
        }
        return iTypeArray;
    }

    public IType[] getSupertypes(IType iType) {
        IType iType2 = this.getSuperclass(iType);
        if (iType2 == null) {
            return this.getSuperInterfaces(iType);
        }
        TypeVector typeVector = new TypeVector(this.getSuperInterfaces(iType));
        typeVector.add(iType2);
        return typeVector.elements();
    }

    public IType getType() {
        return this.focusType;
    }

    protected IType[] growAndAddToArray(IType[] iTypeArray, IType[] iTypeArray2) {
        if (iTypeArray == null || iTypeArray.length == 0) {
            return iTypeArray2;
        }
        IType[] iTypeArray3 = iTypeArray;
        iTypeArray = new IType[iTypeArray3.length + iTypeArray2.length];
        System.arraycopy(iTypeArray3, 0, iTypeArray, 0, iTypeArray3.length);
        System.arraycopy(iTypeArray2, 0, iTypeArray, iTypeArray3.length, iTypeArray2.length);
        return iTypeArray;
    }

    protected IType[] growAndAddToArray(IType[] iTypeArray, IType iType) {
        if (iTypeArray == null || iTypeArray.length == 0) {
            return new IType[]{iType};
        }
        IType[] iTypeArray2 = iTypeArray;
        iTypeArray = new IType[iTypeArray2.length + 1];
        System.arraycopy(iTypeArray2, 0, iTypeArray, 0, iTypeArray2.length);
        iTypeArray[iTypeArray2.length] = iType;
        return iTypeArray;
    }

    public boolean hasFineGrainChanges() {
        ChangeCollector changeCollector = this.changeCollector;
        return changeCollector != null && changeCollector.needsRefresh();
    }

    private boolean hasSubtypeNamed(String string) {
        if (this.focusType != null && this.focusType.getElementName().equals(string)) {
            return true;
        }
        IType[] iTypeArray = this.focusType == null ? this.getAllTypes() : this.getAllSubtypes(this.focusType);
        int n = 0;
        int n2 = iTypeArray.length;
        while (n < n2) {
            if (iTypeArray[n].getElementName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasTypeNamed(String string) {
        IType[] iTypeArray = this.getAllTypes();
        int n = 0;
        int n2 = iTypeArray.length;
        while (n < n2) {
            if (iTypeArray[n].getElementName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean includesTypeOrSupertype(IType iType) {
        try {
            int n;
            String string;
            if (this.hasTypeNamed(iType.getElementName())) {
                return true;
            }
            String string2 = iType.getSuperclassName();
            if (string2 != null && this.hasTypeNamed(string = string2.substring((n = string2.lastIndexOf(46)) + 1))) {
                return true;
            }
            String[] stringArray = iType.getSuperInterfaceNames();
            if (stringArray == null) return false;
            int n2 = 0;
            int n3 = stringArray.length;
            while (true) {
                if (n2 >= n3) {
                    return false;
                }
                String string3 = stringArray[n2];
                int n4 = string3.lastIndexOf(46);
                String string4 = string3.substring(n4 + 1);
                if (this.hasTypeNamed(string4)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    protected void initialize(int n) {
        if (n < 10) {
            n = 10;
        }
        int n2 = n / 2;
        this.classToSuperclass = new HashMap(n);
        this.interfaces = new ArrayList(n2);
        this.missingTypes = new ArrayList(n2);
        this.rootClasses = new TypeVector();
        this.typeToSubtypes = new HashMap(n2);
        this.typeToSuperInterfaces = new HashMap(n2);
        this.typeFlags = new HashMap(n2);
        this.projectRegion = new Region();
        this.packageRegion = new Region();
        this.files = new HashMap(5);
    }

    public synchronized boolean isAffected(IJavaElementDelta iJavaElementDelta) {
        IJavaElement iJavaElement = iJavaElementDelta.getElement();
        switch (iJavaElement.getElementType()) {
            case 1: {
                return this.isAffectedByJavaModel(iJavaElementDelta, iJavaElement);
            }
            case 2: {
                return this.isAffectedByJavaProject(iJavaElementDelta, iJavaElement);
            }
            case 3: {
                return this.isAffectedByPackageFragmentRoot(iJavaElementDelta, iJavaElement);
            }
            case 4: {
                return this.isAffectedByPackageFragment(iJavaElementDelta, (PackageFragment)iJavaElement);
            }
            case 5: 
            case 6: {
                return this.isAffectedByOpenable(iJavaElementDelta, iJavaElement);
            }
        }
        return false;
    }

    private boolean isAffectedByChildren(IJavaElementDelta iJavaElementDelta) {
        if ((iJavaElementDelta.getFlags() & 8) > 0) {
            IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
            int n = 0;
            while (n < iJavaElementDeltaArray.length) {
                if (this.isAffected(iJavaElementDeltaArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean isAffectedByJavaModel(IJavaElementDelta iJavaElementDelta, IJavaElement iJavaElement) {
        switch (iJavaElementDelta.getKind()) {
            case 1: 
            case 2: {
                return iJavaElement.equals(this.javaProject().getJavaModel());
            }
            case 4: {
                return this.isAffectedByChildren(iJavaElementDelta);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isAffectedByJavaProject(IJavaElementDelta iJavaElementDelta, IJavaElement iJavaElement) {
        int n = iJavaElementDelta.getKind();
        int n2 = iJavaElementDelta.getFlags();
        if ((n2 & 0x200) != 0) {
            n = 1;
        }
        if ((n2 & 0x400) != 0) {
            n = 2;
        }
        switch (n) {
            case 1: {
                try {
                    IClasspathEntry[] iClasspathEntryArray = ((JavaProject)this.javaProject()).getExpandedClasspath();
                    int n3 = 0;
                    while (n3 < iClasspathEntryArray.length) {
                        if (iClasspathEntryArray[n3].getEntryKind() == 2 && iClasspathEntryArray[n3].getPath().equals((Object)iJavaElement.getPath())) {
                            return true;
                        }
                        ++n3;
                    }
                    if (this.focusType != null) {
                        iClasspathEntryArray = ((JavaProject)iJavaElement).getExpandedClasspath();
                        IPath iPath = this.javaProject().getPath();
                        int n4 = 0;
                        while (n4 < iClasspathEntryArray.length) {
                            if (iClasspathEntryArray[n4].getEntryKind() == 2 && iClasspathEntryArray[n4].getPath().equals((Object)iPath)) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            case 2: {
                IJavaElement[] iJavaElementArray = this.packageRegion.getElements();
                int n5 = 0;
                while (n5 < iJavaElementArray.length) {
                    IJavaProject iJavaProject = iJavaElementArray[n5].getJavaProject();
                    if (iJavaProject != null && iJavaProject.equals(iJavaElement)) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            case 4: {
                return this.isAffectedByChildren(iJavaElementDelta);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragment(IJavaElementDelta iJavaElementDelta, PackageFragment packageFragment) {
        switch (iJavaElementDelta.getKind()) {
            case 1: {
                return this.projectRegion.contains(packageFragment);
            }
            case 2: {
                return this.packageRegionContainsSamePackageFragment(packageFragment);
            }
            case 4: {
                return this.isAffectedByChildren(iJavaElementDelta);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragmentRoot(IJavaElementDelta iJavaElementDelta, IJavaElement iJavaElement) {
        switch (iJavaElementDelta.getKind()) {
            case 1: {
                return this.projectRegion.contains(iJavaElement);
            }
            case 2: 
            case 4: {
                IJavaElement[] iJavaElementArray;
                int n = iJavaElementDelta.getFlags();
                if ((n & 0x40) > 0 && this.projectRegion != null) {
                    iJavaElementArray = (IJavaElement[])iJavaElement;
                    IPath iPath = iJavaElementArray.getPath();
                    IJavaElement[] iJavaElementArray2 = this.projectRegion.getElements();
                    int n2 = 0;
                    while (n2 < iJavaElementArray2.length) {
                        JavaProject javaProject = (JavaProject)iJavaElementArray2[n2];
                        try {
                            IClasspathEntry iClasspathEntry = javaProject.getClasspathEntryFor(iPath);
                            if (iClasspathEntry != null) {
                                return true;
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        ++n2;
                    }
                }
                if ((n & 0x80) <= 0 && (n & 1) <= 0) break;
                iJavaElementArray = this.packageRegion.getElements();
                int n3 = 0;
                while (n3 < iJavaElementArray.length) {
                    if (iJavaElementArray[n3].getParent().equals(iJavaElement)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
        }
        return this.isAffectedByChildren(iJavaElementDelta);
    }

    protected boolean isAffectedByOpenable(IJavaElementDelta iJavaElementDelta, IJavaElement iJavaElement) {
        if (iJavaElement instanceof CompilationUnit) {
            ChangeCollector changeCollector;
            CompilationUnit compilationUnit;
            block14: {
                compilationUnit = (CompilationUnit)iJavaElement;
                changeCollector = this.changeCollector;
                if (changeCollector == null) {
                    changeCollector = new ChangeCollector(this);
                }
                try {
                    changeCollector.addChange(compilationUnit, iJavaElementDelta);
                }
                catch (JavaModelException javaModelException) {
                    if (!DEBUG) break block14;
                    javaModelException.printStackTrace();
                }
            }
            if (compilationUnit.isWorkingCopy()) {
                this.changeCollector = changeCollector;
                return false;
            }
            return changeCollector.needsRefresh();
        }
        if (iJavaElement instanceof ClassFile) {
            switch (iJavaElementDelta.getKind()) {
                case 2: {
                    return this.files.get(iJavaElement) != null;
                }
                case 1: {
                    IType iType = ((ClassFile)iJavaElement).getType();
                    String string = iType.getElementName();
                    if (!this.hasSupertype(string) && !this.subtypesIncludeSupertypeOf(iType) && !this.missingTypes.contains(string)) break;
                    return true;
                }
                case 4: {
                    IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
                    int n = 0;
                    int n2 = iJavaElementDeltaArray.length;
                    while (n < n2) {
                        IJavaElementDelta iJavaElementDelta2 = iJavaElementDeltaArray[n];
                        IJavaElement iJavaElement2 = iJavaElementDelta2.getElement();
                        if (iJavaElement2 instanceof IType) {
                            boolean bl;
                            IType iType = (IType)iJavaElement2;
                            boolean bl2 = (iJavaElementDelta.getFlags() & 2) > 0;
                            boolean bl3 = bl = (iJavaElementDelta.getFlags() & 0x800) > 0;
                            if (bl2 && this.hasSupertype(iType.getElementName()) || bl && this.includesTypeOrSupertype(iType)) {
                                return true;
                            }
                        }
                        ++n;
                    }
                    break;
                }
            }
        }
        return false;
    }

    private boolean isInterface(IType iType) {
        int n = this.getCachedFlags(iType);
        if (n == -1) {
            try {
                return iType.isInterface();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return Flags.isInterface(n);
    }

    public IJavaProject javaProject() {
        return this.focusType.getJavaProject();
    }

    protected static byte[] readUntil(InputStream inputStream, byte by) throws JavaModelException, IOException {
        return TypeHierarchy.readUntil(inputStream, by, 0);
    }

    protected static byte[] readUntil(InputStream inputStream, byte by, int n) throws IOException, JavaModelException {
        byte by2;
        int n2 = 0;
        byte[] byArray = new byte[10];
        while ((by2 = (byte)inputStream.read()) != by && by2 != -1) {
            if (byArray.length == n2) {
                byte[] byArray2 = byArray;
                byArray = new byte[n2 * 2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            byArray[n2++] = by2;
        }
        if (by2 == -1) {
            throw new JavaModelException(new JavaModelStatus(4));
        }
        byte[] byArray3 = byArray;
        byArray = new byte[n2 + n];
        System.arraycopy(byArray3, 0, byArray, n, n2);
        return byArray;
    }

    public static ITypeHierarchy load(IType iType, InputStream inputStream, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        try {
            Object object;
            byte by;
            byte[] byArray;
            TypeHierarchy typeHierarchy = new TypeHierarchy();
            typeHierarchy.initialize(1);
            IType[] iTypeArray = new IType[10];
            int n = 0;
            byte by2 = (byte)inputStream.read();
            if (by2 != 0) {
                throw new JavaModelException(new JavaModelStatus(4));
            }
            byte by3 = (byte)inputStream.read();
            if ((by3 & 1) != 0) {
                typeHierarchy.computeSubtypes = true;
            }
            if ((byArray = TypeHierarchy.readUntil(inputStream, (byte)10)).length > 0) {
                typeHierarchy.project = (IJavaProject)JavaCore.create(new String(byArray));
                typeHierarchy.scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{typeHierarchy.project});
            } else {
                typeHierarchy.project = null;
                typeHierarchy.scope = SearchEngine.createWorkspaceScope();
            }
            byArray = TypeHierarchy.readUntil(inputStream, (byte)10);
            int n2 = 0;
            int n3 = byArray.length;
            int n4 = 0;
            while (n4 < n3) {
                by = byArray[n4];
                if (by == 44) {
                    object = new byte[n4 - n2];
                    System.arraycopy(byArray, n2, object, 0, n4 - n2);
                    typeHierarchy.missingTypes.add(new String((byte[])object));
                    n2 = n4 + 1;
                }
                ++n4;
            }
            object = new byte[n3 - n2];
            System.arraycopy(byArray, n2, object, 0, n3 - n2);
            typeHierarchy.missingTypes.add(new String((byte[])object));
            while ((by = (byte)inputStream.read()) != 10 && by != -1) {
                byArray = TypeHierarchy.readUntil(inputStream, (byte)13, 1);
                byArray[0] = by;
                object = (IType)JavaCore.create(new String(byArray), workingCopyOwner);
                if (iTypeArray.length == n) {
                    IType[] iTypeArray2 = iTypeArray;
                    iTypeArray = new IType[n * 2];
                    System.arraycopy(iTypeArray2, 0, iTypeArray, 0, n);
                }
                iTypeArray[n++] = object;
                byArray = TypeHierarchy.readUntil(inputStream, (byte)13);
                Integer n5 = TypeHierarchy.bytesToFlags(byArray);
                if (n5 != null) {
                    typeHierarchy.cacheFlags((IType)object, n5);
                }
                if (((n3 = (int)((byte)inputStream.read())) & 1) != 0) {
                    typeHierarchy.addInterface((IType)object);
                }
                if ((n3 & 2) != 0) {
                    if (!object.equals(iType)) {
                        throw new JavaModelException(new JavaModelStatus(4));
                    }
                    typeHierarchy.focusType = object;
                }
                if ((n3 & 4) == 0) continue;
                typeHierarchy.addRootClass((IType)object);
            }
            while ((by = (byte)inputStream.read()) != 10 && by != -1) {
                byArray = TypeHierarchy.readUntil(inputStream, (byte)62, 1);
                byArray[0] = by;
                int n6 = new Integer(new String(byArray));
                byArray = TypeHierarchy.readUntil(inputStream, (byte)10);
                int n7 = new Integer(new String(byArray));
                typeHierarchy.cacheSuperclass(iTypeArray[n6], iTypeArray[n7]);
            }
            while ((by = (byte)inputStream.read()) != 10 && by != -1) {
                byte[] byArray2;
                byArray = TypeHierarchy.readUntil(inputStream, (byte)62, 1);
                byArray[0] = by;
                int n8 = new Integer(new String(byArray));
                byArray = TypeHierarchy.readUntil(inputStream, (byte)10);
                IType[] iTypeArray3 = new IType[byArray.length / 2 + 1];
                n3 = 0;
                n4 = 0;
                int n9 = 0;
                while (n9 < byArray.length) {
                    if (byArray[n9] == 44) {
                        byArray2 = new byte[n9 - n4];
                        System.arraycopy(byArray, n4, byArray2, 0, n9 - n4);
                        n4 = n9 + 1;
                        iTypeArray3[n3++] = iTypeArray[new Integer(new String(byArray2))];
                    }
                    ++n9;
                }
                byArray2 = new byte[byArray.length - n4];
                System.arraycopy(byArray, n4, byArray2, 0, byArray.length - n4);
                iTypeArray3[n3++] = iTypeArray[new Integer(new String(byArray2))];
                IType[] iTypeArray4 = iTypeArray3;
                iTypeArray3 = new IType[n3];
                System.arraycopy(iTypeArray4, 0, iTypeArray3, 0, n3);
                typeHierarchy.cacheSuperInterfaces(iTypeArray[n8], iTypeArray3);
            }
            if (by == -1) {
                throw new JavaModelException(new JavaModelStatus(4));
            }
            return typeHierarchy;
        }
        catch (IOException iOException) {
            throw new JavaModelException(iOException, 985);
        }
    }

    protected boolean packageRegionContainsSamePackageFragment(PackageFragment packageFragment) {
        IJavaElement[] iJavaElementArray = this.packageRegion.getElements();
        int n = 0;
        while (n < iJavaElementArray.length) {
            PackageFragment packageFragment2 = (PackageFragment)iJavaElementArray[n];
            if (Util.equalArraysOrNull(packageFragment2.names, packageFragment.names)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void refresh(IProgressMonitor iProgressMonitor) throws JavaModelException {
        block15: {
            try {
                try {
                    this.progressMonitor = iProgressMonitor;
                    if (iProgressMonitor != null) {
                        iProgressMonitor.beginTask(this.focusType != null ? Messages.bind(Messages.hierarchy_creatingOnType, this.focusType.getFullyQualifiedName()) : Messages.hierarchy_creating, 100);
                    }
                    long l = -1L;
                    if (DEBUG) {
                        l = System.currentTimeMillis();
                        if (this.computeSubtypes) {
                            System.out.println("CREATING TYPE HIERARCHY [" + Thread.currentThread() + "]");
                        } else {
                            System.out.println("CREATING SUPER TYPE HIERARCHY [" + Thread.currentThread() + "]");
                        }
                        if (this.focusType != null) {
                            System.out.println("  on type " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors());
                        }
                    }
                    this.compute();
                    this.initializeRegions();
                    this.needsRefresh = false;
                    this.changeCollector = null;
                    if (DEBUG) {
                        if (this.computeSubtypes) {
                            System.out.println("CREATED TYPE HIERARCHY in " + (System.currentTimeMillis() - l) + "ms");
                        } else {
                            System.out.println("CREATED SUPER TYPE HIERARCHY in " + (System.currentTimeMillis() - l) + "ms");
                        }
                        System.out.println(this.toString());
                    }
                }
                catch (JavaModelException javaModelException) {
                    throw javaModelException;
                }
                catch (CoreException coreException) {
                    throw new JavaModelException(coreException);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (iProgressMonitor != null) {
                    iProgressMonitor.done();
                }
                this.progressMonitor = null;
                throw throwable;
            }
            {
                Object var4_7 = null;
                if (iProgressMonitor == null) break block15;
            }
            iProgressMonitor.done();
        }
        this.progressMonitor = null;
    }

    public synchronized void removeTypeHierarchyChangedListener(ITypeHierarchyChangedListener iTypeHierarchyChangedListener) {
        ArrayList arrayList = this.changeListeners;
        if (arrayList == null) {
            return;
        }
        arrayList.remove(iTypeHierarchyChangedListener);
        if (arrayList.isEmpty()) {
            JavaCore.removeElementChangedListener(this);
        }
    }

    public void store(OutputStream outputStream, IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            Object object;
            IJavaElement[] iJavaElementArray;
            Object object2;
            Object object3;
            Map.Entry entry;
            Object object4;
            Hashtable<IType, Object> hashtable = new Hashtable<IType, Object>();
            Hashtable<Object, IType> hashtable2 = new Hashtable<Object, IType>();
            int n = 0;
            if (this.focusType != null) {
                object4 = new Integer(n++);
                hashtable.put(this.focusType, object4);
                hashtable2.put(object4, this.focusType);
            }
            object4 = this.classToSuperclass.entrySet().toArray();
            int n2 = 0;
            while (n2 < ((Object[])object4).length) {
                entry = (Map.Entry)object4[n2];
                object3 = entry.getKey();
                if (hashtable.get(object3) == null) {
                    object2 = new Integer(n++);
                    hashtable.put((IType)object3, object2);
                    hashtable2.put(object2, (IType)object3);
                }
                if ((object2 = entry.getValue()) != null && hashtable.get(object2) == null) {
                    iJavaElementArray = new Integer(n++);
                    hashtable.put((IType)object2, iJavaElementArray);
                    hashtable2.put(iJavaElementArray, (IType)object2);
                }
                ++n2;
            }
            object4 = this.typeToSuperInterfaces.entrySet().toArray();
            n2 = 0;
            while (n2 < ((Object[])object4).length) {
                entry = (Map.Entry)object4[n2];
                object3 = entry.getKey();
                if (hashtable.get(object3) == null) {
                    object2 = new Integer(n++);
                    hashtable.put((IType)object3, object2);
                    hashtable2.put(object2, (IType)object3);
                }
                if ((object2 = (Object[])entry.getValue()) != null) {
                    int n3 = 0;
                    while (n3 < ((V)object2).length) {
                        Object v = object2[n3];
                        if (object2[n3] != null && hashtable.get(v) == null) {
                            object = new Integer(n++);
                            hashtable.put((IType)v, object);
                            hashtable2.put(object, (IType)v);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            outputStream.write(0);
            n2 = 0;
            if (this.computeSubtypes) {
                n2 = (byte)(n2 | 1);
            }
            outputStream.write(n2);
            if (this.project != null) {
                outputStream.write(this.project.getHandleIdentifier().getBytes());
            }
            outputStream.write(10);
            int n4 = 0;
            while (n4 < this.missingTypes.size()) {
                if (n4 != 0) {
                    outputStream.write(44);
                }
                outputStream.write(((String)this.missingTypes.get(n4)).getBytes());
                ++n4;
            }
            outputStream.write(10);
            n4 = 0;
            while (n4 < n) {
                object3 = (IType)hashtable2.get(new Integer(n4));
                outputStream.write(object3.getHandleIdentifier().getBytes());
                outputStream.write(13);
                outputStream.write(TypeHierarchy.flagsToBytes((Integer)this.typeFlags.get(object3)));
                outputStream.write(13);
                int n5 = 0;
                if (this.focusType != null && this.focusType.equals(object3)) {
                    n5 = (byte)(n5 | 2);
                }
                if (this.interfaces.contains(object3)) {
                    n5 = (byte)(n5 | 1);
                }
                if (this.rootClasses.contains((IType)object3)) {
                    n5 = (byte)(n5 | 4);
                }
                outputStream.write(n5);
                ++n4;
            }
            outputStream.write(10);
            object4 = this.classToSuperclass.entrySet().toArray();
            n4 = 0;
            while (n4 < ((Object[])object4).length) {
                object3 = (Map.Entry)object4[n4];
                IJavaElement iJavaElement = (IJavaElement)object3.getKey();
                iJavaElementArray = (IJavaElement)object3.getValue();
                outputStream.write(((Integer)hashtable.get(iJavaElement)).toString().getBytes());
                outputStream.write(62);
                outputStream.write(((Integer)hashtable.get(iJavaElementArray)).toString().getBytes());
                outputStream.write(10);
                ++n4;
            }
            outputStream.write(10);
            object4 = this.typeToSuperInterfaces.entrySet().toArray();
            n4 = 0;
            while (n4 < ((Object[])object4).length) {
                object3 = (Map.Entry)object4[n4];
                IJavaElement iJavaElement = (IJavaElement)object3.getKey();
                iJavaElementArray = (IJavaElement[])object3.getValue();
                if (iJavaElementArray.length > 0) {
                    outputStream.write(((Integer)hashtable.get(iJavaElement)).toString().getBytes());
                    outputStream.write(62);
                    int n6 = 0;
                    while (n6 < iJavaElementArray.length) {
                        object = iJavaElementArray[n6];
                        if (n6 != 0) {
                            outputStream.write(44);
                        }
                        outputStream.write(((Integer)hashtable.get(object)).toString().getBytes());
                        ++n6;
                    }
                    outputStream.write(10);
                }
                ++n4;
            }
            outputStream.write(10);
        }
        catch (IOException iOException) {
            throw new JavaModelException(iOException, 985);
        }
    }

    boolean subtypesIncludeSupertypeOf(IType iType) {
        String string;
        String string2 = null;
        try {
            string2 = iType.getSuperclassName();
        }
        catch (JavaModelException javaModelException) {
            if (DEBUG) {
                javaModelException.printStackTrace();
            }
            return false;
        }
        if (string2 == null) {
            string2 = "Object";
        }
        int n = -1;
        n = string2.lastIndexOf(46);
        String string3 = string = n > -1 ? string2.substring(n + 1) : string2;
        if (this.hasSubtypeNamed(string)) {
            return true;
        }
        String[] stringArray = null;
        try {
            stringArray = iType.getSuperInterfaceNames();
        }
        catch (JavaModelException javaModelException) {
            if (DEBUG) {
                javaModelException.printStackTrace();
            }
            return false;
        }
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            String string4;
            n = -1;
            String string5 = stringArray[n2];
            n = string5.lastIndexOf(46);
            String string6 = string4 = n > -1 ? string5.substring(n) : string5;
            if (this.hasSubtypeNamed(string4)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Focus: ");
        stringBuffer.append(this.focusType == null ? "<NONE>" : ((JavaElement)((Object)this.focusType)).toStringWithAncestors(false));
        stringBuffer.append("\n");
        if (this.exists()) {
            int n;
            IJavaElement[] iJavaElementArray;
            if (this.focusType != null) {
                stringBuffer.append("Super types:\n");
                this.toString(stringBuffer, this.focusType, 1, true);
                stringBuffer.append("Sub types:\n");
                this.toString(stringBuffer, this.focusType, 1, false);
            } else {
                stringBuffer.append("Sub types of root classes:\n");
                iJavaElementArray = Util.sortCopy(this.getRootClasses());
                n = 0;
                while (n < iJavaElementArray.length) {
                    this.toString(stringBuffer, (IType)iJavaElementArray[n], 1, false);
                    ++n;
                }
            }
            if (this.rootClasses.size > 1) {
                stringBuffer.append("Root classes:\n");
                iJavaElementArray = Util.sortCopy(this.getRootClasses());
                n = 0;
                int n2 = iJavaElementArray.length;
                while (n < n2) {
                    this.toString(stringBuffer, (IType)iJavaElementArray[n], 1, false);
                    ++n;
                }
            } else if (this.rootClasses.size == 0) {
                stringBuffer.append("No root classes");
            }
        } else {
            stringBuffer.append("(Hierarchy became stale)");
        }
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer, IType iType, int n, boolean bl) {
        IJavaElement[] iJavaElementArray = bl ? this.getSupertypes(iType) : this.getSubtypes(iType);
        IJavaElement[] iJavaElementArray2 = Util.sortCopy(iJavaElementArray);
        int n2 = 0;
        while (n2 < iJavaElementArray2.length) {
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append("  ");
                ++n3;
            }
            JavaElement javaElement = (JavaElement)iJavaElementArray2[n2];
            stringBuffer.append(javaElement.toStringWithAncestors(false));
            stringBuffer.append('\n');
            this.toString(stringBuffer, (IType)iJavaElementArray[n2], n + 1, bl);
            ++n2;
        }
    }

    boolean hasSupertype(String string) {
        Iterator iterator = this.classToSuperclass.values().iterator();
        while (iterator.hasNext()) {
            IType iType = (IType)iterator.next();
            if (!iType.getElementName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void worked(int n) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(n);
            this.checkCanceled();
        }
    }
}

