/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.jdom.IDOMImport;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMNode;
import org.eclipse.wst.jsdt.internal.core.util.CharArrayBuffer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class DOMImport
extends DOMNode
implements IDOMImport {
    protected boolean fOnDemand;
    protected int fFlags = 0;

    DOMImport() {
        this.fName = "java.lang.*";
        this.setMask(2048, true);
    }

    DOMImport(char[] cArray, int[] nArray, String string, int[] nArray2, boolean bl, int n) {
        super(cArray, nArray, string, nArray2);
        this.fOnDemand = bl;
        this.fFlags = n;
        this.setMask(2048, true);
    }

    DOMImport(char[] cArray, int[] nArray, String string, boolean bl, int n) {
        this(cArray, nArray, string, new int[]{-1, -1}, bl, n);
        this.fOnDemand = bl;
        this.setMask(2048, false);
    }

    protected void appendFragmentedContents(CharArrayBuffer charArrayBuffer) {
        if (this.fNameRange[0] < 0) {
            charArrayBuffer.append("import ").append(this.fName).append(';').append(Util.getLineSeparator(charArrayBuffer.toString(), null));
        } else {
            charArrayBuffer.append(this.fDocument, this.fSourceRange[0], this.fNameRange[0] - this.fSourceRange[0]);
            charArrayBuffer.append(this.fName);
            charArrayBuffer.append(this.fDocument, this.fNameRange[1] + 1, this.fSourceRange[1] - this.fNameRange[1]);
        }
    }

    public String getContents() {
        if (this.fName == null) {
            return null;
        }
        return super.getContents();
    }

    protected DOMNode getDetailedNode() {
        return (DOMNode)((Object)this.getFactory().createImport(this.getContents()));
    }

    public IJavaElement getJavaElement(IJavaElement iJavaElement) throws IllegalArgumentException {
        if (iJavaElement.getElementType() == 5) {
            return ((ICompilationUnit)iJavaElement).getImport(this.getName());
        }
        throw new IllegalArgumentException(Messages.element_illegalParent);
    }

    public int getNodeType() {
        return 3;
    }

    public boolean isOnDemand() {
        return this.fOnDemand;
    }

    protected DOMNode newDOMNode() {
        return new DOMImport();
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        this.becomeDetailed();
        super.setName(string);
        this.fOnDemand = string.endsWith(".*");
    }

    public String toString() {
        return "IMPORT: " + this.getName();
    }

    public int getFlags() {
        return this.fFlags;
    }

    public void setFlags(int n) {
        this.fFlags = n;
    }
}

