/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import java.util.Enumeration;
import org.eclipse.wst.jsdt.core.jdom.DOMException;
import org.eclipse.wst.jsdt.core.jdom.DOMFactory;
import org.eclipse.wst.jsdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.wst.jsdt.core.jdom.IDOMFactory;
import org.eclipse.wst.jsdt.core.jdom.IDOMMethod;
import org.eclipse.wst.jsdt.core.jdom.IDOMNode;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMType;
import org.eclipse.wst.jsdt.internal.core.jdom.ILineStartFinder;
import org.eclipse.wst.jsdt.internal.core.jdom.SiblingEnumeration;
import org.eclipse.wst.jsdt.internal.core.util.CharArrayBuffer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public abstract class DOMNode
implements IDOMNode {
    protected DOMNode fFirstChild = null;
    protected DOMNode fLastChild = null;
    protected DOMNode fNextNode = null;
    protected DOMNode fParent = null;
    protected DOMNode fPreviousNode = null;
    protected boolean fIsFragmented = false;
    protected String fName = null;
    protected int[] fNameRange;
    protected char[] fDocument = null;
    protected int[] fSourceRange;
    protected int fStateMask = 0;
    protected int fInsertionPosition;
    protected static final int MASK_FIELD_HAS_INITIALIZER = 1;
    protected static final int MASK_FIELD_IS_VARIABLE_DECLARATOR = 2;
    protected static final int MASK_FIELD_TYPE_ALTERED = 4;
    protected static final int MASK_NAME_ALTERED = 8;
    protected static final int MASK_HAS_BODY = 16;
    protected static final int MASK_HAS_COMMENT = 32;
    protected static final int MASK_IS_CONSTRUCTOR = 64;
    protected static final int MASK_TYPE_IS_CLASS = 128;
    protected static final int MASK_TYPE_HAS_SUPERCLASS = 256;
    protected static final int MASK_TYPE_HAS_INTERFACES = 512;
    protected static final int MASK_RETURN_TYPE_ALTERED = 1024;
    protected static final int MASK_DETAILED_SOURCE_INDEXES = 2048;

    DOMNode() {
        this.fName = null;
        this.fDocument = null;
        this.fSourceRange = new int[]{-1, -1};
        this.fNameRange = new int[]{-1, -1};
        this.fragment();
    }

    DOMNode(char[] cArray, int[] nArray, String string, int[] nArray2) {
        this.fDocument = cArray;
        this.fSourceRange = nArray;
        this.fName = string;
        this.fNameRange = nArray2;
    }

    public void addChild(IDOMNode iDOMNode) throws IllegalArgumentException, DOMException {
        this.basicAddChild(iDOMNode);
        if (iDOMNode.getNodeType() == 6 && ((IDOMMethod)iDOMNode).isConstructor()) {
            ((DOMNode)iDOMNode).fragment();
        } else {
            this.fragment();
        }
    }

    protected void appendContents(CharArrayBuffer charArrayBuffer) {
        if (this.isFragmented()) {
            this.appendFragmentedContents(charArrayBuffer);
        } else {
            charArrayBuffer.append(this.fDocument, this.fSourceRange[0], this.fSourceRange[1] + 1 - this.fSourceRange[0]);
        }
    }

    protected void appendContentsOfChildren(CharArrayBuffer charArrayBuffer) {
        DOMNode dOMNode = this.fFirstChild;
        int n = 0;
        int n2 = 0;
        if (dOMNode != null) {
            n = dOMNode.getStartPosition();
            n2 = dOMNode.getEndPosition();
        }
        while (dOMNode != null) {
            DOMNode dOMNode2 = dOMNode.fNextNode;
            if (dOMNode2 != null) {
                if (dOMNode2.isContentMergableWith(dOMNode)) {
                    n2 = dOMNode2.getEndPosition();
                } else {
                    if (dOMNode.isFragmented()) {
                        dOMNode.appendContents(charArrayBuffer);
                    } else {
                        charArrayBuffer.append(dOMNode.getDocument(), n, n2 + 1 - n);
                    }
                    n = dOMNode2.getStartPosition();
                    n2 = dOMNode2.getEndPosition();
                }
            } else if (dOMNode.isFragmented()) {
                dOMNode.appendContents(charArrayBuffer);
            } else {
                charArrayBuffer.append(dOMNode.getDocument(), n, n2 + 1 - n);
            }
            dOMNode = dOMNode2;
        }
    }

    protected abstract void appendFragmentedContents(CharArrayBuffer var1);

    void basicAddChild(IDOMNode iDOMNode) throws IllegalArgumentException, DOMException {
        if (!this.canHaveChildren()) {
            throw new DOMException(Messages.dom_unableAddChild);
        }
        if (iDOMNode == null) {
            throw new IllegalArgumentException(Messages.dom_addNullChild);
        }
        if (!this.isAllowableChild(iDOMNode)) {
            throw new DOMException(Messages.dom_addIncompatibleChild);
        }
        if (iDOMNode.getParent() != null) {
            throw new DOMException(Messages.dom_addChildWithParent);
        }
        if (iDOMNode == this.getRoot()) {
            throw new DOMException(Messages.dom_addAncestorAsChild);
        }
        DOMNode dOMNode = (DOMNode)iDOMNode;
        if (dOMNode.getDocument() != this.getDocument()) {
            dOMNode.localizeContents();
        }
        if (this.fFirstChild == null) {
            this.fFirstChild = dOMNode;
        } else {
            this.fLastChild.fNextNode = dOMNode;
            dOMNode.fPreviousNode = this.fLastChild;
        }
        this.fLastChild = dOMNode;
        dOMNode.fParent = this;
    }

    protected void becomeDetailed() throws DOMException {
        if (!this.isDetailed()) {
            DOMNode dOMNode = this.getDetailedNode();
            if (dOMNode == null) {
                throw new DOMException(Messages.dom_cannotDetail);
            }
            if (dOMNode != this) {
                this.shareContents(dOMNode);
            }
        }
    }

    public boolean canHaveChildren() {
        return false;
    }

    public Object clone() {
        int n = 0;
        char[] cArray = null;
        int n2 = this.fSourceRange[0];
        if (n2 >= 0) {
            n = this.fSourceRange[1] - n2 + 1;
            cArray = new char[n];
            System.arraycopy(this.fDocument, n2, cArray, 0, n);
        }
        DOMNode dOMNode = this.newDOMNode();
        dOMNode.shareContents(this);
        dOMNode.fDocument = cArray;
        if (n2 > 0) {
            dOMNode.offset(0 - n2);
        }
        if (this.canHaveChildren()) {
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                DOMNode dOMNode2;
                DOMNode dOMNode3 = (DOMNode)enumeration.nextElement();
                if (dOMNode3.fDocument == this.fDocument) {
                    dOMNode2 = dOMNode3.cloneSharingDocument(cArray, n2);
                    dOMNode.basicAddChild(dOMNode2);
                    continue;
                }
                dOMNode2 = (DOMNode)dOMNode3.clone();
                dOMNode.addChild(dOMNode2);
            }
        }
        return dOMNode;
    }

    private DOMNode cloneSharingDocument(char[] cArray, int n) {
        DOMNode dOMNode = this.newDOMNode();
        dOMNode.shareContents(this);
        dOMNode.fDocument = cArray;
        if (n > 0) {
            dOMNode.offset(0 - n);
        }
        if (this.canHaveChildren()) {
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                DOMNode dOMNode2;
                DOMNode dOMNode3 = (DOMNode)enumeration.nextElement();
                if (dOMNode3.fDocument == this.fDocument) {
                    dOMNode2 = dOMNode3.cloneSharingDocument(cArray, n);
                    dOMNode.basicAddChild(dOMNode2);
                    continue;
                }
                dOMNode2 = (DOMNode)dOMNode3.clone();
                dOMNode.addChild(dOMNode2);
            }
        }
        return dOMNode;
    }

    protected void fragment() {
        if (!this.isFragmented()) {
            this.fIsFragmented = true;
            if (this.fParent != null) {
                this.fParent.fragment();
            }
        }
    }

    public char[] getCharacters() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer();
        this.appendContents(charArrayBuffer);
        return charArrayBuffer.getContents();
    }

    public IDOMNode getChild(String string) {
        DOMNode dOMNode = this.fFirstChild;
        while (dOMNode != null) {
            String string2 = dOMNode.getName();
            if (string == null ? string2 == null : string.equals(string2)) {
                return dOMNode;
            }
            dOMNode = dOMNode.fNextNode;
        }
        return null;
    }

    public Enumeration getChildren() {
        return new SiblingEnumeration(this.fFirstChild);
    }

    public String getContents() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer();
        this.appendContents(charArrayBuffer);
        return charArrayBuffer.toString();
    }

    protected DOMNode getDetailedNode() {
        return this;
    }

    protected char[] getDocument() {
        return this.fDocument;
    }

    public int getEndPosition() {
        return this.fSourceRange[1];
    }

    protected IDOMFactory getFactory() {
        return new DOMFactory();
    }

    public IDOMNode getFirstChild() {
        return this.fFirstChild;
    }

    public int getInsertionPosition() {
        return this.fInsertionPosition;
    }

    protected boolean getMask(int n) {
        return (this.fStateMask & n) > 0;
    }

    public String getName() {
        return this.fName;
    }

    protected char[] getNameContents() {
        if (this.isNameAltered()) {
            return this.fName.toCharArray();
        }
        if (this.fName == null || this.fNameRange[0] < 0) {
            return null;
        }
        int n = this.fNameRange[1] + 1 - this.fNameRange[0];
        char[] cArray = new char[n];
        System.arraycopy(this.fDocument, this.fNameRange[0], cArray, 0, n);
        return cArray;
    }

    public IDOMNode getNextNode() {
        return this.fNextNode;
    }

    public IDOMNode getParent() {
        return this.fParent;
    }

    protected int getParentEndDeclaration() {
        IDOMNode iDOMNode = this.getParent();
        if (iDOMNode == null) {
            return 0;
        }
        if (iDOMNode instanceof IDOMCompilationUnit) {
            return 0;
        }
        return ((DOMType)iDOMNode).getOpenBodyEnd();
    }

    public IDOMNode getPreviousNode() {
        return this.fPreviousNode;
    }

    protected IDOMNode getRoot() {
        if (this.fParent == null) {
            return this;
        }
        return this.fParent.getRoot();
    }

    public int getStartPosition() {
        return this.fSourceRange[0];
    }

    public void insertSibling(IDOMNode iDOMNode) throws IllegalArgumentException, DOMException {
        if (iDOMNode == null) {
            throw new IllegalArgumentException(Messages.dom_addNullSibling);
        }
        if (this.fParent == null) {
            throw new DOMException(Messages.dom_addSiblingBeforeRoot);
        }
        if (!this.fParent.isAllowableChild(iDOMNode)) {
            throw new DOMException(Messages.dom_addIncompatibleSibling);
        }
        if (iDOMNode.getParent() != null) {
            throw new DOMException(Messages.dom_addSiblingWithParent);
        }
        if (iDOMNode == this.getRoot()) {
            throw new DOMException(Messages.dom_addAncestorAsSibling);
        }
        DOMNode dOMNode = (DOMNode)iDOMNode;
        if (dOMNode.getDocument() != this.getDocument()) {
            dOMNode.localizeContents();
        }
        if (this.fPreviousNode == null) {
            this.fParent.fFirstChild = dOMNode;
        } else {
            this.fPreviousNode.fNextNode = dOMNode;
        }
        dOMNode.fParent = this.fParent;
        dOMNode.fPreviousNode = this.fPreviousNode;
        dOMNode.fNextNode = this;
        this.fPreviousNode = dOMNode;
        if (dOMNode.getNodeType() == 6 && ((IDOMMethod)((Object)dOMNode)).isConstructor()) {
            dOMNode.fragment();
        } else {
            this.fParent.fragment();
        }
    }

    public boolean isAllowableChild(IDOMNode iDOMNode) {
        return false;
    }

    protected boolean isContentMergableWith(DOMNode dOMNode) {
        return !dOMNode.isFragmented() && !this.isFragmented() && dOMNode.getDocument() == this.getDocument() && dOMNode.getEndPosition() + 1 == this.getStartPosition();
    }

    protected boolean isDetailed() {
        return this.getMask(2048);
    }

    protected boolean isFragmented() {
        return this.fIsFragmented;
    }

    protected boolean isNameAltered() {
        return this.getMask(8);
    }

    public boolean isSignatureEqual(IDOMNode iDOMNode) {
        return this.getNodeType() == iDOMNode.getNodeType() && this.getName().equals(iDOMNode.getName());
    }

    protected void localizeContents() {
        DOMNode dOMNode = (DOMNode)this.clone();
        this.shareContents(dOMNode);
    }

    protected abstract DOMNode newDOMNode();

    void normalize(ILineStartFinder iLineStartFinder) {
        if (this.getPreviousNode() == null) {
            this.normalizeStartPosition(this.getParentEndDeclaration(), iLineStartFinder);
        }
        if (this.canHaveChildren()) {
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                ((DOMNode)enumeration.nextElement()).normalize(iLineStartFinder);
            }
        }
        this.normalizeEndPosition(iLineStartFinder, (DOMNode)this.getNextNode());
    }

    void normalizeEndPosition(ILineStartFinder iLineStartFinder, DOMNode dOMNode) {
        if (dOMNode == null) {
            DOMNode dOMNode2 = (DOMNode)this.getParent();
            if (dOMNode2 == null || dOMNode2 instanceof DOMCompilationUnit) {
                this.setSourceRangeEnd(this.fDocument.length - 1);
            } else {
                int n = ((DOMType)dOMNode2).getCloseBodyPosition() - 1;
                this.setSourceRangeEnd(n);
                this.fInsertionPosition = Math.max(iLineStartFinder.getLineStart(n + 1), this.getEndPosition());
            }
        } else {
            int n = dOMNode.getStartPosition() - 1;
            this.fInsertionPosition = Math.max(iLineStartFinder.getLineStart(n + 1), this.getEndPosition());
            dOMNode.normalizeStartPosition(this.getEndPosition(), iLineStartFinder);
            this.setSourceRangeEnd(dOMNode.getStartPosition() - 1);
        }
    }

    void normalizeStartPosition(int n, ILineStartFinder iLineStartFinder) {
        int n2;
        int n3 = this.getStartPosition();
        if (n3 > (n2 = iLineStartFinder.getLineStart(n3)) && (n2 > n || n == 0 && n2 == 0)) {
            this.setStartPosition(n2);
        }
    }

    protected void offset(int n) {
        this.offsetRange(this.fNameRange, n);
        this.offsetRange(this.fSourceRange, n);
    }

    protected void offsetRange(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2;
            nArray[n3] = nArray[n3] + n;
            if (nArray[n2] < 0) {
                nArray[n2] = -1;
            }
            ++n2;
        }
    }

    protected int[] rangeCopy(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n];
            ++n;
        }
        return nArray2;
    }

    public void remove() {
        if (this.fParent != null) {
            this.fParent.fragment();
        }
        if (this.fNextNode != null) {
            this.fNextNode.fPreviousNode = this.fPreviousNode;
        }
        if (this.fPreviousNode != null) {
            this.fPreviousNode.fNextNode = this.fNextNode;
        }
        if (this.fParent != null) {
            if (this.fParent.fFirstChild == this) {
                this.fParent.fFirstChild = this.fNextNode;
            }
            if (this.fParent.fLastChild == this) {
                this.fParent.fLastChild = this.fPreviousNode;
            }
        }
        this.fParent = null;
        this.fNextNode = null;
        this.fPreviousNode = null;
    }

    protected void setMask(int n, boolean bl) {
        this.fStateMask = bl ? (this.fStateMask |= n) : (this.fStateMask &= ~n);
    }

    public void setName(String string) {
        this.fName = string;
        this.setNameAltered(true);
        this.fragment();
    }

    protected void setNameAltered(boolean bl) {
        this.setMask(8, bl);
    }

    protected void setSourceRangeEnd(int n) {
        this.fSourceRange[1] = n;
    }

    protected void setStartPosition(int n) {
        this.fSourceRange[0] = n;
    }

    protected void shareContents(DOMNode dOMNode) {
        this.fDocument = dOMNode.fDocument;
        this.fIsFragmented = dOMNode.fIsFragmented;
        this.fName = dOMNode.fName;
        this.fNameRange = this.rangeCopy(dOMNode.fNameRange);
        this.fSourceRange = this.rangeCopy(dOMNode.fSourceRange);
        this.fStateMask = dOMNode.fStateMask;
        if (this.canHaveChildren()) {
            Enumeration enumeration = this.getChildren();
            Enumeration enumeration2 = dOMNode.getChildren();
            while (enumeration.hasMoreElements()) {
                DOMNode dOMNode2 = (DOMNode)enumeration.nextElement();
                DOMNode dOMNode3 = (DOMNode)enumeration2.nextElement();
                dOMNode2.shareContents(dOMNode3);
            }
        }
    }

    public abstract String toString();
}

