/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import java.util.Map;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.core.jdom.AbstractDOMBuilder;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMField;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMImport;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMInitializer;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMMember;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMMethod;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMPackage;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMType;

public class SimpleDOMBuilder
extends AbstractDOMBuilder
implements ISourceElementRequestor {
    public void acceptProblem(CategorizedProblem categorizedProblem) {
    }

    public void acceptImport(int n, int n2, char[][] cArray, boolean bl, int n3) {
        int[] nArray = new int[]{n, n2};
        String string = new String(CharOperation.concatWith(cArray, '.'));
        if (bl) {
            string = String.valueOf(string) + ".*";
        }
        this.fNode = new DOMImport(this.fDocument, nArray, string, bl, n3);
        this.addChild(this.fNode);
    }

    public void acceptPackage(int n, int n2, char[] cArray) {
        int[] nArray = new int[]{n, n2};
        this.fNode = new DOMPackage(this.fDocument, nArray, CharOperation.charToString(cArray));
        this.addChild(this.fNode);
    }

    public IDOMCompilationUnit createCompilationUnit(String string, String string2) {
        return this.createCompilationUnit(string.toCharArray(), string2.toCharArray());
    }

    public IDOMCompilationUnit createCompilationUnit(ICompilationUnit iCompilationUnit) {
        this.initializeBuild(iCompilationUnit.getContents(), true, true);
        this.getParser(JavaCore.getOptions()).parseCompilationUnit(iCompilationUnit, false);
        return super.createCompilationUnit(iCompilationUnit);
    }

    protected void enterAbstractMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        int[] nArray = new int[]{methodInfo.declarationStart, -1};
        int[] nArray2 = new int[]{methodInfo.nameSourceStart, methodInfo.nameSourceEnd};
        this.fNode = new DOMMethod(this.fDocument, nArray, CharOperation.charToString(methodInfo.name), nArray2, methodInfo.modifiers, methodInfo.isConstructor, CharOperation.charToString(methodInfo.returnType), CharOperation.charArrayToStringArray(methodInfo.parameterTypes), CharOperation.charArrayToStringArray(methodInfo.parameterNames), CharOperation.charArrayToStringArray(methodInfo.exceptionTypes));
        this.addChild(this.fNode);
        this.fStack.push(this.fNode);
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        String string = new String(this.fDocument, methodInfo.nameSourceStart, methodInfo.nameSourceEnd - methodInfo.nameSourceStart);
        int n = string.indexOf(40);
        if (n > -1) {
            methodInfo.nameSourceEnd = methodInfo.nameSourceStart + n - 1;
        }
        this.enterAbstractMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        int[] nArray = new int[]{fieldInfo.declarationStart, -1};
        int[] nArray2 = new int[]{fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd};
        boolean bl = false;
        if (this.fNode instanceof DOMField) {
            bl = fieldInfo.declarationStart == this.fNode.fSourceRange[0];
        }
        this.fNode = new DOMField(this.fDocument, nArray, CharOperation.charToString(fieldInfo.name), nArray2, fieldInfo.modifiers, CharOperation.charToString(fieldInfo.type), bl);
        this.addChild(this.fNode);
        this.fStack.push(this.fNode);
    }

    public void enterInitializer(int n, int n2) {
        int[] nArray = new int[]{n, -1};
        this.fNode = new DOMInitializer(this.fDocument, nArray, n2);
        this.addChild(this.fNode);
        this.fStack.push(this.fNode);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbstractMethod(methodInfo);
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        if (this.fBuildingType) {
            int[] nArray = new int[]{typeInfo.declarationStart, -1};
            int[] nArray2 = new int[]{typeInfo.nameSourceStart, typeInfo.nameSourceEnd};
            this.fNode = new DOMType(this.fDocument, nArray, new String(typeInfo.name), nArray2, typeInfo.modifiers, CharOperation.charArrayToStringArray(typeInfo.superinterfaces), TypeDeclaration.kind(typeInfo.modifiers) == 1);
            this.addChild(this.fNode);
            this.fStack.push(this.fNode);
        }
    }

    public void exitConstructor(int n) {
        this.exitMember(n);
    }

    public void exitField(int n, int n2, int n3) {
        this.exitMember(n2);
    }

    public void exitInitializer(int n) {
        this.exitMember(n);
    }

    protected void exitMember(int n) {
        DOMMember dOMMember = (DOMMember)this.fStack.pop();
        dOMMember.setSourceRangeEnd(n);
        this.fNode = dOMMember;
    }

    public void exitMethod(int n, int n2, int n3) {
        this.exitMember(n);
    }

    public void exitType(int n) {
        this.exitType(n, n);
    }

    protected SourceElementParser getParser(Map map) {
        return new SourceElementParser(this, new DefaultProblemFactory(), new CompilerOptions(map), false, true);
    }
}

