/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.search.AbstractSearchScope;

public class HierarchyScope
extends AbstractSearchScope
implements SuffixConstants {
    public IType focusType;
    private String focusPath;
    private WorkingCopyOwner owner;
    private ITypeHierarchy hierarchy;
    private IType[] types;
    private HashSet resourcePaths;
    private IPath[] enclosingProjectsAndJars;
    protected IResource[] elements;
    protected int elementCount;
    public boolean needsRefresh;

    public void add(IResource iResource) {
        if (this.elementCount == this.elements.length) {
            this.elements = new IResource[this.elementCount * 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.elementCount);
        }
        this.elements[this.elementCount++] = iResource;
    }

    public HierarchyScope(IType iType, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        this.focusType = iType;
        this.owner = workingCopyOwner;
        this.enclosingProjectsAndJars = this.computeProjectsAndJars(iType);
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iType.getPackageFragment().getParent();
        if (iPackageFragmentRoot.isArchive()) {
            String string;
            IPath iPath = iPackageFragmentRoot.getPath();
            Object object = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), iPath, true);
            if (object instanceof IFile) {
                string = iPath.toString();
            } else if (object instanceof File) {
                string = ((File)object).getPath();
            } else {
                return;
            }
            this.focusPath = String.valueOf(string) + "|" + iType.getFullyQualifiedName().replace('.', '/') + ".js";
        } else {
            this.focusPath = iType.getPath().toString();
        }
        this.needsRefresh = true;
    }

    private void buildResourceVector() {
        Object object;
        HashMap<IResource, IResource> hashMap = new HashMap<IResource, IResource>();
        HashMap<IPath, Object> hashMap2 = new HashMap<IPath, Object>();
        this.types = this.hierarchy.getAllTypes();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < this.types.length) {
            block8: {
                block5: {
                    String string;
                    IPath iPath;
                    block7: {
                        Object object2;
                        block6: {
                            IPackageFragmentRoot iPackageFragmentRoot;
                            object = this.types[n];
                            IResource iResource = object.getResource();
                            if (iResource != null && hashMap.get(iResource) == null) {
                                hashMap.put(iResource, iResource);
                                this.add(iResource);
                            }
                            if (!((iPackageFragmentRoot = (IPackageFragmentRoot)object.getPackageFragment().getParent()) instanceof JarPackageFragmentRoot)) break block5;
                            JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)iPackageFragmentRoot;
                            iPath = jarPackageFragmentRoot.getPath();
                            object2 = JavaModel.getTarget((IContainer)iWorkspaceRoot, iPath, true);
                            if (!(object2 instanceof IFile)) break block6;
                            string = iPath.toString();
                            break block7;
                        }
                        if (!(object2 instanceof File)) break block8;
                        string = ((File)object2).getPath();
                    }
                    String string2 = String.valueOf(string) + "|" + object.getFullyQualifiedName().replace('.', '/') + ".js";
                    this.resourcePaths.add(string2);
                    hashMap2.put(iPath, object);
                    break block8;
                }
                hashMap2.put(object.getJavaProject().getProject().getFullPath(), object);
            }
            ++n;
        }
        this.enclosingProjectsAndJars = new IPath[hashMap2.size()];
        n = 0;
        object = hashMap2.keySet().iterator();
        while (object.hasNext()) {
            this.enclosingProjectsAndJars[n++] = (IPath)object.next();
        }
    }

    private IPath[] computeProjectsAndJars(IType iType) throws JavaModelException {
        IPath[] iPathArray;
        HashSet<IPath> hashSet = new HashSet<IPath>();
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iType.getPackageFragment().getParent();
        if (iPackageFragmentRoot.isArchive()) {
            hashSet.add(iPackageFragmentRoot.getPath());
            iPathArray = iPackageFragmentRoot.getPath();
            JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject[] iJavaProjectArray = javaModel.getJavaProjects();
            HashSet hashSet2 = new HashSet();
            int n = 0;
            while (n < iJavaProjectArray.length) {
                JavaProject javaProject = (JavaProject)iJavaProjectArray[n];
                IClasspathEntry iClasspathEntry = javaProject.getClasspathEntryFor((IPath)iPathArray);
                if (iClasspathEntry != null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
                    hashSet.add(javaProject.getPath());
                    int n2 = 0;
                    while (n2 < iPackageFragmentRootArray.length) {
                        IPackageFragmentRoot iPackageFragmentRoot2 = iPackageFragmentRootArray[n2];
                        if (iPackageFragmentRoot2.getKind() == 2) {
                            hashSet.add(iPackageFragmentRoot2.getPath());
                        }
                        ++n2;
                    }
                    this.computeDependents(javaProject, hashSet, hashSet2);
                }
                ++n;
            }
        } else {
            iPathArray = (IPath[])iPackageFragmentRoot.getParent();
            IPackageFragmentRoot[] iPackageFragmentRootArray = iPathArray.getAllPackageFragmentRoots();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                IPackageFragmentRoot iPackageFragmentRoot3 = iPackageFragmentRootArray[n];
                if (iPackageFragmentRoot3.getKind() == 2) {
                    hashSet.add(iPackageFragmentRoot3.getPath());
                } else {
                    hashSet.add(iPackageFragmentRoot3.getParent().getPath());
                }
                ++n;
            }
            this.computeDependents((IJavaProject)iPathArray, hashSet, new HashSet());
        }
        iPathArray = new IPath[hashSet.size()];
        hashSet.toArray(iPathArray);
        return iPathArray;
    }

    private void computeDependents(IJavaProject iJavaProject, HashSet hashSet, HashSet hashSet2) {
        if (hashSet2.contains(iJavaProject)) {
            return;
        }
        hashSet2.add(iJavaProject);
        IProject[] iProjectArray = iJavaProject.getProject().getReferencingProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            try {
                IJavaProject iJavaProject2 = JavaCore.create(iProjectArray[n]);
                IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject2.getPackageFragmentRoots();
                hashSet.add(iJavaProject2.getPath());
                int n2 = 0;
                while (n2 < iPackageFragmentRootArray.length) {
                    IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (iPackageFragmentRoot.isArchive()) {
                        hashSet.add(iPackageFragmentRoot.getPath());
                    }
                    ++n2;
                }
                this.computeDependents(iJavaProject2, hashSet, hashSet2);
            }
            catch (JavaModelException javaModelException) {}
            ++n;
        }
    }

    public boolean encloses(String string) {
        int n;
        if (this.hierarchy == null) {
            if (string.equals(this.focusPath)) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        if ((n = string.indexOf("|")) != -1) {
            return this.resourcePaths.contains(string);
        }
        int n2 = 0;
        while (n2 < this.elementCount) {
            if (string.startsWith(this.elements[n2].getFullPath().toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean encloses(IJavaElement iJavaElement) {
        if (this.hierarchy == null) {
            if (this.focusType.equals(iJavaElement.getAncestor(7))) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        IType iType = null;
        if (iJavaElement instanceof IType) {
            iType = (IType)iJavaElement;
        } else if (iJavaElement instanceof IMember) {
            iType = ((IMember)iJavaElement).getDeclaringType();
        }
        if (iType != null) {
            IType iType2;
            if (this.hierarchy.contains(iType)) {
                return true;
            }
            if (!iType.isBinary() && (iType2 = (IType)iType.getPrimaryElement()) != null) {
                return this.hierarchy.contains(iType2);
            }
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars;
    }

    protected void initialize() throws JavaModelException {
        this.resourcePaths = new HashSet();
        this.elements = new IResource[5];
        this.elementCount = 0;
        this.needsRefresh = false;
        if (this.hierarchy == null) {
            this.hierarchy = this.focusType.newTypeHierarchy(this.owner, null);
        } else {
            this.hierarchy.refresh(null);
        }
        this.buildResourceVector();
    }

    public void processDelta(IJavaElementDelta iJavaElementDelta) {
        if (this.needsRefresh) {
            return;
        }
        this.needsRefresh = this.hierarchy == null ? false : ((TypeHierarchy)this.hierarchy).isAffected(iJavaElementDelta);
    }

    protected void refresh() throws JavaModelException {
        if (this.hierarchy != null) {
            this.initialize();
        }
    }

    public String toString() {
        return "HierarchyScope on " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors();
    }
}

