/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class AddJarFileToIndex
extends IndexRequest {
    IFile resource;

    public AddJarFileToIndex(IFile iFile, IndexManager indexManager) {
        super(iFile.getFullPath().removeLastSegments(1), indexManager);
        this.resource = iFile;
    }

    public AddJarFileToIndex(IPath iPath, IndexManager indexManager) {
        super(iPath.removeLastSegments(1), indexManager);
    }

    public boolean equals(Object object) {
        if (object instanceof AddJarFileToIndex) {
            if (this.resource != null) {
                return this.resource.equals((Object)((AddJarFileToIndex)object).resource);
            }
            if (this.containerPath != null) {
                return this.containerPath.equals((Object)((AddJarFileToIndex)object).containerPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode();
        }
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor var1_1) {
        if (this.isCancelled != false) return true;
        if (var1_1 != null && var1_1.isCanceled()) {
            return true;
        }
        try {
            block42: {
                block41: {
                    block38: {
                        block39: {
                            var2_2 = this.manager.getIndexForUpdate(this.containerPath, false, false);
                            if (var2_2 != null) {
                                if (JobManager.VERBOSE == false) return true;
                                Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                                return true;
                            }
                            var2_2 = this.manager.getIndexForUpdate(this.containerPath, true, true);
                            if (var2_2 == null) {
                                if (JobManager.VERBOSE == false) return true;
                                Util.verbose("-> index could not be created for " + this.containerPath);
                                return true;
                            }
                            var3_4 = var2_2.monitor;
                            if (var3_4 == null) {
                                if (JobManager.VERBOSE == false) return true;
                                Util.verbose("-> index for " + this.containerPath + " just got deleted");
                                return true;
                            }
                            var4_5 = null;
                            try {
                                block47: {
                                    block46: {
                                        block45: {
                                            block43: {
                                                block44: {
                                                    block40: {
                                                        var5_6 = null;
                                                        var3_4.enterWrite();
                                                        if (this.resource == null) break block43;
                                                        var6_7 = this.resource.getLocationURI();
                                                        if (var6_7 == null) {
lbl28:
                                                            // 6 sources

                                                            while (true) {
                                                                var17_9 = null;
                                                                if (var4_5 == null) break block38;
                                                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + var4_5);
                                                                }
                                                                break block39;
                                                                break;
                                                            }
                                                        }
                                                        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                            System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + var6_7.getPath());
                                                        }
                                                        var7_13 = null;
                                                        try {
                                                            var7_13 = Util.toLocalFile(var6_7, var1_1);
                                                        }
                                                        catch (CoreException var8_14) {
                                                            if (!JobManager.VERBOSE) break block40;
                                                            Util.verbose("-> failed to index " + var6_7.getPath() + " because of the following exception:");
                                                            var8_14.printStackTrace();
                                                        }
                                                    }
                                                    if (var7_13 != null) break block44;
                                                    if (JobManager.VERBOSE) {
                                                        Util.verbose("-> failed to index " + var6_7.getPath() + " because the file could not be fetched");
                                                    }
                                                    ** GOTO lbl28
                                                }
                                                var4_5 = new ZipFile(var7_13);
                                                var5_6 = (Path)this.resource.getFullPath().makeRelative();
                                                break block45;
                                            }
                                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                                            }
                                            var4_5 = new ZipFile(this.containerPath.toFile());
                                            var5_6 = (Path)this.containerPath;
                                        }
                                        if (!this.isCancelled) break block46;
                                        if (JobManager.VERBOSE) {
                                            Util.verbose("-> indexing of " + var4_5.getName() + " has been cancelled");
                                        }
                                        ** GOTO lbl28
                                    }
                                    if (JobManager.VERBOSE) {
                                        Util.verbose("-> indexing " + var4_5.getName());
                                    }
                                    var6_8 = System.currentTimeMillis();
                                    var8_15 = var2_2.queryDocumentNames("");
                                    if (var8_15 != null) {
                                        var9_16 = var8_15.length;
                                        var10_18 = "OK";
                                        var11_19 = "DELETED";
                                        var12_20 = new SimpleLookupTable(var9_16 == 0 ? 33 : var9_16 + 11);
                                        var13_21 = 0;
                                        while (true) {
                                            if (var13_21 >= var9_16) break;
                                            var12_20.put(var8_15[var13_21], var11_19);
                                            ++var13_21;
                                        }
                                        var13_22 = var4_5.entries();
                                        while (true) {
                                            if (!var13_22.hasMoreElements()) {
                                                v0 = var13_23 = var12_20.elementSize != var9_16;
                                            }
                                            var14_25 = var13_22.nextElement();
                                            var15_26 = var14_25.getName();
                                            if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(var15_26)) continue;
                                            var12_20.put(var15_26, var10_18);
                                        }
                                        if (!var13_23) {
                                            var14_25 = var12_20.valueTable;
                                            var15_27 = 0;
                                            var16_28 = var14_25.length;
                                            while (var15_27 < var16_28) {
                                                if (var14_25[var15_27] == var11_19) {
                                                    var13_23 = true;
                                                    break;
                                                }
                                                ++var15_27;
                                            }
                                            if (!var13_23) {
                                                if (JobManager.VERBOSE) {
                                                    Util.verbose("-> no indexing required (index is consistent with library) for " + var4_5.getName() + " (" + (System.currentTimeMillis() - var6_8) + "ms)");
                                                }
                                                this.manager.saveIndex(var2_2);
                                                break block41;
                                            }
                                        }
                                    }
                                    var9_17 = SearchEngine.getDefaultSearchParticipant();
                                    var2_2 = this.manager.recreateIndex(this.containerPath);
                                    if (var2_2 != null) break block47;
                                    this.manager.removeIndex(this.containerPath);
                                    ** GOTO lbl28
                                }
                                var10_18 = var4_5.entries();
                                while (true) {
                                    block48: {
                                        if (!var10_18.hasMoreElements()) {
                                            this.manager.saveIndex(var2_2);
                                            if (JobManager.VERBOSE) {
                                                Util.verbose("-> done indexing of " + var4_5.getName() + " (" + (System.currentTimeMillis() - var6_8) + "ms)");
                                            }
                                            break block42;
                                        }
                                        if (!this.isCancelled) break block48;
                                        if (!JobManager.VERBOSE) ** GOTO lbl28
                                        Util.verbose("-> indexing of " + var4_5.getName() + " has been cancelled");
                                        ** continue;
                                    }
                                    var11_19 = (ZipEntry)var10_18.nextElement();
                                    if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(var11_19.getName())) continue;
                                    var12_20 = org.eclipse.wst.jsdt.internal.compiler.util.Util.getZipEntryByteContent((ZipEntry)var11_19, var4_5);
                                    var13_24 = new JavaSearchDocument((ZipEntry)var11_19, (IPath)var5_6, (byte[])var12_20, var9_17);
                                    this.manager.indexDocument(var13_24, var9_17, var2_2, this.containerPath);
                                }
                            }
                            catch (Throwable var18_29) {
                                var17_11 = null;
                                if (var4_5 != null) {
                                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + var4_5);
                                    }
                                    var4_5.close();
                                }
                                var3_4.exitWrite();
                                throw var18_29;
                            }
                        }
                        var4_5.close();
                    }
                    var3_4.exitWrite();
                    return false;
                }
                var17_10 = null;
                if (var4_5 != null) {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + var4_5);
                    }
                    var4_5.close();
                }
                var3_4.exitWrite();
                return true;
            }
            var17_12 = null;
            if (var4_5 != null) {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + var4_5);
                }
                var4_5.close();
            }
            var3_4.exitWrite();
            return true;
        }
        catch (IOException var2_3) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                var2_3.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }
}

