/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.VariableLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.VariablePattern;

public class LocalVariableLocator
extends VariableLocator {
    public LocalVariableLocator(VariablePattern variablePattern) {
        super(variablePattern);
    }

    public int match(LocalDeclaration localDeclaration, MatchingNodeSet matchingNodeSet) {
        int n = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && localDeclaration.initialization != null && this.matchesName(this.pattern.name, localDeclaration.name)) {
            n = this.pattern.mustResolve ? 2 : 3;
        }
        int n2 = 0;
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, localDeclaration.name) && localDeclaration.declarationSourceStart == this.pattern.getVariableStart()) {
            n2 = this.pattern.mustResolve ? 2 : 3;
        }
        return matchingNodeSet.addMatch(localDeclaration, n >= n2 ? n : n2);
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        int n2 = -1;
        int n3 = -1;
        if (aSTNode instanceof SingleNameReference) {
            n2 = aSTNode.sourceStart;
            n3 = aSTNode.sourceEnd - n2 + 1;
        } else if (aSTNode instanceof QualifiedNameReference) {
            QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)aSTNode;
            long l = qualifiedNameReference.sourcePositions[0];
            n2 = (int)(l >>> 32);
            n3 = (int)l - n2 + 1;
        } else if (aSTNode instanceof LocalDeclaration) {
            iJavaElement = this.pattern.getJavaElement();
            if (iJavaElement instanceof LocalVariable) {
                LocalVariable localVariable = (LocalVariable)iJavaElement;
                n2 = localVariable.nameStart;
                n3 = localVariable.nameEnd - n2 + 1;
            } else {
                n2 = this.pattern.getVariableStart();
                n3 = this.pattern.getVariableLength();
            }
        }
        if (n2 >= 0) {
            this.match = matchLocator.newLocalVariableReferenceMatch(iJavaElement, n, n2, n3, aSTNode);
            matchLocator.report(this.match);
        }
    }

    protected int matchContainer() {
        return 4;
    }

    protected int matchLocalVariable(LocalVariableBinding localVariableBinding, boolean bl) {
        if (localVariableBinding == null) {
            return 1;
        }
        if (bl && !this.matchesName(this.pattern.name, localVariableBinding.readableName())) {
            return 0;
        }
        return localVariableBinding.declaration.declarationSourceStart == this.pattern.getVariableStart() ? 3 : 0;
    }

    protected int referenceType() {
        return 14;
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (this.pattern.findReferences && aSTNode instanceof NameReference) {
            return this.resolveLevel((NameReference)aSTNode);
        }
        if (aSTNode instanceof LocalDeclaration) {
            return this.matchLocalVariable(((LocalDeclaration)aSTNode).binding, true);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof LocalVariableBinding)) {
            return 0;
        }
        return this.matchLocalVariable((LocalVariableBinding)binding, true);
    }

    protected int resolveLevel(NameReference nameReference) {
        return this.resolveLevel(nameReference.binding);
    }
}

