/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern
implements IIndexConstants {
    public char[] qualification;
    PackageDeclarationPattern packagePattern;
    public int packageIndex = -1;

    public QualifiedTypeDeclarationPattern(char[] cArray, char[] cArray2, char c, int n) {
        this(n);
        this.qualification = this.isCaseSensitive() ? cArray : CharOperation.toLowerCase(cArray);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? cArray2 : CharOperation.toLowerCase(cArray2);
        this.typeSuffix = c;
        this.mustResolve = this.qualification != null || c != '\u0000';
    }

    public QualifiedTypeDeclarationPattern(char[] cArray, int n, char[] cArray2, char c, int n2) {
        this(cArray, cArray2, c, n2);
        this.packagePattern = new PackageDeclarationPattern(cArray, n);
    }

    QualifiedTypeDeclarationPattern(int n) {
        super(n);
    }

    public void decodeIndexKey(char[] cArray) {
        int n;
        int n2 = CharOperation.indexOf('/', cArray, 0);
        this.simpleName = CharOperation.subarray(cArray, 0, n2);
        if (cArray[n = ++n2] == '/') {
            this.pkg = CharOperation.NO_CHAR;
        } else {
            n2 = CharOperation.indexOf('/', cArray, n);
            this.pkg = internedPackageNames.add(CharOperation.subarray(cArray, n, n2));
        }
        this.qualification = this.pkg;
        int n3 = cArray.length - 1;
        boolean bl = this.secondary = cArray[n3] == 'S';
        if (this.secondary) {
            n3 -= 2;
        }
        this.modifiers = cArray[n3 - 1] + (cArray[n3] << 16);
        this.decodeModifiers();
        n = n2 + 1;
        if (n == (n3 -= 2)) {
            this.enclosingTypeNames = CharOperation.NO_CHAR_CHAR;
        } else {
            int n4 = this.qualification.length;
            int n5 = n3 - n;
            this.qualification = new char[n4 + 1 + n5];
            System.arraycopy(this.qualification, 0, this.qualification, 0, n4);
            this.qualification[n4] = 46;
            if (n3 == n + 1 && cArray[n] == '0') {
                this.enclosingTypeNames = ONE_ZERO_CHAR;
                this.qualification[n4 + 1] = 48;
            } else {
                this.enclosingTypeNames = CharOperation.splitOn('.', cArray, n, n3);
                System.arraycopy(cArray, n, this.qualification, n4 + 1, n5);
            }
        }
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8);
    }

    public boolean matchesDecodedKey(SearchPattern searchPattern) {
        QualifiedTypeDeclarationPattern qualifiedTypeDeclarationPattern = (QualifiedTypeDeclarationPattern)searchPattern;
        if (this.typeSuffix != qualifiedTypeDeclarationPattern.typeSuffix && this.typeSuffix != '\u0000' && !this.matchDifferentTypeSuffixes(this.typeSuffix, qualifiedTypeDeclarationPattern.typeSuffix)) {
            return false;
        }
        return this.matchesName(this.simpleName, qualifiedTypeDeclarationPattern.simpleName) && (this.qualification == null || this.packagePattern == null || this.packagePattern.matchesName(this.qualification, qualifiedTypeDeclarationPattern.qualification));
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        switch (this.typeSuffix) {
            case 'C': {
                stringBuffer.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case '\n': {
                stringBuffer.append("ClassAndInterfaceDeclarationPattern: qualification<");
                break;
            }
            case '\t': {
                stringBuffer.append("ClassAndEnumDeclarationPattern: qualification<");
                break;
            }
            case 'I': {
                stringBuffer.append("InterfaceDeclarationPattern: qualification<");
                break;
            }
            case '\u000b': {
                stringBuffer.append("InterfaceAndAnnotationDeclarationPattern: qualification<");
                break;
            }
            case 'E': {
                stringBuffer.append("EnumDeclarationPattern: qualification<");
                break;
            }
            case 'A': {
                stringBuffer.append("AnnotationTypeDeclarationPattern: qualification<");
                break;
            }
            default: {
                stringBuffer.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            stringBuffer.append(this.qualification);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append(">, type<");
        if (this.simpleName != null) {
            stringBuffer.append(this.simpleName);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append("> ");
        return super.print(stringBuffer);
    }
}

