/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.wst.jsdt.internal.core.search.PathCollector;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.util.ASTNodeFinder;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class SuperTypeNamesCollector {
    SearchPattern pattern;
    char[] typeSimpleName;
    char[] typeQualification;
    MatchLocator locator;
    IType type;
    IProgressMonitor progressMonitor;
    char[][][] result;
    int resultIndex;

    public SuperTypeNamesCollector(SearchPattern searchPattern, char[] cArray, char[] cArray2, MatchLocator matchLocator, IType iType, IProgressMonitor iProgressMonitor) {
        this.pattern = searchPattern;
        this.typeSimpleName = cArray;
        this.typeQualification = cArray2;
        this.locator = matchLocator;
        this.type = iType;
        this.progressMonitor = iProgressMonitor;
    }

    protected void addToResult(char[][] cArray) {
        int n = this.result.length;
        int n2 = 0;
        while (n2 < n) {
            if (CharOperation.equals(this.result[n2], cArray)) {
                return;
            }
            ++n2;
        }
        if (n == this.resultIndex) {
            char[][][] cArrayArray = new char[n * 2][][];
            this.result = cArrayArray;
            System.arraycopy(this.result, 0, cArrayArray, 0, n);
        }
        this.result[this.resultIndex++] = cArray;
    }

    protected CompilationUnitDeclaration buildBindings(ICompilationUnit iCompilationUnit, boolean bl) throws JavaModelException {
        CompilationUnitDeclaration compilationUnitDeclaration;
        org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit iCompilationUnit2 = (org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit)((Object)iCompilationUnit);
        CompilationResult compilationResult = new CompilationResult(iCompilationUnit2, 1, 1, 0);
        CompilationUnitDeclaration compilationUnitDeclaration2 = compilationUnitDeclaration = bl ? this.locator.basicParser().dietParse(iCompilationUnit2, compilationResult) : this.locator.basicParser().parse(iCompilationUnit2, compilationResult);
        if (compilationUnitDeclaration != null) {
            this.locator.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
            this.locator.lookupEnvironment.completeTypeBindings(compilationUnitDeclaration, !bl);
            if (!bl) {
                if (compilationUnitDeclaration.scope != null) {
                    compilationUnitDeclaration.scope.faultInTypes();
                }
                compilationUnitDeclaration.resolve();
            }
        }
        return compilationUnitDeclaration;
    }

    public char[][][] collect() throws JavaModelException {
        if (this.type != null) {
            this.result = new char[1][][];
            this.resultIndex = 0;
            JavaProject javaProject = (JavaProject)this.type.getJavaProject();
            this.locator.initialize(javaProject, 0);
            try {
                if (this.type.isBinary()) {
                    BinaryTypeBinding binaryTypeBinding = this.locator.cacheBinaryType(this.type, null);
                    if (binaryTypeBinding != null) {
                        this.collectSuperTypeNames(binaryTypeBinding);
                    }
                } else {
                    SourceType sourceType;
                    boolean bl;
                    ICompilationUnit iCompilationUnit = this.type.getCompilationUnit();
                    CompilationUnitDeclaration compilationUnitDeclaration = this.buildBindings(iCompilationUnit, bl = (sourceType = (SourceType)this.type).getOuterMostLocalContext() == null);
                    if (compilationUnitDeclaration != null) {
                        ASTNodeFinder aSTNodeFinder = new ASTNodeFinder(compilationUnitDeclaration);
                        InferredType inferredType = aSTNodeFinder.findInferredType(this.type);
                        if (inferredType != null) {
                            this.collectSuperTypeNames(inferredType.binding);
                        } else {
                            TypeDeclaration typeDeclaration = aSTNodeFinder.findType(this.type);
                            if (typeDeclaration != null && typeDeclaration.binding != null) {
                                this.collectSuperTypeNames(typeDeclaration.binding);
                            }
                        }
                    }
                }
            }
            catch (AbortCompilation abortCompilation) {
                return null;
            }
            if (this.result.length > this.resultIndex) {
                char[][][] cArrayArray = new char[this.resultIndex][][];
                this.result = cArrayArray;
                System.arraycopy(this.result, 0, cArrayArray, 0, this.resultIndex);
            }
            return this.result;
        }
        String[] stringArray = this.getPathsOfDeclaringType();
        if (stringArray == null) {
            return null;
        }
        Util.sort(stringArray);
        JavaProject javaProject = null;
        this.result = new char[1][][];
        this.resultIndex = 0;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            try {
                Openable openable = this.locator.handleFactory.createOpenable(stringArray[n], this.locator.scope);
                if (openable != null) {
                    Object object;
                    ITypeRoot iTypeRoot;
                    IJavaProject iJavaProject = openable.getJavaProject();
                    if (!iJavaProject.equals(javaProject)) {
                        javaProject = (JavaProject)iJavaProject;
                        this.locator.initialize(javaProject, 0);
                    }
                    if (openable instanceof ICompilationUnit) {
                        iTypeRoot = (ICompilationUnit)((Object)openable);
                        object = this.buildBindings((ICompilationUnit)iTypeRoot, true);
                        if (object != null) {
                            ((CompilationUnitDeclaration)object).traverse((ASTVisitor)new TypeDeclarationVisitor(), ((CompilationUnitDeclaration)object).scope);
                        }
                    } else if (openable instanceof IClassFile && this.matches((ReferenceBinding)(object = this.locator.cacheBinaryType((iTypeRoot = (IClassFile)((Object)openable)).getType(), null)))) {
                        this.collectSuperTypeNames((ReferenceBinding)object);
                    }
                }
            }
            catch (AbortCompilation abortCompilation) {
            }
            catch (JavaModelException javaModelException) {}
            ++n;
        }
        if (this.result.length > this.resultIndex) {
            char[][][] cArrayArray = new char[this.resultIndex][][];
            this.result = cArrayArray;
            System.arraycopy(this.result, 0, cArrayArray, 0, this.resultIndex);
        }
        return this.result;
    }

    protected void collectSuperTypeNames(ReferenceBinding referenceBinding) {
        ReferenceBinding[] referenceBindingArray;
        ReferenceBinding referenceBinding2 = referenceBinding.superclass();
        if (referenceBinding2 != null) {
            this.addToResult(referenceBinding2.compoundName);
            this.collectSuperTypeNames(referenceBinding2);
        }
        if ((referenceBindingArray = referenceBinding.superInterfaces()) != null) {
            int n = 0;
            while (n < referenceBindingArray.length) {
                ReferenceBinding referenceBinding3 = referenceBindingArray[n];
                this.addToResult(referenceBinding3.compoundName);
                this.collectSuperTypeNames(referenceBinding3);
                ++n;
            }
        }
    }

    protected String[] getPathsOfDeclaringType() {
        if (this.typeQualification == null && this.typeSimpleName == null) {
            return null;
        }
        final PathCollector pathCollector = new PathCollector();
        IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        TypeDeclarationPattern typeDeclarationPattern = new TypeDeclarationPattern(this.typeSimpleName != null ? null : this.typeQualification, null, this.typeSimpleName, '\u0000', this.pattern.getMatchRule());
        IndexQueryRequestor indexQueryRequestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String string, SearchPattern searchPattern, SearchParticipant searchParticipant, AccessRuleSet accessRuleSet) {
                TypeDeclarationPattern typeDeclarationPattern = (TypeDeclarationPattern)searchPattern;
                if (typeDeclarationPattern.enclosingTypeNames != IIndexConstants.ONE_ZERO_CHAR) {
                    pathCollector.acceptIndexMatch(string, searchPattern, searchParticipant, accessRuleSet);
                }
                return true;
            }
        };
        indexManager.performConcurrentJob(new PatternSearchJob(typeDeclarationPattern, new JavaSearchParticipant(), iJavaSearchScope, indexQueryRequestor), 3, (IProgressMonitor)(this.progressMonitor == null ? null : new SubProgressMonitor(this.progressMonitor, 100)));
        return pathCollector.getPaths();
    }

    protected boolean matches(char[][] object) {
        int n = ((char[][])object).length;
        if (n == 0) {
            return false;
        }
        char[] cArray = object[n - 1];
        int n2 = n - 1;
        if (this.typeSimpleName == null || this.pattern.matchesName(cArray, this.typeSimpleName)) {
            char[][] cArrayArray = new char[n2][];
            System.arraycopy(object, 0, cArrayArray, 0, n2);
            return this.pattern.matchesName(this.typeQualification, CharOperation.concatWith(cArrayArray, '.'));
        }
        if (!CharOperation.endsWith(cArray, this.typeSimpleName)) {
            return false;
        }
        char[][] cArray2 = object;
        char[][] cArrayArray = new char[n + 1][];
        object = cArrayArray;
        System.arraycopy(cArray2, 0, cArrayArray, 0, n2);
        int n3 = CharOperation.indexOf('$', cArray);
        if (n3 == -1) {
            return false;
        }
        object[n2] = CharOperation.subarray(cArray, 0, n3);
        object[n] = CharOperation.subarray(cArray, n3 + 1, cArray.length);
        return this.matches((char[][])object);
    }

    protected boolean matches(ReferenceBinding referenceBinding) {
        return referenceBinding != null && referenceBinding.compoundName != null && this.matches(referenceBinding.compoundName);
    }

    public class TypeDeclarationVisitor
    extends ASTVisitor {
        public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
            SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(sourceTypeBinding)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(sourceTypeBinding);
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope compilationUnitScope) {
            SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(sourceTypeBinding)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(sourceTypeBinding);
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
            SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(sourceTypeBinding)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(sourceTypeBinding);
            }
            return true;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope methodScope) {
            return false;
        }

        public boolean visit(Initializer initializer, MethodScope methodScope) {
            return false;
        }

        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope classScope) {
            return false;
        }

        public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
            return false;
        }
    }
}

