/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;

public class DOMFinder
extends ASTVisitor {
    public ASTNode foundNode = null;
    public IBinding foundBinding = null;
    private CompilationUnit ast;
    private SourceRefElement element;
    private boolean resolveBinding;
    private int rangeStart = -1;
    private int rangeLength = 0;

    public DOMFinder(CompilationUnit compilationUnit, SourceRefElement sourceRefElement, boolean bl) {
        this.ast = compilationUnit;
        this.element = sourceRefElement;
        this.resolveBinding = bl;
    }

    protected boolean found(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode2.getStartPosition() == this.rangeStart && aSTNode2.getLength() == this.rangeLength) {
            this.foundNode = aSTNode;
            return true;
        }
        return false;
    }

    public ASTNode search() throws JavaModelException {
        ISourceRange iSourceRange = null;
        iSourceRange = this.element instanceof IMember && !(this.element instanceof IInitializer) ? ((IMember)((Object)this.element)).getNameRange() : this.element.getSourceRange();
        this.rangeStart = iSourceRange.getOffset();
        this.rangeLength = iSourceRange.getLength();
        this.ast.accept(this);
        return this.foundNode;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        if (this.found(annotationTypeDeclaration, annotationTypeDeclaration.getName()) && this.resolveBinding) {
            this.foundBinding = annotationTypeDeclaration.resolveBinding();
        }
        return true;
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        if (this.found(annotationTypeMemberDeclaration, annotationTypeMemberDeclaration.getName()) && this.resolveBinding) {
            this.foundBinding = annotationTypeMemberDeclaration.resolveBinding();
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = anonymousClassDeclaration.getParent();
        switch (aSTNode2.getNodeType()) {
            case 14: {
                aSTNode = ((ClassInstanceCreation)aSTNode2).getType();
                break;
            }
            case 72: {
                aSTNode = ((EnumConstantDeclaration)aSTNode2).getName();
                break;
            }
            default: {
                return true;
            }
        }
        if (this.found(anonymousClassDeclaration, aSTNode) && this.resolveBinding) {
            this.foundBinding = anonymousClassDeclaration.resolveBinding();
        }
        return true;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        if (this.found(enumConstantDeclaration, enumConstantDeclaration.getName()) && this.resolveBinding) {
            this.foundBinding = enumConstantDeclaration.resolveVariable();
        }
        return true;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        if (this.found(enumDeclaration, enumDeclaration.getName()) && this.resolveBinding) {
            this.foundBinding = enumDeclaration.resolveBinding();
        }
        return true;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        if (this.found(importDeclaration, importDeclaration) && this.resolveBinding) {
            this.foundBinding = importDeclaration.resolveBinding();
        }
        return true;
    }

    public boolean visit(Initializer initializer) {
        this.found(initializer, initializer);
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        if (this.found(methodDeclaration, methodDeclaration.getName()) && this.resolveBinding) {
            this.foundBinding = methodDeclaration.resolveBinding();
        }
        return true;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        if (this.found(packageDeclaration, packageDeclaration) && this.resolveBinding) {
            this.foundBinding = packageDeclaration.resolveBinding();
        }
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        if (this.found(typeDeclaration, typeDeclaration.getName()) && this.resolveBinding) {
            this.foundBinding = typeDeclaration.resolveBinding();
        }
        return true;
    }

    public boolean visit(TypeParameter typeParameter) {
        if (this.found(typeParameter, typeParameter.getName()) && this.resolveBinding) {
            this.foundBinding = typeParameter.resolveBinding();
        }
        return true;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        if (this.found(variableDeclarationFragment, variableDeclarationFragment.getName()) && this.resolveBinding) {
            this.foundBinding = variableDeclarationFragment.resolveBinding();
        }
        return true;
    }
}

