/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.util.IBytecodeVisitor;
import org.eclipse.wst.jsdt.core.util.ICodeAttribute;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.core.util.ILocalVariableAttribute;
import org.eclipse.wst.jsdt.core.util.ILocalVariableTableEntry;
import org.eclipse.wst.jsdt.core.util.OpcodeStringValues;
import org.eclipse.wst.jsdt.internal.core.util.Disassembler;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class DefaultBytecodeVisitor
implements IBytecodeVisitor {
    private static final String EMPTY_CLASS_NAME = "\"\"";
    private static final String EMPTY_LOCAL_NAME = "";
    private static final int T_BOOLEAN = 4;
    private static final int T_CHAR = 5;
    private static final int T_FLOAT = 6;
    private static final int T_DOUBLE = 7;
    private static final int T_BYTE = 8;
    private static final int T_SHORT = 9;
    private static final int T_INT = 10;
    private static final int T_LONG = 11;
    private StringBuffer buffer;
    private String lineSeparator;
    private int tabNumber;
    private int digitNumberForPC;
    private ILocalVariableTableEntry[] localVariableTableEntries;
    private int localVariableAttributeLength;
    private int mode;

    public DefaultBytecodeVisitor(ICodeAttribute iCodeAttribute, StringBuffer stringBuffer, String string, int n, int n2) {
        ILocalVariableAttribute iLocalVariableAttribute = iCodeAttribute.getLocalVariableAttribute();
        this.localVariableAttributeLength = iLocalVariableAttribute == null ? 0 : iLocalVariableAttribute.getLocalVariableTableLength();
        this.localVariableTableEntries = this.localVariableAttributeLength != 0 ? iLocalVariableAttribute.getLocalVariableTable() : null;
        this.buffer = stringBuffer;
        this.lineSeparator = string;
        this.tabNumber = n + 1;
        long l = iCodeAttribute.getCodeLength();
        this.digitNumberForPC = Long.toString(l).length();
        this.mode = n2;
    }

    public void _aaload(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[50]);
        this.writeNewLine();
    }

    private void dumpPcNumber(int n) {
        this.writeTabs();
        int n2 = 1;
        if (n != 0) {
            n2 = Integer.toString(n).length();
        }
        int n3 = 0;
        int n4 = this.digitNumberForPC - n2;
        while (n3 < n4) {
            this.buffer.append(' ');
            ++n3;
        }
        this.buffer.append(n);
        this.buffer.append(Messages.disassembler_indentation);
    }

    public void _aastore(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[83]);
        this.writeNewLine();
    }

    public void _aconst_null(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[1]);
        this.writeNewLine();
    }

    public void _aload_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[42], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _aload_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[43], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _aload_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[44], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _aload_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[45], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _aload(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[25], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _anewarray(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_anewarray, new String[]{OpcodeStringValues.BYTECODE_NAMES[189], Integer.toString(n2), this.returnConstantClassName(iConstantPoolEntry)}));
        this.writeNewLine();
    }

    public void _areturn(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[176]);
        this.writeNewLine();
    }

    public void _arraylength(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[190]);
        this.writeNewLine();
    }

    public void _astore_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[75], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _astore_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[76], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    private String getLocalVariableName(int n, int n2) {
        return this.getLocalVariableName(n, n2, false);
    }

    private String getLocalVariableName(int n, int n2, boolean bl) {
        int n3 = n + 1;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                n3 = n2 <= 255 ? n + 2 : n + 3;
            }
        }
        int n4 = 0;
        int n5 = this.localVariableAttributeLength;
        while (n4 < n5) {
            ILocalVariableTableEntry iLocalVariableTableEntry = this.localVariableTableEntries[n4];
            int n6 = iLocalVariableTableEntry.getStartPC();
            if (iLocalVariableTableEntry.getIndex() == n2 && n6 <= n3 && n6 + iLocalVariableTableEntry.getLength() > n3) {
                StringBuffer stringBuffer = new StringBuffer();
                if (bl) {
                    stringBuffer.append(' ').append(n2);
                }
                stringBuffer.append(' ').append('[').append(iLocalVariableTableEntry.getName()).append(']');
                return String.valueOf(stringBuffer);
            }
            ++n4;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(' ').append(n2);
            return String.valueOf(stringBuffer);
        }
        return EMPTY_LOCAL_NAME;
    }

    public void _astore_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[77], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _astore_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[78], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _astore(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[58], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _athrow(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[191]);
        this.writeNewLine();
    }

    public void _baload(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[51]);
        this.writeNewLine();
    }

    public void _bastore(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[84]);
        this.writeNewLine();
    }

    public void _bipush(int n, byte by) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[16]).append(Messages.disassembler_space).append(by);
        this.writeNewLine();
    }

    public void _caload(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[52]);
        this.writeNewLine();
    }

    public void _castore(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[85]);
        this.writeNewLine();
    }

    public void _checkcast(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_checkcast, new String[]{OpcodeStringValues.BYTECODE_NAMES[192], Integer.toString(n2), this.returnConstantClassName(iConstantPoolEntry)}));
        this.writeNewLine();
    }

    public void _d2f(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[144]);
        this.writeNewLine();
    }

    public void _d2i(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[142]);
        this.writeNewLine();
    }

    public void _d2l(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[143]);
        this.writeNewLine();
    }

    public void _dadd(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[99]);
        this.writeNewLine();
    }

    public void _daload(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[49]);
        this.writeNewLine();
    }

    public void _dastore(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[82]);
        this.writeNewLine();
    }

    public void _dcmpg(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[152]);
        this.writeNewLine();
    }

    public void _dcmpl(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[151]);
        this.writeNewLine();
    }

    public void _dconst_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[14]);
        this.writeNewLine();
    }

    public void _dconst_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[15]);
        this.writeNewLine();
    }

    public void _ddiv(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[111]);
        this.writeNewLine();
    }

    public void _dload_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[38], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _dload_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[39], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _dload_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[40], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _dload_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[41], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _dload(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[24], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _dmul(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[107]);
        this.writeNewLine();
    }

    public void _dneg(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[119]);
        this.writeNewLine();
    }

    public void _drem(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[115]);
        this.writeNewLine();
    }

    public void _dreturn(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[175]);
        this.writeNewLine();
    }

    public void _dstore_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[71], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _dstore_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[72], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _dstore_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[73], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _dstore_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[74], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _dstore(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[57], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _dsub(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[103]);
        this.writeNewLine();
    }

    public void _dup_x1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[90]);
        this.writeNewLine();
    }

    public void _dup_x2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[91]);
        this.writeNewLine();
    }

    public void _dup(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[89]);
        this.writeNewLine();
    }

    public void _dup2_x1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[93]);
        this.writeNewLine();
    }

    public void _dup2_x2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[94]);
        this.writeNewLine();
    }

    public void _dup2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[92]);
        this.writeNewLine();
    }

    public void _f2d(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[141]);
        this.writeNewLine();
    }

    public void _f2i(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[139]);
        this.writeNewLine();
    }

    public void _f2l(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[140]);
        this.writeNewLine();
    }

    public void _fadd(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[98]);
        this.writeNewLine();
    }

    public void _faload(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[48]);
        this.writeNewLine();
    }

    public void _fastore(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[81]);
        this.writeNewLine();
    }

    public void _fcmpg(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[150]);
        this.writeNewLine();
    }

    public void _fcmpl(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[149]);
        this.writeNewLine();
    }

    public void _fconst_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[11]);
        this.writeNewLine();
    }

    public void _fconst_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[12]);
        this.writeNewLine();
    }

    public void _fconst_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[13]);
        this.writeNewLine();
    }

    public void _fdiv(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[110]);
        this.writeNewLine();
    }

    public void _fload_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[34], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _fload_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[35], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _fload_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[36], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _fload_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[37], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _fload(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[23], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _fmul(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[106]);
        this.writeNewLine();
    }

    public void _fneg(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[118]);
        this.writeNewLine();
    }

    public void _frem(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[114]);
        this.writeNewLine();
    }

    public void _freturn(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[174]);
        this.writeNewLine();
    }

    public void _fstore_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[67], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _fstore_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[68], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _fstore_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[69], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _fstore_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[70], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _fstore(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[56], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _fsub(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[102]);
        this.writeNewLine();
    }

    public void _getfield(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_getfield, new String[]{OpcodeStringValues.BYTECODE_NAMES[180], Integer.toString(n2), this.returnDeclaringClassName(iConstantPoolEntry), new String(iConstantPoolEntry.getFieldName()), this.returnClassName(Signature.toCharArray(iConstantPoolEntry.getFieldDescriptor()))}));
        this.writeNewLine();
    }

    public void _getstatic(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_getstatic, new String[]{OpcodeStringValues.BYTECODE_NAMES[178], Integer.toString(n2), this.returnDeclaringClassName(iConstantPoolEntry), new String(iConstantPoolEntry.getFieldName()), this.returnClassName(Signature.toCharArray(iConstantPoolEntry.getFieldDescriptor()))}));
        this.writeNewLine();
    }

    public void _goto_w(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[200]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _goto(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[167]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _i2b(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[145]);
        this.writeNewLine();
    }

    public void _i2c(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[146]);
        this.writeNewLine();
    }

    public void _i2d(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[135]);
        this.writeNewLine();
    }

    public void _i2f(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[134]);
        this.writeNewLine();
    }

    public void _i2l(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[133]);
        this.writeNewLine();
    }

    public void _i2s(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[147]);
        this.writeNewLine();
    }

    public void _iadd(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[96]);
        this.writeNewLine();
    }

    public void _iaload(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[46]);
        this.writeNewLine();
    }

    public void _iand(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[126]);
        this.writeNewLine();
    }

    public void _iastore(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[79]);
        this.writeNewLine();
    }

    public void _if_acmpeq(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[165]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _if_acmpne(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[166]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _if_icmpeq(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[159]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _if_icmpge(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[162]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _if_icmpgt(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[163]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _if_icmple(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[164]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _if_icmplt(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[161]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _if_icmpne(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[160]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _iconst_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[3]);
        this.writeNewLine();
    }

    public void _iconst_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[4]);
        this.writeNewLine();
    }

    public void _iconst_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[5]);
        this.writeNewLine();
    }

    public void _iconst_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[6]);
        this.writeNewLine();
    }

    public void _iconst_4(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[7]);
        this.writeNewLine();
    }

    public void _iconst_5(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[8]);
        this.writeNewLine();
    }

    public void _iconst_m1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[2]);
        this.writeNewLine();
    }

    public void _idiv(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[108]);
        this.writeNewLine();
    }

    public void _ifeq(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[153]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _ifge(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[156]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _ifgt(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[157]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _ifle(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[158]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _iflt(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[155]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _ifne(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[154]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _ifnonnull(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[199]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _ifnull(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[198]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _iinc(int n, int n2, int n3) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_iinc, new String[]{OpcodeStringValues.BYTECODE_NAMES[132], Integer.toString(n2), Integer.toString(n3), this.getLocalVariableName(n, n2, false)}));
        this.writeNewLine();
    }

    public void _iload_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[26], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _iload_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[27], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _iload_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[28], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _iload_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[29], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _iload(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[21], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _imul(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[104]);
        this.writeNewLine();
    }

    public void _ineg(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[116]);
        this.writeNewLine();
    }

    public void _instanceof(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_instanceof, new String[]{OpcodeStringValues.BYTECODE_NAMES[193], Integer.toString(n2), this.returnConstantClassName(iConstantPoolEntry)}));
        this.writeNewLine();
    }

    public void _invokeinterface(int n, int n2, byte by, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_invokeinterface, new String[]{OpcodeStringValues.BYTECODE_NAMES[185], Integer.toString(n2), Integer.toString(by), Util.toString(iConstantPoolEntry.getClassName(), iConstantPoolEntry.getMethodName(), iConstantPoolEntry.getMethodDescriptor(), true, this.isCompact())}));
        this.writeNewLine();
    }

    public void _invokespecial(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        String string = this.returnMethodSignature(iConstantPoolEntry);
        this.buffer.append(Messages.bind(Messages.classformat_invokespecial, new String[]{OpcodeStringValues.BYTECODE_NAMES[183], Integer.toString(n2), string}));
        this.writeNewLine();
    }

    public void _invokestatic(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        String string = this.returnMethodSignature(iConstantPoolEntry);
        this.buffer.append(Messages.bind(Messages.classformat_invokestatic, new String[]{OpcodeStringValues.BYTECODE_NAMES[184], Integer.toString(n2), string}));
        this.writeNewLine();
    }

    public void _invokevirtual(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        String string = this.returnMethodSignature(iConstantPoolEntry);
        this.buffer.append(Messages.bind(Messages.classformat_invokevirtual, new String[]{OpcodeStringValues.BYTECODE_NAMES[182], Integer.toString(n2), string}));
        this.writeNewLine();
    }

    public void _ior(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[128]);
        this.writeNewLine();
    }

    public void _irem(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[112]);
        this.writeNewLine();
    }

    public void _ireturn(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[172]);
        this.writeNewLine();
    }

    public void _ishl(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[120]);
        this.writeNewLine();
    }

    public void _ishr(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[122]);
        this.writeNewLine();
    }

    public void _istore_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[59], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _istore_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[60], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _istore_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[61], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _istore_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[62], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _istore(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[54], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _isub(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[100]);
        this.writeNewLine();
    }

    public void _iushr(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[124]);
        this.writeNewLine();
    }

    public void _ixor(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[130]);
        this.writeNewLine();
    }

    public void _jsr_w(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[201]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _jsr(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[168]).append(Messages.disassembler_space).append(n2 + n);
        this.writeNewLine();
    }

    public void _l2d(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[138]);
        this.writeNewLine();
    }

    public void _l2f(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[137]);
        this.writeNewLine();
    }

    public void _l2i(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[136]);
        this.writeNewLine();
    }

    public void _ladd(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[97]);
        this.writeNewLine();
    }

    public void _laload(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[47]);
        this.writeNewLine();
    }

    public void _land(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[127]);
        this.writeNewLine();
    }

    public void _lastore(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[80]);
        this.writeNewLine();
    }

    public void _lcmp(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[148]);
        this.writeNewLine();
    }

    public void _lconst_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[9]);
        this.writeNewLine();
    }

    public void _lconst_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[10]);
        this.writeNewLine();
    }

    public void _ldc_w(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        switch (iConstantPoolEntry.getKind()) {
            case 4: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc_w_float, new String[]{OpcodeStringValues.BYTECODE_NAMES[19], Integer.toString(n2), Float.toString(iConstantPoolEntry.getFloatValue())}));
                break;
            }
            case 3: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc_w_integer, new String[]{OpcodeStringValues.BYTECODE_NAMES[19], Integer.toString(n2), Integer.toString(iConstantPoolEntry.getIntegerValue())}));
                break;
            }
            case 8: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc_w_string, new String[]{OpcodeStringValues.BYTECODE_NAMES[19], Integer.toString(n2), Disassembler.escapeString(iConstantPoolEntry.getStringValue())}));
                break;
            }
            case 7: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc_w_class, new String[]{OpcodeStringValues.BYTECODE_NAMES[19], Integer.toString(n2), this.returnConstantClassName(iConstantPoolEntry)}));
            }
        }
        this.writeNewLine();
    }

    public void _ldc(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        switch (iConstantPoolEntry.getKind()) {
            case 4: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc_w_float, new String[]{OpcodeStringValues.BYTECODE_NAMES[18], Integer.toString(n2), Float.toString(iConstantPoolEntry.getFloatValue())}));
                break;
            }
            case 3: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc_w_integer, new String[]{OpcodeStringValues.BYTECODE_NAMES[18], Integer.toString(n2), Integer.toString(iConstantPoolEntry.getIntegerValue())}));
                break;
            }
            case 8: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc_w_string, new String[]{OpcodeStringValues.BYTECODE_NAMES[18], Integer.toString(n2), Disassembler.escapeString(iConstantPoolEntry.getStringValue())}));
                break;
            }
            case 7: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc_w_class, new String[]{OpcodeStringValues.BYTECODE_NAMES[18], Integer.toString(n2), this.returnConstantClassName(iConstantPoolEntry)}));
            }
        }
        this.writeNewLine();
    }

    public void _ldc2_w(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        switch (iConstantPoolEntry.getKind()) {
            case 5: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc2_w_long, new String[]{OpcodeStringValues.BYTECODE_NAMES[20], Integer.toString(n2), Long.toString(iConstantPoolEntry.getLongValue())}));
                break;
            }
            case 6: {
                this.buffer.append(Messages.bind(Messages.classformat_ldc2_w_double, new String[]{OpcodeStringValues.BYTECODE_NAMES[20], Integer.toString(n2), Double.toString(iConstantPoolEntry.getDoubleValue())}));
            }
        }
        this.writeNewLine();
    }

    public void _ldiv(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[109]);
        this.writeNewLine();
    }

    public void _lload_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[30], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _lload_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[31], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _lload_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[32], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _lload_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[33], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _lload(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_load, new String[]{OpcodeStringValues.BYTECODE_NAMES[22], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _lmul(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[105]);
        this.writeNewLine();
    }

    public void _lneg(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[117]);
        this.writeNewLine();
    }

    public void _lookupswitch(int n, int n2, int n3, int[][] nArray) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[171]).append(" default: ").append(n2 + n);
        this.writeNewLine();
        int n4 = 0;
        while (n4 < n3) {
            this.writeExtraTabs(3);
            this.buffer.append("case ").append(nArray[n4][0]).append(": ").append(nArray[n4][1] + n);
            this.writeNewLine();
            ++n4;
        }
    }

    public void _lor(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[129]);
        this.writeNewLine();
    }

    public void _lrem(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[113]);
        this.writeNewLine();
    }

    public void _lreturn(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[173]);
        this.writeNewLine();
    }

    public void _lshl(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[121]);
        this.writeNewLine();
    }

    public void _lshr(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[123]);
        this.writeNewLine();
    }

    public void _lstore_0(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[63], this.getLocalVariableName(n, 0)}));
        this.writeNewLine();
    }

    public void _lstore_1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[64], this.getLocalVariableName(n, 1)}));
        this.writeNewLine();
    }

    public void _lstore_2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[65], this.getLocalVariableName(n, 2)}));
        this.writeNewLine();
    }

    public void _lstore_3(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[66], this.getLocalVariableName(n, 3)}));
        this.writeNewLine();
    }

    public void _lstore(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_store, new String[]{OpcodeStringValues.BYTECODE_NAMES[55], this.getLocalVariableName(n, n2, true)}));
        this.writeNewLine();
    }

    public void _lsub(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[101]);
        this.writeNewLine();
    }

    public void _lushr(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[125]);
        this.writeNewLine();
    }

    public void _lxor(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[131]);
        this.writeNewLine();
    }

    public void _monitorenter(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[194]);
        this.writeNewLine();
    }

    public void _monitorexit(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[195]);
        this.writeNewLine();
    }

    public void _multianewarray(int n, int n2, int n3, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_multianewarray, new String[]{OpcodeStringValues.BYTECODE_NAMES[197], Integer.toString(n2), this.returnConstantClassName(iConstantPoolEntry)}));
        this.writeNewLine();
    }

    public void _new(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_new, new String[]{OpcodeStringValues.BYTECODE_NAMES[187], Integer.toString(n2), this.returnConstantClassName(iConstantPoolEntry)}));
        this.writeNewLine();
    }

    public void _newarray(int n, int n2) {
        this.dumpPcNumber(n);
        switch (n2) {
            case 4: {
                this.buffer.append(Messages.bind(Messages.classformat_newarray_boolean, new String[]{OpcodeStringValues.BYTECODE_NAMES[188], Integer.toString(n2)}));
                break;
            }
            case 5: {
                this.buffer.append(Messages.bind(Messages.classformat_newarray_char, new String[]{OpcodeStringValues.BYTECODE_NAMES[188], Integer.toString(n2)}));
                break;
            }
            case 6: {
                this.buffer.append(Messages.bind(Messages.classformat_newarray_float, new String[]{OpcodeStringValues.BYTECODE_NAMES[188], Integer.toString(n2)}));
                break;
            }
            case 7: {
                this.buffer.append(Messages.bind(Messages.classformat_newarray_double, new String[]{OpcodeStringValues.BYTECODE_NAMES[188], Integer.toString(n2)}));
                break;
            }
            case 8: {
                this.buffer.append(Messages.bind(Messages.classformat_newarray_byte, new String[]{OpcodeStringValues.BYTECODE_NAMES[188], Integer.toString(n2)}));
                break;
            }
            case 9: {
                this.buffer.append(Messages.bind(Messages.classformat_newarray_short, new String[]{OpcodeStringValues.BYTECODE_NAMES[188], Integer.toString(n2)}));
                break;
            }
            case 10: {
                this.buffer.append(Messages.bind(Messages.classformat_newarray_int, new String[]{OpcodeStringValues.BYTECODE_NAMES[188], Integer.toString(n2)}));
                break;
            }
            case 11: {
                this.buffer.append(Messages.bind(Messages.classformat_newarray_long, new String[]{OpcodeStringValues.BYTECODE_NAMES[188], Integer.toString(n2)}));
            }
        }
        this.writeNewLine();
    }

    public void _nop(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[0]);
        this.writeNewLine();
    }

    public void _pop(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[87]);
        this.writeNewLine();
    }

    public void _pop2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[88]);
        this.writeNewLine();
    }

    public void _putfield(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_putfield, new String[]{OpcodeStringValues.BYTECODE_NAMES[181], Integer.toString(n2), this.returnDeclaringClassName(iConstantPoolEntry), new String(iConstantPoolEntry.getFieldName()), this.returnClassName(Signature.toCharArray(iConstantPoolEntry.getFieldDescriptor()))}));
        this.writeNewLine();
    }

    public void _putstatic(int n, int n2, IConstantPoolEntry iConstantPoolEntry) {
        this.dumpPcNumber(n);
        this.buffer.append(Messages.bind(Messages.classformat_putstatic, new String[]{OpcodeStringValues.BYTECODE_NAMES[179], Integer.toString(n2), this.returnDeclaringClassName(iConstantPoolEntry), new String(iConstantPoolEntry.getFieldName()), this.returnClassName(Signature.toCharArray(iConstantPoolEntry.getFieldDescriptor()))}));
        this.writeNewLine();
    }

    public void _ret(int n, int n2) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[169]).append(Messages.disassembler_space).append(n2);
        this.writeNewLine();
    }

    public void _return(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[177]);
        this.writeNewLine();
    }

    public void _saload(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[53]);
        this.writeNewLine();
    }

    public void _sastore(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[86]);
        this.writeNewLine();
    }

    public void _sipush(int n, short s) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[17]).append(Messages.disassembler_space).append(s);
        this.writeNewLine();
    }

    public void _swap(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[95]);
        this.writeNewLine();
    }

    public void _tableswitch(int n, int n2, int n3, int n4, int[] nArray) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[170]).append(" default: ").append(n2 + n);
        this.writeNewLine();
        int n5 = n3;
        while (n5 < n4 + 1) {
            this.writeExtraTabs(3);
            this.buffer.append("case ").append(n5).append(": ").append(nArray[n5 - n3] + n);
            this.writeNewLine();
            ++n5;
        }
    }

    public void _wide(int n, int n2, int n3, int n4) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[196]);
        this.writeNewLine();
        this._iinc(n + 1, n3, n4);
    }

    public void _wide(int n, int n2, int n3) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[196]);
        this.writeNewLine();
        switch (n2) {
            case 21: {
                this._iload(n + 1, n3);
                break;
            }
            case 23: {
                this._fload(n + 1, n3);
                break;
            }
            case 25: {
                this._aload(n + 1, n3);
                break;
            }
            case 22: {
                this._lload(n + 1, n3);
                break;
            }
            case 24: {
                this._dload(n + 1, n3);
                break;
            }
            case 54: {
                this._istore(n + 1, n3);
                break;
            }
            case 56: {
                this._fstore(n + 1, n3);
                break;
            }
            case 58: {
                this._astore(n + 1, n3);
                break;
            }
            case 55: {
                this._lstore(n + 1, n3);
                break;
            }
            case 57: {
                this._dstore(n + 1, n3);
                break;
            }
            case 169: {
                this._ret(n + 1, n3);
            }
        }
    }

    public void _breakpoint(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[202]);
        this.writeNewLine();
    }

    public void _impdep1(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[254]);
        this.writeNewLine();
    }

    public void _impdep2(int n) {
        this.dumpPcNumber(n);
        this.buffer.append(OpcodeStringValues.BYTECODE_NAMES[255]);
        this.writeNewLine();
    }

    private boolean isCompact() {
        return (this.mode & 8) != 0;
    }

    private String returnConstantClassName(IConstantPoolEntry iConstantPoolEntry) {
        char[] cArray = iConstantPoolEntry.getClassInfoName();
        if (cArray.length == 0) {
            return EMPTY_CLASS_NAME;
        }
        switch (cArray[0]) {
            case '[': {
                StringBuffer stringBuffer = new StringBuffer();
                Util.appendTypeSignature(cArray, 0, stringBuffer, this.isCompact());
                return stringBuffer.toString();
            }
        }
        return this.returnClassName(cArray);
    }

    private String returnClassName(char[] cArray) {
        int n;
        if (cArray.length == 0) {
            return EMPTY_CLASS_NAME;
        }
        if (this.isCompact() && (n = CharOperation.lastIndexOf('/', cArray)) != -1) {
            return new String(cArray, n + 1, cArray.length - n - 1);
        }
        CharOperation.replace(cArray, '/', '.');
        return new String(cArray);
    }

    private String returnDeclaringClassName(IConstantPoolEntry iConstantPoolEntry) {
        char[] cArray = iConstantPoolEntry.getClassName();
        return this.returnClassName(cArray);
    }

    private String returnMethodSignature(IConstantPoolEntry iConstantPoolEntry) {
        char[] cArray = iConstantPoolEntry.getMethodDescriptor();
        CharOperation.replace(cArray, '$', '#');
        char[] cArray2 = Util.toString(iConstantPoolEntry.getClassName(), iConstantPoolEntry.getMethodName(), cArray, true, this.isCompact()).toCharArray();
        CharOperation.replace(cArray2, '#', '$');
        return String.valueOf(cArray2);
    }

    private void writeNewLine() {
        this.buffer.append(this.lineSeparator);
    }

    private void writeTabs() {
        int n = 0;
        int n2 = this.tabNumber;
        while (n < n2) {
            this.buffer.append(Messages.disassembler_indentation);
            ++n;
        }
    }

    private void writeExtraTabs(int n) {
        int n2 = 0;
        int n3 = this.tabNumber + n;
        while (n2 < n3) {
            this.buffer.append(Messages.disassembler_indentation);
            ++n2;
        }
    }
}

