/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IStackMapFrame;
import org.eclipse.wst.jsdt.core.util.IVerificationTypeInfo;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;
import org.eclipse.wst.jsdt.internal.core.util.VerificationInfo;

public class DefaultStackMapFrame
extends ClassFileStruct
implements IStackMapFrame {
    private static final IVerificationTypeInfo[] EMPTY_LOCALS_OR_STACK_ITEMS = new IVerificationTypeInfo[0];
    private int readOffset;
    private int numberOfLocals;
    private int numberOfStackItems;
    private IVerificationTypeInfo[] locals;
    private IVerificationTypeInfo[] stackItems;
    private int offsetDelta;

    public DefaultStackMapFrame(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        int n2;
        int n3;
        this.offsetDelta = this.u2At(byArray, 0, n);
        this.numberOfLocals = n3 = this.u2At(byArray, 2, n);
        if (n3 != 0) {
            this.locals = new IVerificationTypeInfo[n3];
            this.readOffset = 4;
            n2 = 0;
            while (n2 < n3) {
                VerificationInfo verificationInfo = new VerificationInfo(byArray, iConstantPool, n + this.readOffset);
                this.locals[n2] = verificationInfo;
                this.readOffset += verificationInfo.sizeInBytes();
                ++n2;
            }
        } else {
            this.locals = EMPTY_LOCALS_OR_STACK_ITEMS;
        }
        n2 = this.u2At(byArray, this.readOffset, n);
        this.readOffset += 2;
        this.numberOfStackItems = n2;
        if (n2 != 0) {
            this.stackItems = new IVerificationTypeInfo[n2];
            int n4 = 0;
            while (n4 < n2) {
                VerificationInfo verificationInfo = new VerificationInfo(byArray, iConstantPool, n + this.readOffset);
                this.stackItems[n4] = verificationInfo;
                this.readOffset += verificationInfo.sizeInBytes();
                ++n4;
            }
        } else {
            this.stackItems = EMPTY_LOCALS_OR_STACK_ITEMS;
        }
    }

    int sizeInBytes() {
        return this.readOffset;
    }

    public int getFrameType() {
        return 255;
    }

    public IVerificationTypeInfo[] getLocals() {
        return this.locals;
    }

    public int getNumberOfLocals() {
        return this.numberOfLocals;
    }

    public int getNumberOfStackItems() {
        return this.numberOfStackItems;
    }

    public int getOffsetDelta() {
        return this.offsetDelta;
    }

    public IVerificationTypeInfo[] getStackItems() {
        return this.stackItems;
    }
}

