/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IAttributeNamesConstants;
import org.eclipse.wst.jsdt.core.util.IClassFileAttribute;
import org.eclipse.wst.jsdt.core.util.ICodeAttribute;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.core.util.IExceptionAttribute;
import org.eclipse.wst.jsdt.core.util.IMethodInfo;
import org.eclipse.wst.jsdt.internal.core.util.AnnotationDefaultAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;
import org.eclipse.wst.jsdt.internal.core.util.CodeAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ExceptionAttribute;
import org.eclipse.wst.jsdt.internal.core.util.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.wst.jsdt.internal.core.util.RuntimeInvisibleParameterAnnotationsAttribute;
import org.eclipse.wst.jsdt.internal.core.util.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.wst.jsdt.internal.core.util.RuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.wst.jsdt.internal.core.util.SignatureAttribute;

public class MethodInfo
extends ClassFileStruct
implements IMethodInfo {
    private int accessFlags;
    private int attributeBytes;
    private IClassFileAttribute[] attributes;
    private int attributesCount;
    private ICodeAttribute codeAttribute;
    private char[] descriptor;
    private int descriptorIndex;
    private IExceptionAttribute exceptionAttribute;
    private boolean isDeprecated;
    private boolean isSynthetic;
    private char[] name;
    private int nameIndex;

    public MethodInfo(byte[] byArray, IConstantPool iConstantPool, int n, int n2) throws ClassFormatException {
        int n3;
        boolean bl = (n2 & 0x20) == 0;
        this.accessFlags = n3 = this.u2At(byArray, 0, n);
        if ((n3 & 0x1000) != 0) {
            this.isSynthetic = true;
        }
        this.nameIndex = this.u2At(byArray, 2, n);
        IConstantPoolEntry iConstantPoolEntry = iConstantPool.decodeEntry(this.nameIndex);
        if (iConstantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.name = iConstantPoolEntry.getUtf8Value();
        this.descriptorIndex = this.u2At(byArray, 4, n);
        iConstantPoolEntry = iConstantPool.decodeEntry(this.descriptorIndex);
        if (iConstantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.descriptor = iConstantPoolEntry.getUtf8Value();
        this.attributesCount = this.u2At(byArray, 6, n);
        this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
        if (this.attributesCount != 0) {
            if (bl && !this.isAbstract() && !this.isNative()) {
                if (this.attributesCount != 1) {
                    this.attributes = new IClassFileAttribute[this.attributesCount - 1];
                }
            } else {
                this.attributes = new IClassFileAttribute[this.attributesCount];
            }
        }
        int n4 = 0;
        int n5 = 8;
        int n6 = 0;
        while (n6 < this.attributesCount) {
            iConstantPoolEntry = iConstantPool.decodeEntry(this.u2At(byArray, n5, n));
            if (iConstantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            char[] cArray = iConstantPoolEntry.getUtf8Value();
            if (this.equals(cArray, IAttributeNamesConstants.DEPRECATED)) {
                this.isDeprecated = true;
                this.attributes[n4++] = new ClassFileAttribute(byArray, iConstantPool, n + n5);
            } else if (this.equals(cArray, IAttributeNamesConstants.SYNTHETIC)) {
                this.isSynthetic = true;
                this.attributes[n4++] = new ClassFileAttribute(byArray, iConstantPool, n + n5);
            } else if (this.equals(cArray, IAttributeNamesConstants.CODE)) {
                if (!bl) {
                    this.codeAttribute = new CodeAttribute(byArray, iConstantPool, n + n5);
                    this.attributes[n4++] = this.codeAttribute;
                }
            } else if (this.equals(cArray, IAttributeNamesConstants.EXCEPTIONS)) {
                this.exceptionAttribute = new ExceptionAttribute(byArray, iConstantPool, n + n5);
                this.attributes[n4++] = this.exceptionAttribute;
            } else {
                this.attributes[n4++] = this.equals(cArray, IAttributeNamesConstants.SIGNATURE) ? new SignatureAttribute(byArray, iConstantPool, n + n5) : (this.equals(cArray, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS) ? new RuntimeVisibleAnnotationsAttribute(byArray, iConstantPool, n + n5) : (this.equals(cArray, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS) ? new RuntimeInvisibleAnnotationsAttribute(byArray, iConstantPool, n + n5) : (this.equals(cArray, IAttributeNamesConstants.RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS) ? new RuntimeVisibleParameterAnnotationsAttribute(byArray, iConstantPool, n + n5) : (this.equals(cArray, IAttributeNamesConstants.RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS) ? new RuntimeInvisibleParameterAnnotationsAttribute(byArray, iConstantPool, n + n5) : (this.equals(cArray, IAttributeNamesConstants.ANNOTATION_DEFAULT) ? new AnnotationDefaultAttribute(byArray, iConstantPool, n + n5) : new ClassFileAttribute(byArray, iConstantPool, n + n5))))));
            }
            n5 = (int)((long)n5 + (6L + this.u4At(byArray, n5 + 2, n)));
            ++n6;
        }
        this.attributeBytes = n5;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public IClassFileAttribute[] getAttributes() {
        return this.attributes;
    }

    public ICodeAttribute getCodeAttribute() {
        return this.codeAttribute;
    }

    public char[] getDescriptor() {
        return this.descriptor;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public IExceptionAttribute getExceptionAttribute() {
        return this.exceptionAttribute;
    }

    public char[] getName() {
        return this.name;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    private boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isClinit() {
        return this.name[0] == '<' && this.name.length == 8;
    }

    public boolean isConstructor() {
        return this.name[0] == '<' && this.name.length == 6;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    private boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    int sizeInBytes() {
        return this.attributeBytes;
    }
}

