/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.parser.CSSRegionUtil;
import org.eclipse.wst.css.core.internal.parser.CSSStructuredDocumentRegionFactory;
import org.eclipse.wst.css.core.internal.parser.CSSTokenizer;
import org.eclipse.wst.css.core.internal.parser.ICSSTokenizer;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class CSSSourceParser
implements RegionParser {
    public static final int MODE_STYLESHEET = 0;
    public static final int MODE_DECLARATION = 1;
    public static final int MODE_DECLARATION_VALUE = 2;
    private long fStartTime;
    private long fStopTime;
    private ICSSTokenizer fTokenizer;

    public void setParserMode(int mode) {
        int bufsize;
        int initialState;
        switch (mode) {
            case 0: {
                initialState = 0;
                bufsize = 16384;
                break;
            }
            case 1: {
                initialState = 15;
                bufsize = 16384;
                break;
            }
            case 2: {
                initialState = 17;
                bufsize = 256;
                break;
            }
            default: {
                return;
            }
        }
        if (initialState > 0) {
            ICSSTokenizer tokenizer = this.getTokenizer();
            tokenizer.setInitialState(initialState);
            tokenizer.setInitialBufferSize(bufsize);
        }
    }

    public IStructuredDocumentRegion getDocumentRegions() {
        IStructuredDocumentRegion headnode = null;
        if (headnode == null) {
            headnode = this.parseNodes();
        }
        return headnode;
    }

    public List getRegions() {
        IStructuredDocumentRegion headNode = null;
        if (!this.getTokenizer().isEOF()) {
            headNode = this.getDocumentRegions();
        }
        List localRegionsList = this.getRegions(headNode);
        this.primReset();
        return localRegionsList;
    }

    protected List getRegions(IStructuredDocumentRegion headNode) {
        ArrayList<ITextRegion> allRegions = new ArrayList<ITextRegion>();
        IStructuredDocumentRegion currentNode = headNode;
        while (currentNode != null) {
            ITextRegionList nodeRegions = currentNode.getRegions();
            int i = 0;
            while (i < nodeRegions.size()) {
                allRegions.add(nodeRegions.get(i));
                ++i;
            }
            currentNode = currentNode.getNext();
        }
        return allRegions;
    }

    public void reset(Reader reader) {
        this.primReset();
        this.getTokenizer().reset(reader, 0);
    }

    public void reset(Reader reader, int offset) {
        this.reset(reader);
    }

    public void reset(String input) {
        this.reset(new StringReader(input));
    }

    public void reset(String input, int offset) {
        this.reset(input);
    }

    public RegionParser newInstance() {
        return new CSSSourceParser();
    }

    private IStructuredDocumentRegion parseNodes() {
        IStructuredDocumentRegion headNode = null;
        IStructuredDocumentRegion lastNode = null;
        ITextRegion region = null;
        IStructuredDocumentRegion currentNode = null;
        String type = null;
        String currentRegionType = null;
        while ((region = this.getNextRegion()) != null) {
            type = region.getType();
            if (this.mustBeStart(type, currentRegionType) && currentNode != null) {
                currentNode.setEnded(true);
            }
            if (currentNode != null && currentNode.isEnded() || currentNode == null) {
                if (currentNode != null && !currentNode.isEnded()) {
                    currentNode.setEnded(true);
                }
                lastNode = currentNode;
                currentNode = this.createStructuredDocumentRegion(type);
                currentRegionType = type;
                if (lastNode != null) {
                    lastNode.setNext(currentNode);
                }
                currentNode.setPrevious(lastNode);
                currentNode.setStart(region.getStart());
            }
            currentNode.addRegion(region);
            currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
            region.adjustStart(-currentNode.getStart());
            if (this.mustBeEnd(type)) {
                currentNode.setEnded(true);
            }
            if (headNode != null || currentNode == null) continue;
            headNode = currentNode;
        }
        if (currentNode != null && !currentNode.isEnded()) {
            currentNode.setEnded(true);
        }
        this.primReset();
        return headNode;
    }

    private IStructuredDocumentRegion createStructuredDocumentRegion(String type) {
        return CSSStructuredDocumentRegionFactory.createRegion(type);
    }

    protected boolean mustBeStart(String type, String docRegionType) {
        return type == "DELIMITER" || type == "LBRACE" || type == "RBRACE" || type == "IMPORT" || type == "PAGE" || type == "MEDIA" || type == "FONT_FACE" || type == "CHARSET" || type == "ATKEYWORD" || type == "DECLARATION_PROPERTY" || type == "DECLARATION_DELIMITER" || docRegionType == "DECLARATION_PROPERTY" && type == "S" || !CSSRegionUtil.isSelectorBegginingType(docRegionType) && (type == "SELECTOR_ELEMENT_NAME" || type == "SELECTOR_UNIVERSAL" || type == "SELECTOR_PSEUDO" || type == "SELECTOR_CLASS" || type == "SELECTOR_ID" || type == "SELECTOR_ATTRIBUTE_START");
    }

    protected boolean mustBeEnd(String type) {
        return type == "DELIMITER" || type == "LBRACE" || type == "RBRACE" || type == "DECLARATION_DELIMITER";
    }

    private ITextRegion getNextRegion() {
        ITextRegion region = null;
        try {
            region = this.getTokenizer().getNextToken();
            return region;
        }
        catch (StackOverflowError e) {
            Logger.logException(String.valueOf(this.getClass().getName()) + ": input could not be parsed correctly at position " + this.getTokenizer().getOffset(), e);
            throw e;
        }
        catch (Exception e) {
            Logger.logException(String.valueOf(this.getClass().getName()) + ": input could not be parsed correctly at position " + this.getTokenizer().getOffset() + " (" + e.getLocalizedMessage() + ")", e);
            return null;
        }
    }

    private void primReset() {
        this.getTokenizer().reset(new char[0]);
    }

    public ICSSTokenizer getTokenizer() {
        if (this.fTokenizer == null) {
            this.fTokenizer = new CSSTokenizer();
        }
        return this.fTokenizer;
    }

    private int _countNodes(IStructuredDocumentRegion nodes) {
        int result = 0;
        IStructuredDocumentRegion countNode = nodes;
        while (countNode != null) {
            ++result;
            countNode = countNode.getNext();
        }
        return result;
    }
}

