/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.w3c.dom.Element;

public class AddElementDeclarationAction
extends Action {
    protected Definition definition;
    protected String namespace;
    protected String prefix;

    public AddElementDeclarationAction(Definition definition, String namespace, String suggestedPrefix) {
        this.definition = definition;
        this.namespace = namespace;
        this.prefix = suggestedPrefix;
    }

    public void run() {
        String existingPrefix = this.definition.getPrefix(this.namespace);
        if (existingPrefix != null) {
            this.prefix = existingPrefix;
        } else {
            this.prefix = NameUtil.buildUniquePrefix(this.definition, this.prefix);
            Element definitionElement = WSDLEditorUtil.getInstance().getElementForObject(this.definition);
            if (definitionElement != null) {
                definitionElement.setAttribute("xmlns:" + this.prefix, this.namespace);
            }
        }
    }

    public String getPrefix() {
        return this.prefix;
    }
}

