/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class RenameLocalVariableDescriptor
extends JavaRefactoringDescriptor {
    private String fName = null;
    private boolean fReferences = false;
    private ISourceRange fSelection = null;
    private ICompilationUnit fUnit = null;

    public RenameLocalVariableDescriptor() {
        super("org.eclipse.wst.jsdt.ui.rename.local.variable");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("name", this.fName);
        this.fArguments.put("input", RenameLocalVariableDescriptor.elementToHandle(this.getProject(), (IJavaElement)this.fUnit));
        this.fArguments.put("selection", String.valueOf(new Integer(this.fSelection.getOffset()).toString()) + " " + new Integer(this.fSelection.getLength()).toString());
        this.fArguments.put("references", Boolean.toString(this.fReferences));
    }

    public void setCompilationUnit(ICompilationUnit iCompilationUnit) {
        Assert.isNotNull((Object)iCompilationUnit);
        this.fUnit = iCompilationUnit;
    }

    public void setNewName(String string) {
        Assert.isNotNull((Object)string);
        Assert.isLegal((!"".equals(string) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = string;
    }

    public void setSelection(ISourceRange iSourceRange) {
        Assert.isNotNull((Object)iSourceRange);
        this.fSelection = iSourceRange;
    }

    public void setUpdateReferences(boolean bl) {
        this.fReferences = bl;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus refactoringStatus = super.validateDescriptor();
        if (this.fName == null || "".equals(this.fName)) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fUnit == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameLocalVariableDescriptor_no_compilation_unit));
        }
        if (this.fSelection == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameLocalVariableDescriptor_no_selection));
        }
        return refactoringStatus;
    }
}

