/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ant;

import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.EnvironmentMessages;
import org.eclipse.wst.command.internal.env.ant.AntEnvironment;
import org.eclipse.wst.command.internal.env.ant.AntOperationManager;
import org.eclipse.wst.command.internal.env.ant.AntStatusHandler;
import org.eclipse.wst.command.internal.env.context.PersistentResourceContext;
import org.eclipse.wst.command.internal.env.core.CommandManager;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.command.internal.env.core.data.DataFlowManager;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistryImpl;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.FragmentListener;
import org.eclipse.wst.command.internal.env.eclipse.BaseStatusHandler;
import org.eclipse.wst.common.environment.IEnvironment;

public class AntController {
    private AntOperationManager operationManager_;
    private String errorMessage_ = null;
    private AntEnvironment environment_;

    public AntController(Hashtable properties) {
        TransientResourceContext resourceContext = (TransientResourceContext)PersistentResourceContext.getInstance().copy();
        AntStatusHandler handler = new AntStatusHandler();
        this.environment_ = new AntEnvironment(this, resourceContext, handler, properties);
        DataFlowManager dataManager = new DataFlowManager(new DataMappingRegistryImpl(), (IEnvironment)this.environment_);
        CommandFragment rootFragment = this.environment_.getRootCommandFragment();
        if (rootFragment == null) {
            this.errorMessage_ = EnvironmentMessages.MSG_ERROR_ANT_SCENARIO_TYPE;
            handler.reportError((IStatus)new Status(4, "ws_ant", 9999, this.errorMessage_, null));
            return;
        }
        this.createOperationManager(rootFragment, dataManager, this.environment_);
        DataMappingRegistryImpl dataRegistry_ = new DataMappingRegistryImpl();
        rootFragment.registerDataMappings((DataMappingRegistry)dataRegistry_);
        this.operationManager_.moveForwardToNextStop((IProgressMonitor)new NullProgressMonitor());
        IStatus lastStatus = this.operationManager_.getLastStatus();
        if (!lastStatus.isOK()) {
            this.errorMessage_ = lastStatus.getMessage();
            this.operationManager_.undoToLastStop();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage_;
    }

    private void createOperationManager(CommandFragment frag, DataFlowManager mgr, AntEnvironment env) {
        this.operationManager_ = new AntOperationManager(frag, mgr, env);
        this.operationManager_.setPeekFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return AntController.this.peekFragment(fragment);
            }
        });
        this.operationManager_.setNextFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return AntController.this.nextFragment(fragment);
            }
        });
        this.operationManager_.setUndoFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return AntController.this.undoFragment(fragment);
            }
        });
        this.operationManager_.setAfterExecuteFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return AntController.this.afterExecuteNextFragment(fragment);
            }
        });
    }

    protected CommandManager getOperationManager() {
        return this.operationManager_;
    }

    protected boolean peekFragment(CommandFragment fragment) {
        return true;
    }

    protected boolean nextFragment(CommandFragment fragment) {
        return true;
    }

    protected boolean undoFragment(CommandFragment fragment) {
        return true;
    }

    protected boolean afterExecuteNextFragment(CommandFragment fragment) {
        boolean continueExecute = true;
        BaseStatusHandler statusHandler = (BaseStatusHandler)this.environment_.getStatusHandler();
        IStatus commandStatus = this.operationManager_.getLastStatus();
        IStatus handlerStatus = statusHandler.getStatus();
        if (commandStatus.getSeverity() == 4 && handlerStatus.getSeverity() != 4) {
            String errorMessage = commandStatus.getMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                statusHandler.reportError(commandStatus);
            }
        } else if (commandStatus.getSeverity() != 4 && handlerStatus.getSeverity() == 4) {
            this.errorMessage_ = handlerStatus.getMessage();
            continueExecute = false;
        }
        return continueExecute;
    }
}

