/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public final class AddGetterSetterOperation
implements IWorkspaceRunnable {
    private static final String[] EMPTY_STRINGS = new String[0];
    private final IField[] fAccessorFields;
    private boolean fApply = true;
    private TextEdit fEdit = null;
    private final IField[] fGetterFields;
    private final IJavaElement fInsert;
    private final boolean fSave;
    private final IField[] fSetterFields;
    private final CodeGenerationSettings fSettings;
    private boolean fSkipAllExisting = false;
    private final IRequestQuery fSkipExistingQuery;
    private boolean fSort = false;
    private final IType fType;
    private final CompilationUnit fASTRoot;
    private int fVisibility = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public AddGetterSetterOperation(IType iType, IField[] iFieldArray, IField[] iFieldArray2, IField[] iFieldArray3, CompilationUnit compilationUnit, IRequestQuery iRequestQuery, IJavaElement iJavaElement, CodeGenerationSettings codeGenerationSettings, boolean bl, boolean bl2) {
        Assert.isNotNull((Object)iType);
        Assert.isNotNull((Object)compilationUnit);
        Assert.isNotNull((Object)codeGenerationSettings);
        this.fType = iType;
        this.fGetterFields = iFieldArray;
        this.fSetterFields = iFieldArray2;
        this.fAccessorFields = iFieldArray3;
        this.fASTRoot = compilationUnit;
        this.fSkipExistingQuery = iRequestQuery;
        this.fInsert = iJavaElement;
        this.fSettings = codeGenerationSettings;
        this.fSave = bl2;
        this.fApply = bl;
    }

    private void addNewAccessor(IType iType, IField iField, String string, ListRewrite listRewrite, ASTNode aSTNode) throws JavaModelException {
        String string2 = StubUtility.getLineDelimiterUsed((IJavaElement)iType);
        MethodDeclaration methodDeclaration = (MethodDeclaration)listRewrite.getASTRewrite().createStringPlaceholder(CodeFormatterUtil.format(4, string, 0, null, string2, iField.getJavaProject()), 31);
        if (aSTNode != null) {
            listRewrite.insertBefore((ASTNode)methodDeclaration, aSTNode, null);
        } else {
            listRewrite.insertLast((ASTNode)methodDeclaration, null);
        }
    }

    private void generateGetterMethod(IField iField, ListRewrite listRewrite) throws CoreException, OperationCanceledException {
        IType iType = iField.getDeclaringType();
        String string = GetterSetterUtil.getGetterName(iField, null);
        IMethod iMethod = JavaModelUtil.findMethod(string, EMPTY_STRINGS, false, iType);
        if (iMethod == null || !this.querySkipExistingMethods(iMethod)) {
            IJavaElement iJavaElement = null;
            if (iMethod != null) {
                iJavaElement = StubUtility.findNextSibling((IJavaElement)iMethod);
                this.removeExistingAccessor(iMethod, listRewrite);
            } else {
                iJavaElement = this.fInsert;
            }
            ASTNode aSTNode = null;
            if (iJavaElement instanceof IMethod) {
                ASTNode aSTNode2 = NodeFinder.perform(listRewrite.getParent().getRoot(), ((IMethod)this.fInsert).getNameRange());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                aSTNode = ASTNodes.getParent(aSTNode2, clazz);
            }
            this.addNewAccessor(iType, iField, GetterSetterUtil.getGetterStub(iField, string, this.fSettings.createComments, this.fVisibility | iField.getFlags() & 8), listRewrite, aSTNode);
        }
    }

    private void generateSetterMethod(IField iField, ASTRewrite aSTRewrite, ListRewrite listRewrite) throws CoreException, OperationCanceledException {
        IType iType = iField.getDeclaringType();
        String string = GetterSetterUtil.getSetterName(iField, null);
        IMethod iMethod = JavaModelUtil.findMethod(string, new String[]{iField.getTypeSignature()}, false, iType);
        if (iMethod == null || this.querySkipExistingMethods(iMethod)) {
            IJavaElement iJavaElement = null;
            if (iMethod != null) {
                iJavaElement = StubUtility.findNextSibling((IJavaElement)iMethod);
                this.removeExistingAccessor(iMethod, listRewrite);
            } else {
                iJavaElement = this.fInsert;
            }
            ASTNode aSTNode = null;
            if (iJavaElement instanceof IMethod) {
                ASTNode aSTNode2 = NodeFinder.perform((ASTNode)this.fASTRoot, ((IMethod)this.fInsert).getNameRange());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                aSTNode = ASTNodes.getParent(aSTNode2, clazz);
            }
            this.addNewAccessor(iType, iField, GetterSetterUtil.getSetterStub(iField, string, this.fSettings.createComments, this.fVisibility | iField.getFlags() & 8), listRewrite, aSTNode);
            if (Flags.isFinal((int)iField.getFlags())) {
                ASTNode aSTNode3;
                ASTNode aSTNode4 = NodeFinder.perform((ASTNode)this.fASTRoot, iField.getNameRange());
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.FieldDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((aSTNode3 = ASTNodes.getParent(aSTNode4, clazz)) != null) {
                    ModifierRewrite.create(aSTRewrite, aSTNode3).setModifiers(0, 16, null);
                }
            }
        }
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final int getVisibility() {
        return this.fVisibility;
    }

    public final boolean isSkipAllExisting() {
        return this.fSkipAllExisting;
    }

    private boolean querySkipExistingMethods(IMethod iMethod) throws OperationCanceledException {
        if (!this.fSkipAllExisting) {
            switch (this.fSkipExistingQuery.doQuery((IMember)iMethod)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fSkipAllExisting = true;
                }
            }
        }
        return true;
    }

    private void removeExistingAccessor(IMethod iMethod, ListRewrite listRewrite) throws JavaModelException {
        MethodDeclaration methodDeclaration;
        ASTNode aSTNode = NodeFinder.perform(listRewrite.getParent().getRoot(), iMethod.getNameRange());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((methodDeclaration = (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
            listRewrite.remove((ASTNode)methodDeclaration, null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            ClassInstanceCreation classInstanceCreation;
            iProgressMonitor.setTaskName(CodeGenerationMessages.AddGetterSetterOperation_description);
            iProgressMonitor.beginTask("", this.fGetterFields.length + this.fSetterFields.length);
            ICompilationUnit iCompilationUnit = this.fType.getCompilationUnit();
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)this.fASTRoot.getAST());
            ListRewrite listRewrite = null;
            if (this.fType.isAnonymous()) {
                AnonymousClassDeclaration anonymousClassDeclaration;
                ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fASTRoot, this.fType.getNameRange());
                Class<?> clazz = class$2;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$2 = clazz2;
                }
                if ((classInstanceCreation = (ClassInstanceCreation)ASTNodes.getParent(aSTNode, clazz)) != null && (anonymousClassDeclaration = classInstanceCreation.getAnonymousClassDeclaration()) != null) {
                    listRewrite = aSTRewrite.getListRewrite((ASTNode)anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                }
            } else {
                ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fASTRoot, this.fType.getNameRange());
                Class<?> clazz = class$3;
                if (clazz == null) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$3 = clazz3;
                }
                if ((classInstanceCreation = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
                    listRewrite = aSTRewrite.getListRewrite((ASTNode)classInstanceCreation, classInstanceCreation.getBodyDeclarationsProperty());
                }
            }
            if (listRewrite == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, CodeGenerationMessages.AddGetterSetterOperation_error_input_type_not_found, null));
            }
            boolean bl = this.fSkipAllExisting = this.fSkipExistingQuery == null;
            if (!this.fSort) {
                int n = 0;
                while (n < this.fAccessorFields.length) {
                    this.generateGetterMethod(this.fAccessorFields[n], listRewrite);
                    this.generateSetterMethod(this.fAccessorFields[n], aSTRewrite, listRewrite);
                    iProgressMonitor.worked(1);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++n;
                }
            }
            int n = 0;
            while (true) {
                if (n >= this.fGetterFields.length) break;
                this.generateGetterMethod(this.fGetterFields[n], listRewrite);
                iProgressMonitor.worked(1);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++n;
            }
            n = 0;
            while (true) {
                block23: {
                    if (n < this.fSetterFields.length) break block23;
                    this.fEdit = aSTRewrite.rewriteAST();
                    if (this.fApply) {
                        JavaModelUtil.applyEdit(iCompilationUnit, this.fEdit, this.fSave, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    break;
                }
                this.generateSetterMethod(this.fSetterFields[n], aSTRewrite, listRewrite);
                iProgressMonitor.worked(1);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        iProgressMonitor.done();
    }

    public final void setSkipAllExisting(boolean bl) {
        this.fSkipAllExisting = bl;
    }

    public void setSort(boolean bl) {
        this.fSort = bl;
    }

    public final void setVisibility(int n) {
        this.fVisibility = n;
    }
}

