/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;

public final class AddUnimplementedMethodsOperation
implements IWorkspaceRunnable {
    private final boolean fApply;
    private String[] fCreatedImports;
    private final List fCreatedMethods = new ArrayList();
    private final boolean fImports;
    private final int fInsertPos;
    private final IMethodBinding[] fMethodsToImplement;
    private final boolean fSave;
    private boolean fDoCreateComments;
    private final ITypeBinding fType;
    private final CompilationUnit fASTRoot;

    public AddUnimplementedMethodsOperation(CompilationUnit compilationUnit, ITypeBinding iTypeBinding, IMethodBinding[] iMethodBindingArray, int n, boolean bl, boolean bl2, boolean bl3) {
        if (compilationUnit == null || !(compilationUnit.getJavaElement() instanceof ICompilationUnit)) {
            throw new IllegalArgumentException("AST must not be null and has to be created from a ICompilationUnit");
        }
        if (iTypeBinding == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)iTypeBinding);
        if (!(aSTNode instanceof AnonymousClassDeclaration) && !(aSTNode instanceof AbstractTypeDeclaration)) {
            throw new IllegalArgumentException("type has to map to a type declaration in the AST");
        }
        this.fType = iTypeBinding;
        this.fInsertPos = n;
        this.fASTRoot = compilationUnit;
        this.fMethodsToImplement = iMethodBindingArray;
        this.fSave = bl3;
        this.fApply = bl2;
        this.fImports = bl;
        this.fDoCreateComments = StubUtility.doAddComments(compilationUnit.getJavaElement().getJavaProject());
    }

    public void setCreateComments(boolean bl) {
        this.fDoCreateComments = bl;
    }

    public final String[] getCreatedImports() {
        if (this.fCreatedImports != null) {
            return this.fCreatedImports;
        }
        return new String[0];
    }

    public final String[] getCreatedMethods() {
        String[] stringArray = new String[this.fCreatedMethods.size()];
        this.fCreatedMethods.toArray(stringArray);
        return stringArray;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            IMethodBinding iMethodBinding;
            AbstractTypeDeclaration abstractTypeDeclaration;
            Object object;
            iProgressMonitor.beginTask("", 2);
            iProgressMonitor.setTaskName(CodeGenerationMessages.AddUnimplementedMethodsOperation_description);
            this.fCreatedMethods.clear();
            ICompilationUnit iCompilationUnit = (ICompilationUnit)this.fASTRoot.getJavaElement();
            AST aST = this.fASTRoot.getAST();
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fASTRoot, true);
            ITypeBinding iTypeBinding = this.fType;
            ListRewrite listRewrite = null;
            ASTNode aSTNode = this.fASTRoot.findDeclaringNode((IBinding)iTypeBinding);
            if (aSTNode instanceof AnonymousClassDeclaration) {
                listRewrite = aSTRewrite.getListRewrite(aSTNode, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            } else {
                if (!(aSTNode instanceof AbstractTypeDeclaration)) throw new IllegalArgumentException();
                object = ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty();
                listRewrite = aSTRewrite.getListRewrite(aSTNode, object);
            }
            object = JavaPreferencesSettings.getCodeGenerationSettings(iCompilationUnit.getJavaProject());
            object.createComments = this.fDoCreateComments;
            ASTNode aSTNode2 = this.getNodeToInsertBefore(listRewrite);
            IMethodBinding[] iMethodBindingArray = this.fMethodsToImplement;
            if (iMethodBindingArray == null) {
                iMethodBindingArray = StubUtility2.getUnimplementedMethods(iTypeBinding);
            }
            ContextSensitiveImportRewriteContext contextSensitiveImportRewriteContext = null;
            int n = this.fInsertPos;
            if (n == -1 && this.fASTRoot.types().size() > 0 && (n = (abstractTypeDeclaration = (AbstractTypeDeclaration)this.fASTRoot.types().get(0)).getStartPosition()) != -1) {
                contextSensitiveImportRewriteContext = new ContextSensitiveImportRewriteContext(this.fASTRoot, n, importRewrite);
            }
            int n2 = 0;
            while (n2 < iMethodBindingArray.length) {
                iMethodBinding = iMethodBindingArray[n2];
                MethodDeclaration methodDeclaration = StubUtility2.createImplementationStub(iCompilationUnit, aSTRewrite, importRewrite, aST, iMethodBinding, iTypeBinding.getName(), (CodeGenerationSettings)object, iTypeBinding.isInterface(), contextSensitiveImportRewriteContext);
                if (methodDeclaration != null) {
                    this.fCreatedMethods.add(iMethodBinding.getKey());
                    if (aSTNode2 != null) {
                        listRewrite.insertBefore((ASTNode)methodDeclaration, aSTNode2, null);
                    } else {
                        listRewrite.insertLast((ASTNode)methodDeclaration, null);
                    }
                }
                ++n2;
            }
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            iMethodBinding = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            this.fCreatedImports = importRewrite.getCreatedImports();
            if (this.fImports) {
                multiTextEdit.addChild((TextEdit)iMethodBinding);
            }
            multiTextEdit.addChild(aSTRewrite.rewriteAST());
            if (this.fApply) {
                JavaModelUtil.applyEdit(iCompilationUnit, (TextEdit)multiTextEdit, this.fSave, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var17_21 = null;
        }
        iProgressMonitor.done();
    }

    private ASTNode getNodeToInsertBefore(ListRewrite listRewrite) {
        if (this.fInsertPos != -1) {
            List list = listRewrite.getOriginalList();
            int n = 0;
            while (n < list.size()) {
                ASTNode aSTNode = (ASTNode)list.get(n);
                if (aSTNode.getStartPosition() >= this.fInsertPos) {
                    return aSTNode;
                }
                ++n;
            }
        }
        return null;
    }
}

