/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.NamingConventions;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class GetterSetterUtil {
    private static final String[] EMPTY = new String[0];

    private GetterSetterUtil() {
    }

    public static String getGetterName(IField iField, String[] stringArray) throws JavaModelException {
        boolean bl = StubUtility.useIsForBooleanGetters(iField.getJavaProject());
        return GetterSetterUtil.getGetterName(iField, stringArray, bl);
    }

    private static String getGetterName(IField iField, String[] stringArray, boolean bl) throws JavaModelException {
        if (stringArray == null) {
            stringArray = EMPTY;
        }
        return GetterSetterUtil.getGetterName(iField.getJavaProject(), iField.getElementName(), iField.getFlags(), bl && JavaModelUtil.isBoolean(iField), stringArray);
    }

    public static String getGetterName(IVariableBinding iVariableBinding, IJavaProject iJavaProject, String[] stringArray, boolean bl) {
        boolean bl2 = StubUtility.useIsForBooleanGetters(iJavaProject) && bl;
        return GetterSetterUtil.getGetterName(iJavaProject, iVariableBinding.getName(), iVariableBinding.getModifiers(), bl2, stringArray);
    }

    public static String getGetterName(IJavaProject iJavaProject, String string, int n, boolean bl, String[] stringArray) {
        return NamingConventions.suggestGetterName((IJavaProject)iJavaProject, (String)string, (int)n, (boolean)bl, (String[])stringArray);
    }

    public static String getSetterName(IVariableBinding iVariableBinding, IJavaProject iJavaProject, String[] stringArray, boolean bl) {
        return GetterSetterUtil.getSetterName(iJavaProject, iVariableBinding.getName(), iVariableBinding.getModifiers(), bl, stringArray);
    }

    public static String getSetterName(IJavaProject iJavaProject, String string, int n, boolean bl, String[] stringArray) {
        return NamingConventions.suggestSetterName((IJavaProject)iJavaProject, (String)string, (int)n, (boolean)bl, (String[])stringArray);
    }

    public static String getSetterName(IField iField, String[] stringArray) throws JavaModelException {
        if (stringArray == null) {
            stringArray = EMPTY;
        }
        return NamingConventions.suggestSetterName((IJavaProject)iField.getJavaProject(), (String)iField.getElementName(), (int)iField.getFlags(), (boolean)JavaModelUtil.isBoolean(iField), (String[])stringArray);
    }

    public static IMethod getGetter(IField iField) throws JavaModelException {
        if (iField.getDeclaringType() == null) {
            return null;
        }
        String string = GetterSetterUtil.getGetterName(iField, EMPTY, true);
        IMethod iMethod = JavaModelUtil.findMethod(string, new String[0], false, iField.getDeclaringType());
        if (!JavaModelUtil.isBoolean(iField) || iMethod != null && iMethod.exists()) {
            return iMethod;
        }
        String string2 = GetterSetterUtil.getGetterName(iField, EMPTY, false);
        return JavaModelUtil.findMethod(string2, new String[0], false, iField.getDeclaringType());
    }

    public static IMethod getSetter(IField iField) throws JavaModelException {
        if (iField.getDeclaringType() == null) {
            return null;
        }
        String[] stringArray = new String[]{iField.getTypeSignature()};
        return JavaModelUtil.findMethod(GetterSetterUtil.getSetterName(iField, EMPTY), stringArray, false, iField.getDeclaringType());
    }

    public static String getSetterStub(IField iField, String string, boolean bl, int n) throws CoreException {
        String string2;
        String string3;
        String string4 = iField.getElementName();
        IType iType = iField.getDeclaringType();
        String string5 = iField.getTypeSignature();
        String string6 = Signature.toString((String)string5);
        IJavaProject iJavaProject = iField.getJavaProject();
        String string7 = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)iJavaProject, (String)string4, (int)iField.getFlags());
        String string8 = StubUtility.suggestArgumentName(iJavaProject, string7, EMPTY);
        boolean bl2 = Flags.isStatic((int)n);
        boolean bl3 = Flags.isSynchronized((int)n);
        boolean bl4 = Flags.isFinal((int)n);
        String string9 = "\n";
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && (string3 = CodeGeneration.getSetterComment(iField.getCompilationUnit(), iType.getTypeQualifiedName('.'), string, iField.getElementName(), string6, string8, string7, string9)) != null) {
            stringBuffer.append(string3);
            stringBuffer.append(string9);
        }
        stringBuffer.append(JdtFlags.getVisibilityString(n));
        stringBuffer.append(' ');
        if (bl2) {
            stringBuffer.append("static ");
        }
        if (bl3) {
            stringBuffer.append("synchronized ");
        }
        if (bl4) {
            stringBuffer.append("final ");
        }
        stringBuffer.append("void ");
        stringBuffer.append(string);
        stringBuffer.append('(');
        stringBuffer.append(string6);
        stringBuffer.append(' ');
        stringBuffer.append(string8);
        stringBuffer.append(") {");
        stringBuffer.append(string9);
        boolean bl5 = StubUtility.useThisForFieldAccess(iJavaProject);
        if (string8.equals(string4) || bl5 && !bl2) {
            string4 = bl2 ? String.valueOf(iType.getElementName()) + '.' + string4 : "this." + string4;
        }
        if ((string2 = CodeGeneration.getSetterMethodBodyContent(iField.getCompilationUnit(), iType.getTypeQualifiedName('.'), string, string4, string8, string9)) != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("}");
        stringBuffer.append(string9);
        return stringBuffer.toString();
    }

    public static String getGetterStub(IField iField, String string, boolean bl, int n) throws CoreException {
        String string2;
        String string3;
        String string4 = iField.getElementName();
        IType iType = iField.getDeclaringType();
        boolean bl2 = Flags.isStatic((int)n);
        boolean bl3 = Flags.isSynchronized((int)n);
        boolean bl4 = Flags.isFinal((int)n);
        String string5 = Signature.toString((String)iField.getTypeSignature());
        String string6 = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)iField.getJavaProject(), (String)string4, (int)iField.getFlags());
        String string7 = "\n";
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && (string3 = CodeGeneration.getGetterComment(iField.getCompilationUnit(), iType.getTypeQualifiedName('.'), string, iField.getElementName(), string5, string6, string7)) != null) {
            stringBuffer.append(string3);
            stringBuffer.append(string7);
        }
        stringBuffer.append(JdtFlags.getVisibilityString(n));
        stringBuffer.append(' ');
        if (bl2) {
            stringBuffer.append("static ");
        }
        if (bl3) {
            stringBuffer.append("synchronized ");
        }
        if (bl4) {
            stringBuffer.append("final ");
        }
        stringBuffer.append(string5);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append("() {");
        stringBuffer.append(string7);
        boolean bl5 = StubUtility.useThisForFieldAccess(iField.getJavaProject());
        if (bl5 && !bl2) {
            string4 = "this." + string4;
        }
        if ((string2 = CodeGeneration.getGetterMethodBodyContent(iField.getCompilationUnit(), iType.getTypeQualifiedName('.'), string, string4, string7)) != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("}");
        stringBuffer.append(string7);
        return stringBuffer.toString();
    }
}

