/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Message;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTFlattener;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class ASTNodes {
    public static final int NODE_ONLY = 0;
    public static final int INCLUDE_FIRST_PARENT = 1;
    public static final int INCLUDE_ALL_PARENTS = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int PROBLEMS = 3;
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    private static final int CLEAR_VISIBILITY = -8;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private ASTNodes() {
    }

    public static String asString(ASTNode aSTNode) {
        ASTFlattener aSTFlattener = new ASTFlattener();
        aSTNode.accept((ASTVisitor)aSTFlattener);
        return aSTFlattener.getResult();
    }

    public static String asFormattedString(ASTNode aSTNode, int n, String string, Map map) {
        String string2 = ASTNodes.asString(aSTNode);
        TextEdit textEdit = CodeFormatterUtil.format2(aSTNode, string2, n, string, map);
        if (textEdit != null) {
            return CodeFormatterUtil.evaluateFormatterEdit(string2, textEdit, null);
        }
        return string2;
    }

    public static List getContainingList(ASTNode aSTNode) {
        StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
        if (structuralPropertyDescriptor != null && structuralPropertyDescriptor.isChildListProperty()) {
            return (List)aSTNode.getParent().getStructuralProperty(structuralPropertyDescriptor);
        }
        return null;
    }

    public static List getChildren(ASTNode aSTNode) {
        ChildrenCollector childrenCollector = new ChildrenCollector();
        aSTNode.accept((ASTVisitor)childrenCollector);
        return childrenCollector.result;
    }

    public static boolean isExistingNode(ASTNode aSTNode) {
        return aSTNode.getStartPosition() != -1;
    }

    public static Type getElementType(Type type) {
        if (!type.isArrayType()) {
            return type;
        }
        return ((ArrayType)type).getElementType();
    }

    public static ASTNode findDeclaration(IBinding iBinding, ASTNode aSTNode) {
        if ((aSTNode = aSTNode.getRoot()) instanceof CompilationUnit) {
            return ((CompilationUnit)aSTNode).findDeclaringNode(iBinding);
        }
        return null;
    }

    public static VariableDeclaration findVariableDeclaration(IVariableBinding iVariableBinding, ASTNode aSTNode) {
        if (iVariableBinding.isField()) {
            return null;
        }
        ASTNode aSTNode2 = ASTNodes.findDeclaration((IBinding)iVariableBinding, aSTNode);
        if (aSTNode2 instanceof VariableDeclaration) {
            return (VariableDeclaration)aSTNode2;
        }
        return null;
    }

    public static Type getType(VariableDeclaration variableDeclaration) {
        if (variableDeclaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)variableDeclaration).getType();
        }
        if (variableDeclaration instanceof VariableDeclarationFragment) {
            ASTNode aSTNode = ((VariableDeclarationFragment)variableDeclaration).getParent();
            if (aSTNode instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)aSTNode).getType();
            }
            if (aSTNode instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)aSTNode).getType();
            }
            if (aSTNode instanceof FieldDeclaration) {
                return ((FieldDeclaration)aSTNode).getType();
            }
        }
        Assert.isTrue((boolean)false, (String)"Unknown VariableDeclaration");
        return null;
    }

    public static int getDimensions(VariableDeclaration variableDeclaration) {
        int n = variableDeclaration.getExtraDimensions();
        Type type = ASTNodes.getType(variableDeclaration);
        if (type instanceof ArrayType) {
            n += ((ArrayType)type).getDimensions();
        }
        return n;
    }

    public static List getModifiers(VariableDeclaration variableDeclaration) {
        Assert.isNotNull((Object)variableDeclaration);
        if (variableDeclaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)variableDeclaration).modifiers();
        }
        if (variableDeclaration instanceof VariableDeclarationFragment) {
            ASTNode aSTNode = variableDeclaration.getParent();
            if (aSTNode instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)aSTNode).modifiers();
            }
            if (aSTNode instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)aSTNode).modifiers();
            }
        }
        return new ArrayList(0);
    }

    public static boolean isSingleDeclaration(VariableDeclaration variableDeclaration) {
        Assert.isNotNull((Object)variableDeclaration);
        if (variableDeclaration instanceof SingleVariableDeclaration) {
            return true;
        }
        if (variableDeclaration instanceof VariableDeclarationFragment) {
            ASTNode aSTNode = variableDeclaration.getParent();
            if (aSTNode instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)aSTNode).fragments().size() == 1;
            }
            if (aSTNode instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)aSTNode).fragments().size() == 1;
            }
        }
        return false;
    }

    public static boolean isLiteral(Expression expression) {
        int n = expression.getNodeType();
        return n == 9 || n == 13 || n == 33 || n == 34 || n == 45 || n == 57 || n == 87 || n == 85 || n == 88;
    }

    public static boolean isLabel(SimpleName simpleName) {
        int n = simpleName.getParent().getNodeType();
        return n == 30 || n == 10 || n != 18;
    }

    public static boolean isStatic(BodyDeclaration bodyDeclaration) {
        return Modifier.isStatic((int)bodyDeclaration.getModifiers());
    }

    public static List getBodyDeclarations(ASTNode aSTNode) {
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)aSTNode).bodyDeclarations();
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            return ((AnonymousClassDeclaration)aSTNode).bodyDeclarations();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static ChildListPropertyDescriptor getBodyDeclarationsProperty(ASTNode aSTNode) {
        if (aSTNode instanceof CompilationUnit) {
            return CompilationUnit.STATEMENTS_PROPERTY;
        }
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty();
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static String getTypeName(Type type) {
        final StringBuffer stringBuffer = new StringBuffer();
        ASTVisitor aSTVisitor = new ASTVisitor(){

            public boolean visit(PrimitiveType primitiveType) {
                stringBuffer.append(primitiveType.getPrimitiveTypeCode().toString());
                return false;
            }

            public boolean visit(SimpleName simpleName) {
                stringBuffer.append(simpleName.getIdentifier());
                return false;
            }

            public boolean visit(QualifiedName qualifiedName) {
                stringBuffer.append(qualifiedName.getName().getIdentifier());
                return false;
            }

            public void endVisit(ArrayType arrayType) {
                stringBuffer.append("[]");
            }
        };
        type.accept(aSTVisitor);
        return stringBuffer.toString();
    }

    public static InfixExpression.Operator convertToInfixOperator(Assignment.Operator operator) {
        if (operator.equals(Assignment.Operator.PLUS_ASSIGN)) {
            return InfixExpression.Operator.PLUS;
        }
        if (operator.equals(Assignment.Operator.MINUS_ASSIGN)) {
            return InfixExpression.Operator.MINUS;
        }
        if (operator.equals(Assignment.Operator.TIMES_ASSIGN)) {
            return InfixExpression.Operator.TIMES;
        }
        if (operator.equals(Assignment.Operator.DIVIDE_ASSIGN)) {
            return InfixExpression.Operator.DIVIDE;
        }
        if (operator.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return InfixExpression.Operator.AND;
        }
        if (operator.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return InfixExpression.Operator.OR;
        }
        if (operator.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return InfixExpression.Operator.XOR;
        }
        if (operator.equals(Assignment.Operator.REMAINDER_ASSIGN)) {
            return InfixExpression.Operator.REMAINDER;
        }
        if (operator.equals(Assignment.Operator.LEFT_SHIFT_ASSIGN)) {
            return InfixExpression.Operator.LEFT_SHIFT;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
        }
        Assert.isTrue((boolean)false, (String)"Cannot convert assignment operator");
        return null;
    }

    public static boolean isControlStatementBody(StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return structuralPropertyDescriptor == IfStatement.THEN_STATEMENT_PROPERTY || structuralPropertyDescriptor == IfStatement.ELSE_STATEMENT_PROPERTY || structuralPropertyDescriptor == ForStatement.BODY_PROPERTY || structuralPropertyDescriptor == ForInStatement.BODY_PROPERTY || structuralPropertyDescriptor == EnhancedForStatement.BODY_PROPERTY || structuralPropertyDescriptor == WhileStatement.BODY_PROPERTY || structuralPropertyDescriptor == DoStatement.BODY_PROPERTY;
    }

    public static boolean needsParentheses(Expression expression) {
        int n = expression.getNodeType();
        return n == 27 || n == 16 || n == 38 || n == 37 || n == 11 || n == 62;
    }

    public static boolean substituteMustBeParenthesized(Expression expression, Expression expression2) {
        MethodInvocation methodInvocation;
        VariableDeclarationFragment variableDeclarationFragment;
        if (!ASTNodes.needsParentheses(expression)) {
            return false;
        }
        ASTNode aSTNode = expression2.getParent();
        return !(aSTNode instanceof VariableDeclarationFragment ? (variableDeclarationFragment = (VariableDeclarationFragment)aSTNode).getInitializer().equals((Object)expression2) : (aSTNode instanceof MethodInvocation ? (methodInvocation = (MethodInvocation)aSTNode).arguments().contains(expression2) : aSTNode instanceof ReturnStatement));
    }

    public static ASTNode getParent(ASTNode aSTNode, Class clazz) {
        while ((aSTNode = aSTNode.getParent()) != null && !clazz.isInstance(aSTNode)) {
        }
        return aSTNode;
    }

    public static ASTNode getParent(ASTNode aSTNode, int n) {
        while ((aSTNode = aSTNode.getParent()) != null && aSTNode.getNodeType() != n) {
        }
        return aSTNode;
    }

    public static ASTNode findParent(ASTNode aSTNode, StructuralPropertyDescriptor[][] structuralPropertyDescriptorArray) {
        int n = 0;
        while (n < structuralPropertyDescriptorArray.length) {
            StructuralPropertyDescriptor[] structuralPropertyDescriptorArray2 = structuralPropertyDescriptorArray[n];
            ASTNode aSTNode2 = aSTNode;
            int n2 = structuralPropertyDescriptorArray2.length - 1;
            while (n2 >= 0 && aSTNode2 != null) {
                StructuralPropertyDescriptor structuralPropertyDescriptor = structuralPropertyDescriptorArray2[n2];
                if (!structuralPropertyDescriptor.equals(aSTNode2.getLocationInParent())) break;
                aSTNode2 = aSTNode2.getParent();
                --n2;
            }
            if (n2 < 0) {
                return aSTNode2;
            }
            ++n;
        }
        return null;
    }

    public static ASTNode getNormalizedNode(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode;
        if (QualifiedName.NAME_PROPERTY.equals(aSTNode2.getLocationInParent())) {
            aSTNode2 = aSTNode2.getParent();
        }
        if (QualifiedType.NAME_PROPERTY.equals(aSTNode2.getLocationInParent()) || SimpleType.NAME_PROPERTY.equals(aSTNode2.getLocationInParent())) {
            aSTNode2 = aSTNode2.getParent();
        }
        if (ParameterizedType.TYPE_PROPERTY.equals(aSTNode2.getLocationInParent())) {
            aSTNode2 = aSTNode2.getParent();
        }
        return aSTNode2;
    }

    public static boolean isParent(ASTNode aSTNode, ASTNode aSTNode2) {
        Assert.isNotNull((Object)aSTNode2);
        do {
            if ((aSTNode = aSTNode.getParent()) != aSTNode2) continue;
            return true;
        } while (aSTNode != null);
        return false;
    }

    public static int getExclusiveEnd(ASTNode aSTNode) {
        return aSTNode.getStartPosition() + aSTNode.getLength();
    }

    public static int getInclusiveEnd(ASTNode aSTNode) {
        return aSTNode.getStartPosition() + aSTNode.getLength() - 1;
    }

    public static IMethodBinding getMethodBinding(Name name) {
        IBinding iBinding = name.resolveBinding();
        if (iBinding instanceof IMethodBinding) {
            return (IMethodBinding)iBinding;
        }
        return null;
    }

    public static IVariableBinding getVariableBinding(Name name) {
        IBinding iBinding = name.resolveBinding();
        if (iBinding instanceof IVariableBinding) {
            return (IVariableBinding)iBinding;
        }
        return null;
    }

    public static IVariableBinding getLocalVariableBinding(Name name) {
        IVariableBinding iVariableBinding = ASTNodes.getVariableBinding(name);
        if (iVariableBinding == null || iVariableBinding.isField()) {
            return null;
        }
        return iVariableBinding;
    }

    public static IVariableBinding getFieldBinding(Name name) {
        IVariableBinding iVariableBinding = ASTNodes.getVariableBinding(name);
        if (iVariableBinding == null || !iVariableBinding.isField()) {
            return null;
        }
        return iVariableBinding;
    }

    public static ITypeBinding getTypeBinding(Name name) {
        IBinding iBinding = name.resolveBinding();
        if (iBinding instanceof ITypeBinding) {
            return (ITypeBinding)iBinding;
        }
        return null;
    }

    public static ITypeBinding getReceiverTypeBinding(MethodInvocation methodInvocation) {
        AbstractTypeDeclaration abstractTypeDeclaration;
        ITypeBinding iTypeBinding = null;
        Expression expression = methodInvocation.getExpression();
        if (expression != null) {
            return expression.resolveTypeBinding();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)methodInvocation, clazz)) != null) {
            return abstractTypeDeclaration.resolveBinding();
        }
        return iTypeBinding;
    }

    public static ITypeBinding getEnclosingType(ASTNode aSTNode) {
        while (aSTNode != null) {
            if (aSTNode instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)aSTNode).resolveBinding();
            }
            if (aSTNode instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)aSTNode).resolveBinding();
            }
            if (aSTNode instanceof CompilationUnit) {
                return ((CompilationUnit)aSTNode).resolveBinding();
            }
            aSTNode = aSTNode.getParent();
        }
        return null;
    }

    public static IProblem[] getProblems(ASTNode aSTNode, int n, int n2) {
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (!(aSTNode2 instanceof CompilationUnit)) {
            return EMPTY_PROBLEMS;
        }
        IProblem[] iProblemArray = ((CompilationUnit)aSTNode2).getProblems();
        if (aSTNode2 == aSTNode) {
            return iProblemArray;
        }
        int n3 = ASTNodes.computeIterations(n);
        ArrayList<IProblem> arrayList = new ArrayList<IProblem>(5);
        int n4 = 0;
        while (n4 < iProblemArray.length) {
            IProblem iProblem = iProblemArray[n4];
            boolean bl = false;
            if ((n2 & 3) == 3) {
                bl = true;
            } else if ((n2 & 1) != 0) {
                bl = iProblem.isWarning();
            } else if ((n2 & 2) != 0) {
                bl = iProblem.isError();
            }
            if (bl) {
                ASTNode aSTNode3 = aSTNode;
                int n5 = n3;
                do {
                    int n6;
                    int n7;
                    if ((n7 = aSTNode3.getStartPosition()) <= (n6 = iProblem.getSourceStart()) && n6 < n7 + aSTNode3.getLength()) {
                        arrayList.add(iProblem);
                        n5 = 0;
                        continue;
                    }
                    --n5;
                } while ((aSTNode3 = aSTNode3.getParent()) != null && n5 > 0);
            }
            ++n4;
        }
        return arrayList.toArray(new IProblem[arrayList.size()]);
    }

    public static Message[] getMessages(ASTNode aSTNode, int n) {
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (!(aSTNode2 instanceof CompilationUnit)) {
            return EMPTY_MESSAGES;
        }
        Message[] messageArray = ((CompilationUnit)aSTNode2).getMessages();
        if (aSTNode2 == aSTNode) {
            return messageArray;
        }
        int n2 = ASTNodes.computeIterations(n);
        ArrayList<Message> arrayList = new ArrayList<Message>(5);
        int n3 = 0;
        while (n3 < messageArray.length) {
            Message message = messageArray[n3];
            ASTNode aSTNode3 = aSTNode;
            int n4 = n2;
            do {
                int n5;
                int n6;
                if ((n6 = aSTNode3.getStartPosition()) <= (n5 = message.getStartPosition()) && n5 < n6 + aSTNode3.getLength()) {
                    arrayList.add(message);
                    n4 = 0;
                    continue;
                }
                --n4;
            } while ((aSTNode3 = aSTNode3.getParent()) != null && n4 > 0);
            ++n3;
        }
        return arrayList.toArray(new Message[arrayList.size()]);
    }

    private static int computeIterations(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    private static int getOrderPreference(BodyDeclaration bodyDeclaration, MembersOrderPreferenceCache membersOrderPreferenceCache) {
        int n = bodyDeclaration.getNodeType();
        int n2 = bodyDeclaration.getModifiers();
        switch (n) {
            case 55: 
            case 71: 
            case 81: {
                return membersOrderPreferenceCache.getCategoryIndex(0) * 2;
            }
            case 23: {
                if (Modifier.isStatic((int)n2)) {
                    int n3 = membersOrderPreferenceCache.getCategoryIndex(5) * 2;
                    if (Modifier.isFinal((int)n2)) {
                        return n3;
                    }
                    return n3 + 1;
                }
                return membersOrderPreferenceCache.getCategoryIndex(3) * 2;
            }
            case 28: {
                if (Modifier.isStatic((int)n2)) {
                    return membersOrderPreferenceCache.getCategoryIndex(6) * 2;
                }
                return membersOrderPreferenceCache.getCategoryIndex(4) * 2;
            }
            case 82: {
                return membersOrderPreferenceCache.getCategoryIndex(2) * 2;
            }
            case 31: {
                if (Modifier.isStatic((int)n2)) {
                    return membersOrderPreferenceCache.getCategoryIndex(7) * 2;
                }
                if (((MethodDeclaration)bodyDeclaration).isConstructor()) {
                    return membersOrderPreferenceCache.getCategoryIndex(1) * 2;
                }
                return membersOrderPreferenceCache.getCategoryIndex(2) * 2;
            }
        }
        return 100;
    }

    public static int getInsertionIndex(BodyDeclaration bodyDeclaration, List list) {
        int n = list.size();
        MembersOrderPreferenceCache membersOrderPreferenceCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
        int n2 = ASTNodes.getOrderPreference(bodyDeclaration, membersOrderPreferenceCache);
        int n3 = n;
        int n4 = -1;
        int n5 = n - 1;
        while (n5 >= 0) {
            int n6 = ASTNodes.getOrderPreference((BodyDeclaration)list.get(n5), membersOrderPreferenceCache);
            if (n2 == n6) {
                if (n4 != n2) {
                    n3 = n5 + 1;
                    n4 = n2;
                }
            } else if (n4 != n2) {
                if (n6 < n2) {
                    if (n4 == -1) {
                        n3 = n5 + 1;
                        n4 = n6;
                    }
                } else {
                    n3 = n5;
                    n4 = n6;
                }
            }
            --n5;
        }
        return n3;
    }

    public static SimpleName getLeftMostSimpleName(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        final SimpleName[] simpleNameArray = new SimpleName[1];
        ASTVisitor aSTVisitor = new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                Name name = qualifiedName.getQualifier();
                if (name instanceof SimpleName) {
                    simpleNameArray[0] = (SimpleName)name;
                } else {
                    name.accept((ASTVisitor)this);
                }
                return false;
            }
        };
        name.accept(aSTVisitor);
        return simpleNameArray[0];
    }

    public static SimpleType getLeftMostSimpleType(QualifiedType qualifiedType) {
        final SimpleType[] simpleTypeArray = new SimpleType[1];
        ASTVisitor aSTVisitor = new ASTVisitor(){

            public boolean visit(QualifiedType qualifiedType) {
                Type type = qualifiedType.getQualifier();
                if (type instanceof SimpleType) {
                    simpleTypeArray[0] = (SimpleType)type;
                } else {
                    type.accept((ASTVisitor)this);
                }
                return false;
            }
        };
        qualifiedType.accept(aSTVisitor);
        return simpleTypeArray[0];
    }

    public static Name getTopMostName(Name name) {
        Name name2 = name;
        while (name2.getParent() instanceof Name) {
            name2 = (Name)name2.getParent();
        }
        return name2;
    }

    public static Type getTopMostType(Type type) {
        Type type2 = type;
        while (type2.getParent() instanceof Type) {
            type2 = (Type)type2.getParent();
        }
        return type2;
    }

    public static int changeVisibility(int n, int n2) {
        return n & 0xFFFFFFF8 | n2;
    }

    public static void setFlagsToAST(ASTNode aSTNode, final int n) {
        aSTNode.accept((ASTVisitor)new GenericVisitor(true){

            protected boolean visitNode(ASTNode aSTNode) {
                aSTNode.setFlags(aSTNode.getFlags() | n);
                return true;
            }
        });
    }

    public static String getQualifier(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getQualifier().getFullyQualifiedName();
        }
        return "";
    }

    public static String getSimpleNameIdentifier(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().getIdentifier();
        }
        return ((SimpleName)name).getIdentifier();
    }

    public static boolean isDeclaration(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().isDeclaration();
        }
        return ((SimpleName)name).isDeclaration();
    }

    public static Modifier findModifierNode(int n, List list) {
        int n2 = 0;
        while (n2 < list.size()) {
            Object e = list.get(n2);
            if (e instanceof Modifier && ((Modifier)e).getKeyword().toFlagValue() == n) {
                return (Modifier)e;
            }
            ++n2;
        }
        return null;
    }

    public static ITypeBinding getTypeBinding(CompilationUnit compilationUnit, IType iType) throws JavaModelException {
        if (iType.isAnonymous()) {
            IJavaElement iJavaElement = iType.getParent();
            if (iJavaElement instanceof IField && Flags.isEnum((int)((IMember)iJavaElement).getFlags())) {
                AnonymousClassDeclaration anonymousClassDeclaration;
                EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)NodeFinder.perform((ASTNode)compilationUnit, ((ISourceReference)iJavaElement).getSourceRange());
                if (enumConstantDeclaration != null && (anonymousClassDeclaration = enumConstantDeclaration.getAnonymousClassDeclaration()) != null) {
                    return anonymousClassDeclaration.resolveBinding();
                }
            } else {
                ClassInstanceCreation classInstanceCreation;
                ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, iType.getNameRange());
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((classInstanceCreation = (ClassInstanceCreation)ASTNodes.getParent(aSTNode, clazz)) != null) {
                    return classInstanceCreation.resolveTypeBinding();
                }
            }
        } else {
            AbstractTypeDeclaration abstractTypeDeclaration;
            ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, iType.getNameRange());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
                return abstractTypeDeclaration.resolveBinding();
            }
        }
        return null;
    }

    private static class ChildrenCollector
    extends GenericVisitor {
        public List result = null;

        public ChildrenCollector() {
            super(true);
        }

        protected boolean visitNode(ASTNode aSTNode) {
            if (this.result == null) {
                this.result = new ArrayList();
                return true;
            }
            this.result.add(aSTNode);
            return false;
        }
    }
}

