/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.List;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;

public class ModifierRewrite {
    public static final int VISIBILITY_MODIFIERS = 7;
    private ListRewrite fModifierRewrite;
    private AST fAst;

    public static ModifierRewrite create(ASTRewrite aSTRewrite, ASTNode aSTNode) {
        return new ModifierRewrite(aSTRewrite, aSTNode);
    }

    private ModifierRewrite(ASTRewrite aSTRewrite, ASTNode aSTNode) {
        this.fModifierRewrite = this.evaluateListRewrite(aSTRewrite, aSTNode);
        this.fAst = aSTNode.getAST();
    }

    private ListRewrite evaluateListRewrite(ASTRewrite aSTRewrite, ASTNode aSTNode) {
        switch (aSTNode.getNodeType()) {
            case 31: {
                return aSTRewrite.getListRewrite(aSTNode, MethodDeclaration.MODIFIERS2_PROPERTY);
            }
            case 23: {
                return aSTRewrite.getListRewrite(aSTNode, FieldDeclaration.MODIFIERS2_PROPERTY);
            }
            case 58: {
                return aSTRewrite.getListRewrite(aSTNode, VariableDeclarationExpression.MODIFIERS2_PROPERTY);
            }
            case 60: {
                return aSTRewrite.getListRewrite(aSTNode, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
            }
            case 44: {
                return aSTRewrite.getListRewrite(aSTNode, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            }
            case 55: {
                return aSTRewrite.getListRewrite(aSTNode, TypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 71: {
                return aSTRewrite.getListRewrite(aSTNode, EnumDeclaration.MODIFIERS2_PROPERTY);
            }
            case 81: {
                return aSTRewrite.getListRewrite(aSTNode, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 72: {
                return aSTRewrite.getListRewrite(aSTNode, EnumConstantDeclaration.MODIFIERS2_PROPERTY);
            }
            case 82: {
                return aSTRewrite.getListRewrite(aSTNode, AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY);
            }
        }
        throw new IllegalArgumentException("node has no modifiers: " + aSTNode.getClass().getName());
    }

    public ListRewrite getModifierRewrite() {
        return this.fModifierRewrite;
    }

    public void setModifiers(int n, TextEditGroup textEditGroup) {
        this.internalSetModifiers(n, -1, textEditGroup);
    }

    public void setModifiers(int n, int n2, TextEditGroup textEditGroup) {
        this.internalSetModifiers(n, n | n2, textEditGroup);
    }

    public void setVisibility(int n, TextEditGroup textEditGroup) {
        this.internalSetModifiers(n, 7, textEditGroup);
    }

    public void copyAllModifiers(ASTNode aSTNode, TextEditGroup textEditGroup) {
        ListRewrite listRewrite = this.evaluateListRewrite(this.fModifierRewrite.getASTRewrite(), aSTNode);
        List list = listRewrite.getOriginalList();
        if (list.isEmpty()) {
            return;
        }
        ASTNode aSTNode2 = listRewrite.createCopyTarget((ASTNode)list.get(0), (ASTNode)list.get(list.size() - 1));
        if (aSTNode2 != null) {
            this.fModifierRewrite.insertLast(aSTNode2, textEditGroup);
        }
    }

    private void internalSetModifiers(int n, int n2, TextEditGroup textEditGroup) {
    }
}

