/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;

public class TokenScanner {
    public static final int END_OF_FILE = 20001;
    public static final int LEXICAL_ERROR = 20002;
    public static final int DOCUMENT_ERROR = 20003;
    private IScanner fScanner;
    private IDocument fDocument;
    private int fEndPosition;

    public TokenScanner(IScanner iScanner) {
        this(iScanner, null);
    }

    public TokenScanner(IScanner iScanner, IDocument iDocument) {
        this.fScanner = iScanner;
        this.fEndPosition = this.fScanner.getSource().length - 1;
        this.fDocument = iDocument;
    }

    public TokenScanner(IDocument iDocument, IJavaProject iJavaProject) {
        String string = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (String)string, (String)string2);
        this.fScanner.setSource(iDocument.get().toCharArray());
        this.fDocument = iDocument;
        this.fEndPosition = this.fScanner.getSource().length - 1;
    }

    public TokenScanner(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        String string = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)true, (String)string, (String)string2);
        this.fScanner.setSource(iCompilationUnit.getBuffer().getCharacters());
        this.fDocument = null;
        this.fEndPosition = this.fScanner.getSource().length - 1;
    }

    public IScanner getScanner() {
        return this.fScanner;
    }

    public void setOffset(int n) {
        this.fScanner.resetTo(n, this.fEndPosition);
    }

    public int getCurrentEndOffset() {
        return this.fScanner.getCurrentTokenEndPosition() + 1;
    }

    public int getCurrentStartOffset() {
        return this.fScanner.getCurrentTokenStartPosition();
    }

    public int getCurrentLength() {
        return this.getCurrentEndOffset() - this.getCurrentStartOffset();
    }

    public int readNext(boolean bl) throws CoreException {
        int n = 0;
        do {
            try {
                n = this.fScanner.getNextToken();
                if (n == 158) {
                    throw new CoreException(this.createError(20001, "End Of File", null));
                }
            }
            catch (InvalidInputException invalidInputException) {
                throw new CoreException(this.createError(20002, invalidInputException.getMessage(), invalidInputException));
            }
        } while (bl && TokenScanner.isComment(n));
        return n;
    }

    private int readNextWithEOF(boolean bl) throws CoreException {
        int n = 0;
        do {
            try {
                n = this.fScanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                throw new CoreException(this.createError(20002, invalidInputException.getMessage(), invalidInputException));
            }
        } while (bl && TokenScanner.isComment(n));
        return n;
    }

    public int readNext(int n, boolean bl) throws CoreException {
        this.setOffset(n);
        return this.readNext(bl);
    }

    public int getNextStartOffset(int n, boolean bl) throws CoreException {
        this.readNext(n, bl);
        return this.getCurrentStartOffset();
    }

    public int getNextEndOffset(int n, boolean bl) throws CoreException {
        this.readNext(n, bl);
        return this.getCurrentEndOffset();
    }

    public void readToToken(int n) throws CoreException {
        int n2 = 0;
        while ((n2 = this.readNext(false)) != n) {
        }
    }

    public void readToToken(int n, int n2) throws CoreException {
        this.setOffset(n2);
        this.readToToken(n);
    }

    public int getTokenStartOffset(int n, int n2) throws CoreException {
        this.readToToken(n, n2);
        return this.getCurrentStartOffset();
    }

    public int getTokenEndOffset(int n, int n2) throws CoreException {
        this.readToToken(n, n2);
        return this.getCurrentEndOffset();
    }

    public int getPreviousTokenEndOffset(int n, int n2) throws CoreException {
        this.setOffset(n2);
        int n3 = n2;
        int n4 = this.readNext(false);
        while (n4 != n) {
            n3 = this.getCurrentEndOffset();
            n4 = this.readNext(false);
        }
        return n3;
    }

    public int getTokenCommentStart(int n, int n2) throws CoreException {
        this.setOffset(n);
        int n3 = n;
        int n4 = n3 > 0 ? this.getLineOfOffset(n3 - 1) : 0;
        int n5 = this.getLineOfOffset(n2);
        int n6 = -1;
        int n7 = this.readNextWithEOF(false);
        int n8 = this.getCurrentStartOffset();
        int n9 = this.getLineOfOffset(n8);
        while (n7 != 158 && n2 > n8) {
            if (TokenScanner.isComment(n7)) {
                int n10 = n9 - n4;
                if (n10 > 1 || n6 == -1 && (n10 != 0 || n5 == n9)) {
                    n6 = n8;
                }
            } else {
                n6 = -1;
            }
            n4 = n7 == 1001 ? n9 : this.getLineOfOffset(this.getCurrentEndOffset() - 1);
            n7 = this.readNextWithEOF(false);
            n8 = this.getCurrentStartOffset();
            n9 = this.getLineOfOffset(n8);
        }
        if (n6 == -1 || n7 == 158) {
            return n2;
        }
        if (n9 - n4 > 1) {
            return n2;
        }
        return n6;
    }

    public int getTokenCommentEnd(int n, int n2) throws CoreException {
        int n3;
        int n4;
        int n5 = this.getLineOfOffset(n - 1);
        int n6 = n;
        int n7 = n;
        boolean bl = true;
        this.setOffset(n);
        int n8 = this.readNextWithEOF(false);
        while (n8 == 1001 || n8 == 1002) {
            n4 = this.getLineOfOffset(this.getCurrentStartOffset());
            n3 = n4 - n5;
            if (n3 > 1) {
                return n6;
            }
            if (n8 == 1001) {
                n6 = this.getLineEnd(n4);
                n5 = n4;
            } else {
                n6 = this.getCurrentEndOffset();
                n5 = this.getLineOfOffset(n6 - 1);
            }
            if (bl) {
                if (n3 == 0) {
                    n7 = n6;
                } else {
                    bl = false;
                }
            }
            n8 = this.readNextWithEOF(false);
        }
        if (n8 == 158) {
            return n6;
        }
        n4 = this.getLineOfOffset(this.getCurrentStartOffset());
        n3 = n4 - n5;
        if (n3 > 1) {
            return n6;
        }
        return n7;
    }

    public int getLineOfOffset(int n) throws CoreException {
        if (this.fDocument != null) {
            try {
                return this.fDocument.getLineOfOffset(n);
            }
            catch (BadLocationException badLocationException) {
                String string = "Illegal offset: " + n;
                throw new CoreException(this.createError(20003, string, badLocationException));
            }
        }
        return this.getScanner().getLineNumber(n);
    }

    public int getLineEnd(int n) throws CoreException {
        if (this.fDocument != null) {
            try {
                IRegion iRegion = this.fDocument.getLineInformation(n);
                return iRegion.getOffset() + iRegion.getLength();
            }
            catch (BadLocationException badLocationException) {
                String string = "Illegal line: " + n;
                throw new CoreException(this.createError(20003, string, badLocationException));
            }
        }
        return this.getScanner().getLineEnd(n);
    }

    public static boolean isComment(int n) {
        return n == 1002 || n == 1003 || n == 1001;
    }

    public static boolean isModifier(int n) {
        switch (n) {
            case 85: 
            case 94: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return true;
            }
        }
        return false;
    }

    private IStatus createError(int n, String string, Throwable throwable) {
        return JavaUIStatus.createError(20003, string, throwable);
    }
}

