/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;

public class TypeRules {
    public static boolean canAssignPrimitive(PrimitiveType.Code code, PrimitiveType.Code code2) {
        if (code == code2) {
            return true;
        }
        if (code2 == PrimitiveType.BOOLEAN || code == PrimitiveType.BOOLEAN) {
            return false;
        }
        if (code2 == PrimitiveType.CHAR && code == PrimitiveType.BYTE) {
            return false;
        }
        return TypeRules.getTypeOrder(code2) > TypeRules.getTypeOrder(code);
    }

    public static boolean canAssign(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        String string = PrimitiveType.VOID.toString();
        if (string.equals(iTypeBinding.getName()) || string.equals(iTypeBinding2.getName())) {
            return false;
        }
        if (iTypeBinding.isNullType()) {
            return !iTypeBinding2.isPrimitive();
        }
        if (iTypeBinding2.isArray()) {
            int n;
            if (!iTypeBinding.isArray()) {
                return false;
            }
            int n2 = iTypeBinding2.getDimensions();
            if (n2 == (n = iTypeBinding.getDimensions())) {
                iTypeBinding2 = iTypeBinding2.getElementType();
                if ((iTypeBinding = iTypeBinding.getElementType()).isPrimitive() && iTypeBinding != iTypeBinding2) {
                    return false;
                }
            } else {
                if (n2 < n) {
                    return TypeRules.isArrayCompatible(iTypeBinding2.getElementType());
                }
                return false;
            }
        }
        if (iTypeBinding.isPrimitive()) {
            if (!iTypeBinding2.isPrimitive()) {
                return false;
            }
            PrimitiveType.Code code = PrimitiveType.toCode((String)iTypeBinding.getName());
            PrimitiveType.Code code2 = PrimitiveType.toCode((String)iTypeBinding2.getName());
            return TypeRules.canAssignPrimitive(code, code2);
        }
        if (iTypeBinding2.isPrimitive()) {
            return false;
        }
        if (iTypeBinding.isArray()) {
            return TypeRules.isArrayCompatible(iTypeBinding2);
        }
        if (TypeRules.isJavaLangObject(iTypeBinding2)) {
            return true;
        }
        return Bindings.isSuperType(iTypeBinding2, iTypeBinding);
    }

    private static int getTypeOrder(PrimitiveType.Code code) {
        if (code == PrimitiveType.BYTE) {
            return 2;
        }
        if (code == PrimitiveType.CHAR) {
            return 3;
        }
        if (code == PrimitiveType.SHORT) {
            return 3;
        }
        if (code == PrimitiveType.INT) {
            return 4;
        }
        if (code == PrimitiveType.LONG) {
            return 5;
        }
        if (code == PrimitiveType.FLOAT) {
            return 6;
        }
        if (code == PrimitiveType.DOUBLE) {
            return 7;
        }
        return 0;
    }

    public static boolean isArrayCompatible(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isTopLevel()) {
            if (iTypeBinding.isClass()) {
                return "Object".equals(iTypeBinding.getName()) && "java.lang".equals(iTypeBinding.getPackage().getName());
            }
            String string = iTypeBinding.getQualifiedName();
            return "java.io.Serializable".equals(string) || "java.lang.Cloneable".equals(string);
        }
        return false;
    }

    public static boolean isJavaLangObject(ITypeBinding iTypeBinding) {
        return iTypeBinding.isTopLevel() && iTypeBinding.isClass() && "Object".equals(iTypeBinding.getName()) && "java.lang".equals(iTypeBinding.getPackage().getName());
    }

    public static boolean canCast(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        String string = PrimitiveType.VOID.toString();
        if (iTypeBinding.isAnonymous() || iTypeBinding.isNullType() || string.equals(iTypeBinding.getName())) {
            throw new IllegalArgumentException();
        }
        if (iTypeBinding == iTypeBinding2) {
            return true;
        }
        if (string.equals(iTypeBinding2.getName())) {
            return false;
        }
        if (iTypeBinding2.isArray()) {
            int n;
            if (!iTypeBinding.isArray()) {
                return TypeRules.isArrayCompatible(iTypeBinding);
            }
            int n2 = iTypeBinding2.getDimensions();
            if (n2 == (n = iTypeBinding.getDimensions())) {
                iTypeBinding2 = iTypeBinding2.getElementType();
                if ((iTypeBinding = iTypeBinding.getElementType()).isPrimitive() && iTypeBinding != iTypeBinding2) {
                    return false;
                }
            } else {
                if (n2 < n) {
                    return TypeRules.isArrayCompatible(iTypeBinding2.getElementType());
                }
                return TypeRules.isArrayCompatible(iTypeBinding.getElementType());
            }
        }
        if (iTypeBinding.isPrimitive()) {
            if (!iTypeBinding2.isPrimitive()) {
                return false;
            }
            String string2 = PrimitiveType.BOOLEAN.toString();
            return !string2.equals(iTypeBinding.getName()) && !string2.equals(iTypeBinding2.getName());
        }
        if (iTypeBinding2.isPrimitive()) {
            return false;
        }
        if (iTypeBinding.isArray()) {
            return TypeRules.isArrayCompatible(iTypeBinding2);
        }
        if (iTypeBinding.isInterface()) {
            if ((iTypeBinding2.getModifiers() & 0x10) != 0) {
                return Bindings.isSuperType(iTypeBinding, iTypeBinding2);
            }
            return true;
        }
        if (iTypeBinding2.isInterface()) {
            if ((iTypeBinding.getModifiers() & 0x10) != 0) {
                return Bindings.isSuperType(iTypeBinding2, iTypeBinding);
            }
            return true;
        }
        if (TypeRules.isJavaLangObject(iTypeBinding)) {
            return true;
        }
        return Bindings.isSuperType(iTypeBinding2, iTypeBinding) || Bindings.isSuperType(iTypeBinding, iTypeBinding2);
    }
}

