/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom.fragments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.Util;

class AssociativeInfixExpressionFragment
extends ASTFragment
implements IExpressionFragment {
    private final List fOperands;
    private final InfixExpression fGroupRoot;

    public static IExpressionFragment createSubPartFragmentBySourceRange(InfixExpression infixExpression, SourceRange sourceRange, ICompilationUnit iCompilationUnit) throws JavaModelException {
        Assert.isNotNull((Object)infixExpression);
        Assert.isNotNull((Object)sourceRange);
        Assert.isTrue((!sourceRange.covers((ASTNode)infixExpression) ? 1 : 0) != 0);
        Assert.isTrue((boolean)new SourceRange((ASTNode)infixExpression).covers(sourceRange));
        if (!AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)infixExpression)) {
            return null;
        }
        InfixExpression infixExpression2 = AssociativeInfixExpressionFragment.findGroupRoot(infixExpression);
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)infixExpression2));
        ArrayList arrayList = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(infixExpression2);
        List list = AssociativeInfixExpressionFragment.findSubGroupForSourceRange(arrayList, sourceRange);
        if (list.isEmpty() || AssociativeInfixExpressionFragment.rangeIncludesExtraNonWhitespace(sourceRange, list, iCompilationUnit)) {
            return null;
        }
        return new AssociativeInfixExpressionFragment(infixExpression2, list);
    }

    public static IExpressionFragment createFragmentForFullSubtree(InfixExpression infixExpression) {
        Assert.isNotNull((Object)infixExpression);
        if (!AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)infixExpression)) {
            return null;
        }
        InfixExpression infixExpression2 = AssociativeInfixExpressionFragment.findGroupRoot(infixExpression);
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)infixExpression2));
        ArrayList arrayList = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(infixExpression);
        return new AssociativeInfixExpressionFragment(infixExpression2, arrayList);
    }

    private static InfixExpression findGroupRoot(InfixExpression infixExpression) {
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)infixExpression));
        while (!AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)infixExpression)) {
            ASTNode aSTNode = infixExpression.getParent();
            Assert.isNotNull((Object)aSTNode);
            Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix(aSTNode));
            Assert.isTrue((((InfixExpression)aSTNode).getOperator() == infixExpression.getOperator() ? 1 : 0) != 0);
            infixExpression = (InfixExpression)aSTNode;
        }
        return infixExpression;
    }

    private static List findSubGroupForSourceRange(List list, SourceRange sourceRange) {
        Assert.isTrue((!list.isEmpty() ? 1 : 0) != 0);
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        boolean bl = false;
        boolean bl2 = false;
        if (sourceRange.getOffset() == ((ASTNode)list.get(0)).getStartPosition()) {
            bl = true;
        }
        int n = 0;
        while (n < list.size() - 1) {
            ASTNode aSTNode = (ASTNode)list.get(n);
            ASTNode aSTNode2 = (ASTNode)list.get(n + 1);
            if (bl) {
                arrayList.add(aSTNode);
                if (AssociativeInfixExpressionFragment.rangeEndsBetween(sourceRange, aSTNode, aSTNode2)) {
                    bl2 = true;
                    break;
                }
            } else if (AssociativeInfixExpressionFragment.rangeStartsBetween(sourceRange, aSTNode, aSTNode2)) {
                bl = true;
            }
            ++n;
        }
        ASTNode aSTNode = (ASTNode)list.get(list.size() - 1);
        if (sourceRange.getEndExclusive() == new SourceRange(aSTNode).getEndExclusive()) {
            arrayList.add(aSTNode);
            bl2 = true;
        }
        if (!bl2) {
            return new ArrayList(0);
        }
        return arrayList;
    }

    private static boolean rangeStartsBetween(SourceRange sourceRange, ASTNode aSTNode, ASTNode aSTNode2) {
        int n = sourceRange.getOffset();
        return aSTNode.getStartPosition() + aSTNode.getLength() <= n && n <= aSTNode2.getStartPosition();
    }

    private static boolean rangeEndsBetween(SourceRange sourceRange, ASTNode aSTNode, ASTNode aSTNode2) {
        int n = sourceRange.getEndExclusive();
        return aSTNode.getStartPosition() + aSTNode.getLength() <= n && n <= aSTNode2.getStartPosition();
    }

    private static boolean rangeIncludesExtraNonWhitespace(SourceRange sourceRange, List list, ICompilationUnit iCompilationUnit) throws JavaModelException {
        return Util.rangeIncludesNonWhitespaceOutsideRange(sourceRange, AssociativeInfixExpressionFragment.getRangeOfOperands(list), iCompilationUnit.getBuffer());
    }

    private static SourceRange getRangeOfOperands(List list) {
        Expression expression = (Expression)list.get(0);
        Expression expression2 = (Expression)list.get(list.size() - 1);
        return new SourceRange(expression.getStartPosition(), expression2.getStartPosition() + expression2.getLength() - expression.getStartPosition());
    }

    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode aSTNode) {
        IASTFragment iASTFragment = ASTFragmentFactory.createFragmentForFullSubtree(aSTNode);
        if (iASTFragment instanceof AssociativeInfixExpressionFragment) {
            AssociativeInfixExpressionFragment associativeInfixExpressionFragment = (AssociativeInfixExpressionFragment)iASTFragment;
            return associativeInfixExpressionFragment.getSubFragmentsWithMyNodeMatching(this);
        }
        return new IASTFragment[0];
    }

    private static List getMatchingContiguousNodeSubsequences(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            if (AssociativeInfixExpressionFragment.matchesAt(n, list, list2)) {
                arrayList.add(list.subList(n, n + list2.size()));
                n += list2.size();
                continue;
            }
            ++n;
        }
        return arrayList;
    }

    private static boolean matchesAt(int n, List list, List list2) {
        if (n + list2.size() > list.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < list2.size()) {
            if (!JdtASTMatcher.doNodesMatch((ASTNode)list.get(n), (ASTNode)list2.get(n2))) {
                return false;
            }
            ++n2;
            ++n;
        }
        return true;
    }

    private static boolean isAGroupRoot(ASTNode aSTNode) {
        Assert.isNotNull((Object)aSTNode);
        return AssociativeInfixExpressionFragment.isAssociativeInfix(aSTNode) && !AssociativeInfixExpressionFragment.isParentInfixWithSameOperator((InfixExpression)aSTNode);
    }

    private static boolean isAssociativeInfix(ASTNode aSTNode) {
        return aSTNode instanceof InfixExpression && AssociativeInfixExpressionFragment.isOperatorAssociative(((InfixExpression)aSTNode).getOperator());
    }

    private static boolean isParentInfixWithSameOperator(InfixExpression infixExpression) {
        return infixExpression.getParent() instanceof InfixExpression && ((InfixExpression)infixExpression.getParent()).getOperator() == infixExpression.getOperator();
    }

    private static boolean isOperatorAssociative(InfixExpression.Operator operator) {
        return operator == InfixExpression.Operator.PLUS || operator == InfixExpression.Operator.TIMES || operator == InfixExpression.Operator.XOR || operator == InfixExpression.Operator.OR || operator == InfixExpression.Operator.AND || operator == InfixExpression.Operator.CONDITIONAL_OR || operator == InfixExpression.Operator.CONDITIONAL_AND;
    }

    private AssociativeInfixExpressionFragment(InfixExpression infixExpression, List list) {
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)infixExpression));
        Assert.isTrue((list.size() >= 2 ? 1 : 0) != 0);
        this.fGroupRoot = infixExpression;
        this.fOperands = Collections.unmodifiableList(list);
    }

    public boolean matches(IASTFragment iASTFragment) {
        if (!iASTFragment.getClass().equals(this.getClass())) {
            return false;
        }
        AssociativeInfixExpressionFragment associativeInfixExpressionFragment = (AssociativeInfixExpressionFragment)iASTFragment;
        return this.getOperator() == associativeInfixExpressionFragment.getOperator() && this.doOperandsMatch(associativeInfixExpressionFragment);
    }

    private boolean doOperandsMatch(AssociativeInfixExpressionFragment associativeInfixExpressionFragment) {
        if (this.getOperands().size() != associativeInfixExpressionFragment.getOperands().size()) {
            return false;
        }
        Iterator iterator = this.getOperands().iterator();
        Iterator iterator2 = associativeInfixExpressionFragment.getOperands().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            ASTNode aSTNode;
            ASTNode aSTNode2 = (ASTNode)iterator.next();
            if (JdtASTMatcher.doNodesMatch(aSTNode2, aSTNode = (ASTNode)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public IASTFragment[] getSubFragmentsMatching(IASTFragment iASTFragment) {
        return AssociativeInfixExpressionFragment.union(this.getSubFragmentsWithMyNodeMatching(iASTFragment), this.getSubFragmentsWithAnotherNodeMatching(iASTFragment));
    }

    private IASTFragment[] getSubFragmentsWithMyNodeMatching(IASTFragment iASTFragment) {
        if (iASTFragment.getClass() != this.getClass()) {
            return new IASTFragment[0];
        }
        AssociativeInfixExpressionFragment associativeInfixExpressionFragment = (AssociativeInfixExpressionFragment)iASTFragment;
        if (associativeInfixExpressionFragment.getOperator() != this.getOperator()) {
            return new IASTFragment[0];
        }
        List list = AssociativeInfixExpressionFragment.getMatchingContiguousNodeSubsequences(this.getOperands(), associativeInfixExpressionFragment.getOperands());
        IASTFragment[] iASTFragmentArray = new IASTFragment[list.size()];
        int n = 0;
        while (n < list.size()) {
            AssociativeInfixExpressionFragment associativeInfixExpressionFragment2 = new AssociativeInfixExpressionFragment(this.fGroupRoot, (List)list.get(n));
            Assert.isTrue((associativeInfixExpressionFragment2.matches(iASTFragment) || iASTFragment.matches(associativeInfixExpressionFragment2) ? 1 : 0) != 0);
            iASTFragmentArray[n] = associativeInfixExpressionFragment2;
            ++n;
        }
        return iASTFragmentArray;
    }

    private IASTFragment[] getSubFragmentsWithAnotherNodeMatching(IASTFragment iASTFragment) {
        IASTFragment[] iASTFragmentArray = new IASTFragment[]{};
        Iterator iterator = this.getOperands().iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            iASTFragmentArray = AssociativeInfixExpressionFragment.union(iASTFragmentArray, ASTMatchingFragmentFinder.findMatchingFragments(aSTNode, (ASTFragment)iASTFragment));
        }
        return iASTFragmentArray;
    }

    private static IASTFragment[] union(IASTFragment[] iASTFragmentArray, IASTFragment[] iASTFragmentArray2) {
        IASTFragment[] iASTFragmentArray3 = new IASTFragment[iASTFragmentArray.length + iASTFragmentArray2.length];
        System.arraycopy(iASTFragmentArray, 0, iASTFragmentArray3, 0, iASTFragmentArray.length);
        System.arraycopy(iASTFragmentArray2, 0, iASTFragmentArray3, iASTFragmentArray.length, iASTFragmentArray2.length);
        return iASTFragmentArray3;
    }

    public Expression getAssociatedExpression() {
        return this.fGroupRoot;
    }

    public ASTNode getAssociatedNode() {
        return this.fGroupRoot;
    }

    public InfixExpression getGroupRoot() {
        return this.fGroupRoot;
    }

    public int getLength() {
        return this.getEndPositionExclusive() - this.getStartPosition();
    }

    private int getEndPositionExclusive() {
        List list = this.getOperands();
        ASTNode aSTNode = (ASTNode)list.get(list.size() - 1);
        return aSTNode.getStartPosition() + aSTNode.getLength();
    }

    public int getStartPosition() {
        return ((ASTNode)this.getOperands().get(0)).getStartPosition();
    }

    public List getOperands() {
        return this.fOperands;
    }

    public InfixExpression.Operator getOperator() {
        return this.fGroupRoot.getOperator();
    }

    public Expression createCopyTarget(ASTRewrite aSTRewrite) throws JavaModelException {
        ArrayList arrayList = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(this.fGroupRoot);
        if (arrayList.size() == this.fOperands.size()) {
            return (Expression)aSTRewrite.createCopyTarget((ASTNode)this.fGroupRoot);
        }
        CompilationUnit compilationUnit = (CompilationUnit)this.fGroupRoot.getRoot();
        ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        String string = iCompilationUnit.getBuffer().getText(this.getStartPosition(), this.getLength());
        return (Expression)aSTRewrite.createStringPlaceholder(string, 27);
    }

    public void replace(ASTRewrite aSTRewrite, ASTNode aSTNode, TextEditGroup textEditGroup) {
        ArrayList arrayList = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(this.fGroupRoot);
        if (arrayList.size() == this.fOperands.size()) {
            aSTRewrite.replace((ASTNode)this.fGroupRoot, aSTNode, textEditGroup);
            return;
        }
        int n = arrayList.indexOf(this.fOperands.get(0));
        int n2 = n + this.fOperands.size();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            if (n3 < n || n2 <= n3) {
                arrayList2.add(aSTRewrite.createCopyTarget((ASTNode)((Expression)arrayList.get(n3))));
            } else {
                arrayList2.add(aSTNode);
                n3 = n2 - 1;
            }
            ++n3;
        }
        Expression expression = ASTNodeFactory.newInfixExpression(aSTRewrite.getAST(), this.getOperator(), arrayList2);
        aSTRewrite.replace((ASTNode)this.getGroupRoot(), (ASTNode)expression, textEditGroup);
    }

    private static ArrayList findGroupMembersInOrderFor(InfixExpression infixExpression) {
        return new GroupMemberFinder(infixExpression).fMembersInOrder;
    }

    public int hashCode() {
        return this.fGroupRoot.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AssociativeInfixExpressionFragment associativeInfixExpressionFragment = (AssociativeInfixExpressionFragment)object;
        return this.fGroupRoot.equals((Object)associativeInfixExpressionFragment.fGroupRoot) && this.fOperands.equals(associativeInfixExpressionFragment.fOperands);
    }

    private static class GroupMemberFinder
    extends GenericVisitor {
        private ArrayList fMembersInOrder = new ArrayList();
        private InfixExpression fGroupRoot;

        public GroupMemberFinder(InfixExpression infixExpression) {
            super(true);
            Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)infixExpression));
            this.fGroupRoot = infixExpression;
            this.fGroupRoot.accept((ASTVisitor)this);
        }

        protected boolean visitNode(ASTNode aSTNode) {
            if (aSTNode instanceof InfixExpression && ((InfixExpression)aSTNode).getOperator() == this.fGroupRoot.getOperator()) {
                return true;
            }
            this.fMembersInOrder.add(aSTNode);
            return false;
        }
    }
}

