/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;

public class ExpressionsFix
extends AbstractFix {
    public static IFix createAddParanoidalParenthesisFix(CompilationUnit compilationUnit, ASTNode[] aSTNodeArray) throws CoreException {
        if (aSTNodeArray == null) {
            return null;
        }
        if (aSTNodeArray.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < aSTNodeArray.length) {
            ASTNode aSTNode = aSTNodeArray[n];
            if (aSTNode instanceof InfixExpression) {
                aSTNode.accept((ASTVisitor)new MissingParenthesisVisitor(arrayList));
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        AddParenthesisOperation addParenthesisOperation = new AddParenthesisOperation(arrayList.toArray(new Expression[arrayList.size()]));
        return new ExpressionsFix(FixMessages.ExpressionsFix_addParanoiacParenthesis_description, compilationUnit, new IFixRewriteOperation[]{addParenthesisOperation});
    }

    public static IFix createRemoveUnnecessaryParenthesisFix(CompilationUnit compilationUnit, ASTNode[] aSTNodeArray) {
        Object object;
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < aSTNodeArray.length) {
            object = aSTNodeArray[n];
            if (object instanceof ParenthesizedExpression || object instanceof InfixExpression) {
                object.accept((ASTVisitor)new UnnecessaryParenthesisVisitor(arrayList));
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        HashSet hashSet = new HashSet(arrayList);
        object = new RemoveParenthesisOperation(hashSet);
        return new ExpressionsFix(FixMessages.ExpressionsFix_removeUnnecessaryParenthesis_description, compilationUnit, new IFixRewriteOperation[]{object});
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2) {
        if (bl) {
            ArrayList arrayList = new ArrayList();
            compilationUnit.accept((ASTVisitor)new MissingParenthesisVisitor(arrayList));
            if (arrayList.isEmpty()) {
                return null;
            }
            AddParenthesisOperation addParenthesisOperation = new AddParenthesisOperation(arrayList.toArray(new Expression[arrayList.size()]));
            return new ExpressionsFix(FixMessages.ExpressionsFix_add_parenthesis_change_name, compilationUnit, new IFixRewriteOperation[]{addParenthesisOperation});
        }
        if (bl2) {
            ArrayList arrayList = new ArrayList();
            compilationUnit.accept((ASTVisitor)new UnnecessaryParenthesisVisitor(arrayList));
            if (arrayList.isEmpty()) {
                return null;
            }
            HashSet hashSet = new HashSet(arrayList);
            RemoveParenthesisOperation removeParenthesisOperation = new RemoveParenthesisOperation(hashSet);
            return new ExpressionsFix(FixMessages.ExpressionsFix_remove_parenthesis_change_name, compilationUnit, new IFixRewriteOperation[]{removeParenthesisOperation});
        }
        return null;
    }

    private static boolean isStringExpression(Expression expression) {
        ITypeBinding iTypeBinding = expression.resolveTypeBinding();
        return iTypeBinding.getQualifiedName().equals("java.lang.String");
    }

    protected ExpressionsFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        super(string, compilationUnit, iFixRewriteOperationArray);
    }

    private static class AddParenthesisOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final Expression[] fExpressions;

        public AddParenthesisOperation(Expression[] expressionArray) {
            this.fExpressions = expressionArray;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.ExpressionsFix_addParanoiacParenthesis_description);
            list.add(textEditGroup);
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            AST aST = compilationUnitRewrite.getRoot().getAST();
            int n = 0;
            while (n < this.fExpressions.length) {
                Expression expression = this.fExpressions[n];
                ParenthesizedExpression parenthesizedExpression = aST.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)aSTRewrite.createCopyTarget((ASTNode)expression));
                aSTRewrite.replace((ASTNode)expression, (ASTNode)parenthesizedExpression, textEditGroup);
                ++n;
            }
        }
    }

    private static final class MissingParenthesisVisitor
    extends ASTVisitor {
        private final ArrayList fNodes;

        private MissingParenthesisVisitor(ArrayList arrayList) {
            this.fNodes = arrayList;
        }

        public void postVisit(ASTNode aSTNode) {
            if (!(aSTNode.getParent() instanceof InfixExpression)) {
                return;
            }
            boolean bl = false;
            if (aSTNode instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)aSTNode;
                InfixExpression.Operator operator = infixExpression.getOperator();
                InfixExpression infixExpression2 = (InfixExpression)aSTNode.getParent();
                InfixExpression.Operator operator2 = infixExpression2.getOperator();
                if (operator2 == operator) {
                    return;
                }
                boolean bl2 = bl = operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER_EQUALS || operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS || operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR;
            }
            if (aSTNode instanceof InstanceofExpression) {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.fNodes.add(aSTNode);
        }
    }

    private static class RemoveParenthesisOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final HashSet fExpressions;

        public RemoveParenthesisOperation(HashSet hashSet) {
            this.fExpressions = hashSet;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.ExpressionsFix_removeUnnecessaryParenthesis_description);
            list.add(textEditGroup);
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            while (this.fExpressions.size() > 0) {
                ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)this.fExpressions.iterator().next();
                this.fExpressions.remove(parenthesizedExpression);
                ParenthesizedExpression parenthesizedExpression2 = parenthesizedExpression;
                while (this.fExpressions.contains(parenthesizedExpression2.getExpression())) {
                    parenthesizedExpression2 = (ParenthesizedExpression)parenthesizedExpression2.getExpression();
                    this.fExpressions.remove(parenthesizedExpression2);
                }
                ASTNode aSTNode = aSTRewrite.createMoveTarget((ASTNode)parenthesizedExpression2.getExpression());
                ParenthesizedExpression parenthesizedExpression3 = parenthesizedExpression;
                while (this.fExpressions.contains(parenthesizedExpression3.getParent())) {
                    parenthesizedExpression3 = (ParenthesizedExpression)parenthesizedExpression3.getParent();
                    this.fExpressions.remove(parenthesizedExpression3);
                }
                aSTRewrite.replace((ASTNode)parenthesizedExpression3, aSTNode, textEditGroup);
            }
        }
    }

    private static final class UnnecessaryParenthesisVisitor
    extends ASTVisitor {
        private final ArrayList fNodes;

        private UnnecessaryParenthesisVisitor(ArrayList arrayList) {
            this.fNodes = arrayList;
        }

        public void postVisit(ASTNode aSTNode) {
            MethodInvocation methodInvocation;
            if (!(aSTNode instanceof ParenthesizedExpression)) {
                return;
            }
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)aSTNode;
            Expression expression = parenthesizedExpression.getExpression();
            while (expression instanceof ParenthesizedExpression) {
                expression = ((ParenthesizedExpression)expression).getExpression();
            }
            if (parenthesizedExpression.getExpression() instanceof CastExpression && parenthesizedExpression.getParent() instanceof MethodInvocation && (methodInvocation = (MethodInvocation)parenthesizedExpression.getParent()).getExpression() == parenthesizedExpression) {
                return;
            }
            if (parenthesizedExpression.getParent() instanceof Expression) {
                int n;
                methodInvocation = (Expression)parenthesizedExpression.getParent();
                int n2 = UnnecessaryParenthesisVisitor.getExpressionPrecedence(expression);
                if (n2 > (n = UnnecessaryParenthesisVisitor.getExpressionPrecedence((Expression)methodInvocation)) && !(parenthesizedExpression.getParent() instanceof ParenthesizedExpression)) {
                    return;
                }
                if (n2 == n && methodInvocation instanceof InfixExpression) {
                    InfixExpression infixExpression = (InfixExpression)methodInvocation;
                    InfixExpression.Operator operator = infixExpression.getOperator();
                    if (infixExpression.getLeftOperand() == parenthesizedExpression) {
                        this.fNodes.add(aSTNode);
                    } else if (this.isAssoziative(operator)) {
                        if (operator == InfixExpression.Operator.PLUS) {
                            if (ExpressionsFix.isStringExpression(infixExpression.getLeftOperand()) || ExpressionsFix.isStringExpression(infixExpression.getRightOperand())) {
                                return;
                            }
                            Iterator iterator = infixExpression.extendedOperands().iterator();
                            while (iterator.hasNext()) {
                                Expression expression2 = (Expression)iterator.next();
                                if (!ExpressionsFix.isStringExpression(expression2)) continue;
                                return;
                            }
                        }
                        this.fNodes.add(aSTNode);
                    }
                    return;
                }
                if (n2 == n && methodInvocation instanceof ConditionalExpression && ((ConditionalExpression)methodInvocation).getElseExpression() != parenthesizedExpression) {
                    return;
                }
            }
            this.fNodes.add(aSTNode);
        }

        private boolean isAssoziative(InfixExpression.Operator operator) {
            if (operator == InfixExpression.Operator.PLUS) {
                return true;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                return true;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                return true;
            }
            if (operator == InfixExpression.Operator.AND) {
                return true;
            }
            if (operator == InfixExpression.Operator.OR) {
                return true;
            }
            if (operator == InfixExpression.Operator.XOR) {
                return true;
            }
            return operator == InfixExpression.Operator.TIMES;
        }

        private static int getExpressionPrecedence(Expression expression) {
            if (expression instanceof PostfixExpression || expression instanceof MethodInvocation) {
                return 0;
            }
            if (expression instanceof PrefixExpression) {
                return 1;
            }
            if (expression instanceof ClassInstanceCreation || expression instanceof CastExpression) {
                return 2;
            }
            if (expression instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)expression;
                InfixExpression.Operator operator = infixExpression.getOperator();
                return UnnecessaryParenthesisVisitor.getInfixOperatorPrecedence(operator);
            }
            if (expression instanceof InstanceofExpression) {
                return 6;
            }
            if (expression instanceof ConditionalExpression) {
                return 13;
            }
            if (expression instanceof Assignment) {
                return 14;
            }
            return -1;
        }

        private static int getInfixOperatorPrecedence(InfixExpression.Operator operator) {
            if (operator == InfixExpression.Operator.TIMES || operator == InfixExpression.Operator.DIVIDE || operator == InfixExpression.Operator.REMAINDER) {
                return 3;
            }
            if (operator == InfixExpression.Operator.PLUS || operator == InfixExpression.Operator.MINUS) {
                return 4;
            }
            if (operator == InfixExpression.Operator.LEFT_SHIFT || operator == InfixExpression.Operator.RIGHT_SHIFT_SIGNED || operator == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
                return 5;
            }
            if (operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER_EQUALS) {
                return 6;
            }
            if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS) {
                return 7;
            }
            if (operator == InfixExpression.Operator.AND) {
                return 8;
            }
            if (operator == InfixExpression.Operator.XOR) {
                return 9;
            }
            if (operator == InfixExpression.Operator.OR) {
                return 10;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                return 11;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                return 12;
            }
            return -1;
        }
    }
}

