/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.javadoc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.CorextMessages;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIException;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaDocLocations {
    public static final String ARCHIVE_PREFIX = "jar:";
    private static final String PREF_JAVADOCLOCATIONS = "org.eclipse.wst.jsdt.ui.javadoclocations";
    public static final String PREF_JAVADOCLOCATIONS_MIGRATED = "org.eclipse.wst.jsdt.ui.javadoclocations.migrated";
    private static final String NODE_ROOT = "javadoclocation";
    private static final String NODE_ENTRY = "location_01";
    private static final String NODE_PATH = "path";
    private static final String NODE_URL = "url";
    private static final QualifiedName PROJECT_JAVADOC = new QualifiedName("org.eclipse.wst.jsdt.ui", "project_javadoc_location");

    public static void migrateToClasspathAttributes() {
        final Map map = JavaDocLocations.loadOldForCompatibility();
        if (map.isEmpty()) {
            IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
            iPreferenceStore.setValue(PREF_JAVADOCLOCATIONS, "");
            iPreferenceStore.setValue(PREF_JAVADOCLOCATIONS_MIGRATED, true);
            return;
        }
        Job job = new Job(CorextMessages.JavaDocLocations_migratejob_name){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(this, map){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Map val$oldLocations;
                        {
                            this.this$1 = var1_1;
                            this.val$oldLocations = map;
                        }

                        public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                            JavaDocLocations.updateClasspathEntries(this.val$oldLocations, iProgressMonitor);
                            IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
                            iPreferenceStore.setValue("org.eclipse.wst.jsdt.ui.javadoclocations", "");
                            iPreferenceStore.setValue("org.eclipse.wst.jsdt.ui.javadoclocations.migrated", true);
                        }
                    };
                    new WorkbenchRunnableAdapter(iWorkspaceRunnable).run(iProgressMonitor);
                }
                catch (InvocationTargetException invocationTargetException) {
                    JavaPlugin.log(invocationTargetException);
                }
                catch (InterruptedException interruptedException) {}
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void updateClasspathEntries(Map map, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] iJavaProjectArray = JavaCore.create((IWorkspaceRoot)iWorkspaceRoot).getJavaProjects();
        try {
            iProgressMonitor.beginTask(CorextMessages.JavaDocLocations_migrate_operation, iJavaProjectArray.length);
            int n = 0;
            while (n < iJavaProjectArray.length) {
                IJavaProject iJavaProject = iJavaProjectArray[n];
                String string = (String)map.get(iJavaProject.getPath());
                if (string != null) {
                    try {
                        JavaDocLocations.setProjectJavadocLocation(iJavaProject, string);
                    }
                    catch (CoreException coreException) {}
                }
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                boolean bl = false;
                int n2 = 0;
                while (n2 < iClasspathEntryArray.length) {
                    IClasspathEntry iClasspathEntry = JavaDocLocations.getConvertedEntry(iClasspathEntryArray[n2], iJavaProject, map);
                    if (iClasspathEntry != null) {
                        iClasspathEntryArray[n2] = iClasspathEntry;
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    iJavaProject.setRawClasspath(iClasspathEntryArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                } else {
                    iProgressMonitor.worked(1);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        iProgressMonitor.done();
    }

    private static IClasspathEntry getConvertedEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, Map map) {
        IPath iPath = null;
        switch (iClasspathEntry.getEntryKind()) {
            case 2: 
            case 3: {
                return null;
            }
            case 5: {
                JavaDocLocations.convertContainer(iClasspathEntry, iJavaProject, map);
                return null;
            }
            case 1: {
                iPath = iClasspathEntry.getPath();
                break;
            }
            case 4: {
                iPath = JavaCore.getResolvedVariablePath((IPath)iClasspathEntry.getPath());
                break;
            }
            default: {
                return null;
            }
        }
        if (iPath == null) {
            return null;
        }
        IClasspathAttribute[] iClasspathAttributeArray = iClasspathEntry.getExtraAttributes();
        int n = 0;
        while (n < iClasspathAttributeArray.length) {
            if ("javadoc_location".equals(iClasspathAttributeArray[n].getName())) {
                return null;
            }
            ++n;
        }
        String string = (String)map.get(iPath);
        if (string != null) {
            CPListElement cPListElement = CPListElement.createFromExisting(iClasspathEntry, iJavaProject);
            cPListElement.setAttribute("javadoc_location", string);
            return cPListElement.getClasspathEntry();
        }
        return null;
    }

    private static void convertContainer(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, Map map) {
        try {
            IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iClasspathEntry.getPath(), (IJavaProject)iJavaProject);
            if (iClasspathContainer == null) {
                return;
            }
            IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
            boolean bl = false;
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                IClasspathEntry iClasspathEntry2 = iClasspathEntryArray[n];
                IClasspathEntry iClasspathEntry3 = JavaDocLocations.getConvertedEntry(iClasspathEntry2, iJavaProject, map);
                if (iClasspathEntry3 != null) {
                    iClasspathEntryArray[n] = iClasspathEntry3;
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                BuildPathSupport.requestContainerUpdate(iJavaProject, iClasspathContainer, iClasspathEntryArray);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void setProjectJavadocLocation(IJavaProject iJavaProject, URL uRL) {
        try {
            String string = uRL != null ? uRL.toExternalForm() : null;
            JavaDocLocations.setProjectJavadocLocation(iJavaProject, string);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
    }

    private static void setProjectJavadocLocation(IJavaProject iJavaProject, String string) throws CoreException {
        iJavaProject.getProject().setPersistentProperty(PROJECT_JAVADOC, string);
    }

    public static URL getProjectJavadocLocation(IJavaProject iJavaProject) {
        String string;
        block4: {
            string = iJavaProject.getProject().getPersistentProperty(PROJECT_JAVADOC);
            if (string != null) break block4;
            return null;
        }
        try {
            return new URL(string);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        catch (MalformedURLException malformedURLException) {
            JavaPlugin.log(malformedURLException);
        }
        return null;
    }

    public static URL getLibraryJavadocLocation(IClasspathEntry iClasspathEntry) {
        if (iClasspathEntry == null) {
            throw new IllegalArgumentException("Entry must not be null");
        }
        int n = iClasspathEntry.getEntryKind();
        if (n != 1 && n != 4) {
            throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
        }
        IClasspathAttribute[] iClasspathAttributeArray = iClasspathEntry.getExtraAttributes();
        int n2 = 0;
        while (n2 < iClasspathAttributeArray.length) {
            IClasspathAttribute iClasspathAttribute = iClasspathAttributeArray[n2];
            if ("javadoc_location".equals(iClasspathAttribute.getName())) {
                try {
                    return new URL(iClasspathAttribute.getValue());
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    public static URL getJavadocBaseLocation(IJavaElement iJavaElement) throws JavaModelException {
        if (iJavaElement.getElementType() == 2) {
            return JavaDocLocations.getProjectJavadocLocation((IJavaProject)iJavaElement);
        }
        IPackageFragmentRoot iPackageFragmentRoot = JavaModelUtil.getPackageFragmentRoot(iJavaElement);
        if (iPackageFragmentRoot == null) {
            return null;
        }
        if (iPackageFragmentRoot.getKind() == 2) {
            IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
            if (iClasspathEntry == null) {
                return null;
            }
            if (iClasspathEntry.getEntryKind() == 5 && (iClasspathEntry = JavaDocLocations.getRealClasspathEntry(iPackageFragmentRoot.getJavaProject(), iClasspathEntry.getPath(), iPackageFragmentRoot.getPath())) == null) {
                return null;
            }
            return JavaDocLocations.getLibraryJavadocLocation(iClasspathEntry);
        }
        return JavaDocLocations.getProjectJavadocLocation(iPackageFragmentRoot.getJavaProject());
    }

    private static IClasspathEntry getRealClasspathEntry(IJavaProject iJavaProject, IPath iPath, IPath iPath2) throws JavaModelException {
        IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject);
        if (iClasspathContainer != null) {
            IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
                IClasspathEntry iClasspathEntry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
                if (iClasspathEntry2 != null && iPath2.equals((Object)iClasspathEntry2.getPath())) {
                    return iClasspathEntry;
                }
                ++n;
            }
        }
        return null;
    }

    private static JavaUIException createException(Throwable throwable, String string) {
        return new JavaUIException(JavaUIStatus.createError(4, string, throwable));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map loadOldForCompatibility() {
        block33: {
            block35: {
                var0 = new HashMap<K, V>();
                var1_1 = PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.javadoclocations");
                if (var1_1 == null || var1_1.length() <= 0) break block35;
                try {
                    var2_2 = var1_1.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException v0) {
                    var2_2 = var1_1.getBytes();
                }
                var3_5 = new ByteArrayInputStream((byte[])var2_2);
                try {
                    try {
                        JavaDocLocations.loadFromStream(new InputSource((InputStream)var3_5), var0);
                        PreferenceConstants.getPreferenceStore().setValue("org.eclipse.wst.jsdt.ui.javadoclocations", "");
                        var7_6 = var0;
                        var5_9 = null;
                    }
                    catch (CoreException var4_12) {
                        JavaPlugin.log(var4_12);
                        ** GOTO lbl-1000
                    }
                }
                catch (Throwable var6_15) {
                    var5_10 = null;
                    try {
                        var3_5.close();
                        throw var6_15;
                    }
                    catch (IOException v1) {}
                    throw var6_15;
                }
                try {}
                catch (IOException v2) {}
                var3_5.close();
                return var7_6;
                return var7_6;
lbl-1000:
                // 1 sources

                {
                    var5_11 = null;
                }
                try {}
                catch (IOException v3) {
                    ** GOTO lbl-1000
                }
                var3_5.close();
            }
            try lbl-1000:
            // 2 sources

            {
                var2_2 = JavaPlugin.getDefault().getStateLocation().append("javadoclocations.xml").toFile();
                if (!var2_2.exists()) break block33;
                var3_5 = null;
                try {
                    try {
                        var3_5 = new FileReader((File)var2_2);
                        JavaDocLocations.loadFromStream(new InputSource((Reader)var3_5), var0);
                        var2_2.delete();
                        var7_7 = var0;
                        var5_11 = null;
                    }
                    catch (IOException var4_13) {
                        JavaPlugin.log(var4_13);
                        ** GOTO lbl-1000
                    }
                }
                catch (Throwable var6_16) {
                    var5_11 = null;
                    try {
                        if (var3_5 == null) throw var6_16;
                        var3_5.close();
                        throw var6_16;
                    }
                    catch (IOException v4) {}
                    throw var6_16;
                }
                try {}
                catch (IOException v5) {}
                if (var3_5 == null) return var7_7;
                var3_5.close();
                return var7_7;
                return var7_7;
lbl-1000:
                // 1 sources

                {
                    var5_11 = null;
                    try {}
                    catch (IOException v6) {}
                    if (var3_5 != null) {
                        var3_5.close();
                    }
                }
            }
            catch (CoreException var2_3) {
                JavaPlugin.log(var2_3);
            }
        }
        try {
            var2_2 = new QualifiedName("org.eclipse.wst.jsdt.ui", "jdoclocation");
            var3_5 = ResourcesPlugin.getWorkspace().getRoot();
            var4_14 = var3_5.getPersistentProperty((QualifiedName)var2_2);
            if (var4_14 == null) return var0;
            var5_11 = new StringReader(var4_14);
            try {
                JavaDocLocations.loadFromStream(new InputSource(var5_11), var0);
                var3_5.setPersistentProperty((QualifiedName)var2_2, null);
                var8_19 = var0;
                var6_17 = null;
            }
            catch (Throwable var7_8) {
                var6_18 = null;
                try {
                    var5_11.close();
                    throw var7_8;
                }
                catch (IOException v7) {}
                throw var7_8;
            }
            try {}
            catch (IOException v8) {}
            var5_11.close();
            return var8_19;
            return var8_19;
        }
        catch (CoreException var2_4) {
            JavaPlugin.log(var2_4);
        }
        return var0;
    }

    private static void loadFromStream(InputSource inputSource, Map map) throws CoreException {
        Element element;
        Object object;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            element = ((DocumentBuilder)object).parse(inputSource).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw JavaDocLocations.createException(sAXException, CorextMessages.JavaDocLocations_error_readXML);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw JavaDocLocations.createException(parserConfigurationException, CorextMessages.JavaDocLocations_error_readXML);
        }
        catch (IOException iOException) {
            throw JavaDocLocations.createException(iOException, CorextMessages.JavaDocLocations_error_readXML);
        }
        if (element == null) {
            return;
        }
        if (!element.getNodeName().equalsIgnoreCase(NODE_ROOT)) {
            return;
        }
        object = element.getChildNodes();
        int n = object.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2;
            Node node = object.item(n2);
            short s = node.getNodeType();
            if (s == 1 && (element2 = (Element)node).getNodeName().equalsIgnoreCase(NODE_ENTRY)) {
                String string = element2.getAttribute(NODE_PATH);
                String string2 = element2.getAttribute(NODE_URL);
                map.put(Path.fromPortableString((String)string), string2);
            }
            ++n2;
        }
    }

    public static URL getJavadocLocation(IJavaElement iJavaElement, boolean bl) throws JavaModelException {
        URL uRL = JavaDocLocations.getJavadocBaseLocation(iJavaElement);
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith("/")) {
            stringBuffer.append('/');
        }
        switch (iJavaElement.getElementType()) {
            case 4: {
                JavaDocLocations.appendPackageSummaryPath((IPackageFragment)iJavaElement, stringBuffer);
                break;
            }
            case 2: 
            case 3: {
                JavaDocLocations.appendIndexPath(stringBuffer);
                break;
            }
            case 12: {
                iJavaElement = iJavaElement.getParent();
            }
            case 5: {
                IType iType = ((ICompilationUnit)iJavaElement).findPrimaryType();
                if (iType == null) {
                    return null;
                }
                JavaDocLocations.appendTypePath(iType, stringBuffer);
                break;
            }
            case 6: {
                JavaDocLocations.appendTypePath(((IClassFile)iJavaElement).getType(), stringBuffer);
                break;
            }
            case 7: {
                JavaDocLocations.appendTypePath((IType)iJavaElement, stringBuffer);
                break;
            }
            case 8: {
                IField iField = (IField)iJavaElement;
                JavaDocLocations.appendTypePath(iField.getDeclaringType(), stringBuffer);
                if (!bl) break;
                JavaDocLocations.appendFieldReference(iField, stringBuffer);
                break;
            }
            case 9: {
                IMethod iMethod = (IMethod)iJavaElement;
                JavaDocLocations.appendTypePath(iMethod.getDeclaringType(), stringBuffer);
                if (!bl) break;
                JavaDocLocations.appendMethodReference(iMethod, stringBuffer);
                break;
            }
            case 10: {
                JavaDocLocations.appendTypePath(((IMember)iJavaElement).getDeclaringType(), stringBuffer);
                break;
            }
            case 13: {
                IImportDeclaration iImportDeclaration = (IImportDeclaration)iJavaElement;
                if (iImportDeclaration.isOnDemand()) {
                    IJavaElement iJavaElement2 = JavaModelUtil.findTypeContainer(iJavaElement.getJavaProject(), Signature.getQualifier((String)iImportDeclaration.getElementName()));
                    if (iJavaElement2 instanceof IType) {
                        JavaDocLocations.appendTypePath((IType)iJavaElement2, stringBuffer);
                        break;
                    }
                    if (!(iJavaElement2 instanceof IPackageFragment)) break;
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)iJavaElement2, stringBuffer);
                    break;
                }
                IType iType = iJavaElement.getJavaProject().findType(iImportDeclaration.getElementName());
                JavaDocLocations.appendTypePath(iType, stringBuffer);
                break;
            }
            case 11: {
                IJavaElement iJavaElement3 = iJavaElement.getAncestor(4);
                if (iJavaElement3 != null) {
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)iJavaElement3, stringBuffer);
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        try {
            return new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            JavaPlugin.log(malformedURLException);
            return null;
        }
    }

    private static void appendPackageSummaryPath(IPackageFragment iPackageFragment, StringBuffer stringBuffer) {
        String string = iPackageFragment.getElementName().replace('.', '/');
        stringBuffer.append(string);
        stringBuffer.append("/package-summary.html");
    }

    private static void appendIndexPath(StringBuffer stringBuffer) {
        stringBuffer.append("index.html");
    }

    private static void appendTypePath(IType iType, StringBuffer stringBuffer) {
        IPackageFragment iPackageFragment = iType.getPackageFragment();
        String string = iPackageFragment.getElementName().replace('.', '/');
        String string2 = JavaModelUtil.getTypeQualifiedName(iType);
        stringBuffer.append(string);
        stringBuffer.append('/');
        stringBuffer.append(string2);
        stringBuffer.append(".html");
    }

    private static void appendFieldReference(IField iField, StringBuffer stringBuffer) {
        stringBuffer.append('#');
        stringBuffer.append(iField.getElementName());
    }

    private static void appendMethodReference(IMethod iMethod, StringBuffer stringBuffer) throws JavaModelException {
        stringBuffer.append('#');
        stringBuffer.append(iMethod.getElementName());
        stringBuffer.append('(');
        String[] stringArray = iMethod.getParameterTypes();
        IType iType = iMethod.getDeclaringType();
        boolean bl = Flags.isVarargs((int)iMethod.getFlags());
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            String string;
            String string2;
            if (n2 != 0) {
                stringBuffer.append(", ");
            }
            if ((string2 = JavaModelUtil.getResolvedTypeName(string = Signature.getTypeErasure((String)stringArray[n2]), iType)) != null) {
                stringBuffer.append(string2);
                int n3 = Signature.getArrayCount((String)string);
                if (n2 == n && bl) {
                    --n3;
                }
                while (n3 > 0) {
                    stringBuffer.append("[]");
                    --n3;
                }
                if (n2 == n && bl) {
                    stringBuffer.append("...");
                }
            }
            ++n2;
        }
        stringBuffer.append(')');
    }
}

