/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;
    static /* synthetic */ Class class$0;

    private Checks() {
    }

    public static RefactoringStatus checkIfConstructorName(IMethod iMethod, String string, String string2) {
        if (!string.equals(string2)) {
            return null;
        }
        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.Checks_constructor_name, new Object[]{JavaElementUtil.createMethodSignature(iMethod), JavaModelUtil.getFullyQualifiedName(iMethod.getDeclaringType())}));
    }

    public static RefactoringStatus checkFieldName(String string) {
        return Checks.checkName(string, JavaConventions.validateFieldName((String)string));
    }

    public static RefactoringStatus checkTypeParameterName(String string) {
        return Checks.checkName(string, JavaConventions.validateTypeVariableName((String)string));
    }

    public static RefactoringStatus checkIdentifier(String string) {
        return Checks.checkName(string, JavaConventions.validateIdentifier((String)string));
    }

    public static RefactoringStatus checkMethodName(String string) {
        RefactoringStatus refactoringStatus = Checks.checkName(string, JavaConventions.validateMethodName((String)string));
        if (refactoringStatus.isOK() && Checks.startsWithUpperCase(string)) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.Checks_method_names_lowercase);
        }
        return refactoringStatus;
    }

    public static RefactoringStatus checkTypeName(String string) {
        if (string.indexOf(".") != -1) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_no_dot);
        }
        return Checks.checkName(string, JavaConventions.validateJavaTypeName((String)string));
    }

    public static RefactoringStatus checkPackageName(String string) {
        return Checks.checkName(string, JavaConventions.validatePackageName((String)string));
    }

    public static RefactoringStatus checkCompilationUnitName(String string) {
        return Checks.checkName(string, JavaConventions.validateCompilationUnitName((String)string));
    }

    public static RefactoringStatus checkCompilationUnitNewName(ICompilationUnit iCompilationUnit, String string) {
        String string2 = JavaModelUtil.getRenamedCUName(iCompilationUnit, string);
        if (Checks.resourceExists(RenameResourceChange.renamedResourcePath(iCompilationUnit.getResource().getFullPath(), string2))) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.Checks_cu_name_used, string));
        }
        return new RefactoringStatus();
    }

    public static boolean startsWithUpperCase(String string) {
        if (string == null) {
            return false;
        }
        if ("".equals(string)) {
            return false;
        }
        return string.charAt(0) == Character.toUpperCase(string.charAt(0));
    }

    public static boolean startsWithLowerCase(String string) {
        if (string == null) {
            return false;
        }
        if ("".equals(string)) {
            return false;
        }
        return string.charAt(0) == Character.toLowerCase(string.charAt(0));
    }

    public static boolean resourceExists(IPath iPath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(iPath) != null;
    }

    public static boolean isTopLevel(IType iType) {
        return iType.getDeclaringType() == null;
    }

    public static boolean isAnonymous(IType iType) throws JavaModelException {
        return iType.isAnonymous();
    }

    public static boolean isTopLevelType(IMember iMember) {
        return iMember.getElementType() == 7 && Checks.isTopLevel((IType)iMember);
    }

    public static boolean isInsideLocalType(IType iType) throws JavaModelException {
        while (iType != null) {
            if (iType.isLocal()) {
                return true;
            }
            iType = iType.getDeclaringType();
        }
        return false;
    }

    public static boolean isAlreadyNamed(IJavaElement iJavaElement, String string) {
        return string.equals(iJavaElement.getElementName());
    }

    public static RefactoringStatus checkForMainAndNativeMethods(ICompilationUnit iCompilationUnit) throws JavaModelException {
        return Checks.checkForMainAndNativeMethods(iCompilationUnit.getTypes());
    }

    public static RefactoringStatus checkForMainAndNativeMethods(IType[] iTypeArray) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < iTypeArray.length) {
            refactoringStatus.merge(Checks.checkForMainAndNativeMethods(iTypeArray[n]));
            ++n;
        }
        return refactoringStatus;
    }

    public static RefactoringStatus checkForMainAndNativeMethods(IType iType) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(Checks.checkForMainAndNativeMethods(iType.getMethods()));
        refactoringStatus.merge(Checks.checkForMainAndNativeMethods(iType.getTypes()));
        return refactoringStatus;
    }

    private static RefactoringStatus checkForMainAndNativeMethods(IMethod[] iMethodArray) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < iMethodArray.length) {
            String string;
            if (JdtFlags.isNative((IMember)iMethodArray[n])) {
                string = Messages.format(RefactoringCoreMessages.Checks_method_native, new String[]{JavaModelUtil.getFullyQualifiedName(iMethodArray[n].getDeclaringType()), iMethodArray[n].getElementName(), "UnsatisfiedLinkError"});
                refactoringStatus.addEntry(3, string, JavaStatusContext.create((IMember)iMethodArray[n]), Corext.getPluginId(), 192);
            }
            if (iMethodArray[n].isMainMethod()) {
                string = Messages.format(RefactoringCoreMessages.Checks_has_main, JavaModelUtil.getFullyQualifiedName(iMethodArray[n].getDeclaringType()));
                refactoringStatus.addEntry(2, string, JavaStatusContext.create((IMember)iMethodArray[n]), Corext.getPluginId(), 193);
            }
            ++n;
        }
        return refactoringStatus;
    }

    public static RefactoringStatus checkMethodInType(ITypeBinding iTypeBinding, String string, ITypeBinding[] iTypeBindingArray) {
        IMethodBinding iMethodBinding;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (string.equals(iTypeBinding.getName())) {
            refactoringStatus.addWarning(RefactoringCoreMessages.Checks_methodName_constructor);
        }
        if ((iMethodBinding = Bindings.findMethodInType(iTypeBinding, string, iTypeBindingArray)) != null) {
            refactoringStatus.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_exists, new Object[]{string, iTypeBinding.getName()}), JavaStatusContext.create(iMethodBinding));
        }
        return refactoringStatus;
    }

    public static RefactoringStatus checkMethodInHierarchy(ITypeBinding iTypeBinding, String string, ITypeBinding iTypeBinding2, ITypeBinding[] iTypeBindingArray) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IMethodBinding iMethodBinding = Bindings.findMethodInHierarchy(iTypeBinding, string, iTypeBindingArray);
        if (iMethodBinding != null) {
            Object object;
            boolean bl = false;
            ITypeBinding iTypeBinding3 = iMethodBinding.getReturnType();
            if (iTypeBinding2 != null && iTypeBinding3 != null) {
                object = iTypeBinding2.getKey();
                String string2 = iTypeBinding3.getKey();
                if (object == null && string2 == null) {
                    bl = iTypeBinding2 != iTypeBinding3;
                } else if (object != null && string2 != null) {
                    bl = !((String)object).equals(string2);
                }
            }
            object = iMethodBinding.getDeclaringClass();
            if (bl) {
                refactoringStatus.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_returnTypeClash, new Object[]{string, object.getName()}), JavaStatusContext.create(iMethodBinding));
            } else {
                refactoringStatus.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_overrides, new Object[]{string, object.getName()}), JavaStatusContext.create(iMethodBinding));
            }
        }
        return refactoringStatus;
    }

    public static boolean isExtractableExpression(ASTNode[] aSTNodeArray, ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode;
        if (Checks.isEnumCase(aSTNode2)) {
            return false;
        }
        if (aSTNodeArray != null && aSTNodeArray.length == 1) {
            aSTNode2 = aSTNodeArray[0];
        }
        return Checks.isExtractableExpression(aSTNode2);
    }

    public static boolean isEnumCase(ASTNode aSTNode) {
        Name name;
        IBinding iBinding;
        SwitchCase switchCase;
        Expression expression;
        if (aSTNode instanceof SwitchCase && (expression = (switchCase = (SwitchCase)aSTNode).getExpression()) instanceof Name && (iBinding = (name = (Name)expression).resolveBinding()) instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            return iVariableBinding.isEnumConstant();
        }
        return false;
    }

    public static boolean isExtractableExpression(ASTNode aSTNode) {
        if (!(aSTNode instanceof Expression)) {
            return false;
        }
        if (aSTNode instanceof Name) {
            IBinding iBinding = ((Name)aSTNode).resolveBinding();
            return !(iBinding instanceof ITypeBinding);
        }
        return true;
    }

    public static boolean isInsideJavadoc(ASTNode aSTNode) {
        do {
            if (aSTNode.getNodeType() != 29) continue;
            return true;
        } while ((aSTNode = aSTNode.getParent()) != null);
        return false;
    }

    public static RefactoringStatus checkName(String string, IStatus iStatus) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if ("".equals(string)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (iStatus.isOK()) {
            return refactoringStatus;
        }
        switch (iStatus.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)iStatus.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)iStatus.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)iStatus.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static IMethod findMethod(String string, int n, boolean bl, IType iType) throws JavaModelException {
        return Checks.findMethod(string, n, bl, iType.getMethods());
    }

    public static IMethod findMethod(IMethod iMethod, IType iType) throws JavaModelException {
        return Checks.findMethod(iMethod.getElementName(), iMethod.getParameterTypes().length, iMethod.isConstructor(), iType.getMethods());
    }

    public static IMethod findMethod(IMethod iMethod, IMethod[] iMethodArray) throws JavaModelException {
        return Checks.findMethod(iMethod.getElementName(), iMethod.getParameterTypes().length, iMethod.isConstructor(), iMethodArray);
    }

    public static IMethod findMethod(String string, int n, boolean bl, IMethod[] iMethodArray) throws JavaModelException {
        int n2 = iMethodArray.length - 1;
        while (n2 >= 0) {
            IMethod iMethod = iMethodArray[n2];
            if (string.equals(iMethod.getElementName()) && bl == iMethod.isConstructor() && n == iMethod.getParameterTypes().length) {
                return iMethod;
            }
            --n2;
        }
        return null;
    }

    public static IMethod findSimilarMethod(IMethod iMethod, IType iType) throws JavaModelException {
        return Checks.findSimilarMethod(iMethod, iType.getMethods());
    }

    public static IMethod findSimilarMethod(IMethod iMethod, IMethod[] iMethodArray) throws JavaModelException {
        boolean bl = iMethod.isConstructor();
        int n = 0;
        while (n < iMethodArray.length) {
            IMethod iMethod2 = iMethodArray[n];
            if (iMethod2.isConstructor() == bl && iMethod.isSimilar(iMethod2)) {
                return iMethod2;
            }
            ++n;
        }
        return null;
    }

    public static boolean compareParamTypes(String[] stringArray, String[] stringArray2) {
        if (stringArray.length == stringArray2.length) {
            int n = 0;
            while (n < stringArray.length) {
                String string;
                String string2 = Signature.getSimpleName((String)Signature.toString((String)stringArray[n]));
                if (!string2.equals(string = Signature.getSimpleName((String)Signature.toString((String)stringArray2[n])))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static RefactoringStatus checkIfCuBroken(IMember iMember) throws JavaModelException {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)JavaCore.create((IResource)iMember.getCompilationUnit().getResource());
        if (iCompilationUnit == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_created);
        }
        if (!iCompilationUnit.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_parsed);
        }
        return new RefactoringStatus();
    }

    public static SearchResultGroup[] excludeCompilationUnits(SearchResultGroup[] searchResultGroupArray, RefactoringStatus refactoringStatus) throws JavaModelException {
        ArrayList<SearchResultGroup> arrayList = new ArrayList<SearchResultGroup>();
        boolean bl = searchResultGroupArray.length == 0;
        int n = 0;
        while (n < searchResultGroupArray.length) {
            IResource iResource = searchResultGroupArray[n].getResource();
            IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
            if (iJavaElement instanceof ICompilationUnit) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)JavaCore.create((IResource)iResource);
                if (!iCompilationUnit.isStructureKnown()) {
                    String string = Checks.getFullPath(iCompilationUnit);
                    refactoringStatus.addError(Messages.format(RefactoringCoreMessages.Checks_cannot_be_parsed, string));
                } else {
                    arrayList.add(searchResultGroupArray[n]);
                }
            }
            ++n;
        }
        if (!bl && arrayList.isEmpty()) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.Checks_all_excluded);
        }
        return arrayList.toArray(new SearchResultGroup[arrayList.size()]);
    }

    private static final String getFullPath(ICompilationUnit iCompilationUnit) {
        Assert.isTrue((boolean)iCompilationUnit.exists());
        return iCompilationUnit.getResource().getFullPath().toString();
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] searchResultGroupArray) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < searchResultGroupArray.length) {
            Checks.checkCompileErrorsInAffectedFile(refactoringStatus, searchResultGroupArray[n].getResource());
            ++n;
        }
        return refactoringStatus;
    }

    public static void checkCompileErrorsInAffectedFile(RefactoringStatus refactoringStatus, IResource iResource) throws JavaModelException {
        if (Checks.hasCompileErrors(iResource)) {
            refactoringStatus.addWarning(Messages.format(RefactoringCoreMessages.Checks_cu_has_compile_errors, iResource.getFullPath().makeRelative()));
        }
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] searchResultGroupArray, IResource iResource) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < searchResultGroupArray.length) {
            IResource iResource2 = searchResultGroupArray[n].getResource();
            if (iResource2.equals((Object)iResource)) {
                iResource = null;
            }
            Checks.checkCompileErrorsInAffectedFile(refactoringStatus, iResource2);
            ++n;
        }
        if (iResource != null) {
            Checks.checkCompileErrorsInAffectedFile(refactoringStatus, iResource);
        }
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasCompileErrors(IResource iResource) throws JavaModelException {
        try {
            IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.wst.jsdt.core.problem", true, 2);
            int n = 0;
            while (true) {
                if (n >= iMarkerArray.length) {
                    return false;
                }
                if (iMarkerArray[n].getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            throw javaModelException;
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    public static boolean isReadOnly(Object object) throws JavaModelException {
        if (object instanceof IResource) {
            return Checks.isReadOnly((IResource)object);
        }
        if (object instanceof IJavaElement) {
            if (object instanceof IPackageFragmentRoot && Checks.isClasspathDelete((IPackageFragmentRoot)object)) {
                return false;
            }
            return Checks.isReadOnly(((IJavaElement)object).getResource());
        }
        Assert.isTrue((boolean)false, (String)"not expected to get here");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReadOnly(IResource iResource) throws JavaModelException {
        ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
        if (resourceAttributes != null && resourceAttributes.isReadOnly()) {
            return true;
        }
        if (!(iResource instanceof IContainer)) {
            return false;
        }
        IContainer iContainer = (IContainer)iResource;
        try {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (true) {
                if (n >= iResourceArray.length) {
                    return false;
                }
                if (Checks.isReadOnly(iResourceArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            throw javaModelException;
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    public static boolean isClasspathDelete(IPackageFragmentRoot iPackageFragmentRoot) {
        IResource iResource = iPackageFragmentRoot.getResource();
        if (iResource == null) {
            return true;
        }
        IProject iProject = iResource.getProject();
        if (iResource.getParent() != null && iPackageFragmentRoot.isArchive() && !iResource.getParent().equals((Object)iProject)) {
            return true;
        }
        IProject iProject2 = iPackageFragmentRoot.getJavaProject().getProject();
        return !iProject.equals((Object)iProject2);
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] iFileArray, Object object) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IStatus iStatus = Resources.checkInSync((IResource[])iFileArray);
        if (!iStatus.isOK()) {
            refactoringStatus.merge(RefactoringStatus.create((IStatus)iStatus));
        }
        if (!(iStatus = Resources.makeCommittable((IResource[])iFileArray, object)).isOK()) {
            refactoringStatus.merge(RefactoringStatus.create((IStatus)iStatus));
            if (!refactoringStatus.hasFatalError()) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return refactoringStatus;
    }

    public static RefactoringStatus validateEdit(ICompilationUnit iCompilationUnit, Object object) {
        IResource iResource = iCompilationUnit.getPrimary().getResource();
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (iResource == null) {
            return refactoringStatus;
        }
        IStatus iStatus = Resources.checkInSync(iResource);
        if (!iStatus.isOK()) {
            refactoringStatus.merge(RefactoringStatus.create((IStatus)iStatus));
        }
        if (!(iStatus = Resources.makeCommittable(iResource, object)).isOK()) {
            refactoringStatus.merge(RefactoringStatus.create((IStatus)iStatus));
            if (!refactoringStatus.hasFatalError()) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return refactoringStatus;
    }

    public static RefactoringStatus checkAvailability(IJavaElement iJavaElement) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (!iJavaElement.exists()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_not_in_model, iJavaElement.getElementName()));
        }
        if (iJavaElement.isReadOnly()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_read_only, iJavaElement.getElementName()));
        }
        if (iJavaElement.exists() && !iJavaElement.isStructureKnown()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_unknown_structure, iJavaElement.getElementName()));
        }
        if (iJavaElement instanceof IMember && ((IMember)iJavaElement).isBinary()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_binary, iJavaElement.getElementName()));
        }
        return refactoringStatus;
    }

    public static boolean isAvailable(IJavaElement iJavaElement) throws JavaModelException {
        if (iJavaElement == null) {
            return false;
        }
        if (!iJavaElement.exists()) {
            return false;
        }
        if (iJavaElement.isReadOnly()) {
            return false;
        }
        if (!(iJavaElement instanceof IJavaProject || iJavaElement instanceof ILocalVariable || iJavaElement.isStructureKnown())) {
            return false;
        }
        return !(iJavaElement instanceof IMember) || !((IMember)iJavaElement).isBinary();
    }

    public static IType findTypeInPackage(IPackageFragment iPackageFragment, String string) throws JavaModelException {
        Assert.isTrue((boolean)iPackageFragment.exists());
        Assert.isTrue((!iPackageFragment.isReadOnly() ? 1 : 0) != 0);
        if (string.indexOf(".") != -1) {
            string = string.substring(0, string.indexOf("."));
        }
        ICompilationUnit[] iCompilationUnitArray = iPackageFragment.getCompilationUnits();
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            if (iCompilationUnitArray[n].getType(string).exists()) {
                return iCompilationUnitArray[n].getType(string);
            }
            ++n;
        }
        return null;
    }

    public static RefactoringStatus checkTempName(String string) {
        RefactoringStatus refactoringStatus = Checks.checkIdentifier(string);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        if (!Checks.startsWithLowerCase(string)) {
            refactoringStatus.addWarning(RefactoringCoreMessages.ExtractTempRefactoring_convention);
        }
        return refactoringStatus;
    }

    public static RefactoringStatus checkEnumConstantName(String string) {
        RefactoringStatus refactoringStatus = Checks.checkFieldName(string);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                refactoringStatus.addWarning(RefactoringCoreMessages.RenameEnumConstRefactoring_convention);
                break;
            }
            ++n;
        }
        return refactoringStatus;
    }

    public static RefactoringStatus checkConstantName(String string) {
        RefactoringStatus refactoringStatus = Checks.checkFieldName(string);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                refactoringStatus.addWarning(RefactoringCoreMessages.ExtractConstantRefactoring_convention);
                break;
            }
            ++n;
        }
        return refactoringStatus;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isException(IType var0, IProgressMonitor var1_1) throws JavaModelException {
        block6: {
            if (var0.isClass()) break block6;
            while (true) {
                var4_2 = null;
                var1_1.done();
                return false;
            }
        }
        try {
            var2_5 = var0.newSupertypeHierarchy(var1_1).getAllSupertypes(var0);
            var3_6 = 0;
            while (true) {
                if (var3_6 >= var2_5.length) ** continue;
                if (!"java.lang.Throwable".equals(var2_5[var3_6].getFullyQualifiedName())) break block7;
                var4_3 = null;
                break;
            }
        }
        catch (Throwable var5_7) {
            var4_4 = null;
            var1_1.done();
            throw var5_7;
        }
        {
            block7: {
                var1_1.done();
                return true;
            }
            ++var3_6;
            continue;
        }
    }

    public static int checkExpressionIsRValue(Expression expression) {
        if (expression instanceof Name && !(((Name)expression).resolveBinding() instanceof IVariableBinding)) {
            return 1;
        }
        ITypeBinding iTypeBinding = expression.resolveTypeBinding();
        if (iTypeBinding == null) {
            return 1;
        }
        if (iTypeBinding.getName().equals("void")) {
            return 2;
        }
        return 0;
    }

    public static boolean isDeclaredIn(VariableDeclaration variableDeclaration, Class clazz) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = ASTNodes.getParent((ASTNode)variableDeclaration, clazz);
        if (aSTNode2 == null) {
            return false;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((aSTNode = ASTNodes.getParent((ASTNode)variableDeclaration, clazz2)) == null) {
            return true;
        }
        return !ASTNodes.isParent(aSTNode, aSTNode2);
    }
}

