/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class JDTRefactoringDescriptorComment {
    private static final String ELEMENT_DELIMITER = RefactoringCoreMessages.JavaRefactoringDescriptorComment_element_delimiter;
    private static final String LINE_DELIMITER = System.getProperty("line.separator", "\n");
    private final String fHeader;
    private final String fProject;
    private final List fSettings = new ArrayList(6);

    public static String createCompositeSetting(String string, String[] stringArray) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)stringArray);
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && !"".equals(stringArray[n])) {
                stringBuffer.append(LINE_DELIMITER);
                stringBuffer.append(ELEMENT_DELIMITER);
                stringBuffer.append(stringArray[n]);
            } else {
                stringBuffer.append(LINE_DELIMITER);
                stringBuffer.append(ELEMENT_DELIMITER);
                stringBuffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, string);
        }
        return stringBuffer.toString();
    }

    public JDTRefactoringDescriptorComment(String string, Object object, String string2) {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)string2);
        this.fProject = string;
        this.fHeader = string2;
        this.initializeInferredSettings(object);
    }

    public void addSetting(int n, String string) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)string);
        Assert.isTrue((!"".equals(string) ? 1 : 0) != 0);
        this.fSettings.add(n, string);
    }

    public void addSetting(String string) {
        if (string != null && !"".equals(string)) {
            this.fSettings.add(string);
        }
    }

    public String asString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.fHeader);
        if (this.fProject != null && !"".equals(this.fProject)) {
            stringBuffer.append(LINE_DELIMITER);
            stringBuffer.append(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_original_project, this.fProject));
        }
        Iterator iterator = this.fSettings.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(LINE_DELIMITER);
            stringBuffer.append(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_inferred_setting_pattern, string));
        }
        return stringBuffer.toString();
    }

    public int getCount() {
        return this.fSettings.size();
    }

    private void initializeInferredSettings(Object object) {
        Object object2;
        Object object3;
        if (object instanceof INameUpdating) {
            object3 = (INameUpdating)object;
            this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabels.getTextLabel(object3.getElements()[0], JavaElementLabels.ALL_FULLY_QUALIFIED)));
            try {
                object2 = object3.getNewElement();
                if (object2 != null) {
                    this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_renamed_element_pattern, JavaElementLabels.getTextLabel(object2, JavaElementLabels.ALL_FULLY_QUALIFIED)));
                } else {
                    String string = JavaElementLabels.getTextLabel(object3.getElements()[0], JavaElementLabels.ALL_FULLY_QUALIFIED);
                    String string2 = object3.getCurrentElementName();
                    if (string2.length() < string.length()) {
                        String string3 = string.substring(0, string.length() - string2.length());
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_renamed_element_pattern, String.valueOf(string3) + object3.getNewElementName()));
                    }
                }
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        } else if (object instanceof RefactoringProcessor) {
            object3 = (RefactoringProcessor)object;
            object2 = object3.getElements();
            if (object2 != null) {
                if (((IJavaElement)object2).length == 1 && object2[0] != null) {
                    this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabels.getTextLabel(object2[0], JavaElementLabels.ALL_FULLY_QUALIFIED)));
                } else if (((IJavaElement)object2).length > 1) {
                    StringBuffer stringBuffer = new StringBuffer(128);
                    stringBuffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_original_elements);
                    int n = 0;
                    while (n < ((IJavaElement)object2).length) {
                        if (object2[n] != null) {
                            stringBuffer.append(LINE_DELIMITER);
                            stringBuffer.append(ELEMENT_DELIMITER);
                            stringBuffer.append(JavaElementLabels.getTextLabel(object2[n], JavaElementLabels.ALL_FULLY_QUALIFIED));
                        } else {
                            stringBuffer.append(LINE_DELIMITER);
                            stringBuffer.append(ELEMENT_DELIMITER);
                            stringBuffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
                        }
                        ++n;
                    }
                    this.fSettings.add(stringBuffer.toString());
                }
            }
        } else if (object instanceof IReorgPolicy) {
            Object object4;
            object3 = (IReorgPolicy)object;
            object2 = object3.getJavaElementDestination();
            if (object2 != null) {
                this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_destination_pattern, JavaElementLabels.getTextLabel(object2, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            } else {
                object2 = object3.getResourceDestination();
                if (object2 != null) {
                    this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_destination_pattern, JavaElementLabels.getTextLabel(object2, JavaElementLabels.ALL_FULLY_QUALIFIED)));
                }
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.addAll(Arrays.asList(object3.getJavaElements()));
            arrayList.addAll(Arrays.asList(object3.getResources()));
            Object[] objectArray = arrayList.toArray();
            if (objectArray != null) {
                if (objectArray.length == 1 && objectArray[0] != null) {
                    this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabels.getTextLabel(objectArray[0], JavaElementLabels.ALL_FULLY_QUALIFIED)));
                } else if (objectArray.length > 1) {
                    object4 = new StringBuffer(128);
                    ((StringBuffer)object4).append(RefactoringCoreMessages.JavaRefactoringDescriptor_original_elements);
                    int n = 0;
                    while (n < objectArray.length) {
                        if (objectArray[n] != null) {
                            ((StringBuffer)object4).append(LINE_DELIMITER);
                            ((StringBuffer)object4).append(ELEMENT_DELIMITER);
                            ((StringBuffer)object4).append(JavaElementLabels.getTextLabel(objectArray[n], JavaElementLabels.ALL_FULLY_QUALIFIED));
                        } else {
                            ((StringBuffer)object4).append(LINE_DELIMITER);
                            ((StringBuffer)object4).append(ELEMENT_DELIMITER);
                            ((StringBuffer)object4).append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
                        }
                        ++n;
                    }
                    this.fSettings.add(((StringBuffer)object4).toString());
                }
            }
            if (object instanceof IReorgPolicy.IMovePolicy && (object4 = (IReorgPolicy.IMovePolicy)object).isTextualMove()) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptorComment_textual_move_only);
            }
        }
        if (object instanceof IReferenceUpdating && (object3 = (IReferenceUpdating)object).canEnableUpdateReferences() && object3.getUpdateReferences()) {
            this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_update_references);
        }
        if (object instanceof ISimilarDeclarationUpdating && (object3 = (ISimilarDeclarationUpdating)object).canEnableSimilarDeclarationUpdating() && object3.getUpdateSimilarDeclarations()) {
            int n = object3.getMatchStrategy();
            if (n == 1) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar);
            } else if (n == 2) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar_embedded);
            } else if (n == 3) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar_suffix);
            }
        }
        if (object instanceof IQualifiedNameUpdating && (object3 = (IQualifiedNameUpdating)object).canEnableQualifiedNameUpdating() && object3.getUpdateQualifiedNames()) {
            String string = object3.getFilePatterns();
            if (string != null && !"".equals(string)) {
                this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_qualified_names_pattern, string.trim()));
            } else {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_qualified_names);
            }
        }
        if (object instanceof ITextUpdating && (object3 = (ITextUpdating)object).canEnableTextUpdating()) {
            this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_textual_occurrences);
        }
        if (object instanceof IDelegateUpdating && (object3 = (IDelegateUpdating)object).canEnableDelegateUpdating() && object3.getDelegateUpdating()) {
            if (object3.getDeprecateDelegates()) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_keep_original_deprecated);
            } else {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_keep_original);
            }
        }
    }

    public void removeSetting(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fSettings.remove(n);
    }
}

