/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.WorkspaceTracker;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class DynamicValidationStateChange
extends CompositeChange
implements WorkspaceTracker.Listener {
    private boolean fListenerRegistered = false;
    private RefactoringStatus fValidationState = null;
    private long fTimeStamp;
    private ISchedulingRule fSchedulingRule;
    private static final long LIFE_TIME = 1800000L;

    public DynamicValidationStateChange(Change change) {
        super(change.getName());
        this.add(change);
        this.markAsSynthetic();
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public DynamicValidationStateChange(String string) {
        super(string);
        this.markAsSynthetic();
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public DynamicValidationStateChange(String string, Change[] changeArray) {
        super(string, changeArray);
        this.markAsSynthetic();
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void initializeValidationData(IProgressMonitor iProgressMonitor) {
        super.initializeValidationData(iProgressMonitor);
        WorkspaceTracker.INSTANCE.addListener(this);
        this.fListenerRegistered = true;
        this.fTimeStamp = System.currentTimeMillis();
    }

    public void dispose() {
        if (this.fListenerRegistered) {
            WorkspaceTracker.INSTANCE.removeListener(this);
            this.fListenerRegistered = false;
        }
        super.dispose();
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fValidationState == null) {
            return super.isValid(iProgressMonitor);
        }
        return this.fValidationState;
    }

    public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
        final Change[] changeArray = new Change[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                changeArray[0] = DynamicValidationStateChange.super.perform(iProgressMonitor);
            }
        };
        JavaCore.run((IWorkspaceRunnable)iWorkspaceRunnable, (ISchedulingRule)this.fSchedulingRule, (IProgressMonitor)iProgressMonitor);
        return changeArray[0];
    }

    protected Change createUndoChange(Change[] changeArray) {
        DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(this.getName());
        int n = 0;
        while (n < changeArray.length) {
            dynamicValidationStateChange.add(changeArray[n]);
            ++n;
        }
        return dynamicValidationStateChange;
    }

    public void workspaceChanged() {
        long l = System.currentTimeMillis();
        if (l - this.fTimeStamp < 1800000L) {
            return;
        }
        this.fValidationState = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.DynamicValidationStateChange_workspace_changed);
        WorkspaceTracker.INSTANCE.removeListener(this);
        this.fListenerRegistered = false;
        Change[] changeArray = this.clear();
        int n = 0;
        while (n < changeArray.length) {
            final Change change = changeArray[n];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    change.dispose();
                }

                public void handleException(Throwable throwable) {
                    JavaPlugin.log(throwable);
                }
            });
            ++n;
        }
    }

    public void setSchedulingRule(ISchedulingRule iSchedulingRule) {
        this.fSchedulingRule = iSchedulingRule;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.fSchedulingRule;
    }
}

