/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitReorgChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class MoveCompilationUnitChange
extends CompilationUnitReorgChange {
    private boolean fUndoable;
    private long fStampToRestore;

    public MoveCompilationUnitChange(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment) {
        super(iCompilationUnit, iPackageFragment);
        this.fStampToRestore = -1L;
    }

    private MoveCompilationUnitChange(IPackageFragment iPackageFragment, String string, IPackageFragment iPackageFragment2, long l) {
        super(iPackageFragment.getHandleIdentifier(), iPackageFragment2.getHandleIdentifier(), iPackageFragment.getCompilationUnit(string).getHandleIdentifier());
        this.fStampToRestore = l;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.MoveCompilationUnitChange_name, new String[]{this.getCu().getElementName(), MoveCompilationUnitChange.getPackageName(this.getDestinationPackage())});
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        return super.isValid(iProgressMonitor, 7);
    }

    Change doPerformReorg(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        ICompilationUnit iCompilationUnit;
        IResource iResource;
        String string = this.getNewName();
        String string2 = string == null ? this.getCu().getElementName() : string;
        long l = -1L;
        IResource iResource2 = this.getCu().getResource();
        if (iResource2 != null) {
            l = iResource2.getModificationStamp();
        }
        this.fUndoable = !this.getDestinationPackage().getCompilationUnit(string2).exists();
        this.getCu().move((IJavaElement)this.getDestinationPackage(), null, string, true, iProgressMonitor);
        if (this.fStampToRestore != -1L && (iResource = (iCompilationUnit = this.getDestinationPackage().getCompilationUnit(string2)).getResource()) != null) {
            iResource.revertModificationStamp(this.fStampToRestore);
        }
        if (this.fUndoable) {
            return new MoveCompilationUnitChange(this.getDestinationPackage(), this.getCu().getElementName(), this.getOldPackage(), l);
        }
        return null;
    }
}

