/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenameCompilationUnitChange
extends AbstractJavaElementRenameChange {
    public RenameCompilationUnitChange(ICompilationUnit iCompilationUnit, String string) {
        this(iCompilationUnit.getResource().getFullPath(), iCompilationUnit.getElementName(), string, -1L);
        Assert.isTrue((!iCompilationUnit.isReadOnly() ? 1 : 0) != 0, (String)"compilation unit must not be read-only");
    }

    private RenameCompilationUnitChange(IPath iPath, String string, String string2, long l) {
        super(iPath, string, string2, l);
    }

    protected IPath createNewPath() {
        IPath iPath = this.getResourcePath();
        if (iPath.getFileExtension() != null) {
            return iPath.removeFileExtension().removeLastSegments(1).append(this.getNewName());
        }
        return iPath.removeLastSegments(1).append(this.getNewName());
    }

    protected Change createUndoChange(long l) throws JavaModelException {
        return new RenameCompilationUnitChange(this.createNewPath(), this.getNewName(), this.getOldName(), l);
    }

    protected void doRename(IProgressMonitor iProgressMonitor) throws CoreException {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)this.getModifiedElement();
        if (iCompilationUnit != null) {
            iCompilationUnit.rename(this.getNewName(), false, iProgressMonitor);
        }
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_name, new String[]{this.getOldName(), this.getNewName()});
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        return super.isValid(iProgressMonitor, 7);
    }
}

