/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExceptionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.LocalTypeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.CodeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

class ExtractMethodAnalyzer
extends CodeAnalyzer {
    public static final int ERROR = -2;
    public static final int UNDEFINED = -1;
    public static final int NO = 0;
    public static final int EXPRESSION = 1;
    public static final int ACCESS_TO_LOCAL = 2;
    public static final int RETURN_STATEMENT_VOID = 3;
    public static final int RETURN_STATEMENT_VALUE = 4;
    public static final int MULTIPLE = 5;
    private BodyDeclaration fEnclosingBodyDeclaration;
    private IMethodBinding fEnclosingMethodBinding;
    private int fMaxVariableId;
    private int fReturnKind;
    private Type fReturnType;
    private FlowInfo fInputFlowInfo;
    private FlowContext fInputFlowContext;
    private IVariableBinding[] fArguments;
    private IVariableBinding[] fMethodLocals;
    private ITypeBinding[] fTypeVariables;
    private IVariableBinding fReturnValue;
    private IVariableBinding[] fCallerLocals;
    private IVariableBinding fReturnLocal;
    private ITypeBinding[] fAllExceptions;
    private ITypeBinding fExpressionBinding;
    private boolean fForceStatic;
    private boolean fIsLastStatementSelected;
    static /* synthetic */ Class class$0;

    public ExtractMethodAnalyzer(ICompilationUnit iCompilationUnit, Selection selection) throws JavaModelException {
        super(iCompilationUnit, selection, false);
    }

    public BodyDeclaration getEnclosingBodyDeclaration() {
        return this.fEnclosingBodyDeclaration;
    }

    public int getReturnKind() {
        return this.fReturnKind;
    }

    public boolean extractsExpression() {
        return this.fReturnKind == 1;
    }

    public Type getReturnType() {
        return this.fReturnType;
    }

    public boolean generateImport() {
        switch (this.fReturnKind) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public IVariableBinding[] getArguments() {
        return this.fArguments;
    }

    public IVariableBinding[] getMethodLocals() {
        return this.fMethodLocals;
    }

    public IVariableBinding getReturnValue() {
        return this.fReturnValue;
    }

    public IVariableBinding[] getCallerLocals() {
        return this.fCallerLocals;
    }

    public IVariableBinding getReturnLocal() {
        return this.fReturnLocal;
    }

    public ITypeBinding getExpressionBinding() {
        return this.fExpressionBinding;
    }

    public boolean getForceStatic() {
        return this.fForceStatic;
    }

    public ITypeBinding[] getTypeVariables() {
        return this.fTypeVariables;
    }

    public RefactoringStatus checkInitialConditions(ImportRewrite importRewrite) {
        int n;
        RefactoringStatus refactoringStatus = this.getStatus();
        this.checkExpression(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.fReturnKind = -1;
        this.fMaxVariableId = LocalVariableIndex.perform(this.fEnclosingBodyDeclaration);
        if (this.analyzeSelection(refactoringStatus).hasFatalError()) {
            return refactoringStatus;
        }
        int n2 = n = this.fReturnKind == 0 ? 0 : 1;
        if (this.fReturnValue != null) {
            this.fReturnKind = 2;
            ++n;
        }
        if (this.isExpressionSelected()) {
            this.fReturnKind = 1;
            ++n;
        }
        if (n > 1) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_ambiguous_return_value, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            this.fReturnKind = 5;
            return refactoringStatus;
        }
        this.initReturnType(importRewrite);
        return refactoringStatus;
    }

    private void checkExpression(RefactoringStatus refactoringStatus) {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (aSTNodeArray != null && aSTNodeArray.length == 1) {
            ASTNode aSTNode = aSTNodeArray[0];
            if (aSTNode instanceof Type) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_type_reference, JavaStatusContext.create((ITypeRoot)this.fCUnit, aSTNode));
            } else if (aSTNode.getLocationInParent() == SwitchCase.EXPRESSION_PROPERTY) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_switch_case, JavaStatusContext.create((ITypeRoot)this.fCUnit, aSTNode));
            }
        }
    }

    private void initReturnType(ImportRewrite importRewrite) {
        AST aST = this.fEnclosingBodyDeclaration.getAST();
        this.fReturnType = null;
        switch (this.fReturnKind) {
            case 2: {
                VariableDeclaration variableDeclaration = ASTNodes.findVariableDeclaration(this.fReturnValue, (ASTNode)this.fEnclosingBodyDeclaration);
                this.fReturnType = ASTNodeFactory.newType(aST, variableDeclaration);
                break;
            }
            case 1: {
                Expression expression = (Expression)this.getFirstSelectedNode();
                this.fExpressionBinding = expression.getNodeType() == 14 ? ((ClassInstanceCreation)expression).getType().resolveBinding() : expression.resolveTypeBinding();
                if (this.fExpressionBinding != null) {
                    if (this.fExpressionBinding.isNullType()) {
                        this.getStatus().addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_null_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)expression));
                        break;
                    }
                    ITypeBinding iTypeBinding = Bindings.normalizeForDeclarationUse(this.fExpressionBinding, aST);
                    if (iTypeBinding == null) break;
                    this.fReturnType = importRewrite.addImport(iTypeBinding, aST);
                    break;
                }
                this.fReturnType = aST.newPrimitiveType(PrimitiveType.VOID);
                this.getStatus().addError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_determine_return_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)expression));
                break;
            }
            case 4: {
                if (this.fEnclosingBodyDeclaration.getNodeType() != 31) break;
                this.fReturnType = ((MethodDeclaration)this.fEnclosingBodyDeclaration).getReturnType2();
                break;
            }
            default: {
                this.fReturnType = aST.newPrimitiveType(PrimitiveType.VOID);
            }
        }
        if (this.fReturnType == null) {
            this.fReturnType = aST.newPrimitiveType(PrimitiveType.VOID);
        }
    }

    public boolean isLiteralNodeSelected() {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (aSTNodeArray.length != 1) {
            return false;
        }
        ASTNode aSTNode = aSTNodeArray[0];
        switch (aSTNode.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: 
            case 87: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    public void checkInput(RefactoringStatus refactoringStatus, String string, AST aST) {
        ITypeBinding[] iTypeBindingArray = this.getArgumentTypes();
        ITypeBinding iTypeBinding = ASTNodes.getEnclosingType((ASTNode)this.fEnclosingBodyDeclaration);
        refactoringStatus.merge(Checks.checkMethodInType(iTypeBinding, string, iTypeBindingArray));
        refactoringStatus.merge(Checks.checkMethodInHierarchy(iTypeBinding.getSuperclass(), string, null, iTypeBindingArray));
    }

    private ITypeBinding[] getArgumentTypes() {
        ITypeBinding[] iTypeBindingArray = new ITypeBinding[this.fArguments.length];
        int n = 0;
        while (n < this.fArguments.length) {
            iTypeBindingArray[n] = this.fArguments[n].getType();
            ++n;
        }
        return iTypeBindingArray;
    }

    private RefactoringStatus analyzeSelection(RefactoringStatus refactoringStatus) {
        this.fInputFlowContext = new FlowContext(0, this.fMaxVariableId + 1);
        this.fInputFlowContext.setConsiderAccessMode(true);
        this.fInputFlowContext.setComputeMode(FlowContext.ARGUMENTS);
        InOutFlowAnalyzer inOutFlowAnalyzer = new InOutFlowAnalyzer(this.fInputFlowContext);
        this.fInputFlowInfo = inOutFlowAnalyzer.perform(this.getSelectedNodes());
        if (this.fInputFlowInfo.branches()) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_branch_mismatch, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            this.fReturnKind = -2;
            return refactoringStatus;
        }
        if (this.fInputFlowInfo.isValueReturn()) {
            this.fReturnKind = 4;
        } else if (this.fInputFlowInfo.isVoidReturn() || this.fInputFlowInfo.isPartialReturn() && this.isVoidMethod() && this.isLastStatementSelected()) {
            this.fReturnKind = 3;
        } else if (this.fInputFlowInfo.isNoReturn() || this.fInputFlowInfo.isThrow() || this.fInputFlowInfo.isUndefined()) {
            this.fReturnKind = 0;
        }
        if (this.fReturnKind == -1) {
            refactoringStatus.addError(RefactoringCoreMessages.FlowAnalyzer_execution_flow, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            this.fReturnKind = 0;
        }
        this.computeInput();
        this.computeExceptions();
        this.computeOutput(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.adjustArgumentsAndMethodLocals();
        this.compressArrays();
        return refactoringStatus;
    }

    private boolean isVoidMethod() {
        if (this.fEnclosingMethodBinding == null) {
            return true;
        }
        ITypeBinding iTypeBinding = this.fEnclosingMethodBinding.getReturnType();
        return this.fEnclosingBodyDeclaration.getAST().resolveWellKnownType("void").equals((Object)iTypeBinding);
    }

    public boolean isLastStatementSelected() {
        return this.fIsLastStatementSelected;
    }

    private void computeLastStatementSelected() {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (aSTNodeArray.length == 0) {
            this.fIsLastStatementSelected = false;
        } else {
            Block block = null;
            if (this.fEnclosingBodyDeclaration instanceof MethodDeclaration) {
                block = ((MethodDeclaration)this.fEnclosingBodyDeclaration).getBody();
            } else if (this.fEnclosingBodyDeclaration instanceof Initializer) {
                block = ((Initializer)this.fEnclosingBodyDeclaration).getBody();
            }
            if (block != null) {
                List list = block.statements();
                this.fIsLastStatementSelected = aSTNodeArray[aSTNodeArray.length - 1] == list.get(list.size() - 1);
            }
        }
    }

    private void computeInput() {
        int n = 54;
        this.fArguments = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, n));
        this.fMethodLocals = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, 24));
        this.fTypeVariables = this.computeTypeVariables(this.fInputFlowInfo.getTypeVariables());
    }

    private IVariableBinding[] removeSelectedDeclarations(IVariableBinding[] iVariableBindingArray) {
        ArrayList<IVariableBinding> arrayList = new ArrayList<IVariableBinding>(iVariableBindingArray.length);
        Selection selection = this.getSelection();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            ASTNode aSTNode = ((CompilationUnit)this.fEnclosingBodyDeclaration.getRoot()).findDeclaringNode((IBinding)iVariableBindingArray[n]);
            if (!selection.covers(aSTNode)) {
                arrayList.add(iVariableBindingArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IVariableBinding[arrayList.size()]);
    }

    private ITypeBinding[] computeTypeVariables(ITypeBinding[] iTypeBindingArray) {
        ASTNode aSTNode;
        Selection selection = this.getSelection();
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>();
        CompilationUnit compilationUnit = (CompilationUnit)this.fEnclosingBodyDeclaration.getRoot();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            aSTNode = compilationUnit.findDeclaringNode((IBinding)iTypeBindingArray[n]);
            if (aSTNode == null || !selection.covers(aSTNode) && aSTNode.getParent() instanceof MethodDeclaration) {
                hashSet.add(iTypeBindingArray[n]);
            }
            ++n;
        }
        n = 0;
        while (n < this.fArguments.length) {
            ASTNode aSTNode2;
            aSTNode = this.fArguments[n];
            ITypeBinding iTypeBinding = aSTNode.getType();
            if (iTypeBinding != null && iTypeBinding.isTypeVariable() && ((aSTNode2 = compilationUnit.findDeclaringNode((IBinding)iTypeBinding)) == null || !selection.covers(aSTNode2) && aSTNode2.getParent() instanceof MethodDeclaration)) {
                hashSet.add(iTypeBinding);
            }
            ++n;
        }
        return hashSet.toArray(new ITypeBinding[hashSet.size()]);
    }

    private void computeOutput(RefactoringStatus refactoringStatus) {
        Object object;
        FlowContext flowContext = new FlowContext(0, this.fMaxVariableId + 1);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.RETURN_VALUES);
        FlowInfo flowInfo = new InOutFlowAnalyzer(flowContext).perform(this.getSelectedNodes());
        IVariableBinding[] iVariableBindingArray = flowInfo.get(flowContext, 56);
        IRegion iRegion = this.getSelectedNodeRange();
        Selection selection = Selection.createFromStartLength(iRegion.getOffset(), iRegion.getLength());
        int n = 0;
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo flowInfo2 = new InputFlowAnalyzer(flowContext, selection, true).perform(this.fEnclosingBodyDeclaration);
        IVariableBinding[] iVariableBindingArray2 = flowInfo2.get(flowContext, 38);
        int n2 = 0;
        while (n2 < iVariableBindingArray.length && n <= 1) {
            object = iVariableBindingArray[n2];
            int n3 = 0;
            while (n3 < iVariableBindingArray2.length) {
                if (iVariableBindingArray2[n3] == object) {
                    ++n;
                    this.fReturnValue = object;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                this.fReturnValue = null;
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.fReturnValue = null;
                refactoringStatus.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_assignments_to_local, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
                return;
            }
        }
        ArrayList<IVariableBinding> arrayList = new ArrayList<IVariableBinding>(5);
        object = new InputFlowAnalyzer(flowContext, selection, false).perform(this.fEnclosingBodyDeclaration);
        IVariableBinding[] iVariableBindingArray3 = ((FlowInfo)object).get(flowContext, 56);
        int n4 = 0;
        while (n4 < iVariableBindingArray3.length) {
            IVariableBinding iVariableBinding = iVariableBindingArray3[n4];
            if (this.getSelection().covers(ASTNodes.findDeclaration((IBinding)iVariableBinding, (ASTNode)this.fEnclosingBodyDeclaration))) {
                arrayList.add(iVariableBinding);
            }
            ++n4;
        }
        this.fCallerLocals = arrayList.toArray(new IVariableBinding[arrayList.size()]);
        if (this.fReturnValue != null && this.getSelection().covers(ASTNodes.findDeclaration((IBinding)this.fReturnValue, (ASTNode)this.fEnclosingBodyDeclaration))) {
            this.fReturnLocal = this.fReturnValue;
        }
    }

    private void adjustArgumentsAndMethodLocals() {
        int n = 0;
        while (n < this.fArguments.length) {
            IVariableBinding iVariableBinding = this.fArguments[n];
            if (this.fInputFlowInfo.hasAccessMode(this.fInputFlowContext, iVariableBinding, 16)) {
                if (iVariableBinding != this.fReturnValue) {
                    this.fArguments[n] = null;
                }
                if (this.fArguments[n] != null) {
                    int n2 = 0;
                    while (n2 < this.fMethodLocals.length) {
                        if (this.fMethodLocals[n2] == iVariableBinding) {
                            this.fMethodLocals[n2] = null;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void compressArrays() {
        this.fArguments = this.compressArray(this.fArguments);
        this.fCallerLocals = this.compressArray(this.fCallerLocals);
        this.fMethodLocals = this.compressArray(this.fMethodLocals);
    }

    private IVariableBinding[] compressArray(IVariableBinding[] iVariableBindingArray) {
        if (iVariableBindingArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < iVariableBindingArray.length) {
            if (iVariableBindingArray[n2] != null) {
                ++n;
            }
            ++n2;
        }
        if (n == iVariableBindingArray.length) {
            return iVariableBindingArray;
        }
        IVariableBinding[] iVariableBindingArray2 = new IVariableBinding[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < iVariableBindingArray.length) {
            if (iVariableBindingArray[n3] != null) {
                iVariableBindingArray2[n4++] = iVariableBindingArray[n3];
            }
            ++n3;
        }
        return iVariableBindingArray2;
    }

    public void aboutToCreateChange() {
    }

    public ITypeBinding[] getExceptions(boolean bl, AST aST) {
        if (bl) {
            return this.fAllExceptions;
        }
        ArrayList<ITypeBinding> arrayList = new ArrayList<ITypeBinding>(this.fAllExceptions.length);
        int n = 0;
        while (n < this.fAllExceptions.length) {
            ITypeBinding iTypeBinding = this.fAllExceptions[n];
            if (bl || !Bindings.isRuntimeException(iTypeBinding)) {
                arrayList.add(iTypeBinding);
            }
            ++n;
        }
        return arrayList.toArray(new ITypeBinding[arrayList.size()]);
    }

    private void computeExceptions() {
        this.fAllExceptions = ExceptionAnalyzer.perform(this.getSelectedNodes());
    }

    protected void handleNextSelectedNode(ASTNode aSTNode) {
        super.handleNextSelectedNode(aSTNode);
        this.checkParent(aSTNode);
    }

    protected boolean handleSelectionEndsIn(ASTNode aSTNode) {
        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_doesNotCover, JavaStatusContext.create((ITypeRoot)this.fCUnit, aSTNode));
        return super.handleSelectionEndsIn(aSTNode);
    }

    private void checkParent(ASTNode aSTNode) {
        ASTNode aSTNode2 = this.getFirstSelectedNode().getParent();
        do {
            if ((aSTNode = aSTNode.getParent()) != aSTNode2) continue;
            return;
        } while (aSTNode != null);
        this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_parent_mismatch);
    }

    /*
     * Unable to fully structure code
     */
    public void endVisit(CompilationUnit var1_1) {
        block12: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            var2_2 = this.getStatus();
                            if (var2_2.hasFatalError()) break block12;
                            if (this.hasSelectedNodes()) break block13;
                            var3_3 = this.getLastCoveringNode();
                            if (var3_3 instanceof Block && var3_3.getParent() instanceof MethodDeclaration && (var5_7 = ASTNodes.getMessages((ASTNode)(var4_5 = (MethodDeclaration)var3_3.getParent()), 0)).length > 0) {
                                var2_2.addFatalError(Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_compile_errors, var4_5.getName().getIdentifier()), JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)var4_5));
                            } else {
                                var2_2.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_only_method_body);
                            }
                            break block12;
                        }
                        v0 = this.getFirstSelectedNode();
                        v1 = ExtractMethodAnalyzer.class$0;
                        if (v1 == null) {
                            try {
                                v1 = ExtractMethodAnalyzer.class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
                            }
                            catch (ClassNotFoundException v2) {
                                throw new NoClassDefFoundError(v2.getMessage());
                            }
                        }
                        this.fEnclosingBodyDeclaration = (BodyDeclaration)ASTNodes.getParent(v0, v1);
                        if (this.fEnclosingBodyDeclaration != null && (this.fEnclosingBodyDeclaration.getNodeType() == 31 || this.fEnclosingBodyDeclaration.getNodeType() == 28)) break block14;
                        var2_2.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_only_method_body);
                        break block12;
                    }
                    if (ASTNodes.getEnclosingType((ASTNode)this.fEnclosingBodyDeclaration) != null) break block15;
                    var2_2.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_compile_errors_no_parent_binding);
                    break block12;
                }
                if (this.fEnclosingBodyDeclaration.getNodeType() == 31) {
                    this.fEnclosingMethodBinding = ((MethodDeclaration)this.fEnclosingBodyDeclaration).resolveBinding();
                }
                if (this.isSingleExpressionOrStatementSet()) break block16;
                var2_2.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_single_expression_or_set);
                break block12;
            }
            if (!this.isExpressionSelected()) ** GOTO lbl48
            var3_4 = this.getFirstSelectedNode();
            if (!(var3_4 instanceof Name)) ** GOTO lbl-1000
            var4_6 = (Name)var3_4;
            if (var4_6.resolveBinding() instanceof ITypeBinding) {
                var2_2.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_type_reference);
            } else {
                if (var4_6.resolveBinding() instanceof IMethodBinding) {
                    var2_2.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_method_name_reference);
                }
                if (var4_6.isSimpleName() && ((SimpleName)var4_6).isDeclaration()) {
                    var2_2.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_name_in_declaration);
                } else lbl-1000:
                // 2 sources

                {
                    this.fForceStatic = ASTNodes.getParent(var3_4, 46) != null || ASTNodes.getParent(var3_4, 17) != null;
lbl48:
                    // 2 sources

                    var2_2.merge(LocalTypeAnalyzer.perform(this.fEnclosingBodyDeclaration, this.getSelection()));
                    this.computeLastStatementSelected();
                }
            }
        }
        super.endVisit(var1_1);
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        boolean bl = super.visit(anonymousClassDeclaration);
        if (this.isFirstSelectedNode((ASTNode)anonymousClassDeclaration)) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_anonymous_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)anonymousClassDeclaration));
            return false;
        }
        return bl;
    }

    public boolean visit(Assignment assignment) {
        boolean bl = super.visit(assignment);
        if (this.getSelection().getVisitSelectionMode((ASTNode)assignment.getLeftHandSide()) == 2) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_leftHandSideOfAssignment, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)assignment));
            return false;
        }
        return bl;
    }

    public boolean visit(DoStatement doStatement) {
        boolean bl = super.visit(doStatement);
        try {
            int n = this.getTokenScanner().getTokenEndOffset(121, doStatement.getStartPosition());
            if (this.getSelection().getOffset() == n) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_after_do_keyword, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
                return false;
            }
        }
        catch (CoreException coreException) {}
        return bl;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        Block block = methodDeclaration.getBody();
        if (block == null) {
            return false;
        }
        Selection selection = this.getSelection();
        int n = block.getStartPosition();
        int n2 = n + block.getLength();
        if (n >= selection.getOffset() || selection.getExclusiveEnd() >= n2) {
            return false;
        }
        return super.visit(methodDeclaration);
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        return this.visitConstructorInvocation((ASTNode)constructorInvocation, super.visit(constructorInvocation));
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        return this.visitConstructorInvocation((ASTNode)superConstructorInvocation, super.visit(superConstructorInvocation));
    }

    private boolean visitConstructorInvocation(ASTNode aSTNode, boolean bl) {
        if (this.getSelection().getVisitSelectionMode(aSTNode) == 2) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_super_or_this, JavaStatusContext.create((ITypeRoot)this.fCUnit, aSTNode));
            return false;
        }
        return bl;
    }

    public void endVisit(ForInStatement forInStatement) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)forInStatement) == 3 && forInStatement.getIterationVariable().equals((Object)this.getFirstSelectedNode())) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_initializer, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
        }
        super.endVisit(forInStatement);
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        boolean bl = super.visit(variableDeclarationFragment);
        if (this.isFirstSelectedNode((ASTNode)variableDeclarationFragment)) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_variable_declaration_fragment, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)variableDeclarationFragment));
            return false;
        }
        return bl;
    }

    public void endVisit(ForStatement forStatement) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)forStatement) == 3) {
            if (forStatement.initializers().contains(this.getFirstSelectedNode())) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_initializer, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            } else if (forStatement.updaters().contains(this.getLastSelectedNode())) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_updater, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            }
        }
        super.endVisit(forStatement);
    }

    public void endVisit(VariableDeclarationExpression variableDeclarationExpression) {
        this.checkTypeInDeclaration(variableDeclarationExpression.getType());
        super.endVisit(variableDeclarationExpression);
    }

    public void endVisit(VariableDeclarationStatement variableDeclarationStatement) {
        this.checkTypeInDeclaration(variableDeclarationStatement.getType());
        super.endVisit(variableDeclarationStatement);
    }

    private boolean isFirstSelectedNode(ASTNode aSTNode) {
        return this.getSelection().getVisitSelectionMode(aSTNode) == 2 && this.getFirstSelectedNode() == aSTNode;
    }

    private void checkTypeInDeclaration(Type type) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)type) == 2 && this.getFirstSelectedNode() == type) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_variable_declaration, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
        }
    }

    private boolean isSingleExpressionOrStatementSet() {
        ASTNode aSTNode = this.getFirstSelectedNode();
        if (aSTNode == null) {
            return true;
        }
        return !(aSTNode instanceof Expression) || this.getSelectedNodes().length == 1;
    }
}

