/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CallInliner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.TargetProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class InlineMethodRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_DELETE = "delete";
    private ITypeRoot fInitialTypeRoot;
    private ASTNode fInitialNode;
    private TextChangeManager fChangeManager;
    private SourceProvider fSourceProvider;
    private TargetProvider fTargetProvider;
    private boolean fDeleteSource;
    private Mode fCurrentMode;
    private Mode fInitialMode;
    private int fSelectionStart;
    private int fSelectionLength;

    private InlineMethodRefactoring(ITypeRoot iTypeRoot, ASTNode aSTNode, int n, int n2) {
        Assert.isNotNull((Object)iTypeRoot);
        Assert.isTrue((boolean)JavaElementUtil.isSourceAvailable((ISourceReference)iTypeRoot));
        Assert.isNotNull((Object)aSTNode);
        this.fInitialTypeRoot = iTypeRoot;
        this.fInitialNode = aSTNode;
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
    }

    private InlineMethodRefactoring(ICompilationUnit iCompilationUnit, MethodInvocation methodInvocation, int n, int n2) {
        this((ITypeRoot)iCompilationUnit, (ASTNode)methodInvocation, n, n2);
        this.fTargetProvider = TargetProvider.create(iCompilationUnit, methodInvocation);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit iCompilationUnit, SuperMethodInvocation superMethodInvocation, int n, int n2) {
        this((ITypeRoot)iCompilationUnit, (ASTNode)superMethodInvocation, n, n2);
        this.fTargetProvider = TargetProvider.create(iCompilationUnit, superMethodInvocation);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit iCompilationUnit, ConstructorInvocation constructorInvocation, int n, int n2) {
        this((ITypeRoot)iCompilationUnit, (ASTNode)constructorInvocation, n, n2);
        this.fTargetProvider = TargetProvider.create(iCompilationUnit, constructorInvocation);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ITypeRoot iTypeRoot, MethodDeclaration methodDeclaration, int n, int n2) {
        this(iTypeRoot, (ASTNode)methodDeclaration, n, n2);
        this.fSourceProvider = new SourceProvider(iTypeRoot, methodDeclaration);
        this.fTargetProvider = TargetProvider.create(methodDeclaration);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_ALL;
        this.fDeleteSource = this.canEnableDeleteSource();
    }

    public static InlineMethodRefactoring create(ITypeRoot iTypeRoot, CompilationUnit compilationUnit, int n, int n2) {
        ASTNode aSTNode = InlineMethodRefactoring.getTargetNode(iTypeRoot, compilationUnit, n, n2);
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode.getNodeType() == 31) {
            return new InlineMethodRefactoring(iTypeRoot, (MethodDeclaration)aSTNode, n, n2);
        }
        ICompilationUnit iCompilationUnit = (ICompilationUnit)iTypeRoot;
        if (aSTNode.getNodeType() == 32) {
            return new InlineMethodRefactoring(iCompilationUnit, (MethodInvocation)aSTNode, n, n2);
        }
        if (aSTNode.getNodeType() == 48) {
            return new InlineMethodRefactoring(iCompilationUnit, (SuperMethodInvocation)aSTNode, n, n2);
        }
        if (aSTNode.getNodeType() == 17) {
            return new InlineMethodRefactoring(iCompilationUnit, (ConstructorInvocation)aSTNode, n, n2);
        }
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineMethodRefactoring_name;
    }

    public boolean canEnableDeleteSource() {
        return !(this.fSourceProvider.getTypeRoot() instanceof IClassFile);
    }

    public boolean getDeleteSource() {
        return this.fDeleteSource;
    }

    public void setDeleteSource(boolean bl) {
        if (bl) {
            Assert.isTrue((boolean)this.canEnableDeleteSource());
        }
        this.fDeleteSource = bl;
    }

    public Mode getInitialMode() {
        return this.fInitialMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus setCurrentMode(Mode mode) throws JavaModelException {
        if (this.fCurrentMode == mode) {
            return new RefactoringStatus();
        }
        Assert.isTrue((this.getInitialMode() == Mode.INLINE_SINGLE ? 1 : 0) != 0);
        this.fCurrentMode = mode;
        if (mode == Mode.INLINE_SINGLE) {
            if (this.fInitialNode instanceof MethodInvocation) {
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (MethodInvocation)this.fInitialNode);
                return this.fTargetProvider.checkActivation();
            } else if (this.fInitialNode instanceof SuperMethodInvocation) {
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (SuperMethodInvocation)this.fInitialNode);
                return this.fTargetProvider.checkActivation();
            } else {
                if (!(this.fInitialNode instanceof ConstructorInvocation)) throw new IllegalStateException(String.valueOf(this.fInitialNode));
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (ConstructorInvocation)this.fInitialNode);
            }
            return this.fTargetProvider.checkActivation();
        } else {
            this.fTargetProvider = TargetProvider.create(this.fSourceProvider.getDeclaration());
        }
        return this.fTargetProvider.checkActivation();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.fSourceProvider == null && Invocations.isInvocation(this.fInitialNode)) {
            this.fSourceProvider = InlineMethodRefactoring.resolveSourceProvider(refactoringStatus, this.fInitialTypeRoot, this.fInitialNode);
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
        }
        this.fTargetProvider.setSourceProvider(this.fSourceProvider);
        refactoringStatus.merge(this.fSourceProvider.checkActivation());
        refactoringStatus.merge(this.fTargetProvider.checkActivation());
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("", 20);
        this.fChangeManager = new TextChangeManager();
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fSourceProvider.initialize();
        this.fTargetProvider.initialize();
        iProgressMonitor.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_searching);
        RefactoringStatus refactoringStatus2 = new RefactoringStatus();
        ICompilationUnit[] iCompilationUnitArray = this.fTargetProvider.getAffectedCompilationUnits(refactoringStatus2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        if (refactoringStatus2.hasFatalError()) {
            refactoringStatus.merge(refactoringStatus2);
            return refactoringStatus;
        }
        IFile[] iFileArray = this.getFilesToBeModified(iCompilationUnitArray);
        refactoringStatus.merge(Checks.validateModifiesFiles(iFileArray, this.getValidationContext()));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])iFileArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        this.checkOverridden(refactoringStatus, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 15);
        subProgressMonitor.beginTask("", iCompilationUnitArray.length * 3);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            block19: {
                Object var21_22;
                ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
                subProgressMonitor.subTask(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_processing, iCompilationUnit.getElementName()));
                CallInliner callInliner = null;
                try {
                    BodyDeclaration bodyDeclaration;
                    boolean bl = false;
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    CompilationUnitChange compilationUnitChange = (CompilationUnitChange)this.fChangeManager.get(iCompilationUnit);
                    compilationUnitChange.setEdit((TextEdit)multiTextEdit);
                    BodyDeclaration[] bodyDeclarationArray = this.fTargetProvider.getAffectedBodyDeclarations(iCompilationUnit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    if (bodyDeclarationArray.length == 0) {
                        var21_22 = null;
                        if (callInliner != null) {
                            callInliner.dispose();
                        }
                        break block19;
                    }
                    callInliner = new CallInliner(iCompilationUnit, (CompilationUnit)bodyDeclarationArray[0].getRoot(), this.fSourceProvider);
                    int n2 = 0;
                    while (n2 < bodyDeclarationArray.length) {
                        bodyDeclaration = bodyDeclarationArray[n2];
                        callInliner.initialize(bodyDeclaration);
                        RefactoringStatus refactoringStatus3 = new RefactoringStatus();
                        ASTNode[] aSTNodeArray = this.removeNestedCalls(refactoringStatus3, iCompilationUnit, this.fTargetProvider.getInvocations(bodyDeclaration, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 2)));
                        int n3 = 0;
                        while (n3 < aSTNodeArray.length) {
                            ASTNode aSTNode = aSTNodeArray[n3];
                            refactoringStatus.merge(callInliner.initialize(aSTNode, this.fTargetProvider.getStatusSeverity()));
                            if (refactoringStatus.hasFatalError()) break;
                            if (refactoringStatus.getSeverity() < this.fTargetProvider.getStatusSeverity()) {
                                bl = true;
                                TextEditGroup textEditGroup = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_inline);
                                compilationUnitChange.addTextEditGroup(textEditGroup);
                                refactoringStatus.merge(callInliner.perform(textEditGroup));
                            } else {
                                this.fDeleteSource = false;
                            }
                            ++n3;
                        }
                        if (!refactoringStatus3.isOK()) {
                            refactoringStatus.merge(refactoringStatus3);
                            this.fDeleteSource = false;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        this.fChangeManager.remove(iCompilationUnit);
                    } else {
                        multiTextEdit.addChild(callInliner.getModifications());
                        ImportRewrite importRewrite = callInliner.getImportEdit();
                        if (importRewrite.hasRecordedChanges() && (!((bodyDeclaration = importRewrite.rewriteImports(null)) instanceof MultiTextEdit) || ((MultiTextEdit)bodyDeclaration).getChildrenSize() > 0)) {
                            multiTextEdit.addChild((TextEdit)bodyDeclaration);
                            compilationUnitChange.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_import, new TextEdit[]{bodyDeclaration}));
                        }
                    }
                    var21_22 = null;
                    if (callInliner != null) {
                        callInliner.dispose();
                    }
                }
                catch (Throwable throwable) {
                    var21_22 = null;
                    if (callInliner != null) {
                        callInliner.dispose();
                    }
                    throw throwable;
                }
                subProgressMonitor.worked(1);
                if (subProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n;
        }
        refactoringStatus.merge(refactoringStatus2);
        subProgressMonitor.done();
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        IJavaProject iJavaProject;
        String string;
        TextChange textChange;
        if (this.fDeleteSource && this.fCurrentMode == Mode.INLINE_ALL) {
            textChange = this.fChangeManager.get((ICompilationUnit)this.fSourceProvider.getTypeRoot());
            string = this.fSourceProvider.getDeleteEdit();
            iJavaProject = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_delete, new TextEdit[]{string});
            TextEdit textEdit = textChange.getEdit();
            if (textEdit != null) {
                TextChangeCompatibility.insert(textEdit, (TextEdit)string);
            } else {
                textChange.setEdit((TextEdit)string);
            }
            textChange.addTextEditGroup((TextEditGroup)iJavaProject);
        }
        textChange = new HashMap();
        string = null;
        iJavaProject = this.fInitialTypeRoot.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        int n = 786434;
        IMethodBinding iMethodBinding = this.fSourceProvider.getDeclaration().resolveBinding();
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        if (!Modifier.isPrivate((int)iMethodBinding.getModifiers())) {
            n |= 4;
        }
        String string2 = Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_descriptor_description_short, iMethodBinding.getName());
        String string3 = Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)iMethodBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)iMethodBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        if (this.fDeleteSource) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.InlineMethodRefactoring_remove_method);
        }
        if (this.fCurrentMode == Mode.INLINE_ALL) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.InlineMethodRefactoring_replace_references);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.inline.method", string, string2, jDTRefactoringDescriptorComment.asString(), (Map)textChange, n);
        textChange.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fInitialTypeRoot));
        textChange.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        textChange.put(ATTRIBUTE_DELETE, Boolean.valueOf(this.fDeleteSource).toString());
        textChange.put(ATTRIBUTE_MODE, new Integer(this.fCurrentMode == Mode.INLINE_ALL ? 1 : 0).toString());
        return new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.InlineMethodRefactoring_edit_inlineCall, (Change[])this.fChangeManager.getAllChanges());
    }

    private static SourceProvider resolveSourceProvider(RefactoringStatus refactoringStatus, ITypeRoot iTypeRoot, ASTNode aSTNode) throws JavaModelException {
        CompilationUnit compilationUnit = (CompilationUnit)aSTNode.getRoot();
        IMethodBinding iMethodBinding = Invocations.resolveBinding(aSTNode);
        if (iMethodBinding == null) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            return null;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)compilationUnit.findDeclaringNode((IBinding)iMethodBinding);
        if (methodDeclaration != null) {
            return new SourceProvider(iTypeRoot, methodDeclaration);
        }
        IMethod iMethod = (IMethod)iMethodBinding.getJavaElement();
        if (iMethod != null) {
            IClassFile iClassFile;
            CompilationUnit compilationUnit2;
            ICompilationUnit iCompilationUnit = iMethod.getCompilationUnit();
            if (iCompilationUnit != null) {
                compilationUnit2 = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, true);
            } else {
                iClassFile = iMethod.getClassFile();
                if (!JavaElementUtil.isSourceAvailable((ISourceReference)iClassFile)) {
                    String string = JavaElementLabels.getTextLabel(iMethod, 129L);
                    refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_error_classFile, string));
                    return null;
                }
                compilationUnit2 = new RefactoringASTParser(3).parse((ITypeRoot)iClassFile, true);
            }
            iClassFile = compilationUnit2.findDeclaringNode(iMethodBinding.getMethodDeclaration().getKey());
            if (iClassFile instanceof MethodDeclaration) {
                return new SourceProvider(compilationUnit2.getTypeRoot(), (MethodDeclaration)iClassFile);
            }
        }
        refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
        return null;
    }

    private static ASTNode getTargetNode(ITypeRoot iTypeRoot, CompilationUnit compilationUnit, int n, int n2) {
        ASTNode aSTNode = null;
        try {
            aSTNode = InlineMethodRefactoring.checkNode(NodeFinder.perform((ASTNode)compilationUnit, n, n2, iTypeRoot), (IJavaElement)iTypeRoot);
        }
        catch (JavaModelException javaModelException) {}
        if (aSTNode != null) {
            return aSTNode;
        }
        return InlineMethodRefactoring.checkNode(NodeFinder.perform((ASTNode)compilationUnit, n, n2), (IJavaElement)iTypeRoot);
    }

    private static ASTNode checkNode(ASTNode aSTNode, IJavaElement iJavaElement) {
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode.getNodeType() == 42) {
            aSTNode = aSTNode.getParent();
        } else if (aSTNode.getNodeType() == 21) {
            aSTNode = ((ExpressionStatement)aSTNode).getExpression();
        }
        switch (aSTNode.getNodeType()) {
            case 31: {
                return aSTNode;
            }
            case 17: 
            case 32: 
            case 48: {
                return iJavaElement instanceof ICompilationUnit ? aSTNode : null;
            }
        }
        return null;
    }

    private IFile[] getFilesToBeModified(ICompilationUnit[] iCompilationUnitArray) {
        IFile iFile;
        ArrayList<IFile> arrayList = new ArrayList<IFile>(iCompilationUnitArray.length + 1);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            iFile = this.getFile(iCompilationUnitArray[n]);
            if (iFile != null) {
                arrayList.add(iFile);
            }
            ++n;
        }
        if (this.fDeleteSource && (iFile = this.getFile((ICompilationUnit)this.fSourceProvider.getTypeRoot())) != null && !arrayList.contains(iFile)) {
            arrayList.add(iFile);
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    private IFile getFile(ICompilationUnit iCompilationUnit) {
        IResource iResource = (iCompilationUnit = iCompilationUnit.getPrimary()).getResource();
        if (iResource != null && iResource.getType() == 1) {
            return (IFile)iResource;
        }
        return null;
    }

    private void checkOverridden(RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) throws JavaModelException {
        iProgressMonitor.beginTask("", 9);
        iProgressMonitor.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden);
        MethodDeclaration methodDeclaration = this.fSourceProvider.getDeclaration();
        IMethod iMethod = (IMethod)methodDeclaration.resolveBinding().getJavaElement();
        if (iMethod == null || Flags.isPrivate((int)iMethod.getFlags())) {
            iProgressMonitor.worked(8);
            return;
        }
        IType iType = iMethod.getDeclaringType();
        if (iType == null) {
            iProgressMonitor.worked(8);
            return;
        }
        ITypeHierarchy iTypeHierarchy = iType.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 6));
        this.checkSubTypes(refactoringStatus, iMethod, iTypeHierarchy.getAllSubtypes(iType), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        this.checkSuperClasses(refactoringStatus, iMethod, iTypeHierarchy.getAllSuperclasses(iType), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        this.checkSuperInterfaces(refactoringStatus, iMethod, iTypeHierarchy.getAllSuperInterfaces(iType), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        iProgressMonitor.setTaskName("");
    }

    private void checkSubTypes(RefactoringStatus refactoringStatus, IMethod iMethod, IType[] iTypeArray, IProgressMonitor iProgressMonitor) {
        this.checkTypes(refactoringStatus, iMethod, iTypeArray, RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden_error, iProgressMonitor);
    }

    private void checkSuperClasses(RefactoringStatus refactoringStatus, IMethod iMethod, IType[] iTypeArray, IProgressMonitor iProgressMonitor) {
        this.checkTypes(refactoringStatus, iMethod, iTypeArray, RefactoringCoreMessages.InlineMethodRefactoring_checking_overrides_error, iProgressMonitor);
    }

    private void checkSuperInterfaces(RefactoringStatus refactoringStatus, IMethod iMethod, IType[] iTypeArray, IProgressMonitor iProgressMonitor) {
        this.checkTypes(refactoringStatus, iMethod, iTypeArray, RefactoringCoreMessages.InlineMethodRefactoring_checking_implements_error, iProgressMonitor);
    }

    private void checkTypes(RefactoringStatus refactoringStatus, IMethod iMethod, IType[] iTypeArray, String string, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("", iTypeArray.length);
        int n = 0;
        while (n < iTypeArray.length) {
            iProgressMonitor.worked(1);
            IMethod[] iMethodArray = iTypeArray[n].findMethods(iMethod);
            if (iMethodArray != null && iMethodArray.length > 0) {
                refactoringStatus.addError(Messages.format(string, iTypeArray[n].getElementName()), JavaStatusContext.create((IMember)iMethodArray[0]));
            }
            ++n;
        }
    }

    private ASTNode[] removeNestedCalls(RefactoringStatus refactoringStatus, ICompilationUnit iCompilationUnit, ASTNode[] aSTNodeArray) {
        if (aSTNodeArray.length <= 1) {
            return aSTNodeArray;
        }
        ASTNode[] aSTNodeArray2 = new ASTNode[aSTNodeArray.length];
        int n = 0;
        while (n < aSTNodeArray.length) {
            aSTNodeArray2[n] = aSTNodeArray[n].getParent();
            ++n;
        }
        n = 0;
        while (n < aSTNodeArray.length) {
            this.removeNestedCalls(refactoringStatus, iCompilationUnit, aSTNodeArray2, aSTNodeArray, n);
            ++n;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        int n2 = 0;
        while (n2 < aSTNodeArray.length) {
            if (aSTNodeArray[n2] != null) {
                arrayList.add(aSTNodeArray[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new ASTNode[arrayList.size()]);
    }

    private void removeNestedCalls(RefactoringStatus refactoringStatus, ICompilationUnit iCompilationUnit, ASTNode[] aSTNodeArray, ASTNode[] aSTNodeArray2, int n) {
        ASTNode aSTNode = aSTNodeArray2[n];
        int n2 = 0;
        while (n2 < aSTNodeArray.length) {
            ASTNode aSTNode2 = aSTNodeArray[n2];
            while (aSTNode2 != null) {
                if (aSTNode2 == aSTNode) {
                    refactoringStatus.addError(RefactoringCoreMessages.InlineMethodRefactoring_nestedInvocation, JavaStatusContext.create((ITypeRoot)iCompilationUnit, aSTNode2));
                    aSTNodeArray2[n] = null;
                }
                aSTNode2 = aSTNode2.getParent();
            }
            ++n2;
        }
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute(ATTRIBUTE_DELETE);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELETE));
            }
            this.fDeleteSource = Boolean.valueOf(string);
            String string2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_MODE);
            if (string2 != null && !"".equals(string2)) {
                int n = 0;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MODE));
                }
                try {
                    this.setCurrentMode(n == 1 ? Mode.INLINE_ALL : Mode.INLINE_SINGLE);
                }
                catch (JavaModelException javaModelException) {
                    return RefactoringStatus.createFatalErrorStatus((String)javaModelException.getLocalizedMessage());
                }
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public static class Mode {
        public static final Mode INLINE_ALL = new Mode();
        public static final Mode INLINE_SINGLE = new Mode();

        private Mode() {
        }
    }
}

