/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;

public class Invocations {
    public static List getArguments(ASTNode aSTNode) {
        switch (aSTNode.getNodeType()) {
            case 32: {
                return ((MethodInvocation)aSTNode).arguments();
            }
            case 48: {
                return ((SuperMethodInvocation)aSTNode).arguments();
            }
            case 17: {
                return ((ConstructorInvocation)aSTNode).arguments();
            }
        }
        throw new IllegalArgumentException(aSTNode.toString());
    }

    public static Expression getExpression(ASTNode aSTNode) {
        switch (aSTNode.getNodeType()) {
            case 32: {
                return ((MethodInvocation)aSTNode).getExpression();
            }
            case 17: 
            case 48: {
                return null;
            }
        }
        throw new IllegalArgumentException(aSTNode.toString());
    }

    public static boolean isInvocation(ASTNode aSTNode) {
        int n = aSTNode.getNodeType();
        return n == 32 || n == 48 || n == 17;
    }

    public static IMethodBinding resolveBinding(ASTNode aSTNode) {
        switch (aSTNode.getNodeType()) {
            case 32: {
                SimpleName simpleName = ((MethodInvocation)aSTNode).getName();
                if (simpleName != null) {
                    return (IMethodBinding)simpleName.resolveBinding();
                }
                return ((MethodInvocation)aSTNode).resolveMethodBinding();
            }
            case 48: {
                return ((SuperMethodInvocation)aSTNode).resolveMethodBinding();
            }
            case 17: {
                return ((ConstructorInvocation)aSTNode).resolveConstructorBinding();
            }
        }
        throw new IllegalArgumentException(aSTNode.toString());
    }

    public static boolean isResolvedTypeInferredFromExpectedType(Expression expression) {
        switch (expression.getNodeType()) {
            case 32: {
                return ((MethodInvocation)expression).isResolvedTypeInferredFromExpectedType();
            }
            case 48: {
                return ((SuperMethodInvocation)expression).isResolvedTypeInferredFromExpectedType();
            }
            case 17: {
                return false;
            }
        }
        throw new IllegalArgumentException(expression.toString());
    }

    public static ChildListPropertyDescriptor getTypeArgumentsProperty(Expression expression) {
        switch (expression.getNodeType()) {
            case 32: {
                return MethodInvocation.TYPE_ARGUMENTS_PROPERTY;
            }
            case 48: {
                return SuperMethodInvocation.TYPE_ARGUMENTS_PROPERTY;
            }
            case 17: {
                return ConstructorInvocation.TYPE_ARGUMENTS_PROPERTY;
            }
        }
        throw new IllegalArgumentException(expression.toString());
    }
}

