/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;

class SnippetFinder
extends GenericVisitor {
    private List fResult = new ArrayList(2);
    private Match fMatch;
    private ASTNode[] fSnippet;
    private int fIndex;
    private Matcher fMatcher;
    private int fTypes;

    private SnippetFinder(ASTNode[] aSTNodeArray) {
        super(true);
        this.fSnippet = aSTNodeArray;
        this.fMatcher = new Matcher();
        this.reset();
    }

    public static Match[] perform(ASTNode aSTNode, ASTNode[] aSTNodeArray) {
        Assert.isTrue((aSTNode instanceof CompilationUnit || aSTNode instanceof AbstractTypeDeclaration || aSTNode instanceof AnonymousClassDeclaration ? 1 : 0) != 0);
        SnippetFinder snippetFinder = new SnippetFinder(aSTNodeArray);
        aSTNode.accept((ASTVisitor)snippetFinder);
        Iterator iterator = snippetFinder.fResult.iterator();
        while (iterator.hasNext()) {
            Match match = (Match)iterator.next();
            ASTNode[] aSTNodeArray2 = match.getNodes();
            if (aSTNodeArray2.length != 1 || !SnippetFinder.isLeftHandSideOfAssignment(aSTNodeArray2[0])) continue;
            iterator.remove();
        }
        return snippetFinder.fResult.toArray(new Match[snippetFinder.fResult.size()]);
    }

    private static boolean isLeftHandSideOfAssignment(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        return aSTNode2 != null && aSTNode2.getNodeType() == 7 && ((Assignment)aSTNode2).getLeftHandSide() == aSTNode;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        if (++this.fTypes > 1) {
            return false;
        }
        return super.visit(typeDeclaration);
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        --this.fTypes;
        super.endVisit(typeDeclaration);
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        if (++this.fTypes > 1) {
            return false;
        }
        return super.visit(enumDeclaration);
    }

    public void endVisit(EnumDeclaration enumDeclaration) {
        --this.fTypes;
        super.endVisit(enumDeclaration);
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        if (++this.fTypes > 1) {
            return false;
        }
        return super.visit(annotationTypeDeclaration);
    }

    public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        --this.fTypes;
        super.endVisit(annotationTypeDeclaration);
    }

    protected boolean visitNode(ASTNode aSTNode) {
        if (this.matches(aSTNode)) {
            return false;
        }
        if (!this.isResetted()) {
            this.reset();
            if (this.matches(aSTNode)) {
                return false;
            }
        }
        return true;
    }

    private boolean matches(ASTNode aSTNode) {
        if (this.isSnippetNode(aSTNode)) {
            return false;
        }
        if (aSTNode.subtreeMatch((ASTMatcher)this.fMatcher, (Object)this.fSnippet[this.fIndex]) && this.fMatch.hasCorrectNesting(aSTNode)) {
            this.fMatch.add(aSTNode);
            ++this.fIndex;
            if (this.fIndex == this.fSnippet.length) {
                this.fResult.add(this.fMatch);
                this.reset();
            }
            return true;
        }
        return false;
    }

    private boolean isResetted() {
        return this.fIndex == 0 && this.fMatch.isEmpty();
    }

    private void reset() {
        this.fIndex = 0;
        this.fMatch = new Match();
    }

    private boolean isSnippetNode(ASTNode aSTNode) {
        int n = 0;
        while (n < this.fSnippet.length) {
            if (aSTNode == this.fSnippet[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static class Match {
        private List fNodes = new ArrayList(10);
        private Map fLocalMappings = new HashMap();

        public void add(ASTNode aSTNode) {
            this.fNodes.add(aSTNode);
        }

        public boolean hasCorrectNesting(ASTNode aSTNode) {
            if (this.fNodes.size() == 0) {
                return true;
            }
            ASTNode aSTNode2 = aSTNode.getParent();
            if (((ASTNode)this.fNodes.get(0)).getParent() != aSTNode2) {
                return false;
            }
            int n = aSTNode2.getNodeType();
            return n == 8 || n == 50;
        }

        public ASTNode[] getNodes() {
            return this.fNodes.toArray(new ASTNode[this.fNodes.size()]);
        }

        public void addLocal(IVariableBinding iVariableBinding, SimpleName simpleName) {
            this.fLocalMappings.put(iVariableBinding, simpleName);
        }

        public SimpleName getMappedName(IVariableBinding iVariableBinding) {
            return (SimpleName)this.fLocalMappings.get(iVariableBinding);
        }

        public IVariableBinding getMappedBinding(IVariableBinding iVariableBinding) {
            SimpleName simpleName = (SimpleName)this.fLocalMappings.get(iVariableBinding);
            return ASTNodes.getVariableBinding((Name)simpleName);
        }

        public boolean isEmpty() {
            return this.fNodes.isEmpty() && this.fLocalMappings.isEmpty();
        }

        public boolean isMethodBody() {
            ASTNode aSTNode = (ASTNode)this.fNodes.get(0);
            if (aSTNode.getParent() == null) {
                return false;
            }
            ASTNode aSTNode2 = aSTNode.getParent().getParent();
            if (aSTNode2 == null || aSTNode2.getNodeType() != 31) {
                return false;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode2;
            return methodDeclaration.getBody().statements().size() == this.fNodes.size();
        }

        public MethodDeclaration getEnclosingMethod() {
            ASTNode aSTNode = (ASTNode)this.fNodes.get(0);
            return (MethodDeclaration)ASTNodes.getParent(aSTNode, 31);
        }
    }

    private class Matcher
    extends ASTMatcher {
        private Matcher() {
        }

        public boolean match(SimpleName simpleName, Object object) {
            if (!(object instanceof SimpleName)) {
                return false;
            }
            SimpleName simpleName2 = (SimpleName)object;
            if (simpleName.isDeclaration() != simpleName2.isDeclaration()) {
                return false;
            }
            IBinding iBinding = simpleName.resolveBinding();
            IBinding iBinding2 = simpleName2.resolveBinding();
            if (iBinding == null || iBinding2 == null) {
                return false;
            }
            IVariableBinding iVariableBinding = ASTNodes.getVariableBinding((Name)simpleName);
            IVariableBinding iVariableBinding2 = ASTNodes.getVariableBinding((Name)simpleName2);
            if (iVariableBinding == null || iVariableBinding2 == null) {
                return Bindings.equals(iBinding, iBinding2);
            }
            if (!iVariableBinding.isField() && !iVariableBinding2.isField() && Bindings.equals((IBinding)iVariableBinding.getType(), (IBinding)iVariableBinding2.getType())) {
                IVariableBinding iVariableBinding3;
                SimpleName simpleName3 = SnippetFinder.this.fMatch.getMappedName(iVariableBinding2);
                if (simpleName3 != null && !Bindings.equals((IBinding)iVariableBinding, (IBinding)(iVariableBinding3 = ASTNodes.getVariableBinding((Name)simpleName3)))) {
                    return false;
                }
                SnippetFinder.this.fMatch.addLocal(iVariableBinding2, simpleName);
                return true;
            }
            return Bindings.equals(iBinding, iBinding2);
        }
    }
}

