/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.delegates;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.MethodRefParameter;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateCreator;

public class DelegateMethodCreator
extends DelegateCreator {
    private ASTNode fDelegateInvocation;
    private MethodRef fDocMethodReference;

    protected void initialize() {
        Assert.isTrue((boolean)(this.getDeclaration() instanceof MethodDeclaration));
        if (this.getNewElementName() == null) {
            this.setNewElementName(((MethodDeclaration)this.getDeclaration()).getName().getIdentifier());
        }
        this.setInsertBefore(true);
    }

    protected ASTNode createBody(BodyDeclaration bodyDeclaration) throws JavaModelException {
        MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
        if (methodDeclaration.getBody() == null) {
            return null;
        }
        return this.createDelegateMethodBody(methodDeclaration);
    }

    protected ASTNode createDocReference(BodyDeclaration bodyDeclaration) throws JavaModelException {
        this.fDocMethodReference = this.getAst().newMethodRef();
        this.fDocMethodReference.setName(this.getAst().newSimpleName(this.getNewElementName()));
        if (this.isMoveToAnotherFile()) {
            this.fDocMethodReference.setQualifier(this.createDestinationTypeName());
        }
        this.createArguments((MethodDeclaration)bodyDeclaration, this.fDocMethodReference.parameters(), false);
        return this.fDocMethodReference;
    }

    protected ASTNode getBodyHead(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration;
    }

    protected ChildPropertyDescriptor getJavaDocProperty() {
        return MethodDeclaration.JAVADOC_PROPERTY;
    }

    protected ChildPropertyDescriptor getBodyProperty() {
        return MethodDeclaration.BODY_PROPERTY;
    }

    public ASTNode getDelegateInvocation() {
        return this.fDelegateInvocation;
    }

    public MethodRef getJavadocReference() {
        return this.fDocMethodReference;
    }

    protected Statement createMethodInvocation(MethodDeclaration methodDeclaration, MethodInvocation methodInvocation) {
        PrimitiveType primitiveType;
        Assert.isNotNull((Object)methodDeclaration);
        Assert.isNotNull((Object)methodInvocation);
        Object object = null;
        Type type = methodDeclaration.getReturnType2();
        object = type == null ? this.createExpressionStatement(methodInvocation) : (type instanceof PrimitiveType ? ((primitiveType = (PrimitiveType)type).getPrimitiveTypeCode().equals(PrimitiveType.VOID) ? this.createExpressionStatement(methodInvocation) : this.createReturnStatement(methodInvocation)) : this.createReturnStatement(methodInvocation));
        return object;
    }

    protected IBinding getDeclarationBinding() {
        MethodDeclaration methodDeclaration = (MethodDeclaration)this.getDeclaration();
        return methodDeclaration.resolveBinding();
    }

    private void createArguments(MethodDeclaration methodDeclaration, List list, boolean bl) throws JavaModelException {
        Assert.isNotNull((Object)methodDeclaration);
        Assert.isNotNull((Object)list);
        SingleVariableDeclaration singleVariableDeclaration = null;
        int n = methodDeclaration.parameters().size();
        int n2 = 0;
        while (n2 < n) {
            MethodRefParameter methodRefParameter;
            singleVariableDeclaration = (SingleVariableDeclaration)methodDeclaration.parameters().get(n2);
            if (bl) {
                methodRefParameter = this.getAst().newSimpleName(singleVariableDeclaration.getName().getIdentifier());
                list.add(methodRefParameter);
            } else {
                methodRefParameter = this.getAst().newMethodRefParameter();
                methodRefParameter.setType(ASTNodeFactory.newType(this.getAst(), (VariableDeclaration)singleVariableDeclaration));
                if (n2 == n - 1 && methodDeclaration.isVarargs()) {
                    methodRefParameter.setVarargs(true);
                }
                list.add(methodRefParameter);
            }
            ++n2;
        }
    }

    private Block createDelegateMethodBody(MethodDeclaration methodDeclaration) throws JavaModelException {
        ConstructorInvocation constructorInvocation;
        List list;
        ConstructorInvocation constructorInvocation2;
        Assert.isNotNull((Object)methodDeclaration);
        MethodDeclaration methodDeclaration2 = (MethodDeclaration)this.getDeclaration();
        if (methodDeclaration2.isConstructor()) {
            constructorInvocation2 = this.getAst().newConstructorInvocation();
            list = constructorInvocation2.arguments();
            constructorInvocation = constructorInvocation2;
            this.fDelegateInvocation = constructorInvocation2;
        } else {
            constructorInvocation2 = this.getAst().newMethodInvocation();
            constructorInvocation2.setName(this.getAst().newSimpleName(this.getNewElementName()));
            constructorInvocation2.setExpression(this.getAccess());
            list = constructorInvocation2.arguments();
            constructorInvocation = this.createMethodInvocation(methodDeclaration, (MethodInvocation)constructorInvocation2);
            this.fDelegateInvocation = constructorInvocation2;
        }
        this.createArguments(methodDeclaration, list, true);
        constructorInvocation2 = this.getAst().newBlock();
        constructorInvocation2.statements().add(constructorInvocation);
        return constructorInvocation2;
    }

    private ExpressionStatement createExpressionStatement(MethodInvocation methodInvocation) {
        Assert.isNotNull((Object)methodInvocation);
        return methodInvocation.getAST().newExpressionStatement((Expression)methodInvocation);
    }

    private ReturnStatement createReturnStatement(MethodInvocation methodInvocation) {
        Assert.isNotNull((Object)methodInvocation);
        ReturnStatement returnStatement = methodInvocation.getAST().newReturnStatement();
        returnStatement.setExpression((Expression)methodInvocation);
        return returnStatement;
    }

    protected String getTextEditGroupLabel() {
        return RefactoringCoreMessages.DelegateMethodCreator_text_edit_group_field;
    }
}

