/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class AccessorClassCreator {
    private final ICompilationUnit fCu;
    private final String fAccessorClassName;
    private final IPath fAccessorPath;
    private final IPath fResourceBundlePath;
    private final IPackageFragment fAccessorPackage;
    private final boolean fIsEclipseNLS;
    private final NLSSubstitution[] fNLSSubstitutions;
    private final String fSubstitutionPattern;

    private AccessorClassCreator(ICompilationUnit iCompilationUnit, String string, IPath iPath, IPackageFragment iPackageFragment, IPath iPath2, boolean bl, NLSSubstitution[] nLSSubstitutionArray, String string2) {
        this.fCu = iCompilationUnit;
        this.fAccessorClassName = string;
        this.fAccessorPath = iPath;
        this.fAccessorPackage = iPackageFragment;
        this.fResourceBundlePath = iPath2;
        this.fIsEclipseNLS = bl;
        this.fNLSSubstitutions = nLSSubstitutionArray;
        this.fSubstitutionPattern = string2;
    }

    public static Change create(ICompilationUnit iCompilationUnit, String string, IPath iPath, IPackageFragment iPackageFragment, IPath iPath2, boolean bl, NLSSubstitution[] nLSSubstitutionArray, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        AccessorClassCreator accessorClassCreator = new AccessorClassCreator(iCompilationUnit, string, iPath, iPackageFragment, iPath2, bl, nLSSubstitutionArray, string2);
        return new CreateTextFileChange(iPath, accessorClassCreator.createAccessorCUSource(iProgressMonitor), null, "java");
    }

    private String createAccessorCUSource(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = AccessorClassCreator.getFileHandle(this.fAccessorPath).getProject();
        String string = StubUtility.getLineDelimiterPreference(iProject);
        return CodeFormatterUtil.format(8, this.getUnformattedSource(iProgressMonitor), 0, null, string, this.fCu.getJavaProject());
    }

    private static IFile getFileHandle(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
    }

    private String getUnformattedSource(IProgressMonitor iProgressMonitor) throws CoreException {
        String string;
        block7: {
            ICompilationUnit iCompilationUnit = null;
            try {
                String string2;
                String string3;
                iCompilationUnit = this.fAccessorPackage.getCompilationUnit(this.fAccessorPath.lastSegment()).getWorkingCopy(null);
                String string4 = null;
                String string5 = null;
                IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
                String string6 = StubUtility.getLineDelimiterUsed(iJavaProject);
                if (StubUtility.doAddComments(iJavaProject)) {
                    string4 = CodeGeneration.getTypeComment(iCompilationUnit, this.fAccessorClassName, string6);
                    string5 = CodeGeneration.getFileComment(iCompilationUnit, string6);
                }
                if ((string3 = CodeGeneration.getCompilationUnitContent(iCompilationUnit, string5, string4, string2 = this.createClass(string6), string6)) == null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (string5 != null) {
                        stringBuffer.append(string5).append(string6);
                    }
                    if (!this.fAccessorPackage.isDefaultPackage()) {
                        stringBuffer.append("package ").append(this.fAccessorPackage.getElementName()).append(';');
                    }
                    stringBuffer.append(string6).append(string6);
                    if (string4 != null) {
                        stringBuffer.append(string4).append(string6);
                    }
                    stringBuffer.append(string2);
                    string3 = stringBuffer.toString();
                }
                iCompilationUnit.getBuffer().setContents(string3);
                this.addImportsToAccessorCu(iCompilationUnit, iProgressMonitor);
                string = iCompilationUnit.getSource();
                Object var10_11 = null;
                if (iCompilationUnit == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var10_12 = null;
                    if (iCompilationUnit == null) break block8;
                    iCompilationUnit.discardWorkingCopy();
                }
                throw throwable;
            }
            iCompilationUnit.discardWorkingCopy();
        }
        return string;
    }

    private void addImportsToAccessorCu(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) throws CoreException {
        ImportRewrite importRewrite = StubUtility.createImportRewrite(iCompilationUnit, true);
        if (this.fIsEclipseNLS) {
            importRewrite.addImport("org.eclipse.osgi.util.NLS");
        } else {
            importRewrite.addImport("java.util.MissingResourceException");
            importRewrite.addImport("java.util.ResourceBundle");
        }
        TextEdit textEdit = importRewrite.rewriteImports(iProgressMonitor);
        JavaModelUtil.applyEdit(iCompilationUnit, textEdit, false, null);
    }

    private String createClass(String string) throws CoreException {
        if (this.fIsEclipseNLS) {
            MembersOrderPreferenceCache membersOrderPreferenceCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
            int n = membersOrderPreferenceCache.getCategoryIndex(1);
            int n2 = membersOrderPreferenceCache.getCategoryIndex(5);
            int n3 = membersOrderPreferenceCache.getCategoryIndex(6);
            String string2 = String.valueOf(this.createConstructor(string)) + string;
            String string3 = String.valueOf(this.createStaticInitializer(string)) + string;
            String string4 = String.valueOf(this.createStaticFields(string)) + string;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("public class ").append(this.fAccessorClassName).append(" extends NLS {");
            stringBuffer.append("private static final String ").append("BUNDLE_NAME").append(" = \"").append(this.getResourceBundleName()).append("\"; ");
            stringBuffer.append(NLSElement.createTagText(1)).append(string);
            if (n < n2) {
                if (n2 < n3) {
                    stringBuffer.append(string2);
                    stringBuffer.append(string4);
                    stringBuffer.append(string3);
                } else {
                    stringBuffer.append(string2);
                    stringBuffer.append(string3);
                    stringBuffer.append(string4);
                }
            } else if (n < n3) {
                stringBuffer.append(string4);
                stringBuffer.append(string2);
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string4);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
            }
            stringBuffer.append('}').append(string);
            return stringBuffer.toString();
        }
        MembersOrderPreferenceCache membersOrderPreferenceCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
        int n = membersOrderPreferenceCache.getCategoryIndex(1);
        int n4 = membersOrderPreferenceCache.getCategoryIndex(2);
        String string5 = String.valueOf(string) + this.createConstructor(string);
        String string6 = String.valueOf(string) + this.createGetStringMethod(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public class ").append(this.fAccessorClassName).append(" {");
        stringBuffer.append("private static final String ").append("BUNDLE_NAME");
        stringBuffer.append(" = \"").append(this.getResourceBundleName()).append("\"; ").append(NLSElement.createTagText(1)).append(string);
        stringBuffer.append(string).append("private static final ResourceBundle ").append(this.getResourceBundleConstantName());
        stringBuffer.append("= ResourceBundle.getBundle(").append("BUNDLE_NAME").append(");").append(string);
        if (n < n4) {
            stringBuffer.append(string5);
            stringBuffer.append(string6);
        } else {
            stringBuffer.append(string5);
            stringBuffer.append(string6);
        }
        stringBuffer.append(string).append('}').append(string);
        return stringBuffer.toString();
    }

    private String getResourceBundleConstantName() {
        return "RESOURCE_BUNDLE";
    }

    private String createStaticFields(String string) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.fNLSSubstitutions.length) {
            object = this.fNLSSubstitutions[n];
            int n2 = ((NLSSubstitution)object).getState();
            if ((((NLSSubstitution)object).hasStateChanged() || ((NLSSubstitution)object).isAccessorRename()) && n2 == 0 && hashSet.add(((NLSSubstitution)object).getKey())) {
                arrayList.add(object);
            }
            ++n;
        }
        Collections.sort(arrayList, new Comparator(){
            private Collator fCollator = Collator.getInstance();

            public int compare(Object object, Object object2) {
                NLSSubstitution nLSSubstitution = (NLSSubstitution)object;
                NLSSubstitution nLSSubstitution2 = (NLSSubstitution)object2;
                return this.fCollator.compare(nLSSubstitution.getKey(), nLSSubstitution2.getKey());
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        object = arrayList.iterator();
        while (object.hasNext()) {
            NLSSubstitution nLSSubstitution = (NLSSubstitution)object.next();
            this.appendStaticField(stringBuffer, nLSSubstitution);
        }
        return stringBuffer.toString();
    }

    private void appendStaticField(StringBuffer stringBuffer, NLSSubstitution nLSSubstitution) {
        stringBuffer.append("public static String ");
        stringBuffer.append(nLSSubstitution.getKey());
        stringBuffer.append(';');
    }

    private String createGetStringMethod(String string) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public static String ");
        int n = this.fSubstitutionPattern.indexOf("${key}");
        if (n != -1) {
            stringBuffer.append(this.fSubstitutionPattern.substring(0, n));
            stringBuffer.append("String key");
            stringBuffer.append(this.fSubstitutionPattern.substring(n + "${key}".length()));
        } else {
            stringBuffer.append("getString(String key)");
        }
        stringBuffer.append('{').append(string);
        stringBuffer.append("try {").append(string).append("return ").append(this.getResourceBundleConstantName()).append(".getString(key);").append(string).append("} catch (MissingResourceException e) {").append(string).append("return '!' + key + '!';").append(string).append("}");
        stringBuffer.append(string).append('}');
        return stringBuffer.toString();
    }

    private String createStaticInitializer(String string) throws CoreException {
        return "static {" + string + "// initialize resource bundle" + string + "NLS.initializeMessages(BUNDLE_NAME, " + this.fAccessorClassName + ".class);" + string + "}";
    }

    private String createConstructor(String string) {
        return "private " + this.fAccessorClassName + "(){" + string + '}';
    }

    private String getPropertyFileName() {
        return this.fResourceBundlePath.lastSegment();
    }

    private String getPropertyFileNameWithoutExtension() {
        String string = this.getPropertyFileName();
        return string.substring(0, string.indexOf(".properties"));
    }

    private String getResourceBundleName() throws CoreException {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourceBundlePath.removeLastSegments(1));
        if (iResource != null && iResource.exists()) {
            IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
            if (iJavaElement instanceof IPackageFragment) {
                IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                return String.valueOf(iPackageFragment.getElementName()) + '.' + this.getPropertyFileNameWithoutExtension();
            }
            if (iJavaElement instanceof IPackageFragmentRoot || iJavaElement instanceof IJavaProject) {
                return this.getPropertyFileNameWithoutExtension();
            }
        }
        throw new CoreException((IStatus)new StatusInfo(4, "Resourcebundle not specified"));
    }
}

