/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class NLSPropertyFileModifier {
    public static Change create(NLSSubstitution[] nLSSubstitutionArray, IPath iPath) throws CoreException {
        String string = Messages.format(NLSMessages.NLSPropertyFileModifier_change_name, iPath.toString());
        TextFileChange textFileChange = null;
        if (!Checks.resourceExists(iPath)) {
            IProject iProject = NLSPropertyFileModifier.getFileHandle(iPath).getProject();
            String string2 = StubUtility.getLineDelimiterPreference(iProject);
            Document document = new Document();
            document.setInitialLineDelimiter(string2);
            textFileChange = new DocumentChange(string, (IDocument)document);
            NLSPropertyFileModifier.addChanges((TextChange)textFileChange, nLSSubstitutionArray);
            textFileChange.perform((IProgressMonitor)new NullProgressMonitor());
            String string3 = null;
            IContentType iContentType = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.javaProperties");
            IContentType[] iContentTypeArray = Platform.getContentTypeManager().findContentTypesFor(iPath.lastSegment());
            if (iContentTypeArray.length == 0 || iContentTypeArray.length > 1 || !iContentTypeArray[0].equals(iContentType)) {
                if (iContentType != null) {
                    string3 = iContentType.getDefaultCharset();
                }
                if (string3 == null) {
                    string3 = "ISO-8859-1";
                }
            }
            return new CreateTextFileChange(iPath, textFileChange.getCurrentContent((IProgressMonitor)new NullProgressMonitor()), string3, "properties");
        }
        textFileChange = new TextFileChange(string, NLSPropertyFileModifier.getPropertyFile(iPath));
        textFileChange.setTextType("properties");
        NLSPropertyFileModifier.addChanges((TextChange)textFileChange, nLSSubstitutionArray);
        return textFileChange;
    }

    private static IFile getPropertyFile(IPath iPath) {
        return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
    }

    private static IFile getFileHandle(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
    }

    private static void addChanges(TextChange textChange, NLSSubstitution[] nLSSubstitutionArray) throws CoreException {
        PropertyFileDocumentModel propertyFileDocumentModel = new PropertyFileDocumentModel(textChange.getCurrentDocument((IProgressMonitor)new NullProgressMonitor()));
        HashMap hashMap = NLSPropertyFileModifier.getNewKeyToSubstitutionMap(nLSSubstitutionArray);
        HashMap hashMap2 = NLSPropertyFileModifier.getOldKeyToSubstitutionMap(nLSSubstitutionArray);
        NLSPropertyFileModifier.addInsertEdits(textChange, nLSSubstitutionArray, hashMap, hashMap2, propertyFileDocumentModel);
        NLSPropertyFileModifier.addRemoveEdits(textChange, nLSSubstitutionArray, hashMap, hashMap2, propertyFileDocumentModel);
        NLSPropertyFileModifier.addReplaceEdits(textChange, nLSSubstitutionArray, hashMap, hashMap2, propertyFileDocumentModel);
    }

    static HashMap getNewKeyToSubstitutionMap(NLSSubstitution[] nLSSubstitutionArray) {
        HashMap<String, NLSSubstitution> hashMap = new HashMap<String, NLSSubstitution>(nLSSubstitutionArray.length);
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution;
            NLSSubstitution nLSSubstitution2 = nLSSubstitutionArray[n];
            if (nLSSubstitution2.getState() == 0 && ((nLSSubstitution = (NLSSubstitution)hashMap.get(nLSSubstitution2.getKey())) == null || nLSSubstitution.hasPropertyFileChange() && !nLSSubstitution2.hasPropertyFileChange())) {
                hashMap.put(nLSSubstitution2.getKey(), nLSSubstitution2);
            }
            ++n;
        }
        return hashMap;
    }

    static HashMap getOldKeyToSubstitutionMap(NLSSubstitution[] nLSSubstitutionArray) {
        HashMap<String, NLSSubstitution> hashMap = new HashMap<String, NLSSubstitution>(nLSSubstitutionArray.length);
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution;
            String string;
            NLSSubstitution nLSSubstitution2 = nLSSubstitutionArray[n];
            if (nLSSubstitution2.getInitialState() == 0 && (string = nLSSubstitution2.getInitialKey()) != null && ((nLSSubstitution = (NLSSubstitution)hashMap.get(string)) == null || nLSSubstitution.hasStateChanged() && !nLSSubstitution2.hasStateChanged())) {
                hashMap.put(string, nLSSubstitution2);
            }
            ++n;
        }
        return hashMap;
    }

    static boolean doReplace(NLSSubstitution nLSSubstitution, Map map, Map map2) {
        if (nLSSubstitution.getState() != 0 || nLSSubstitution.hasStateChanged() || nLSSubstitution.getInitialValue() == null) {
            return false;
        }
        if (map2.get(nLSSubstitution.getInitialKey()) != nLSSubstitution) {
            return false;
        }
        return (nLSSubstitution.isKeyRename() || nLSSubstitution.isValueRename()) && map.get(nLSSubstitution.getKey()) == nLSSubstitution;
    }

    private static void addReplaceEdits(TextChange textChange, NLSSubstitution[] nLSSubstitutionArray, Map map, Map map2, PropertyFileDocumentModel propertyFileDocumentModel) {
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            KeyValuePair keyValuePair;
            KeyValuePair keyValuePair2;
            ReplaceEdit replaceEdit;
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            if (NLSPropertyFileModifier.doReplace(nLSSubstitution, map, map2) && (replaceEdit = propertyFileDocumentModel.replace(keyValuePair2 = new KeyValuePair(nLSSubstitution.getInitialKey(), nLSSubstitution.getInitialValue()), keyValuePair = new KeyValuePair(nLSSubstitution.getKey(), nLSSubstitution.getValueNonEmpty()))) != null) {
                TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSPropertyFileModifier_replace_entry, nLSSubstitution.getKey()), (TextEdit)replaceEdit);
            }
            ++n;
        }
    }

    static boolean doInsert(NLSSubstitution nLSSubstitution, Map map, Map map2) {
        if (nLSSubstitution.getState() != 0) {
            return false;
        }
        if (!(nLSSubstitution.hasStateChanged() || nLSSubstitution.getInitialValue() == null || nLSSubstitution.isKeyRename() && map2.get(nLSSubstitution.getInitialKey()) != nLSSubstitution)) {
            return false;
        }
        return map.get(nLSSubstitution.getKey()) == nLSSubstitution;
    }

    private static void addInsertEdits(TextChange textChange, NLSSubstitution[] nLSSubstitutionArray, Map map, Map map2, PropertyFileDocumentModel propertyFileDocumentModel) {
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            if (NLSPropertyFileModifier.doInsert(nLSSubstitution, map, map2)) {
                String string = nLSSubstitution.getValueNonEmpty();
                KeyValuePair keyValuePair = new KeyValuePair(nLSSubstitution.getKey(), string);
                InsertEdit insertEdit = propertyFileDocumentModel.insert(keyValuePair);
                String string2 = Messages.format(NLSMessages.NLSPropertyFileModifier_add_entry, keyValuePair.getKey());
                TextChangeCompatibility.addTextEdit(textChange, string2, (TextEdit)insertEdit);
            }
            ++n;
        }
    }

    static boolean doRemove(NLSSubstitution nLSSubstitution, Map map, Map map2) {
        if (nLSSubstitution.getInitialState() != 0 || nLSSubstitution.getInitialKey() == null) {
            return false;
        }
        if (map2.get(nLSSubstitution.getInitialKey()) != nLSSubstitution) {
            return false;
        }
        if (nLSSubstitution.hasStateChanged()) {
            return true;
        }
        return nLSSubstitution.hasPropertyFileChange() && map.get(nLSSubstitution.getKey()) != nLSSubstitution;
    }

    private static void addRemoveEdits(TextChange textChange, NLSSubstitution[] nLSSubstitutionArray, Map map, Map map2, PropertyFileDocumentModel propertyFileDocumentModel) {
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            DeleteEdit deleteEdit;
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            if (NLSPropertyFileModifier.doRemove(nLSSubstitution, map, map2) && (deleteEdit = propertyFileDocumentModel.remove(nLSSubstitution.getInitialKey())) != null) {
                TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSPropertyFileModifier_remove_entry, nLSSubstitution.getInitialKey()), (TextEdit)deleteEdit);
            }
            ++n;
        }
    }
}

