/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameJavaProjectChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public final class RenameJavaProjectProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private IJavaProject fProject;
    private boolean fUpdateReferences;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameJavaProjectProcessor";

    public RenameJavaProjectProcessor(IJavaProject iJavaProject) {
        this.fProject = iJavaProject;
        if (this.fProject != null) {
            this.setNewElementName(this.fProject.getElementName());
        }
        this.fUpdateReferences = true;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fProject);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameJavaProjectRefactoring_rename;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fProject);
    }

    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    public Object getNewElement() throws CoreException {
        IPath iPath = this.fProject.getPath().removeLastSegments(1).append(this.getNewElementName());
        return JavaCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(iPath));
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications renameModifications = new RenameModifications();
        renameModifications.rename(this.fProject, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return renameModifications;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        IFile iFile = this.fProject.getProject().getFile(".project");
        if (iFile != null && iFile.exists()) {
            return new IFile[]{iFile};
        }
        return new IFile[0];
    }

    public int getSaveMode() {
        return 2;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String getCurrentElementName() {
        return this.fProject.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String string) throws CoreException {
        Assert.isNotNull((Object)string, (String)"new name");
        RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)ResourcesPlugin.getWorkspace().validateName(string, 4));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        if (this.projectNameAlreadyExists(string)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameJavaProjectRefactoring_already_exists);
        }
        if (this.projectFolderAlreadyExists(string)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameJavaProjectProcessor_folder_already_exists);
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            iProgressMonitor.beginTask("", 1);
            try {
                if (!this.isReadOnly()) break block3;
                String string = Messages.format(RefactoringCoreMessages.RenameJavaProjectRefactoring_read_only, this.fProject.getElementName());
                refactoringStatus = RefactoringStatus.createErrorStatus((String)string);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Object var4_7 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private boolean isReadOnly() {
        return Resources.isReadOnly(this.fProject.getResource());
    }

    private boolean projectNameAlreadyExists(String string) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(string).exists();
    }

    private boolean projectFolderAlreadyExists(String string) throws CoreException {
        boolean bl;
        boolean bl2 = bl = this.fProject.getProject().getDescription().getLocationURI() != null;
        if (bl) {
            return false;
        }
        URI uRI = this.fProject.getProject().getLocationURI();
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        IFileStore iFileStore2 = iFileStore.getParent().getChild(string);
        return iFileStore2.fetchInfo().exists();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            iProgressMonitor.beginTask("", 1);
            String string = Messages.format(RefactoringCoreMessages.RenameJavaProjectProcessor_descriptor_description_short, this.fProject.getElementName());
            String string2 = Messages.format(RefactoringCoreMessages.RenameJavaProjectChange_descriptor_description, new String[]{this.fProject.getElementName(), this.getNewElementName()});
            String string3 = new JDTRefactoringDescriptorComment(null, this, string2).asString();
            RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.java.project");
            renameJavaElementDescriptor.setProject(null);
            renameJavaElementDescriptor.setDescription(string);
            renameJavaElementDescriptor.setComment(string3);
            renameJavaElementDescriptor.setFlags(7);
            renameJavaElementDescriptor.setJavaElement((IJavaElement)this.fProject);
            renameJavaElementDescriptor.setNewName(this.getNewElementName());
            renameJavaElementDescriptor.setUpdateReferences(this.fUpdateReferences);
            dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenameJavaProjectRefactoring_rename, new Change[]{new RenameJavaProjectChange(this.fProject, this.getNewElementName(), this.fUpdateReferences)});
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute("input");
            if (string2 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (object == null || !object.exists() || object.getElementType() != 2) {
                    return ScriptableRefactoring.createInputFatalStatus(object, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.java.project");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fProject = (IJavaProject)object;
            object = javaRefactoringArguments.getAttribute("name");
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName((String)object);
            string = javaRefactoringArguments.getAttribute("references");
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fUpdateReferences = Boolean.valueOf(string);
        return new RefactoringStatus();
    }
}

