/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.refactoring.IJavaElementMapper;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.GenericRefactoringHandleTransplanter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.Changes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.CommentAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class RenamePackageProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating,
IResourceMapper,
IJavaElementMapper {
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private IPackageFragment fPackage;
    private TextChangeManager fChangeManager;
    private ImportsManager fImportsManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    private boolean fRenameSubpackages;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renamePackageProcessor";
    private RenamePackageChange fRenamePackageChange;

    public RenamePackageProcessor(IPackageFragment iPackageFragment) {
        this.fPackage = iPackageFragment;
        if (this.fPackage != null) {
            this.setNewElementName(this.fPackage.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fRenameSubpackages = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fPackage);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenamePackageRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fPackage);
    }

    public Object[] getElements() {
        return new Object[]{this.fPackage};
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications renameModifications = new RenameModifications();
        renameModifications.rename(this.fPackage, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()), this.fRenameSubpackages);
        return renameModifications;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        HashSet<IFile> hashSet = new HashSet<IFile>();
        hashSet.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.fRenameSubpackages) {
            IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                hashSet.addAll(Arrays.asList(ResourceUtil.getFiles(iPackageFragmentArray[n].getCompilationUnits())));
                ++n;
            }
        } else {
            hashSet.addAll(Arrays.asList(ResourceUtil.getFiles(this.fPackage.getCompilationUnits())));
        }
        if (this.fQualifiedNameSearchResult != null) {
            hashSet.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        return hashSet.toArray(new IFile[hashSet.size()]);
    }

    public int getSaveMode() {
        return 2;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean bl) {
        this.fUpdateTextualMatches = bl;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fPackage.isDefaultPackage();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean bl) {
        this.fUpdateQualifiedNames = bl;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String string) {
        Assert.isNotNull((Object)string);
        this.fFilePatterns = string;
    }

    public IResource getRefactoredResource(IResource iResource) {
        IPath iPath;
        IFolder iFolder = (IFolder)this.fPackage.getResource();
        if (iFolder == null) {
            return iResource;
        }
        IContainer iContainer = (IContainer)this.getNewPackage().getResource();
        if (iFolder.equals((Object)iResource)) {
            return iContainer;
        }
        IPath iPath2 = iFolder.getProjectRelativePath();
        if (iPath2.isPrefixOf(iPath = iResource.getProjectRelativePath()) && (this.fRenameSubpackages || iResource instanceof IFile && iFolder.equals((Object)iResource.getParent()))) {
            IPath iPath3 = iPath.removeFirstSegments(iPath2.segmentCount());
            if (iResource instanceof IFile) {
                return iContainer.getFile(iPath3);
            }
            return iContainer.getFolder(iPath3);
        }
        return iResource;
    }

    public IJavaElement getRefactoredJavaElement(IJavaElement iJavaElement) {
        return new GenericRefactoringHandleTransplanter(){

            protected IPackageFragment transplantHandle(IPackageFragmentRoot iPackageFragmentRoot, IPackageFragment iPackageFragment) {
                if (!RenamePackageProcessor.this.fRenameSubpackages) {
                    if (RenamePackageProcessor.this.fPackage.equals(iPackageFragment)) {
                        return RenamePackageProcessor.this.getNewPackage();
                    }
                } else {
                    String string = iPackageFragment.getElementName();
                    String string2 = RenamePackageProcessor.this.fPackage.getElementName();
                    if (RenamePackageProcessor.this.fPackage.getParent().equals(iPackageFragmentRoot) && string.startsWith(String.valueOf(string2) + '.')) {
                        String string3 = String.valueOf(RenamePackageProcessor.this.getNewElementName()) + string.substring(string2.length() - 1);
                        return RenamePackageProcessor.this.getPackageFragmentRoot().getPackageFragment(string3);
                    }
                }
                return super.transplantHandle(iPackageFragmentRoot, iPackageFragment);
            }

            protected IMethod transplantHandle(IType iType, IMethod iMethod) {
                String[] stringArray = this.resolveParameterTypes(iMethod);
                return iType.getMethod(iMethod.getElementName(), stringArray);
            }

            private String[] resolveParameterTypes(IMethod iMethod) {
                String[] stringArray = iMethod.getParameterTypes();
                String[] stringArray2 = new String[stringArray.length];
                String[] stringArray3 = new String[]{Signature.createTypeSignature((String)RenamePackageProcessor.this.fPackage.getElementName(), (boolean)false), Signature.createTypeSignature((String)RenamePackageProcessor.this.fPackage.getElementName(), (boolean)true)};
                String[] stringArray4 = new String[]{Signature.createTypeSignature((String)RenamePackageProcessor.this.getNewElementName(), (boolean)false), Signature.createTypeSignature((String)RenamePackageProcessor.this.getNewElementName(), (boolean)true)};
                int n = 0;
                while (n < stringArray.length) {
                    stringArray2[n] = stringArray[n];
                    int n2 = 0;
                    while (n2 < stringArray3.length) {
                        stringArray2[n] = this.replaceAll(stringArray2[n], stringArray3[n2], stringArray4[n2]);
                        ++n2;
                    }
                    ++n;
                }
                return stringArray2;
            }

            private String replaceAll(String string, String string2, String string3) {
                int n;
                StringBuffer stringBuffer = new StringBuffer(string.length());
                int n2 = 0;
                while ((n = string.indexOf(string2, n2)) != -1) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append(string3);
                    n2 = n + string2.length();
                }
                stringBuffer.append(string.substring(n2));
                return stringBuffer.toString();
            }
        }.transplantHandle(iJavaElement);
    }

    public boolean canEnableRenameSubpackages() throws JavaModelException {
        return this.fPackage.hasSubpackages();
    }

    public boolean getRenameSubpackages() {
        return this.fRenameSubpackages;
    }

    public void setRenameSubpackages(boolean bl) {
        this.fRenameSubpackages = bl;
    }

    public final String getCurrentElementName() {
        return this.fPackage.getElementName();
    }

    public String getCurrentElementQualifier() {
        return "";
    }

    public RefactoringStatus checkNewElementName(String string) throws CoreException {
        Assert.isNotNull((Object)string, (String)"new name");
        RefactoringStatus refactoringStatus = Checks.checkPackageName(string);
        if (Checks.isAlreadyNamed((IJavaElement)this.fPackage, string)) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.RenamePackageRefactoring_another_name);
        }
        refactoringStatus.merge(this.checkPackageInCurrentRoot(string));
        return refactoringStatus;
    }

    public Object getNewElement() {
        return this.getNewPackage();
    }

    private IPackageFragment getNewPackage() {
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        return iPackageFragmentRoot.getPackageFragment(this.getNewElementName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        String string;
        RefactoringStatus refactoringStatus2;
        block11: {
            iProgressMonitor.beginTask("", 23 + (this.fUpdateQualifiedNames ? 10 : 0) + (this.fUpdateTextualMatches ? 10 : 0));
            iProgressMonitor.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
            refactoringStatus2 = new RefactoringStatus();
            refactoringStatus2.merge(this.checkNewElementName(this.getNewElementName()));
            iProgressMonitor.worked(1);
            refactoringStatus2.merge(this.checkForMainAndNativeMethods());
            iProgressMonitor.worked(2);
            if (this.fPackage.isReadOnly()) {
                string = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_Packagered_only, this.fPackage.getElementName());
                refactoringStatus2.addFatalError(string);
            } else if (Resources.isReadOnly(this.fPackage.getResource())) {
                string = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_resource_read_only, this.fPackage.getElementName());
                refactoringStatus2.addError(string);
            }
            refactoringStatus2.merge(this.checkPackageName(this.getNewElementName()));
            if (!refactoringStatus2.hasFatalError()) break block11;
            RefactoringStatus refactoringStatus3 = refactoringStatus2;
            Object var7_7 = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        try {
            this.fChangeManager = new TextChangeManager();
            this.fImportsManager = new ImportsManager();
            string = new SubProgressMonitor(iProgressMonitor, 16);
            if (this.fRenameSubpackages) {
                IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
                string.beginTask("", iPackageFragmentArray.length);
                int n = 0;
                while (n < iPackageFragmentArray.length) {
                    new PackageRenamer(iPackageFragmentArray[n], this, this.fChangeManager, this.fImportsManager).doRename((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)string, 1), refactoringStatus2);
                    ++n;
                }
                string.done();
            } else {
                new PackageRenamer(this.fPackage, this, this.fChangeManager, this.fImportsManager).doRename((IProgressMonitor)string, refactoringStatus2);
            }
            this.fImportsManager.rewriteImports(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            if (this.fUpdateTextualMatches) {
                iProgressMonitor.subTask(RefactoringCoreMessages.RenamePackageRefactoring_searching_text);
                TextMatchUpdater.perform((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10), RefactoringScopeFactory.create((IJavaElement)this.fPackage), this, this.fChangeManager, new SearchResultGroup[0]);
            }
            if (this.fUpdateQualifiedNames) {
                this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            }
            refactoringStatus = refactoringStatus2;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public IPackageFragment getPackage() {
        return this.fPackage;
    }

    private RefactoringStatus checkForMainAndNativeMethods() throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.fRenameSubpackages) {
            IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                ICompilationUnit[] iCompilationUnitArray = iPackageFragmentArray[n].getCompilationUnits();
                int n2 = 0;
                while (n2 < iCompilationUnitArray.length) {
                    refactoringStatus.merge(Checks.checkForMainAndNativeMethods(iCompilationUnitArray[n2]));
                    ++n2;
                }
                ++n;
            }
        } else {
            ICompilationUnit[] iCompilationUnitArray = this.fPackage.getCompilationUnits();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                refactoringStatus.merge(Checks.checkForMainAndNativeMethods(iCompilationUnitArray[n]));
                ++n;
            }
        }
        return refactoringStatus;
    }

    public static boolean isPackageNameOkInRoot(String string, IPackageFragmentRoot iPackageFragmentRoot) throws CoreException {
        IPackageFragment iPackageFragment = iPackageFragmentRoot.getPackageFragment(string);
        if (!iPackageFragment.exists()) {
            return true;
        }
        if (!iPackageFragment.hasSubpackages()) {
            return false;
        }
        if (iPackageFragment.containsJavaResources()) {
            return false;
        }
        return iPackageFragment.getNonJavaResources().length == 0;
    }

    private RefactoringStatus checkPackageInCurrentRoot(String string) throws CoreException {
        if (RenamePackageProcessor.isPackageNameOkInRoot(string, this.getPackageFragmentRoot())) {
            return null;
        }
        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenamePackageRefactoring_package_exists);
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return (IPackageFragmentRoot)this.fPackage.getParent();
    }

    private RefactoringStatus checkPackageName(String string) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IPackageFragmentRoot[] iPackageFragmentRootArray = this.fPackage.getJavaProject().getPackageFragmentRoots();
        Set set = this.getTopLevelTypeNames();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            if (!RenamePackageProcessor.isPackageNameOkInRoot(string, iPackageFragmentRootArray[n])) {
                String string2 = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_aleady_exists, new Object[]{this.getNewElementName(), iPackageFragmentRootArray[n].getElementName()});
                refactoringStatus.merge(RefactoringStatus.createWarningStatus((String)string2));
                refactoringStatus.merge(this.checkTypeNameConflicts(iPackageFragmentRootArray[n], string, set));
            }
            ++n;
        }
        return refactoringStatus;
    }

    private Set getTopLevelTypeNames() throws CoreException {
        ICompilationUnit[] iCompilationUnitArray = this.fPackage.getCompilationUnits();
        HashSet hashSet = new HashSet(2 * iCompilationUnitArray.length);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            hashSet.addAll(RenamePackageProcessor.getTopLevelTypeNames(iCompilationUnitArray[n]));
            ++n;
        }
        return hashSet;
    }

    private static Collection getTopLevelTypeNames(ICompilationUnit iCompilationUnit) throws CoreException {
        IType[] iTypeArray = iCompilationUnit.getTypes();
        ArrayList<String> arrayList = new ArrayList<String>(iTypeArray.length);
        int n = 0;
        while (n < iTypeArray.length) {
            arrayList.add(iTypeArray[n].getElementName());
            ++n;
        }
        return arrayList;
    }

    private RefactoringStatus checkTypeNameConflicts(IPackageFragmentRoot iPackageFragmentRoot, String string, Set set) throws CoreException {
        IPackageFragment iPackageFragment = iPackageFragmentRoot.getPackageFragment(string);
        if (this.fPackage.equals(iPackageFragment)) {
            return null;
        }
        ICompilationUnit[] iCompilationUnitArray = iPackageFragment.getCompilationUnits();
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            refactoringStatus.merge(this.checkTypeNameConflicts(iCompilationUnitArray[n], set));
            ++n;
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkTypeNameConflicts(ICompilationUnit iCompilationUnit, Set set) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IType[] iTypeArray = iCompilationUnit.getTypes();
        String string = iCompilationUnit.getParent().getElementName();
        int n = 0;
        while (n < iTypeArray.length) {
            String string2 = iTypeArray[n].getElementName();
            if (set.contains(string2)) {
                Object[] objectArray = new String[]{string, string2};
                String string3 = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_contains_type, objectArray);
                RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((IMember)iTypeArray[n]);
                refactoringStatus.addError(string3, refactoringStatusContext);
            }
            ++n;
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.RenamePackageRefactoring_creating_change, 1);
            RenameJavaElementDescriptor renameJavaElementDescriptor = this.createRefactoringDescriptor();
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange2 = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenamePackageRefactoring_change_name);
            dynamicValidationRefactoringChange2.addAll((Change[])this.fChangeManager.getAllChanges());
            this.fRenamePackageChange = new RenamePackageChange(this.fPackage, this.getNewElementName(), this.fRenameSubpackages);
            dynamicValidationRefactoringChange2.add(this.fRenamePackageChange);
            iProgressMonitor.worked(1);
            dynamicValidationRefactoringChange = dynamicValidationRefactoringChange2;
            Object var4_5 = null;
            this.fChangeManager = null;
            this.fImportsManager = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.fChangeManager = null;
            this.fImportsManager = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    private RenameJavaElementDescriptor createRefactoringDescriptor() {
        String string = null;
        IJavaProject iJavaProject = this.fPackage.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        String string2 = Messages.format(RefactoringCoreMessages.RenamePackageProcessor_descriptor_description_short, this.fPackage.getElementName());
        String string3 = Messages.format(RefactoringCoreMessages.RenamePackageProcessor_descriptor_description, new String[]{this.fPackage.getElementName(), this.getNewElementName()});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        if (this.fRenameSubpackages) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.RenamePackageProcessor_rename_subpackages);
        }
        RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.package");
        renameJavaElementDescriptor.setProject(string);
        renameJavaElementDescriptor.setDescription(string2);
        renameJavaElementDescriptor.setComment(jDTRefactoringDescriptorComment.asString());
        renameJavaElementDescriptor.setFlags(589830);
        renameJavaElementDescriptor.setJavaElement((IJavaElement)this.fPackage);
        renameJavaElementDescriptor.setNewName(this.getNewElementName());
        renameJavaElementDescriptor.setUpdateReferences(this.fUpdateReferences);
        renameJavaElementDescriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
        renameJavaElementDescriptor.setUpdateQualifiedNames(this.fUpdateQualifiedNames);
        if (this.fUpdateQualifiedNames && this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
            renameJavaElementDescriptor.setFileNamePatterns(this.fFilePatterns);
        }
        renameJavaElementDescriptor.setUpdateHierarchy(this.fRenameSubpackages);
        return renameJavaElementDescriptor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fQualifiedNameSearchResult == null) return null;
        CompositeChange compositeChange = (CompositeChange)this.fRenamePackageChange.getParent();
        try {
            compositeChange.remove((Change)this.fRenamePackageChange);
            compositeChange.add(this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(changeArray)));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fQualifiedNameSearchResult = null;
            compositeChange.add((Change)this.fRenamePackageChange);
            this.fRenamePackageChange = null;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.fQualifiedNameSearchResult = null;
        }
        compositeChange.add((Change)this.fRenamePackageChange);
        this.fRenamePackageChange = null;
        return null;
    }

    private void computeQualifiedNameMatches(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fPackage.getElementName(), this.getNewElementName(), this.fFilePatterns, this.fPackage.getJavaProject().getProject(), iProgressMonitor);
    }

    public String getNewPackageName(String string) {
        String string2 = this.getPackage().getElementName();
        return String.valueOf(this.getNewElementName()) + string.substring(string2.length());
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute("input");
            if (string2 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (object == null || !object.exists() || object.getElementType() != 4) {
                    return ScriptableRefactoring.createInputFatalStatus(object, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.package");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fPackage = (IPackageFragment)object;
            object = javaRefactoringArguments.getAttribute("name");
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName((String)object);
            String string3 = javaRefactoringArguments.getAttribute(ATTRIBUTE_PATTERNS);
            this.fFilePatterns = string3 != null && !"".equals(string3) ? string3 : "";
            String string4 = javaRefactoringArguments.getAttribute("references");
            if (string4 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.fUpdateReferences = Boolean.valueOf(string4);
            String string5 = javaRefactoringArguments.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
            if (string5 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
            }
            this.fUpdateTextualMatches = Boolean.valueOf(string5);
            String string6 = javaRefactoringArguments.getAttribute(ATTRIBUTE_QUALIFIED);
            if (string6 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFIED));
            }
            this.fUpdateQualifiedNames = Boolean.valueOf(string6);
            string = javaRefactoringArguments.getAttribute(ATTRIBUTE_HIERARCHICAL);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_HIERARCHICAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fRenameSubpackages = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    static class ImportsManager {
        private HashMap fImportChanges = new HashMap();

        ImportsManager() {
        }

        public ImportChange getImportChange(ICompilationUnit iCompilationUnit) {
            ImportChange importChange = (ImportChange)this.fImportChanges.get(iCompilationUnit);
            if (importChange == null) {
                importChange = new ImportChange();
                this.fImportChanges.put(iCompilationUnit, importChange);
            }
            return importChange;
        }

        public void rewriteImports(TextChangeManager textChangeManager, IProgressMonitor iProgressMonitor) throws CoreException {
            Iterator iterator = this.fImportChanges.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Map.Entry entry = iterator.next();
                ICompilationUnit iCompilationUnit = (ICompilationUnit)entry.getKey();
                ImportChange importChange = (ImportChange)entry.getValue();
                ImportRewrite importRewrite = StubUtility.createImportRewrite(iCompilationUnit, true);
                importRewrite.setFilterImplicitImports(false);
                TextEdit textEdit = importChange.fStaticToRemove.iterator();
                while (textEdit.hasNext()) {
                    importRewrite.removeStaticImport((String)textEdit.next());
                }
                textEdit = importChange.fToRemove.iterator();
                while (textEdit.hasNext()) {
                    importRewrite.removeImport((String)textEdit.next());
                }
                textEdit = importChange.fStaticToAdd.iterator();
                while (textEdit.hasNext()) {
                    object = (String[])textEdit.next();
                    importRewrite.addStaticImport(object[0], object[1], true);
                }
                textEdit = importChange.fToAdd.iterator();
                while (textEdit.hasNext()) {
                    importRewrite.addImport((String)textEdit.next());
                }
                if (!importRewrite.hasRecordedChanges()) continue;
                textEdit = importRewrite.rewriteImports(iProgressMonitor);
                object = RefactoringCoreMessages.RenamePackageRefactoring_update_imports;
                try {
                    TextChangeCompatibility.addTextEdit(textChangeManager.get(iCompilationUnit), (String)object, textEdit);
                }
                catch (MalformedTreeException malformedTreeException) {
                    JavaPlugin.logErrorMessage("MalformedTreeException while processing cu " + iCompilationUnit);
                    throw malformedTreeException;
                }
            }
        }

        public static class ImportChange {
            private ArrayList fStaticToRemove = new ArrayList();
            private ArrayList fStaticToAdd = new ArrayList();
            private ArrayList fToRemove = new ArrayList();
            private ArrayList fToAdd = new ArrayList();

            public void removeStaticImport(String string) {
                this.fStaticToRemove.add(string);
            }

            public void addStaticImport(String string, String string2) {
                this.fStaticToAdd.add(new String[]{string, string2});
            }

            public void removeImport(String string) {
                this.fToRemove.add(string);
            }

            public void addImport(String string) {
                this.fToAdd.add(string);
            }
        }
    }

    private static class PackageRenamer {
        private final IPackageFragment fPackage;
        private final RenamePackageProcessor fProcessor;
        private final TextChangeManager fTextChangeManager;
        private final ImportsManager fImportsManager;
        private SearchResultGroup[] fOccurrences;
        private List fReferencesToTypesInNamesakes;
        private List fReferencesToTypesInPackage;

        public PackageRenamer(IPackageFragment iPackageFragment, RenamePackageProcessor renamePackageProcessor, TextChangeManager textChangeManager, ImportsManager importsManager) {
            this.fPackage = iPackageFragment;
            this.fProcessor = renamePackageProcessor;
            this.fTextChangeManager = textChangeManager;
            this.fImportsManager = importsManager;
        }

        void doRename(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
            iProgressMonitor.beginTask("", 16);
            if (this.fProcessor.getUpdateReferences()) {
                iProgressMonitor.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_searching);
                this.fOccurrences = this.getReferences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4), refactoringStatus);
                this.fReferencesToTypesInNamesakes = this.getReferencesToTypesInNamesakes((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4), refactoringStatus);
                this.fReferencesToTypesInPackage = this.getReferencesToTypesInPackage((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4), refactoringStatus);
                iProgressMonitor.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
                refactoringStatus.merge(this.analyzeAffectedCompilationUnits());
                iProgressMonitor.worked(1);
            } else {
                this.fOccurrences = new SearchResultGroup[0];
                iProgressMonitor.worked(13);
            }
            if (refactoringStatus.hasFatalError()) {
                return;
            }
            if (this.fProcessor.getUpdateReferences()) {
                this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            } else {
                iProgressMonitor.worked(3);
            }
            iProgressMonitor.done();
        }

        private SearchResultGroup[] getReferences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
            IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)this.fPackage);
            SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)this.fPackage, (int)2);
            return RefactoringSearchEngine.search(searchPattern, iJavaSearchScope, iProgressMonitor, refactoringStatus);
        }

        private void addReferenceUpdates(IProgressMonitor iProgressMonitor) throws CoreException {
            Object object;
            iProgressMonitor.beginTask("", this.fOccurrences.length + this.fReferencesToTypesInPackage.size() + this.fReferencesToTypesInNamesakes.size());
            int n = 0;
            while (n < this.fOccurrences.length) {
                object = this.fOccurrences[n].getCompilationUnit();
                if (object != null) {
                    SearchResultGroup searchResultGroup;
                    SearchResultGroup searchResultGroup2;
                    SearchMatch[] searchMatchArray = this.fOccurrences[n].getSearchResults();
                    int n2 = 0;
                    while (n2 < searchMatchArray.length) {
                        SearchMatch searchMatch = searchMatchArray[n2];
                        IJavaElement iJavaElement = SearchUtils.getEnclosingJavaElement(searchMatch);
                        if (iJavaElement instanceof IImportDeclaration) {
                            IImportDeclaration iImportDeclaration = (IImportDeclaration)iJavaElement;
                            String string = this.getUpdatedImport(iImportDeclaration);
                            this.updateImport((ICompilationUnit)object, iImportDeclaration, string);
                        } else {
                            TextChangeCompatibility.addTextEdit(this.fTextChangeManager.get((ICompilationUnit)object), RefactoringCoreMessages.RenamePackageRefactoring_update_reference, this.createTextChange(searchMatch));
                        }
                        ++n2;
                    }
                    if (this.fReferencesToTypesInNamesakes.size() != 0 && (searchResultGroup2 = PackageRenamer.extractGroupFor(object, this.fReferencesToTypesInNamesakes)) != null) {
                        this.addTypeImports(searchResultGroup2);
                    }
                    if (this.fReferencesToTypesInPackage.size() != 0 && (searchResultGroup = PackageRenamer.extractGroupFor(object, this.fReferencesToTypesInPackage)) != null) {
                        this.updateTypeImports(searchResultGroup);
                    }
                    iProgressMonitor.worked(1);
                }
                ++n;
            }
            if (this.fReferencesToTypesInNamesakes.size() != 0) {
                Iterator iterator = this.fReferencesToTypesInNamesakes.iterator();
                while (iterator.hasNext()) {
                    object = (SearchResultGroup)iterator.next();
                    this.addTypeImports((SearchResultGroup)object);
                    iProgressMonitor.worked(1);
                }
            }
            if (this.fReferencesToTypesInPackage.size() != 0) {
                Iterator iterator = this.fReferencesToTypesInPackage.iterator();
                while (iterator.hasNext()) {
                    object = (SearchResultGroup)iterator.next();
                    this.updateTypeImports((SearchResultGroup)object);
                    iProgressMonitor.worked(1);
                }
            }
            iProgressMonitor.done();
        }

        private static SearchResultGroup extractGroupFor(ICompilationUnit iCompilationUnit, List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SearchResultGroup searchResultGroup = (SearchResultGroup)iterator.next();
                if (!iCompilationUnit.equals(searchResultGroup.getCompilationUnit())) continue;
                iterator.remove();
                return searchResultGroup;
            }
            return null;
        }

        private TextEdit createTextChange(SearchMatch searchMatch) {
            return new ReplaceEdit(searchMatch.getOffset(), searchMatch.getLength(), this.getNewPackageName());
        }

        private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, refactoringStatus);
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            refactoringStatus.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
            return refactoringStatus;
        }

        private IJavaSearchScope getPackageAndOccurrencesWithoutNamesakesScope() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.fPackage);
            int n = 0;
            while (n < this.fOccurrences.length) {
                IPackageFragment iPackageFragment;
                ICompilationUnit iCompilationUnit = this.fOccurrences[n].getCompilationUnit();
                if (iCompilationUnit != null && !(iPackageFragment = (IPackageFragment)iCompilationUnit.getParent()).getElementName().equals(this.fPackage.getElementName())) {
                    arrayList.add(iCompilationUnit);
                }
                ++n;
            }
            return SearchEngine.createJavaSearchScope((IJavaElement[])arrayList.toArray(new IJavaElement[arrayList.size()]));
        }

        private List getReferencesToTypesInNamesakes(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
            iProgressMonitor.beginTask("", 2);
            IJavaElement[] iJavaElementArray = new IJavaElement[this.fOccurrences.length + 1];
            int n = 0;
            while (n < this.fOccurrences.length) {
                iJavaElementArray[n] = this.fOccurrences[n].getCompilationUnit();
                ++n;
            }
            iJavaElementArray[this.fOccurrences.length] = this.fPackage;
            IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.createReferencedScope(iJavaElementArray);
            IPackageFragment[] iPackageFragmentArray = this.getNamesakePackages(iJavaSearchScope, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (iPackageFragmentArray.length == 0) {
                iProgressMonitor.done();
                return new ArrayList(0);
            }
            IType[] iTypeArray = this.getTypesInPackages(iPackageFragmentArray);
            if (iTypeArray.length == 0) {
                iProgressMonitor.done();
                return new ArrayList(0);
            }
            SearchPattern searchPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])iTypeArray, 2);
            IJavaSearchScope iJavaSearchScope2 = this.getPackageAndOccurrencesWithoutNamesakesScope();
            SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(searchPattern, iJavaSearchScope2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
            iProgressMonitor.done();
            return new ArrayList<SearchResultGroup>(Arrays.asList(searchResultGroupArray));
        }

        private List getReferencesToTypesInPackage(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
            iProgressMonitor.beginTask("", 2);
            IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)this.fPackage);
            IPackageFragment[] iPackageFragmentArray = this.getNamesakePackages(iJavaSearchScope, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (iPackageFragmentArray.length == 0) {
                iProgressMonitor.done();
                return new ArrayList(0);
            }
            IJavaSearchScope iJavaSearchScope2 = SearchEngine.createJavaSearchScope((IJavaElement[])iPackageFragmentArray);
            IType[] iTypeArray = this.getTypesInPackage(this.fPackage);
            if (iTypeArray.length == 0) {
                iProgressMonitor.done();
                return new ArrayList(0);
            }
            SearchPattern searchPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])iTypeArray, 2);
            SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(searchPattern, iJavaSearchScope2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
            iProgressMonitor.done();
            return new ArrayList<SearchResultGroup>(Arrays.asList(searchResultGroupArray));
        }

        private IType[] getTypesInPackage(IPackageFragment iPackageFragment) throws JavaModelException {
            ArrayList arrayList = new ArrayList();
            this.addContainedTypes(iPackageFragment, arrayList);
            return arrayList.toArray(new IType[arrayList.size()]);
        }

        private IPackageFragment[] getNamesakePackages(IJavaSearchScope iJavaSearchScope, IProgressMonitor iProgressMonitor) throws CoreException {
            SearchPattern searchPattern = SearchPattern.createPattern((String)this.fPackage.getElementName(), (int)2, (int)0, (int)8);
            HashSet hashSet = new HashSet();
            SearchRequestor searchRequestor = new SearchRequestor(this, hashSet){
                final /* synthetic */ PackageRenamer this$1;
                private final /* synthetic */ HashSet val$packageFragments;
                {
                    this.this$1 = packageRenamer;
                    this.val$packageFragments = hashSet;
                }

                public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                    IJavaElement iJavaElement = SearchUtils.getEnclosingJavaElement(searchMatch);
                    if (iJavaElement instanceof IPackageFragment) {
                        IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                        if (!PackageRenamer.access$0(this.this$1).equals(iPackageFragment)) {
                            this.val$packageFragments.add(iPackageFragment);
                        }
                    }
                }
            };
            new SearchEngine().search(searchPattern, SearchUtils.getDefaultSearchParticipants(), iJavaSearchScope, searchRequestor, iProgressMonitor);
            return hashSet.toArray(new IPackageFragment[hashSet.size()]);
        }

        private IType[] getTypesInPackages(IPackageFragment[] iPackageFragmentArray) throws JavaModelException {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                IPackageFragment iPackageFragment = iPackageFragmentArray[n];
                this.addContainedTypes(iPackageFragment, arrayList);
                ++n;
            }
            return arrayList.toArray(new IType[arrayList.size()]);
        }

        private void addContainedTypes(IPackageFragment iPackageFragment, List list) throws JavaModelException {
            IJavaElement[] iJavaElementArray = iPackageFragment.getChildren();
            int n = 0;
            while (n < iJavaElementArray.length) {
                IJavaElement iJavaElement = iJavaElementArray[n];
                if (iJavaElement instanceof ICompilationUnit) {
                    list.addAll(Arrays.asList(((ICompilationUnit)iJavaElement).getTypes()));
                } else if (iJavaElement instanceof IClassFile) {
                    list.add(((IClassFile)iJavaElement).getType());
                }
                ++n;
            }
        }

        private void updateImport(ICompilationUnit iCompilationUnit, IImportDeclaration iImportDeclaration, String string) throws JavaModelException {
            ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(iCompilationUnit);
            if (Flags.isStatic((int)iImportDeclaration.getFlags())) {
                importChange.removeStaticImport(iImportDeclaration.getElementName());
                importChange.addStaticImport(Signature.getQualifier((String)string), Signature.getSimpleName((String)string));
            } else {
                importChange.removeImport(iImportDeclaration.getElementName());
                importChange.addImport(string);
            }
        }

        private void addTypeImports(SearchResultGroup searchResultGroup) throws CoreException {
            SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
            int n = 0;
            while (n < searchMatchArray.length) {
                String string;
                SearchMatch searchMatch = searchMatchArray[n];
                IJavaElement iJavaElement = SearchUtils.getEnclosingJavaElement(searchMatch);
                if (!(iJavaElement instanceof IImportDeclaration) && !(string = PackageRenamer.getNormalizedTypeReference(searchMatch)).startsWith(this.fPackage.getElementName())) {
                    string = PackageRenamer.cutOffInnerTypes(string);
                    ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(searchResultGroup.getCompilationUnit());
                    importChange.addImport(String.valueOf(this.fPackage.getElementName()) + '.' + string);
                }
                ++n;
            }
        }

        private void updateTypeImports(SearchResultGroup searchResultGroup) throws CoreException {
            SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
            int n = 0;
            while (n < searchMatchArray.length) {
                Object object;
                SearchMatch searchMatch = searchMatchArray[n];
                IJavaElement iJavaElement = SearchUtils.getEnclosingJavaElement(searchMatch);
                if (iJavaElement instanceof IImportDeclaration) {
                    object = (IImportDeclaration)iJavaElement;
                    this.updateImport(searchResultGroup.getCompilationUnit(), (IImportDeclaration)object, this.getUpdatedImport((IImportDeclaration)object));
                } else {
                    object = PackageRenamer.getNormalizedTypeReference(searchMatch);
                    if (!((String)object).startsWith(this.fPackage.getElementName())) {
                        object = PackageRenamer.cutOffInnerTypes((String)object);
                        ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(searchResultGroup.getCompilationUnit());
                        importChange.removeImport(String.valueOf(this.fPackage.getElementName()) + '.' + (String)object);
                        importChange.addImport(String.valueOf(this.getNewPackageName()) + '.' + (String)object);
                    }
                }
                ++n;
            }
        }

        private static String getNormalizedTypeReference(SearchMatch searchMatch) throws JavaModelException {
            ICompilationUnit iCompilationUnit = SearchUtils.getCompilationUnit(searchMatch);
            String string = iCompilationUnit.getBuffer().getText(searchMatch.getOffset(), searchMatch.getLength());
            return CommentAnalyzer.normalizeReference(string);
        }

        private static String cutOffInnerTypes(String string) {
            int n = string.indexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            return string;
        }

        private String getUpdatedImport(IImportDeclaration iImportDeclaration) {
            String string = iImportDeclaration.getElementName();
            int n = this.fPackage.getElementName().length();
            String string2 = String.valueOf(this.getNewPackageName()) + string.substring(n);
            return string2;
        }

        private String getNewPackageName() {
            return this.fProcessor.getNewPackageName(this.fPackage.getElementName());
        }

        static /* synthetic */ IPackageFragment access$0(PackageRenamer packageRenamer) {
            return packageRenamer.fPackage;
        }
    }
}

