/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameSourceFolderChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenameSourceFolderProcessor
extends JavaRenameProcessor {
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private IPackageFragmentRoot fSourceFolder;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameSourceFolderProcessor";

    public RenameSourceFolderProcessor(IPackageFragmentRoot iPackageFragmentRoot) {
        this.fSourceFolder = iPackageFragmentRoot;
        if (iPackageFragmentRoot != null) {
            this.setNewElementName(iPackageFragmentRoot.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fSourceFolder);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameSourceFolderRefactoring_rename;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fSourceFolder);
    }

    public Object[] getElements() {
        return new Object[]{this.fSourceFolder};
    }

    public Object getNewElement() throws CoreException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = this.fSourceFolder.getJavaProject().getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            if (iPackageFragmentRootArray[n].getElementName().equals(this.getNewElementName())) {
                return iPackageFragmentRootArray[n];
            }
            ++n;
        }
        return null;
    }

    public int getSaveMode() {
        return 2;
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications renameModifications = new RenameModifications();
        renameModifications.rename(this.fSourceFolder, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return renameModifications;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[0];
    }

    public String getCurrentElementName() {
        return this.fSourceFolder.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String string) throws CoreException {
        IPath iPath;
        Assert.isNotNull((Object)string, (String)"new name");
        if (!string.trim().equals(string)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_blank);
        }
        IContainer iContainer = this.fSourceFolder.getResource().getParent();
        if (!iContainer.getFullPath().isValidSegment(string)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_invalid_name);
        }
        RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)iContainer.getWorkspace().validateName(string, 2));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(RefactoringStatus.create((IStatus)iContainer.getWorkspace().validatePath(this.createNewPath(string), 2)));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        IJavaProject iJavaProject = this.fSourceFolder.getJavaProject();
        if (iJavaProject.findPackageFragmentRoot(iPath = iJavaProject.getProject().getFullPath().append(string)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_already_exists);
        }
        if (iJavaProject.getProject().findMember((IPath)new Path(string)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_alread_exists);
        }
        return refactoringStatus;
    }

    private String createNewPath(String string) {
        return this.fSourceFolder.getPath().removeLastSegments(1).append(string).toString();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        iProgressMonitor.beginTask("", 1);
        try {
            refactoringStatus = new RefactoringStatus();
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        iProgressMonitor.beginTask(RefactoringCoreMessages.RenameTypeRefactoring_creating_change, 1);
        try {
            IResource iResource = this.fSourceFolder.getResource();
            String string = iResource.getProject().getName();
            String string2 = this.getNewElementName();
            String string3 = Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_descriptor_description_short, this.fSourceFolder.getElementName());
            String string4 = Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_descriptor_description, new String[]{iResource.getFullPath().toString(), string2});
            String string5 = new JDTRefactoringDescriptorComment(string, this, string4).asString();
            RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.source.folder");
            renameJavaElementDescriptor.setProject(string);
            renameJavaElementDescriptor.setDescription(string3);
            renameJavaElementDescriptor.setComment(string5);
            renameJavaElementDescriptor.setFlags(0);
            renameJavaElementDescriptor.setJavaElement((IJavaElement)this.fSourceFolder);
            renameJavaElementDescriptor.setNewName(string2);
            dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenameSourceFolderRefactoring_rename, new Change[]{new RenameSourceFolderChange(this.fSourceFolder, string2)});
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        Object object;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute(ATTRIBUTE_PATH);
            if (string != null) {
                object = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(string));
                if (object == null || !object.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(object, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.source.folder");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PATH));
            }
            this.fSourceFolder = (IPackageFragmentRoot)JavaCore.create((IResource)object);
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_NAME);
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_NAME));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName((String)object);
        return new RefactoringStatus();
    }
}

